/*
 * Decompiled with CFR 0.152.
 */
package inria.net;

import inria.util.Logger;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Random;

public abstract class MulticastSession
implements Runnable {
    protected int MaxPacketSize = 1024;
    protected int port;
    protected int ttl = 1;
    protected InetAddress inetAddr;
    protected DatagramSocket sock_in = null;
    protected DatagramSocket sock_out = null;
    protected int packets = 0;
    protected int bytes = 0;
    protected Thread thread = null;
    static Random rand = new Random(193295976324752L);

    protected MulticastSession() {
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.setName(this.getClass().getName());
            this.thread.setPriority(10);
            this.thread.start();
        }
    }

    public void stop() {
        this.thread = null;
        if (this.inetAddr != null) {
            if (this.inetAddr.isMulticastAddress()) {
                try {
                    if (this.sock_in != null) {
                        ((MulticastSocket)this.sock_in).leaveGroup(this.inetAddr);
                    }
                    if (this.sock_out != null) {
                        ((MulticastSocket)this.sock_out).leaveGroup(this.inetAddr);
                    }
                }
                catch (IOException iOException) {
                    Logger.error(this, "failed to leave group", iOException);
                }
            }
            if (this.sock_in != null) {
                this.sock_in.close();
                this.sock_in = null;
            }
            if (this.sock_out != null) {
                this.sock_out.close();
                this.sock_out = null;
            }
        }
    }

    protected void initialize(InetAddress inetAddress, int n) throws IOException {
        this.inetAddr = inetAddress;
        if (MulticastSession.isMulticast(this.inetAddr)) {
            this.sock_in = new MulticastSocket(n);
            ((MulticastSocket)this.sock_in).joinGroup(this.inetAddr);
            this.sock_out = new MulticastSocket();
            ((MulticastSocket)this.sock_out).joinGroup(this.inetAddr);
        } else {
            this.sock_in = new DatagramSocket(n);
            this.sock_out = new DatagramSocket();
        }
        this.port = n;
    }

    protected void initialize(String string, int n) throws IOException, UnknownHostException {
        this.initialize(InetAddress.getByName(string), n);
    }

    public void setTTL(int n) {
        this.ttl = n;
    }

    public int getTTL() {
        return this.ttl;
    }

    public synchronized void send(byte[] byArray, int n) {
        this.send(byArray, n, this.ttl);
    }

    public synchronized void send(byte[] byArray, int n, int n2) {
        if (this.sock_out == null) {
            Logger.debug(this, "send: null socket");
            return;
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, n, this.inetAddr, this.port);
        try {
            if (this.inetAddr.isMulticastAddress()) {
                ((MulticastSocket)this.sock_out).send(datagramPacket, (byte)n2);
            } else {
                this.sock_out.send(datagramPacket);
                ++this.packets;
                this.bytes += datagramPacket.getLength();
            }
        }
        catch (Exception exception) {
            Logger.error(this, "send error", exception);
        }
    }

    protected abstract boolean parse(byte[] var1, int var2, InetAddress var3);

    public void run() {
        if (Logger.debug) {
            Logger.debug(this, "started on " + this.inetAddr.getHostAddress() + "/" + this.port + "/" + this.ttl);
        }
        byte[] byArray = null;
        Thread thread = Thread.currentThread();
        while (this.thread == thread) {
            if (this.sock_in == null) {
                Logger.debug(this, "receive: null socket");
                break;
            }
            if (byArray == null) {
                byArray = new byte[this.MaxPacketSize];
            }
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            try {
                this.sock_in.receive(datagramPacket);
            }
            catch (IOException iOException) {
                if (!Logger.debug) continue;
                Logger.debug(this, "receive: " + iOException.getMessage());
                continue;
            }
            ++this.packets;
            this.bytes += datagramPacket.getLength();
            if (this.parse(datagramPacket.getData(), datagramPacket.getLength(), datagramPacket.getAddress())) continue;
            byArray = null;
        }
        if (Logger.debug) {
            Logger.debug(this, "thread stopped");
        }
        this.thread = null;
    }

    public static boolean isMulticast(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        return (byArray[0] & 0xF0) == 224;
    }

    private boolean drop() {
        return rand.nextDouble() < 0.2;
    }

    public int packets() {
        return this.packets;
    }

    public int bytes() {
        return this.bytes;
    }
}

