/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.util;

import com.sun.multicast.util.ImpossibleException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Util {
    private Util() {
    }

    public static int readUnsignedShort(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF);
    }

    public static void writeShort(short s, byte[] byArray, int n) {
        byArray[n] = (byte)(s >>> 8);
        byArray[n + 1] = (byte)(s & 0xFF);
    }

    public static long readUnsignedInt(byte[] byArray, int n) {
        return (((long)byArray[n] & 0xFFL) << 24) + (long)((byArray[n + 1] & 0xFF) << 16) + (long)((byArray[n + 2] & 0xFF) << 8) + (long)(byArray[n + 3] & 0xFF);
    }

    public static int readInt(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
    }

    public static void writeInt(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16 & 0xFF);
        byArray[n2 + 2] = (byte)(n >>> 8 & 0xFF);
        byArray[n2 + 3] = (byte)(n & 0xFF);
    }

    public static long readLong(byte[] byArray, int n) {
        return (((long)byArray[n] & 0xFFL) << 56) + (long)((byArray[n + 1] & 0xFF) << 48) + (long)((byArray[n + 2] & 0xFF) << 40) + (long)((byArray[n + 3] & 0xFF) << 32) + (long)((byArray[n + 4] & 0xFF) << 24) + (long)((byArray[n + 5] & 0xFF) << 16) + (long)((byArray[n + 6] & 0xFF) << 8) + (long)(byArray[n + 7] & 0xFF);
    }

    public static void writeLong(long l, byte[] byArray, int n) {
        byArray[n] = (byte)(l >>> 56);
        byArray[n + 1] = (byte)(l >>> 48 & 0xFFL);
        byArray[n + 2] = (byte)(l >>> 40 & 0xFFL);
        byArray[n + 3] = (byte)(l >>> 32 & 0xFFL);
        byArray[n + 4] = (byte)(l >>> 24 & 0xFFL);
        byArray[n + 5] = (byte)(l >>> 16 & 0xFFL);
        byArray[n + 6] = (byte)(l >>> 8 & 0xFFL);
        byArray[n + 7] = (byte)(l & 0xFFL);
    }

    public static InetAddress intToInetAddress(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n >>> 24 & 0xFF);
        stringBuffer.append(".");
        stringBuffer.append(n >>> 16 & 0xFF);
        stringBuffer.append(".");
        stringBuffer.append(n >>> 8 & 0xFF);
        stringBuffer.append(".");
        stringBuffer.append(n & 0xFF);
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(stringBuffer.toString());
        }
        catch (UnknownHostException unknownHostException) {
            throw new ImpossibleException(unknownHostException);
        }
        return inetAddress;
    }

    public static int InetAddressToInt(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        return ((byArray[0] & 0xFF) << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
    }

    public static Object readObject(byte[] byArray) {
        Object object = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
            objectInputStream.close();
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            throw new ImpossibleException(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ImpossibleException(classNotFoundException);
        }
        return object;
    }

    public static byte[] writeObject(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            throw new ImpossibleException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Object deepClone(Object object) {
        return Util.readObject(Util.writeObject(object));
    }

    public static void writeByteArrayToFile(byte[] byArray, String string, int n) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.write(byArray, 0, n);
        objectOutputStream.flush();
        fileOutputStream.close();
    }
}

