/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.test;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;

public class Sender {
    public static void main(String[] stringArray) {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        InetAddress inetAddress = null;
        if (stringArray.length == 0) {
            System.out.println("Usage:  java Sender <multicast address> [pps]");
            System.exit(1);
        }
        try {
            inetAddress = InetAddress.getByName(stringArray[0]);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Bad multicast address " + stringArray[0]);
            System.exit(1);
        }
        int n = 1;
        if (stringArray.length == 2) {
            n = Integer.parseInt(stringArray[1]);
        }
        MulticastSocket multicastSocket = null;
        try {
            multicastSocket = new MulticastSocket(6666);
            multicastSocket.joinGroup(inetAddress);
        }
        catch (IOException iOException) {
            System.out.println("Can't create multicast socket!");
            System.exit(1);
        }
        long l = System.currentTimeMillis();
        int n2 = 1;
        while (true) {
            byArray[0] = (byte)(n2 >> 24 & 0xFF);
            byArray[1] = (byte)(n2 >> 16 & 0xFF);
            byArray[2] = (byte)(n2 >> 8 & 0xFF);
            byArray[3] = (byte)(n2 & 0xFF);
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, 6666);
            try {
                multicastSocket.send(datagramPacket, (byte)20);
                long l2 = System.currentTimeMillis();
                double d = (double)(l2 - l) / 1000.0;
                l = l2;
                System.out.println(d + " sent packet " + n2);
                ++n2;
            }
            catch (IOException iOException) {
                System.out.println("Can't send on multicast socket!");
                System.exit(1);
            }
            int n3 = (int)(1000.0 / (double)n);
            try {
                Thread.sleep(n3);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

