/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.test;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;

public class Receiver {
    public static void main(String[] stringArray) {
        InetAddress inetAddress = null;
        if (stringArray.length < 1) {
            System.out.println("Usage:  java Receiver <multicast address> [<interface>]");
            System.exit(1);
        }
        try {
            inetAddress = InetAddress.getByName(stringArray[0]);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Bad multicast address " + stringArray[0]);
            System.exit(1);
        }
        MulticastSocket multicastSocket = null;
        try {
            multicastSocket = new MulticastSocket(6666);
            if (stringArray.length >= 2) {
                System.out.println("interface " + stringArray[1]);
                multicastSocket.setInterface(InetAddress.getByName(stringArray[1]));
            }
            multicastSocket.joinGroup(inetAddress);
        }
        catch (IOException iOException) {
            System.out.println("Can't create multicast socket!");
            System.exit(1);
        }
        byte[] byArray = new byte[1000];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        long l = 0L;
        int n = 1;
        int n2 = 0;
        while (true) {
            try {
                while (true) {
                    multicastSocket.receive(datagramPacket);
                    int n3 = (byArray[0] << 24 & 0xFF000000) + (byArray[1] << 16 & 0xFFFF00) + (byArray[2] << 8 & 0xFF00) + (byArray[3] & 0xFF);
                    if (l != 0L && n3 != n) {
                        System.out.println("Out of sequence packet.  Expected " + n + " Got " + n3);
                        if (n3 < n) {
                            System.out.println("Received earlier packet " + n3);
                        } else {
                            n2 += n3 - n;
                        }
                    }
                    n = n3 + 1;
                    long l2 = System.currentTimeMillis();
                    if (l == 0L) {
                        l = l2;
                    }
                    double d = (double)(l2 - l) / 1000.0;
                    l = l2;
                    System.out.println(d + " received packet " + n3 + " missed " + n2);
                }
            }
            catch (IOException iOException) {
                System.out.println("Can't receiver on multicast socket!");
                System.exit(1);
                continue;
            }
            break;
        }
    }
}

