/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.um;

import com.sun.multicast.reliable.transport.InvalidMulticastAddressException;
import com.sun.multicast.reliable.transport.InvalidTransportProfileException;
import com.sun.multicast.reliable.transport.RMPacketSocket;
import com.sun.multicast.reliable.transport.RMStreamSocket;
import com.sun.multicast.reliable.transport.TransportProfile;
import com.sun.multicast.reliable.transport.um.UMPacketSocket;
import com.sun.multicast.util.UnsupportedException;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;

public class UMTransportProfile
implements TransportProfile,
Cloneable,
Serializable {
    private String name = "Unreliable Multicast Transport";
    private InetAddress address = null;
    private int port = 0;
    private byte ttl = 1;
    private boolean multiSender = false;
    private boolean ordered = false;
    private long dataRate = 65535L;
    private boolean useAuthentication = false;
    private String authenticationSpecFileName = null;
    private String authenticationSpecPassword = null;

    private UMTransportProfile() {
    }

    public UMTransportProfile(InetAddress inetAddress, int n) throws InvalidMulticastAddressException {
        if (!inetAddress.isMulticastAddress()) {
            throw new InvalidMulticastAddressException("The address specified is not a valid multicast address");
        }
        this.address = inetAddress;
        this.port = n;
    }

    public RMStreamSocket createRMStreamSocket(int n) throws UnsupportedException {
        throw new UnsupportedException("createRMStreamSocket isn't supported for Unreliable Multicast.");
    }

    public RMPacketSocket createRMPacketSocket(int n) throws UnsupportedException, InvalidTransportProfileException, IOException {
        this.validate();
        UMPacketSocket uMPacketSocket = new UMPacketSocket();
        uMPacketSocket.connect(this);
        return uMPacketSocket;
    }

    public String getName() {
        return this.name;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public byte getTTL() {
        return this.ttl;
    }

    public long getDataRate() {
        return this.dataRate;
    }

    public String getAuthenticationSpecFileName() {
        return this.authenticationSpecFileName;
    }

    public boolean isMultiSender() {
        return this.multiSender;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isUsingAuthentication() {
        return this.useAuthentication;
    }

    public void setAddress(InetAddress inetAddress) throws InvalidMulticastAddressException {
        if (!inetAddress.isMulticastAddress()) {
            throw new InvalidMulticastAddressException("The address specified is not a multicast address!");
        }
        this.address = inetAddress;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setOrdered(boolean bl) {
        this.ordered = bl;
    }

    public void setTTL(byte by) {
        this.ttl = by;
    }

    public void setMultiSender(boolean bl) throws UnsupportedException {
        this.multiSender = bl;
    }

    public void setDataRate(long l) {
        this.dataRate = l;
    }

    private void validate() throws InvalidTransportProfileException {
        if (!this.address.isMulticastAddress()) {
            throw new InvalidTransportProfileException("invalid multicast address");
        }
        if (this.port < 0 || this.port > 65535) {
            throw new InvalidTransportProfileException("invalid multicast port");
        }
        if (this.dataRate <= 0L) {
            throw new InvalidTransportProfileException("invalid data rate");
        }
        if (this.ttl == 0) {
            throw new InvalidTransportProfileException("invalid TTL");
        }
    }

    public boolean isValid() {
        boolean bl = true;
        try {
            this.validate();
        }
        catch (InvalidTransportProfileException invalidTransportProfileException) {
            bl = false;
        }
        return bl;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("CloneNotSupportedError should not happen");
        }
    }

    public void enableAuthentication() {
        this.useAuthentication = true;
    }

    public void disableAuthentication() {
        this.useAuthentication = false;
    }

    public void setAuthenticationSpecFileName(String string) {
        this.authenticationSpecFileName = string;
    }

    public String getAuthenticationSpecPassword() {
        return this.authenticationSpecPassword;
    }

    public void setAuthenticationSpecPassword(String string) {
        this.authenticationSpecPassword = string;
    }
}

