/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.um;

import com.sun.multicast.reliable.transport.um.UMDataBlock;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.util.Vector;

class UMSender
implements Runnable {
    private static final int MAX_QUEUE = 16;
    private MulticastSocket ms = null;
    private Thread thread = null;
    private Vector transmitQueue = new Vector(16);
    private long transmitInterval = 10L;
    private long bytesSent = 0L;
    private long packetsSent = 0L;
    private long dataRate = 64000L;

    public UMSender(MulticastSocket multicastSocket, long l) {
        this.ms = multicastSocket;
        this.dataRate = l;
    }

    public synchronized void insqueue(DatagramPacket datagramPacket, byte by) {
        while (this.transmitQueue.size() == 16) {
            try {
                System.out.println("Queue Full....");
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                System.out.println(interruptedException);
            }
        }
        this.transmitQueue.addElement(new UMDataBlock(datagramPacket, by));
        this.start();
    }

    public synchronized void insqueue(DatagramPacket datagramPacket) {
        while (this.transmitQueue.size() == 16) {
            try {
                System.out.println("Queue Full....");
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                System.out.println(interruptedException);
            }
        }
        this.transmitQueue.addElement(new UMDataBlock(datagramPacket));
        this.start();
    }

    public synchronized boolean isQueueEmpty() {
        return this.transmitQueue.isEmpty();
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.setPriority(10);
            this.thread.start();
        }
    }

    public synchronized void run() {
        long l = 0L;
        long l2 = 0L;
        while (!this.transmitQueue.isEmpty()) {
            l = System.currentTimeMillis();
            UMDataBlock uMDataBlock = (UMDataBlock)this.transmitQueue.firstElement();
            this.transmitQueue.removeElement(uMDataBlock);
            try {
                if (uMDataBlock.getTTL() == 0) {
                    this.ms.send(uMDataBlock.getDatagramPacket());
                } else {
                    this.ms.send(uMDataBlock.getDatagramPacket(), uMDataBlock.getTTL());
                }
                this.computeRate(uMDataBlock.getDatagramPacket());
                if (this.transmitInterval - l2 > 0L) {
                    Thread.sleep(this.transmitInterval - l2);
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            l2 = System.currentTimeMillis() - l - this.transmitInterval;
        }
        this.notify();
        this.thread = null;
    }

    public void computeRate(DatagramPacket datagramPacket) {
        this.bytesSent += (long)datagramPacket.getLength();
        ++this.packetsSent;
        this.transmitInterval = this.dataRate != 0L ? (long)(datagramPacket.getLength() * 1000) / this.dataRate : 0L;
    }

    public long getDataRate() {
        return this.dataRate;
    }

    public void setDataRate(long l) {
        this.dataRate = l;
    }
}

