/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.um;

import com.sun.multicast.reliable.transport.RMPacketSocket;
import com.sun.multicast.reliable.transport.RMStatistics;
import com.sun.multicast.reliable.transport.TransportProfile;
import com.sun.multicast.reliable.transport.um.UMSender;
import com.sun.multicast.reliable.transport.um.UMTransportProfile;
import com.sun.multicast.util.UnsupportedException;
import com.sun.multicast.util.Util;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;

public class UMPacketSocket
implements RMPacketSocket {
    private static final int HEADER = 4;
    private static final int PACKETNUMBER = 0;
    private int packetNumber = 0;
    private UMTransportProfile tp = null;
    private MulticastSocket ms = null;
    private UMSender sender = null;
    private boolean firstTime = true;

    UMPacketSocket() {
    }

    void connect(UMTransportProfile uMTransportProfile) throws IOException {
        this.ms = new MulticastSocket(uMTransportProfile.getPort());
        this.ms.joinGroup(uMTransportProfile.getAddress());
        try {
            this.ms.setTimeToLive(uMTransportProfile.getTTL());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            if (this.firstTime) {
                this.firstTime = false;
                System.out.println("jdk1.2 method setTimeToLive doesn't exist.  Trying setTTL()");
            }
            this.ms.setTTL(uMTransportProfile.getTTL());
        }
        this.tp = (UMTransportProfile)uMTransportProfile.clone();
        this.sender = new UMSender(this.ms, uMTransportProfile.getDataRate());
    }

    public InetAddress getInterface() throws SocketException {
        return this.ms.getInterface();
    }

    public TransportProfile getTransportProfile() {
        return (TransportProfile)this.tp.clone();
    }

    public RMStatistics getRMStatistics() throws UnsupportedException {
        throw new UnsupportedException();
    }

    public void setInterface(InetAddress inetAddress) throws SocketException {
        this.ms.setInterface(inetAddress);
    }

    public void send(DatagramPacket datagramPacket) throws IOException {
        this.sender.insqueue(this.copyDP(datagramPacket));
    }

    public void send(DatagramPacket datagramPacket, byte by) throws IOException {
        this.sender.insqueue(this.copyDP(datagramPacket), by);
    }

    public DatagramPacket receive() throws IOException {
        byte[] byArray = new byte[65535];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        this.ms.receive(datagramPacket);
        byte[] byArray2 = new byte[datagramPacket.getLength() - 4];
        System.arraycopy(datagramPacket.getData(), 4, byArray2, 0, byArray2.length);
        DatagramPacket datagramPacket2 = new DatagramPacket(byArray2, byArray2.length, datagramPacket.getAddress(), datagramPacket.getPort());
        return datagramPacket2;
    }

    public void abort() {
        this.ms.close();
    }

    public void close() {
        try {
            while (!this.sender.isQueueEmpty()) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.ms.close();
    }

    public int getSoTimeout() throws SocketException {
        return this.ms.getSoTimeout();
    }

    public void setSoTimeout(int n) throws SocketException {
        this.ms.setSoTimeout(n);
    }

    public long getDataRate() {
        return this.tp.getDataRate();
    }

    public void setDataRate(long l) {
        this.tp.setDataRate(l);
        this.sender.setDataRate(l);
    }

    public int getMaxLength() {
        return 65507;
    }

    private DatagramPacket copyDP(DatagramPacket datagramPacket) {
        byte[] byArray = new byte[4 + datagramPacket.getLength()];
        System.arraycopy(datagramPacket.getData(), 0, byArray, 4, byArray.length - 4);
        Util.writeInt(++this.packetNumber, byArray, 0);
        DatagramPacket datagramPacket2 = new DatagramPacket(byArray, byArray.length, this.tp.getAddress(), this.tp.getPort());
        return datagramPacket2;
    }
}

