/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.TRAMAckPacket;
import com.sun.multicast.reliable.transport.tram.TRAMAckPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMAckPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMAmPacket;
import com.sun.multicast.reliable.transport.tram.TRAMAmPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMAmPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMHbPacket;
import com.sun.multicast.reliable.transport.tram.TRAMHbPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMHbPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMHelloUniPacket;
import com.sun.multicast.reliable.transport.tram.TRAMHelloUniPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMHelloUniPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMLogger;
import com.sun.multicast.reliable.transport.tram.TRAMPacket;
import com.sun.multicast.reliable.transport.tram.TRAMRmPacket;
import com.sun.multicast.reliable.transport.tram.TRAMRmPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMRmPacketListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Vector;

class UcastInputDispThread
extends Thread {
    private static final int MAXCNTL_PKTSIZE = 1350;
    private TRAMControlBlock tramblk = null;
    private TRAMLogger logger;
    private static final String name = "TRAM UcastInputDispThread";
    private Vector helloUniListeners = new Vector(10, 10);
    private Vector ackListeners = new Vector(10, 10);
    private Vector hbListeners = new Vector(10, 10);
    private Vector amListeners = new Vector(10, 10);
    private Vector rmListeners = new Vector(10, 10);
    private Vector cgListeners = new Vector();
    private boolean done = false;

    public UcastInputDispThread(TRAMControlBlock tRAMControlBlock) {
        super(name);
        this.setDaemon(true);
        this.tramblk = tRAMControlBlock;
        this.logger = tRAMControlBlock.getLogger();
        this.start();
    }

    public void run() {
        if (this.tramblk.getSimulator() == null) {
            DatagramSocket datagramSocket = this.tramblk.getUnicastSocket();
            while (!this.done) {
                try {
                    byte[] byArray = new byte[1350];
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, 1350);
                    if (datagramPacket == null) continue;
                    datagramSocket.receive(datagramPacket);
                    this.dispatchPacket(datagramPacket);
                }
                catch (IOException iOException) {
                    if (this.done) continue;
                    iOException.printStackTrace();
                }
                catch (Exception exception) {
                    if (this.logger.requiresLogging(1023)) {
                        this.logger.putPacketln(this, "Got an error in the ucast run loop");
                    }
                    exception.printStackTrace();
                }
            }
        }
        if (this.logger.requiresLogging(3)) {
            this.logger.putPacketln(this, "Thread exit!!");
        }
    }

    void dispatchPacket(DatagramPacket datagramPacket) {
        int n;
        if (TRAMPacket.getVersionNumber(datagramPacket) != 2) {
            if (this.logger.requiresLogging(1023)) {
                this.logger.putPacketln(this, "Dropping packet due to Version# mismatch. Expect 2 Got " + TRAMPacket.getVersionNumber(datagramPacket));
            }
            return;
        }
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Got a packet from " + datagramPacket.getAddress() + " Type    = " + TRAMPacket.getMessageType(datagramPacket) + " SubType = " + TRAMPacket.getSubType(datagramPacket));
        }
        if ((n = this.tramblk.getSessionId()) != 0 && TRAMPacket.getId(datagramPacket) != n) {
            if (this.logger.requiresLogging(35)) {
                this.logger.putPacketln(this, "Discarding a UCast packet from " + datagramPacket.getAddress() + " for SessionId Mismatch");
            }
            return;
        }
        if (TRAMPacket.getMessageType(datagramPacket) == 3) {
            switch (TRAMPacket.getSubType(datagramPacket)) {
                case 3: {
                    if (this.logger.requiresLogging(55)) {
                        this.logger.putPacketln(this, "Got a Hello uni message from " + datagramPacket.getAddress());
                    }
                    TRAMHelloUniPacket tRAMHelloUniPacket = new TRAMHelloUniPacket(datagramPacket);
                    try {
                        TRAMHelloUniPacketEvent tRAMHelloUniPacketEvent = new TRAMHelloUniPacketEvent(this, tRAMHelloUniPacket);
                        this.notifyTRAMHelloUniPacketEvent(tRAMHelloUniPacketEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (!this.logger.requiresLogging(35)) break;
                        this.logger.putPacketln(this, exception.getMessage());
                    }
                    break;
                }
                case 5: {
                    if (this.logger.requiresLogging(39)) {
                        this.logger.putPacketln(this, "Got a HB message from " + datagramPacket.getAddress());
                    }
                    TRAMHbPacket tRAMHbPacket = new TRAMHbPacket(datagramPacket);
                    try {
                        TRAMHbPacketEvent tRAMHbPacketEvent = new TRAMHbPacketEvent(this, tRAMHbPacket);
                        this.notifyTRAMHbPacketEvent(tRAMHbPacketEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (!this.logger.requiresLogging(35)) break;
                        this.logger.putPacketln(this, exception.getMessage());
                    }
                    break;
                }
                case 1: {
                    if (this.logger.requiresLogging(39)) {
                        this.logger.putPacketln(this, "Got a AM message from " + datagramPacket.getAddress());
                    }
                    TRAMAmPacket tRAMAmPacket = new TRAMAmPacket(datagramPacket);
                    try {
                        TRAMAmPacketEvent tRAMAmPacketEvent = new TRAMAmPacketEvent(this, tRAMAmPacket);
                        this.notifyTRAMAmPacketEvent(tRAMAmPacketEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (!this.logger.requiresLogging(35)) break;
                        this.logger.putPacketln(this, exception.getMessage());
                    }
                    break;
                }
                case 2: {
                    if (this.logger.requiresLogging(39)) {
                        this.logger.putPacketln(this, "Got an RM message from " + datagramPacket.getAddress());
                    }
                    TRAMRmPacket tRAMRmPacket = new TRAMRmPacket(datagramPacket);
                    try {
                        TRAMRmPacketEvent tRAMRmPacketEvent = new TRAMRmPacketEvent(this, tRAMRmPacket);
                        this.notifyTRAMRmPacketEvent(tRAMRmPacketEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (!this.logger.requiresLogging(35)) break;
                        this.logger.putPacketln(this, exception.getMessage());
                    }
                    break;
                }
                case 4: {
                    if (this.logger.requiresLogging(39)) {
                        this.logger.putPacketln(this, "Got an ACK message from " + datagramPacket.getAddress());
                    }
                    try {
                        TRAMAckPacket tRAMAckPacket = new TRAMAckPacket(datagramPacket);
                        TRAMAckPacketEvent tRAMAckPacketEvent = new TRAMAckPacketEvent(this, tRAMAckPacket);
                        this.notifyTRAMAckPacketEvent(tRAMAckPacketEvent);
                        break;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (!this.logger.requiresLogging(1023)) break;
                        this.logger.putPacketln(this, exception.toString());
                    }
                }
            }
        }
    }

    public synchronized void addTRAMAckPacketListener(TRAMAckPacketListener tRAMAckPacketListener) {
        Vector vector = this.ackListeners;
        synchronized (vector) {
            this.ackListeners.addElement(tRAMAckPacketListener);
        }
    }

    public void removeTRAMAckPacketListener(TRAMAckPacketListener tRAMAckPacketListener) {
        Vector vector = this.ackListeners;
        synchronized (vector) {
            this.ackListeners.removeElement(tRAMAckPacketListener);
        }
    }

    public void notifyTRAMAckPacketEvent(TRAMAckPacketEvent tRAMAckPacketEvent) {
        Vector vector = this.ackListeners;
        synchronized (vector) {
            int n = 0;
            while (n < this.ackListeners.size()) {
                ((TRAMAckPacketListener)this.ackListeners.elementAt(n)).receiveAckPacket(tRAMAckPacketEvent);
                ++n;
            }
        }
    }

    public synchronized void addTRAMAmPacketListener(TRAMAmPacketListener tRAMAmPacketListener) {
        Vector vector = this.amListeners;
        synchronized (vector) {
            this.amListeners.addElement(tRAMAmPacketListener);
        }
    }

    public void removeTRAMAmPacketListener(TRAMAmPacketListener tRAMAmPacketListener) {
        Vector vector = this.amListeners;
        synchronized (vector) {
            this.amListeners.removeElement(tRAMAmPacketListener);
        }
    }

    public void notifyTRAMAmPacketEvent(TRAMAmPacketEvent tRAMAmPacketEvent) {
        Vector vector = this.amListeners;
        synchronized (vector) {
            int n = 0;
            while (n < this.amListeners.size()) {
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "found an AM listener");
                }
                ((TRAMAmPacketListener)this.amListeners.elementAt(n)).receiveTRAMAmPacket(tRAMAmPacketEvent);
                ++n;
            }
        }
    }

    public synchronized void addTRAMRmPacketListener(TRAMRmPacketListener tRAMRmPacketListener) {
        Vector vector = this.rmListeners;
        synchronized (vector) {
            this.rmListeners.addElement(tRAMRmPacketListener);
        }
    }

    public void removeTRAMRmPacketListener(TRAMRmPacketListener tRAMRmPacketListener) {
        Vector vector = this.rmListeners;
        synchronized (vector) {
            this.rmListeners.removeElement(tRAMRmPacketListener);
        }
    }

    public void notifyTRAMRmPacketEvent(TRAMRmPacketEvent tRAMRmPacketEvent) {
        Vector vector = this.rmListeners;
        synchronized (vector) {
            int n = 0;
            while (n < this.rmListeners.size()) {
                ((TRAMRmPacketListener)this.rmListeners.elementAt(n)).receiveTRAMRmPacket(tRAMRmPacketEvent);
                ++n;
            }
        }
    }

    public synchronized void addTRAMHbPacketListener(TRAMHbPacketListener tRAMHbPacketListener) {
        Vector vector = this.hbListeners;
        synchronized (vector) {
            this.hbListeners.addElement(tRAMHbPacketListener);
        }
    }

    public void removeTRAMHbPacketListener(TRAMHbPacketListener tRAMHbPacketListener) {
        Vector vector = this.hbListeners;
        synchronized (vector) {
            this.hbListeners.removeElement(tRAMHbPacketListener);
        }
    }

    public void notifyTRAMHbPacketEvent(TRAMHbPacketEvent tRAMHbPacketEvent) {
        Vector vector = this.hbListeners;
        synchronized (vector) {
            int n = 0;
            while (n < this.hbListeners.size()) {
                ((TRAMHbPacketListener)this.hbListeners.elementAt(n)).receiveTRAMHbPacket(tRAMHbPacketEvent);
                ++n;
            }
        }
    }

    public synchronized void addTRAMHelloUniPacketListener(TRAMHelloUniPacketListener tRAMHelloUniPacketListener) {
        Vector vector = this.helloUniListeners;
        synchronized (vector) {
            this.helloUniListeners.addElement(tRAMHelloUniPacketListener);
        }
    }

    public void removeTRAMHelloUniPacketListener(TRAMHelloUniPacketListener tRAMHelloUniPacketListener) {
        Vector vector = this.helloUniListeners;
        synchronized (vector) {
            this.helloUniListeners.removeElement(tRAMHelloUniPacketListener);
        }
    }

    public void notifyTRAMHelloUniPacketEvent(TRAMHelloUniPacketEvent tRAMHelloUniPacketEvent) {
        Vector vector = this.helloUniListeners;
        synchronized (vector) {
            int n = 0;
            while (n < this.helloUniListeners.size()) {
                ((TRAMHelloUniPacketListener)this.helloUniListeners.elementAt(n)).receiveTRAMHelloUniPacket(tRAMHelloUniPacketEvent);
                ++n;
            }
        }
    }

    public void terminate() {
        this.done = true;
    }
}

