/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.InvalidMulticastAddressException;
import com.sun.multicast.reliable.transport.InvalidTransportProfileException;
import com.sun.multicast.reliable.transport.RMPacketSocket;
import com.sun.multicast.reliable.transport.RMStreamSocket;
import com.sun.multicast.reliable.transport.TransportProfile;
import com.sun.multicast.reliable.transport.tram.TRAMConfigurator;
import com.sun.multicast.reliable.transport.tram.TRAMLogger;
import com.sun.multicast.reliable.transport.tram.TRAMPacketSocket;
import com.sun.multicast.reliable.transport.tram.TRAMSimulator;
import com.sun.multicast.reliable.transport.tram.TRAMStreamSocket;
import com.sun.multicast.util.UnsupportedException;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;

public class TRAMTransportProfile
implements TransportProfile,
Cloneable,
Serializable {
    private static final int MAX_PORT_NUMBER = 65535;
    public static final int MIN_CONG_WINDOW_MULTIPLE = 2;
    public static final int MAX_CONG_WINDOW_MULTIPLE = 5;
    public static final int LATE_JOIN_WITH_LIMITED_RECOVERY = 1;
    protected static final int LATE_JOIN_WITH_FULL_RECOVERY = 2;
    public static final int LATE_JOIN_WITH_NO_RECOVERY = 3;
    public static final int TREE_FORM_HA = 1;
    public static final int TREE_FORM_MTHA = 2;
    public static final int TREE_FORM_HAMTHA = 3;
    public static final int TREE_FORM_STATIC_R = 32;
    public static final int TREE_FORM_STATIC_RW = 96;
    public static final int TREE_FORM_HA_STATIC_R = 33;
    public static final int TREE_FORM_MTHA_STATIC_R = 34;
    public static final int TREE_FORM_HAMTHA_STATIC_R = 35;
    public static final int TREE_FORM_HA_STATIC_RW = 97;
    public static final int TREE_FORM_MTHA_STATIC_RW = 98;
    public static final int TREE_FORM_HAMTHA_STATIC_RW = 99;
    public static final int LOG_VERBOSE = 1023;
    public static final int LOG_NONE = 0;
    public static final int LOG_DIAGNOSTICS = 3;
    public static final int LOG_INFO = 1;
    public static final int LOG_CONGESTION = 16;
    public static final int LOG_CONTROL_MESG = 32;
    public static final int LOG_DATA_MESG = 64;
    public static final int LOG_SESSION_STATUS = 128;
    public static final int LOG_SECURITY = 512;
    public static final int LOG_DATA_CACHE = 256;
    public static final int LOG_TEST = 1;
    public static final int LOG_PERFORMANCE_MONITOR = 1024;
    private String n = "TRAM V2";
    private InetAddress a = null;
    private int p = 4567;
    private byte ttl = 1;
    private boolean m = false;
    private boolean o = false;
    private byte mr = (byte)3;
    private byte tm = (byte)2;
    private short xm = (short)32;
    private boolean h = false;
    private short xnh = this.xm < 3 ? (short)(this.xm / 2) : (short)(2 * this.xm / 3);
    private long hr = 1000L;
    private long phr = 1000L;
    private long msr = 500L;
    private long br = 1000L;
    private short nw = (short)5;
    private byte xhm = (byte)5;
    private short aw = (short)32;
    private short xc = (short)5;
    private short cw = (short)(2 * this.aw);
    private short nackReportWindow = (short)5;
    private byte maxHelloMisses = (byte)5;
    private byte bti = (byte)2;
    private int up = 0;
    private double s = 0.0;
    private long d = 0L;
    private long xr = 64000L;
    private long nr = 1000L;
    private InetAddress sa = null;
    private int lm = 0;
    private byte hti = (byte)2;
    private byte htl = 1;
    private byte mti = 1;
    private long hi = 2000L;
    private long xbd = this.xr / 20L;
    private long xbt = this.xr;
    private int tfp = 3;
    private int ljp = 3;
    private int xb = 1454;
    private boolean alt = false;
    private boolean ua = false;
    private transient String afn = null;
    private transient String apw = null;
    private int id;
    private boolean sx = false;
    private int cs = 1200;
    private int mtp = 5;
    private boolean rad = true;
    private int receiveBufferSize = 0;
    private boolean decentralizedPruning = false;
    private double pW = 1.5;
    private transient long receiverMaxDataRate = 0L;
    private transient int maxConsecutiveCongestionCount = 1;
    private double rim = 0.15;
    private int tfarc = 5;
    private int mpt = this.aw / 4;

    public TRAMTransportProfile(String string) throws IOException {
        TRAMConfigurator.LoadConfig(string, this);
    }

    public TRAMTransportProfile(InetAddress inetAddress, int n) throws IOException, InvalidMulticastAddressException {
        this.setAddress(inetAddress);
        this.setPort(n);
    }

    public static void main(String[] stringArray) {
        TRAMTransportProfile tRAMTransportProfile = null;
        if (stringArray.length == 0) {
            System.out.println("No config file specified. Loading default");
            System.exit(1);
        } else {
            System.out.println("Using " + stringArray[0] + " as config file ");
            try {
                tRAMTransportProfile = new TRAMTransportProfile(stringArray[0]);
            }
            catch (IOException iOException) {
                System.out.println("IOException");
                System.exit(1);
            }
        }
        System.out.println("Mrole = " + tRAMTransportProfile.getMrole());
        System.out.println("Tmode = " + tRAMTransportProfile.getTmode());
        System.out.println("Address = " + tRAMTransportProfile.getAddress().getHostName());
        System.out.println("Port = " + tRAMTransportProfile.getPort());
        System.out.println("TTL = " + tRAMTransportProfile.getTTL());
        System.out.println("Max Members = " + tRAMTransportProfile.getMaxMembers());
        System.out.println("Hello Rate = " + tRAMTransportProfile.getHelloRate());
        System.out.println("Ms Rate= " + tRAMTransportProfile.getMsRate());
        System.out.println("Beacon Rate = " + tRAMTransportProfile.getBeaconRate());
        System.out.println("Ack Window = " + tRAMTransportProfile.getAckWindow());
        System.out.println("Nack Window = " + tRAMTransportProfile.getNackReportWindow());
        System.out.println("HelloMisses = " + tRAMTransportProfile.getMaxHelloMisses());
        System.out.println("Ms TTL Incr = " + tRAMTransportProfile.getMsTTLIncrements());
        System.out.println("Beacon TTL Incr = " + tRAMTransportProfile.getBeaconTTLIncrements());
        System.out.println("Unicast Port = " + tRAMTransportProfile.getUnicastPort());
        System.out.println("Min Rate = " + tRAMTransportProfile.getMinDataRate());
        System.out.println("Max Rate = " + tRAMTransportProfile.getMaxDataRate());
        System.out.println("Data Src Address = " + tRAMTransportProfile.getDataSourceAddress().getHostName());
        System.out.println("Hello Rate = " + tRAMTransportProfile.getHelloRate());
        System.out.println("Maximum Buffer Size = " + tRAMTransportProfile.getMaxBuf());
        if (!tRAMTransportProfile.isValid()) {
            System.out.println("The config is Invalid");
        }
    }

    public RMStreamSocket createRMStreamSocket(int n) throws UnsupportedException, InvalidTransportProfileException, IOException {
        return this.createRMStreamSocket(n, null);
    }

    public RMStreamSocket createRMStreamSocket(int n, InetAddress inetAddress) throws UnsupportedException, InvalidTransportProfileException, IOException {
        this.validate();
        this.setOrdered(true);
        switch (n) {
            case 2: {
                this.setTmode((byte)2);
                break;
            }
            case 1: {
                this.setTmode((byte)1);
                this.setMrole((byte)2);
                break;
            }
            default: {
                throw new UnsupportedException("Mode specified is unsupported " + n);
            }
        }
        this.randomizeTimers();
        TRAMStreamSocket tRAMStreamSocket = new TRAMStreamSocket();
        tRAMStreamSocket.connect(this, inetAddress);
        return tRAMStreamSocket;
    }

    public RMPacketSocket createRMPacketSocket(int n) throws UnsupportedException, InvalidTransportProfileException, IOException {
        return this.createRMPacketSocket(n, (InetAddress)null);
    }

    public RMPacketSocket createRMPacketSocket(int n, InetAddress inetAddress) throws UnsupportedException, InvalidTransportProfileException, IOException {
        this.validate();
        switch (n) {
            case 2: {
                this.setTmode((byte)2);
                break;
            }
            case 1: {
                this.setTmode((byte)1);
                this.setMrole((byte)2);
                break;
            }
            case 4: {
                this.h = true;
                break;
            }
            default: {
                throw new UnsupportedException("Mode specified is unsupported " + n);
            }
        }
        this.randomizeTimers();
        TRAMPacketSocket tRAMPacketSocket = new TRAMPacketSocket();
        tRAMPacketSocket.connect(this, inetAddress);
        return tRAMPacketSocket;
    }

    public RMPacketSocket createRMPacketSocket(int n, TRAMSimulator tRAMSimulator) throws UnsupportedException, InvalidTransportProfileException, IOException {
        return this.createRMPacketSocket(n, null, tRAMSimulator);
    }

    public RMPacketSocket createRMPacketSocket(int n, InetAddress inetAddress, TRAMSimulator tRAMSimulator) throws UnsupportedException, InvalidTransportProfileException, IOException {
        this.validate();
        switch (n) {
            case 2: {
                this.setTmode((byte)2);
                break;
            }
            case 1: {
                this.setTmode((byte)1);
                this.setMrole((byte)2);
                break;
            }
            default: {
                throw new UnsupportedException("Mode specified is unsupported " + n);
            }
        }
        this.randomizeTimers();
        TRAMPacketSocket tRAMPacketSocket = new TRAMPacketSocket(tRAMSimulator);
        tRAMPacketSocket.connect(this, inetAddress);
        return tRAMPacketSocket;
    }

    public Object clone() {
        TRAMTransportProfile tRAMTransportProfile = null;
        try {
            tRAMTransportProfile = (TRAMTransportProfile)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("TransportProfile Not Cloneable");
        }
        return tRAMTransportProfile;
    }

    private void validate() throws InvalidTransportProfileException {
        if (!this.a.isMulticastAddress()) {
            throw new InvalidTransportProfileException("invalid multicast address");
        }
        if (this.p < 0 || this.p > 65535) {
            throw new InvalidTransportProfileException("invalid multicast port");
        }
        if (this.up < 0 || this.up > 65535) {
            throw new InvalidTransportProfileException("invalid unicast port");
        }
        if (this.ttl == 0) {
            throw new InvalidTransportProfileException("invalid TTL");
        }
        if (this.m) {
            throw new InvalidTransportProfileException("multisender not supported");
        }
        if (this.mr < 1 || this.mr > 3) {
            throw new InvalidTransportProfileException("invalid mrole");
        }
        if (this.tm < 1 || this.tm > 3) {
            throw new InvalidTransportProfileException("invalid tmode");
        }
    }

    public boolean isValid() {
        boolean bl = true;
        try {
            this.validate();
        }
        catch (InvalidTransportProfileException invalidTransportProfileException) {
            bl = false;
        }
        return bl;
    }

    public String getName() {
        return this.n;
    }

    public boolean getSAhead() {
        return this.h;
    }

    public InetAddress getAddress() {
        return this.a;
    }

    public void setAddress(InetAddress inetAddress) throws InvalidMulticastAddressException {
        if (!inetAddress.isMulticastAddress()) {
            throw new InvalidMulticastAddressException("The address specified is not a valid multicast address");
        }
        this.a = inetAddress;
    }

    public int getPort() {
        return this.p;
    }

    public void setPort(int n) {
        this.p = n;
    }

    public byte getTTL() {
        return this.ttl;
    }

    public void setTTL(byte by) {
        this.ttl = by;
        this.htl = by;
    }

    public boolean isMultiSender() {
        return this.m;
    }

    public void setMultiSender(boolean bl) throws UnsupportedException {
        this.m = bl;
    }

    public boolean isOrdered() {
        return this.o;
    }

    public boolean isUsingAuthentication() {
        return this.ua;
    }

    public void setOrdered(boolean bl) {
        this.o = bl;
    }

    public byte getMrole() {
        return this.mr;
    }

    public void setMrole(byte by) throws IllegalArgumentException {
        if (by < 1 || by > 3) {
            throw new IllegalArgumentException();
        }
        this.mr = by;
    }

    public byte getTmode() {
        return this.tm;
    }

    public void setTmode(byte by) throws IllegalArgumentException {
        if (by < 1 || by > 4) {
            throw new IllegalArgumentException();
        }
        this.tm = by;
        try {
            if (this.tm == 1 && this.sa == null) {
                this.sa = InetAddress.getLocalHost();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public short getMaxMembers() {
        return this.xm;
    }

    public void setMaxMembers(short s) {
        this.xm = s;
        this.xnh = s < 3 ? (short)(s / 2) : (short)(2 * s / 3);
    }

    public long getHelloRate() {
        return this.hr;
    }

    public void setHelloRate(long l) {
        this.hr = l;
    }

    public long getPruneHelloRate() {
        return this.phr;
    }

    public void setPruneHelloRate(long l) {
        this.phr = l;
    }

    public long getMsRate() {
        return this.msr;
    }

    public void setMsRate(long l) {
        this.msr = l;
    }

    public long getBeaconRate() {
        return this.br;
    }

    public void setBeaconRate(long l) {
        this.br = l;
    }

    public short getAckWindow() {
        return this.aw;
    }

    public void setAckWindow(short s) {
        this.aw = s < 1 ? (short)1 : s;
        this.cw = (short)(2 * this.aw);
        if (this.cs < 3 * this.aw) {
            this.cs = Math.max(30, 3 * this.aw);
        }
    }

    public void setCongestionWindow(int n) {
        this.cw = n < this.aw ? this.aw : (n > this.xc * this.aw ? (short)(this.xc * this.aw) : (short)n);
    }

    public int getCongestionWindow() {
        return this.cw & 0xFFFF;
    }

    public short getNackReportWindow() {
        return this.nw;
    }

    public void setNackReportWindow(short s) {
        this.nw = s;
    }

    public byte getMaxHelloMisses() {
        return this.xhm;
    }

    public void setMaxHelloMisses(byte by) {
        this.xhm = by;
    }

    public byte getBeaconTTLIncrements() {
        return this.bti;
    }

    public void setBeaconTTLIncrements(byte by) {
        this.bti = by;
    }

    public int getUnicastPort() {
        return this.up;
    }

    public void setUnicastPort(int n) {
        this.up = n;
    }

    public double getTransferDataSize() {
        return this.s;
    }

    public void setTransferDataSize(double d) {
        this.s = d;
    }

    public long getTransferDuration() {
        return this.d;
    }

    public void setTransferDuration(long l) {
        this.d = l;
    }

    public long getMinDataRate() {
        return this.nr;
    }

    public void setMinDataRate(long l) {
        this.nr = l;
    }

    public long getMaxDataRate() {
        return this.xr;
    }

    public void setMaxDataRate(long l) {
        this.xr = l;
    }

    public InetAddress getDataSourceAddress() {
        return this.sa;
    }

    public void setDataSourceAddress(InetAddress inetAddress) {
        this.sa = inetAddress;
    }

    public void setLogMask(int n) {
        this.lm = n;
    }

    public boolean isLoggingEnabled() {
        return this.lm != 0;
    }

    public boolean isLoggingEnabled(int n) {
        return TRAMLogger.isLoggingEnabled(this.lm, n);
    }

    public int getLogMask() {
        return this.lm;
    }

    public void setLanTreeFormation(boolean bl) {
        this.alt = bl;
    }

    public boolean isLanTreeFormationEnabled() {
        return this.alt;
    }

    public int getMaxNonHeads() {
        return this.xnh;
    }

    public void setMaxNonHeads(int n) {
        this.xnh = (short)(n & 0xFFFF);
    }

    public byte getHaTTLIncrements() {
        return this.hti;
    }

    public void setHaTTLIncrements(byte by) {
        this.hti = by;
    }

    public byte getHaTTLLimit() {
        return this.htl;
    }

    public void setHaTTLLimit(byte by) {
        this.htl = by;
    }

    public byte getMsTTLIncrements() {
        return this.mti;
    }

    public void setMsTTLIncrements(byte by) {
        this.mti = by;
    }

    public long getMaxHABWWhileDataTransfer() {
        return this.xbd;
    }

    public void setMaxHABWWhileDataTransfer(long l) {
        this.xbd = l;
    }

    public long getMaxHABWWhileTreeForming() {
        return this.xbt;
    }

    public void setMaxHABWWhileTreeForming(long l) {
        this.xbt = l;
    }

    public long getHaInterval() {
        return this.hi;
    }

    public void setHaInterval(long l) {
        this.hi = l;
    }

    public int getLateJoinPreference() {
        return this.ljp;
    }

    public void setLateJoinPreference(int n) {
        this.ljp = n;
    }

    public int getTreeFormationPreference(boolean bl) {
        if (!bl) {
            return this.tfp;
        }
        return this.tfp & 0x1F;
    }

    public void setTreeFormationPreference(int n) {
        this.tfp = n;
    }

    public int getMaxBuf() {
        return this.xb;
    }

    public void setMaxBuf(int n) {
        this.xb = n;
    }

    void randomizeTimers() {
        double d = Math.random();
        d += 1.0;
        d *= 2.0;
        this.hr = (int)Math.rint((double)this.hr * (d /= 3.0));
        this.msr = (int)Math.rint((double)this.msr * d);
    }

    public void enableAuthentication() {
        this.ua = true;
    }

    public void disableAuthentication() {
        this.ua = false;
    }

    public String getAuthenticationSpecFileName() {
        return this.afn;
    }

    public void setAuthenticationSpecFileName(String string) {
        this.afn = string;
    }

    public String getAuthenticationSpecPassword() {
        return this.apw;
    }

    public void setAuthenticationSpecPassword(String string) {
        this.apw = string;
    }

    public int getSessionId() {
        return this.id;
    }

    public void setSessionId(int n) {
        this.id = n;
    }

    public void setSmoothTransmission(boolean bl) {
        this.sx = bl;
    }

    public boolean isSmoothTransmission() {
        return this.sx;
    }

    public void setCacheSize(int n) {
        this.cs = n < 30 || n < 3 * this.aw ? Math.max(30, 3 * this.aw) : n;
    }

    public int getCacheSize() {
        return this.cs;
    }

    public void setMaxPruneTime(int n) {
        if (n > 0) {
            this.mtp = n;
        }
    }

    public int getMaxPruneTime() {
        return this.mtp;
    }

    public void setreaffiliateAfterBeingDisowned(boolean bl) {
        this.rad = bl;
    }

    public boolean reaffiliateAfterBeingDisowned() {
        return this.rad;
    }

    public void setDecentralizedPruning(boolean bl) {
        this.decentralizedPruning = bl;
    }

    public boolean decentralizedPruning() {
        return this.decentralizedPruning;
    }

    public void setPruningWindow(double d) {
        if (d < 1.0 || d > 5.0) {
            return;
        }
        this.pW = d;
    }

    public double getPruningWindow() {
        return this.pW;
    }

    public void setReceiverMaxDataRate(long l) {
        this.receiverMaxDataRate = l;
    }

    public long getReceiverMaxDataRate() {
        return this.receiverMaxDataRate;
    }

    public void setMaxConsecutiveCongestionCount(int n) {
        this.maxConsecutiveCongestionCount = n;
    }

    public int getMaxConsecutiveCongestionCount() {
        return this.maxConsecutiveCongestionCount;
    }

    public void setReceiveBufferSize(int n) {
        this.receiveBufferSize = n;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setRateIncreaseFactor(double d) {
        this.rim = d;
    }

    public double getRateIncreaseFactor() {
        return this.rim;
    }

    public void setTimeForAvgRateCalc(int n) {
        this.tfarc = n;
    }

    public int getTimeForAvgRateCalc() {
        return this.tfarc;
    }

    public void setMissingPacketThreshold(int n) {
        this.mpt = n;
    }

    public int getMissingPacketThreshold() {
        return this.mpt;
    }

    public void setMaxCongestionWindowMultiple(int n) {
        this.xc = n < 2 ? (short)2 : (n > 5 ? (short)5 : (short)n);
    }

    public int getMaxCongestionWindowMultiple() {
        return this.xc;
    }
}

