/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.TRAMLogger;
import com.sun.multicast.reliable.transport.tram.TRAMTimerEventHandler;

class TRAMTimer
extends Thread {
    private String name;
    private TRAMTimerEventHandler handler = null;
    private boolean loaded;
    private TRAMLogger logger;
    private long time;
    private boolean running = false;
    private boolean done = false;

    public TRAMTimer(String string, TRAMTimerEventHandler tRAMTimerEventHandler) {
        super(string);
        this.initialize(string, tRAMTimerEventHandler);
        this.start();
    }

    public TRAMTimer(String string, TRAMTimerEventHandler tRAMTimerEventHandler, TRAMLogger tRAMLogger) {
        super(string);
        this.initialize(string, tRAMTimerEventHandler);
        this.logger = tRAMLogger;
        this.start();
    }

    private void initialize(String string, TRAMTimerEventHandler tRAMTimerEventHandler) {
        this.name = string;
        this.handler = tRAMTimerEventHandler;
        this.loaded = false;
        this.logger = null;
        this.time = 0L;
        this.running = false;
        this.setDaemon(true);
    }

    public void run() {
        while (!this.done) {
            long l = 0L;
            if (this.getLoaded()) {
                this.setRunning(true);
                l = this.getTime();
                try {
                    if (this.logger == null) {
                        System.out.println("Sleeping for " + l);
                    } else if (this.logger.requiresLogging(7)) {
                        this.logger.putPacketln(this, "Sleeping for " + l);
                    }
                    Thread.sleep(l);
                    this.setRunning(false);
                    this.setLoaded(false);
                    if (this.handler != null) {
                        this.handler.handleTimeout();
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (this.logger == null) {
                        System.out.println("Interruped ...");
                    } else if (this.logger.requiresLogging(7)) {
                        this.logger.putPacketln(this, "Interruped ...");
                    }
                    this.setRunning(false);
                }
            }
            if (this.getLoaded() || this.done) continue;
            if (this.logger == null) {
                System.out.println("Timer not loaded... suspending");
            } else if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Timer not loaded... suspending");
            }
            this.stall();
        }
    }

    private synchronized void stall() {
        block3: {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                if (this.logger == null) {
                    System.out.println("Interruped during wait...");
                }
                if (!this.logger.requiresLogging(7)) break block3;
                this.logger.putPacketln(this, "Interruped during wait...");
            }
        }
    }

    private synchronized void wake() {
        this.notifyAll();
    }

    public void loadTimer(long l) {
        if (this.logger == null) {
            System.out.println("Loading new timer " + l);
        } else if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Loading new timer " + l);
        }
        this.setTime(l);
        this.setLoaded(true);
        this.wake();
    }

    public void reloadTimer(long l) {
        if (this.logger == null) {
            System.out.println("Reloading new timer " + l);
        } else if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Reloading new timer " + l);
        }
        this.stopTimer();
        this.setTime(l);
        this.setLoaded(true);
        this.wake();
    }

    public void stopTimer() {
        if (this.logger == null) {
            System.out.println("In stopTimer");
        } else if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "In stopTimer");
        }
        if (this.getRunning()) {
            if (this.logger == null) {
                System.out.println("Stopping an active timer");
            } else if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Stopping an active timer");
            }
            this.setLoaded(false);
            this.setTime(0L);
            this.setRunning(false);
            this.interrupt();
        }
    }

    public void killTimer() {
        this.done = true;
        this.handler = null;
        this.wake();
        this.interrupt();
    }

    private synchronized boolean getLoaded() {
        return this.loaded;
    }

    private synchronized void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    private synchronized boolean getRunning() {
        return this.running;
    }

    private synchronized void setRunning(boolean bl) {
        this.running = bl;
    }

    private synchronized long getTime() {
        return this.time;
    }

    private synchronized void setTime(long l) {
        this.time = l;
    }
}

