/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.RMStatistics;
import com.sun.multicast.reliable.transport.RMStreamSocket;
import com.sun.multicast.reliable.transport.TransportProfile;
import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMControlBlockException;
import com.sun.multicast.reliable.transport.tram.TRAMInputOutput;
import com.sun.multicast.reliable.transport.tram.TRAMInputStream;
import com.sun.multicast.reliable.transport.tram.TRAMOutputStream;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;

public class TRAMStreamSocket
implements RMStreamSocket {
    private TRAMOutputStream outputStream = null;
    private TRAMInputStream inputStream = null;
    private TRAMControlBlock tramblk = null;
    private TRAMTransportProfile tp = null;
    private TRAMInputOutput pktio = null;

    void connect(TRAMTransportProfile tRAMTransportProfile, InetAddress inetAddress) throws IOException {
        this.tp = (TRAMTransportProfile)tRAMTransportProfile.clone();
        this.tp.setOrdered(true);
        MulticastSocket multicastSocket = new MulticastSocket(this.tp.getPort());
        try {
            int n = multicastSocket.getReceiveBufferSize();
            int n2 = 262144;
            while (n2 > n) {
                try {
                    multicastSocket.setReceiveBufferSize(n2);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (Exception exception) {
                    break;
                }
                n2 -= 1024;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        InetAddress inetAddress2 = inetAddress;
        if (inetAddress2 == null) {
            inetAddress2 = InetAddress.getLocalHost();
        }
        try {
            multicastSocket.setInterface(inetAddress2);
        }
        catch (SocketException socketException) {
            throw new IOException(socketException + " Unable to set multicast interface address to " + inetAddress2);
        }
        multicastSocket.joinGroup(this.tp.getAddress());
        try {
            this.tramblk = new TRAMControlBlock(multicastSocket, this.tp);
        }
        catch (TRAMControlBlockException tRAMControlBlockException) {
            throw new IOException(tRAMControlBlockException + "Unable create TRAM ControlBlock");
        }
        this.pktio = this.tramblk.getPacketDb();
    }

    public InetAddress getInterface() throws SocketException {
        MulticastSocket multicastSocket = this.tramblk.getMulticastSocket();
        return multicastSocket.getInterface();
    }

    public InputStream getInputStream() throws IOException {
        if ((this.tp.getTmode() & 0xFF) == 1) {
            throw new IOException("Sender may not receive its own data");
        }
        if (this.inputStream == null) {
            this.inputStream = new TRAMInputStream(this.tramblk, this.pktio);
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = new TRAMOutputStream(this.tramblk, this.pktio);
        }
        return this.outputStream;
    }

    public void setInterface(InetAddress inetAddress) throws SocketException {
        MulticastSocket multicastSocket = this.tramblk.getMulticastSocket();
        multicastSocket.setInterface(inetAddress);
    }

    public TransportProfile getTransportProfile() {
        return (TransportProfile)this.tp.clone();
    }

    public RMStatistics getRMStatistics() {
        return (RMStatistics)this.tramblk.getTRAMStats().clone();
    }

    public void abort() {
        if (this.tramblk != null) {
            this.tramblk.doTRAMAbort();
        }
    }

    public void close() {
        if (this.tramblk != null && this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

