/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.RMStatistics;
import com.sun.multicast.reliable.transport.tram.GroupMgmtBlk;
import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMPacket;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import com.sun.multicast.util.UnsupportedException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public class TRAMStats
implements RMStatistics,
Cloneable {
    TRAMControlBlock tramblk = null;
    private long bytesSent = 0L;
    private long bytesReSent = 0L;
    private long bytesRcvd = 0L;
    private long retransBytesRcvd = 0L;
    private long packetsSent = 0L;
    private long packetsRcvd = 0L;
    private long retransSent = 0L;
    private long retransRcvd = 0L;
    private long duplicatePackets = 0L;
    private long duplicateBytes = 0L;
    private long dataStartTime = 0L;
    private long packetsNotRecovered = 0L;
    private long packetsNotDelivered = 0L;
    private int prunedMembers = 0;
    private int lostMembers = 0;
    private long mcastCntlBytesSent = 0L;
    private long mcastCntlBytesRcvd = 0L;
    private long mcastBeaconSent = 0L;
    private long mcastBeaconRcvd = 0L;
    private long mcastHelloSent = 0L;
    private long mcastHelloRcvd = 0L;
    private long mcastHASent = 0L;
    private long mcastHARcvd = 0L;
    private long mcastMSSent = 0L;
    private long mcastMSRcvd = 0L;
    private long ucastCntlBytesSent = 0L;
    private long ucastCntlBytesRcvd = 0L;
    private long ucastAMSent = 0L;
    private long ucastAMRcvd = 0L;
    private long ucastRMSent = 0L;
    private long ucastRMRcvd = 0L;
    private long ucastHelloSent = 0L;
    private long ucastHelloRcvd = 0L;
    private long ucastACKSent = 0L;
    private long ucastACKRcvd = 0L;
    private long ucastCongSent = 0L;
    private long ucastCongRcvd = 0L;
    private long ucastHBSent = 0L;
    private long ucastHBRcvd = 0L;
    private Vector senderAddresses = null;
    private Vector receiverAddresses = null;

    public TRAMStats(TRAMControlBlock tRAMControlBlock) {
        this.tramblk = tRAMControlBlock;
    }

    public int getSenderCount() throws UnsupportedException {
        if (this.senderAddresses == null) {
            return 0;
        }
        return this.senderAddresses.size();
    }

    public InetAddress[] getSenderList() throws UnsupportedException {
        InetAddress[] inetAddressArray = null;
        if (this.senderAddresses == null || this.senderAddresses.size() == 0) {
            return inetAddressArray;
        }
        inetAddressArray = new InetAddress[this.senderAddresses.size() + 1];
        int n = 0;
        while (n < this.senderAddresses.size()) {
            try {
                InetAddress inetAddress = (InetAddress)this.senderAddresses.elementAt(n);
                InetAddress inetAddress2 = InetAddress.getByName(inetAddress.getHostAddress());
                inetAddressArray[n] = InetAddress.getByName(inetAddress.getHostAddress());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                break;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            ++n;
        }
        return inetAddressArray;
    }

    public int getReceiverCount() {
        int n = 0;
        TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
        try {
            GroupMgmtBlk groupMgmtBlk = this.tramblk.getGroupMgmtBlk();
            n = groupMgmtBlk.getDirectMemberCount() + groupMgmtBlk.getIndirectMemberCount();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return n;
    }

    public int getDirectMemberCount() {
        try {
            GroupMgmtBlk groupMgmtBlk = this.tramblk.getGroupMgmtBlk();
            return groupMgmtBlk.getDirectMemberCount();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public int getIndirectMemberCount() {
        try {
            GroupMgmtBlk groupMgmtBlk = this.tramblk.getGroupMgmtBlk();
            return groupMgmtBlk.getIndirectMemberCount();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public InetAddress[] getReceiverList() throws UnsupportedException {
        throw new UnsupportedException();
    }

    public long getTotalDataSent() throws UnsupportedException {
        return this.bytesSent;
    }

    public long getTotalDataReSent() throws UnsupportedException {
        return this.bytesReSent;
    }

    public long getTotalDataReceive() throws UnsupportedException {
        return this.bytesRcvd;
    }

    protected Object clone() {
        TRAMStats tRAMStats = null;
        int n = 0;
        try {
            tRAMStats = (TRAMStats)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("TRAMStats Not Cloneable");
        }
        if (this.senderAddresses != null && this.senderAddresses.size() != 0) {
            n = 0;
            while (n < this.senderAddresses.size()) {
                try {
                    tRAMStats.addSender((InetAddress)this.senderAddresses.elementAt(n));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                ++n;
            }
        }
        if (this.receiverAddresses != null && this.receiverAddresses.size() != 0) {
            n = 0;
            while (n < this.receiverAddresses.size()) {
                try {
                    tRAMStats.addReceiver((InetAddress)this.receiverAddresses.elementAt(n));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                ++n;
            }
        }
        tRAMStats.setPacketsNotRecovered(this.packetsNotRecovered);
        tRAMStats.setPacketsNotDelivered(this.packetsNotDelivered);
        return tRAMStats;
    }

    public void addSender(InetAddress inetAddress) {
        if (this.senderAddresses == null) {
            this.senderAddresses = new Vector();
        }
        if (this.senderAddresses.size() != 0) {
            this.senderAddresses.removeAllElements();
        }
        this.senderAddresses.addElement(inetAddress);
    }

    public void removeSender(InetAddress inetAddress) {
        if (this.senderAddresses == null || this.senderAddresses.size() == 0) {
            return;
        }
        int n = 0;
        while (n < this.senderAddresses.size()) {
            try {
                InetAddress inetAddress2 = (InetAddress)this.senderAddresses.elementAt(n);
                if (inetAddress.equals(inetAddress2)) {
                    this.senderAddresses.removeElement(inetAddress2);
                    return;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void addReceiver(InetAddress inetAddress) {
        if (this.receiverAddresses == null) {
            this.receiverAddresses = new Vector();
        }
        this.receiverAddresses.addElement(inetAddress);
    }

    public void removeReceiver(InetAddress inetAddress) {
        if (this.receiverAddresses == null || this.receiverAddresses.size() == 0) {
            return;
        }
        int n = 0;
        while (n < this.receiverAddresses.size()) {
            try {
                InetAddress inetAddress2 = (InetAddress)this.receiverAddresses.elementAt(n);
                if (inetAddress.equals(inetAddress2)) {
                    this.receiverAddresses.removeElement(inetAddress2);
                    return;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++n;
        }
    }

    public long getPacketsSent() {
        return this.packetsSent;
    }

    public long getPacketsRcvd() {
        return this.packetsRcvd;
    }

    public long getDuplicatePackets() {
        return this.duplicatePackets;
    }

    public long getDuplicateBytes() {
        return this.duplicateBytes;
    }

    public long getPacketsNotRecovered() {
        return this.packetsNotRecovered;
    }

    public void setPacketsNotRecovered(long l) {
        this.packetsNotRecovered = l;
    }

    public long getPacketsNotDelivered() {
        return this.packetsNotDelivered;
    }

    public void setPacketsNotDelivered(long l) {
        this.packetsNotDelivered = l;
    }

    public void addBytesSent(long l) {
        this.bytesSent += l;
    }

    public void addBytesReSent(long l) {
        this.bytesReSent += l;
    }

    public void addPacketsSent() {
        ++this.packetsSent;
    }

    public void addPacketsSent(long l) {
        this.packetsSent += l;
    }

    public void addBytesRcvd(long l) {
        this.bytesRcvd += l;
    }

    protected void addPacketsRcvd() {
        ++this.packetsRcvd;
    }

    protected void incPacketsRcvd() {
        ++this.packetsRcvd;
    }

    protected void addPacketsRcvd(long l) {
        this.packetsRcvd += l;
    }

    protected void addDuplicatePackets() {
        ++this.duplicatePackets;
    }

    protected void addDuplicatePackets(long l) {
        this.duplicatePackets += l;
    }

    protected void addDuplicateBytes(long l) {
        this.duplicateBytes += l;
    }

    protected void addPacketsNotRecovered(long l) {
        this.packetsNotRecovered += l;
    }

    protected void addPacketsNotDelivered(long l) {
        this.packetsNotDelivered += l;
    }

    public int getPeakMembers() {
        GroupMgmtBlk groupMgmtBlk = this.tramblk.getGroupMgmtBlk();
        return groupMgmtBlk.getPeakMemberCount();
    }

    public int getPrunedMembers() {
        return this.prunedMembers;
    }

    public int getLostMembers() {
        return this.lostMembers;
    }

    protected void addPrunedMembers() {
        ++this.prunedMembers;
    }

    protected void addPrunedMembers(int n) {
        this.prunedMembers += n;
    }

    protected void addLostMembers() {
        ++this.lostMembers;
    }

    protected void addLostMembers(int n) {
        this.lostMembers += n;
    }

    protected void addRetransBytesRcvd(int n) {
        this.retransBytesRcvd += (long)n;
    }

    protected void incRetransSent() {
        ++this.retransSent;
    }

    public long getRetransmissionsSent() {
        return this.retransSent;
    }

    protected void incRetransRcvd() {
        ++this.retransRcvd;
    }

    public long getRetransmissionsRcvd() {
        return this.retransRcvd;
    }

    public long getRetransBytesRcvd() {
        return this.retransBytesRcvd;
    }

    public long getDataStartTime() {
        return this.dataStartTime;
    }

    protected void setDataStartTime(long l) {
        this.dataStartTime = l;
    }

    public void setRcvdCntlMsgCounters(TRAMPacket tRAMPacket) {
        switch (tRAMPacket.getMessageType()) {
            case 1: {
                this.mcastCntlBytesRcvd += (long)tRAMPacket.getLength();
                switch (tRAMPacket.getSubType()) {
                    case 1: {
                        ++this.mcastBeaconRcvd;
                        break;
                    }
                    case 2: {
                        ++this.mcastHelloRcvd;
                        break;
                    }
                    case 3: {
                        ++this.mcastHARcvd;
                        break;
                    }
                    case 4: {
                        ++this.mcastMSRcvd;
                    }
                }
                break;
            }
            case 3: {
                this.ucastCntlBytesRcvd += (long)tRAMPacket.getLength();
                switch (tRAMPacket.getSubType()) {
                    case 1: {
                        ++this.ucastAMRcvd;
                        break;
                    }
                    case 2: {
                        ++this.ucastRMRcvd;
                        break;
                    }
                    case 3: {
                        ++this.ucastHelloRcvd;
                        break;
                    }
                    case 4: {
                        if ((tRAMPacket.getFlags() & 4) != 0) {
                            ++this.ucastACKRcvd;
                        }
                        if ((tRAMPacket.getFlags() & 8) == 0) break;
                        ++this.ucastCongRcvd;
                        break;
                    }
                    case 5: {
                        ++this.ucastHBRcvd;
                    }
                }
                break;
            }
        }
    }

    public void setSendCntlMsgCounters(TRAMPacket tRAMPacket) {
        switch (tRAMPacket.getMessageType()) {
            case 1: {
                this.mcastCntlBytesSent += (long)tRAMPacket.getLength();
                switch (tRAMPacket.getSubType()) {
                    case 1: {
                        ++this.mcastBeaconSent;
                        break;
                    }
                    case 2: {
                        ++this.mcastHelloSent;
                        break;
                    }
                    case 3: {
                        ++this.mcastHASent;
                        break;
                    }
                    case 4: {
                        ++this.mcastMSSent;
                    }
                }
                break;
            }
            case 3: {
                this.ucastCntlBytesSent += (long)tRAMPacket.getLength();
                switch (tRAMPacket.getSubType()) {
                    case 1: {
                        ++this.ucastAMSent;
                        break;
                    }
                    case 2: {
                        ++this.ucastRMSent;
                        break;
                    }
                    case 3: {
                        ++this.ucastHelloSent;
                        break;
                    }
                    case 4: {
                        if ((tRAMPacket.getFlags() & 4) != 0) {
                            ++this.ucastACKSent;
                        }
                        if ((tRAMPacket.getFlags() & 8) == 0) break;
                        ++this.ucastCongSent;
                        break;
                    }
                    case 5: {
                        ++this.ucastHBSent;
                    }
                }
                break;
            }
        }
    }

    public long getMcastControlBytesSent() {
        return this.mcastCntlBytesSent;
    }

    public long getMcastControlBytesRcvd() {
        return this.mcastCntlBytesRcvd;
    }

    public long getMcastBeaconSent() {
        return this.mcastBeaconSent;
    }

    public long getMcastBeaconRcvd() {
        return this.mcastBeaconRcvd;
    }

    public long getMcastHelloSent() {
        return this.mcastHelloSent;
    }

    public long getMcastHelloRcvd() {
        return this.mcastHelloRcvd;
    }

    public long getMcastHASent() {
        return this.mcastHASent;
    }

    public long getMcastHARcvd() {
        return this.mcastHARcvd;
    }

    public long getMcastMSSent() {
        return this.mcastMSSent;
    }

    public long getMcastMSRcvd() {
        return this.mcastMSRcvd;
    }

    public long ucastCntlBytesSent() {
        return this.ucastCntlBytesSent;
    }

    public long ucastCntlBytesRcvd() {
        return this.ucastCntlBytesRcvd;
    }

    public long ucastAMSent() {
        return this.ucastAMSent;
    }

    public long ucastAMRcvd() {
        return this.ucastAMRcvd;
    }

    public long ucastRMSent() {
        return this.ucastRMSent;
    }

    public long ucastRMRcvd() {
        return this.ucastRMRcvd;
    }

    public long ucastHelloSent() {
        return this.ucastHelloSent;
    }

    public long ucastHelloRcvd() {
        return this.ucastHelloRcvd;
    }

    public long ucastACKSent() {
        return this.ucastACKSent;
    }

    public long ucastACKRcvd() {
        return this.ucastACKRcvd;
    }

    public long ucastCongSent() {
        return this.ucastCongSent;
    }

    public long ucastCongRcvd() {
        return this.ucastCongRcvd;
    }

    public long ucastHBSent() {
        return this.ucastHBSent;
    }

    public long ucastHBRcvd() {
        return this.ucastHBRcvd;
    }
}

