/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

class TRAMSeqNumber {
    private int seqNumber = 1;
    private static long MASK = 0xFFFFFFFFL;
    private static final long ROLLOVERMAX = Integer.MAX_VALUE;

    public TRAMSeqNumber() {
    }

    public TRAMSeqNumber(int n) {
        this.seqNumber = n;
    }

    public static void main(String[] stringArray) {
        TRAMSeqNumber tRAMSeqNumber = null;
        boolean bl = false;
        if (stringArray.length != 2) {
            System.out.println("Usage: java TRAMSeqNumber baseNumber compareNumber");
        }
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        tRAMSeqNumber = new TRAMSeqNumber(Integer.parseInt(stringArray[0]));
        if (tRAMSeqNumber.isEqualTo(n2)) {
            System.out.println(n + " = " + n2);
        }
        if (tRAMSeqNumber.isLessThan(n2)) {
            System.out.println(n + " < " + n2);
        }
        if (tRAMSeqNumber.isGreaterThan(n2)) {
            System.out.println(n + " > " + n2);
        }
        if (tRAMSeqNumber.isLessThanOrEqual(n2)) {
            System.out.println(n + " <= " + n2);
        }
        if (tRAMSeqNumber.isGreaterThanOrEqual(n2)) {
            System.out.println(n + " >= " + n2);
        }
        System.out.println("TRAMCompareSeqNumber");
        int n3 = tRAMSeqNumber.compareSeqNumber(n2);
        if (n3 == 0) {
            System.out.println(n + " = " + n2);
        } else if (n3 == 1) {
            System.out.println(n + " > " + n2);
        } else {
            System.out.println(n + " < " + n2);
        }
        System.out.println("Performing the 20 Increments. Start # " + tRAMSeqNumber.getSeqNumber());
        int n4 = 1;
        while (n4 <= 20) {
            tRAMSeqNumber.incrSeqNumber();
            System.out.println("          " + tRAMSeqNumber.getSeqNumber());
            ++n4;
        }
        System.out.println("Performing the 20 Decrements. Start# " + tRAMSeqNumber.getSeqNumber());
        int n5 = 1;
        while (n5 <= 20) {
            tRAMSeqNumber.decrSeqNumber();
            System.out.println("          " + tRAMSeqNumber.getSeqNumber());
            ++n5;
        }
        System.out.println("Current Seq Number " + tRAMSeqNumber.getSeqNumber());
        tRAMSeqNumber.add(10);
        System.out.println("Sequence Number + 10 = " + tRAMSeqNumber.getSeqNumber());
        System.out.println("Current Seq Number " + tRAMSeqNumber.getSeqNumber());
        tRAMSeqNumber.subtract(10);
        System.out.println("Sequence Number - 10 = " + tRAMSeqNumber.getSeqNumber());
    }

    public final int getSeqNumber() {
        return this.seqNumber;
    }

    public void setSeqNumber(int n) {
        this.seqNumber = n;
    }

    public final void incrSeqNumber() {
        ++this.seqNumber;
    }

    public final void decrSeqNumber() {
        --this.seqNumber;
    }

    public final int getPreviousSeqNumber() {
        int n = --this.seqNumber;
        return n;
    }

    public int compareSeqNumber(int n) {
        if (this.seqNumber == n) {
            return 0;
        }
        long l = (long)this.seqNumber & MASK;
        long l2 = (long)n & MASK;
        long l3 = Math.abs(l - l2);
        if (l3 >= Integer.MAX_VALUE) {
            if (l > l2) {
                return -1;
            }
            return 1;
        }
        if (l > l2) {
            return 1;
        }
        return -1;
    }

    public boolean isEqualTo(int n) {
        return n == this.seqNumber;
    }

    public boolean isLessThan(int n) {
        long l = (long)this.seqNumber & MASK;
        long l2 = (long)n & MASK;
        long l3 = l - l2;
        if (Math.abs(l3) >= Integer.MAX_VALUE) {
            return l3 >= 0L;
        }
        return l3 < 0L;
    }

    public boolean isGreaterThan(int n) {
        long l = (long)this.seqNumber & MASK;
        long l2 = (long)n & MASK;
        long l3 = l - l2;
        if (Math.abs(l3) >= Integer.MAX_VALUE) {
            return l3 < 0L;
        }
        return l3 > 0L;
    }

    public boolean isLessThanOrEqual(int n) {
        if (this.isLessThan(n)) {
            return true;
        }
        return this.isEqualTo(n);
    }

    public boolean isGreaterThanOrEqual(int n) {
        if (this.isGreaterThan(n)) {
            return true;
        }
        return this.isEqualTo(n);
    }

    public void add(int n) {
        this.seqNumber += n;
    }

    public void subtract(int n) {
        this.seqNumber -= n;
    }
}

