/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMPacket;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import com.sun.multicast.util.Util;
import java.net.DatagramPacket;
import java.net.InetAddress;

class TRAMRmPacket
extends TRAMPacket {
    public static final byte FLAGBIT_V6ADDRESS = -128;
    private static final byte REASON_CODE = 0;
    private static final byte RESERVED = 1;
    private static final byte SOURCE_ADDR = 2;
    private static final byte RMDATA = 6;
    public static final int RCODE_ACCEPTING_POTENTIAL_HEADS = 1;
    public static final int RCODE_MEMBERSHIP_FULL = 2;
    public static final int RCODE_TTL_OUT_OF_LIMITS = 3;
    public static final int RCODE_RESIGNING = 4;
    public static final int RCODE_NOT_A_LANHEAD = 5;
    private byte reasonCode = 0;
    private InetAddress srcAddress = null;

    public TRAMRmPacket(DatagramPacket datagramPacket) {
        super(datagramPacket);
        int n = super.readInt(2);
        this.srcAddress = Util.intToInetAddress(n);
        this.reasonCode = super.readByte(0);
    }

    public TRAMRmPacket(TRAMControlBlock tRAMControlBlock, int n) {
        super(6, tRAMControlBlock.getSessionId());
        this.setMessageType(3);
        this.setSubType(2);
        TRAMTransportProfile tRAMTransportProfile = tRAMControlBlock.getTransportProfile();
        this.srcAddress = tRAMTransportProfile.getDataSourceAddress();
        this.reasonCode = (byte)n;
    }

    public DatagramPacket createDatagramPacket() {
        super.writeInt(Util.InetAddressToInt(this.srcAddress), 2);
        super.writeByte(this.reasonCode, 0);
        return super.createDatagramPacket();
    }

    public InetAddress getSrcAddress() {
        return this.srcAddress;
    }

    public void setSrcAddress(InetAddress inetAddress) {
        this.srcAddress = inetAddress;
    }

    public int getReasonCode() {
        return this.reasonCode & 0xFF;
    }

    public void setReasonCode(int n) {
        this.reasonCode = (byte)n;
    }
}

