/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.GroupMgmtBlk;
import com.sun.multicast.reliable.transport.tram.MemberBlock;
import com.sun.multicast.reliable.transport.tram.PerfMon;
import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacket;
import com.sun.multicast.reliable.transport.tram.TRAMLogger;
import com.sun.multicast.reliable.transport.tram.TRAMStats;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import com.sun.multicast.reliable.transport.tram.TRAMVector;
import com.sun.multicast.util.UnsupportedException;
import java.net.InetAddress;
import java.net.UnknownHostException;

class TRAMRateAdjuster {
    private TRAMControlBlock tramblk;
    private TRAMTransportProfile tp;
    private TRAMStats tramStats;
    private TRAMLogger logger;
    private long rateIncrement;
    private boolean doOnce = true;
    private boolean slowStart = true;
    private int outSequenceNumber;
    private boolean timeToPrune = false;
    private long curDataRate;
    private int myFlowControlInfo;
    private PerfMon perfMon = null;
    private long averageDataRate;
    private boolean windowClosed = false;
    private boolean windowClosedSinceLastLog = false;
    private int lastAverageWindowSize;
    private int averageWindowSize;
    private static final int MIN_RATE_INCREMENT = 2500;
    private static final int CONGESTION_WINDOW_INCREMENT = 2;
    TRAMVector rateInfo = new TRAMVector();
    private static final int MAX_RATE_INFO_VECTOR = 1000;
    private long totalBytesTransferred = 0L;

    public TRAMRateAdjuster(TRAMControlBlock tRAMControlBlock) {
        this.tramblk = tRAMControlBlock;
        this.tp = tRAMControlBlock.getTransportProfile();
        this.logger = tRAMControlBlock.getLogger();
        this.tramStats = tRAMControlBlock.getTRAMStats();
        this.setDataRate(this.tp.getMinDataRate() + 5000L);
        this.rateIncrement = 2500L;
        if (this.logger.requiresLogging(16)) {
            this.logger.putPacketln(this, "JRMS Version 10, 12/5/00");
            this.logger.putPacketln(this, "Min Rate = " + this.tp.getMinDataRate());
            this.logger.putPacketln(this, "Max Rate = " + this.tp.getMaxDataRate());
            if (this.tp.getTmode() == 1) {
                this.logger.putPacketln(this, "Initial Rate = " + this.curDataRate);
            }
        }
        if (this.tp.getTmode() == 1 && (this.tp.getLogMask() & 0x400) != 0) {
            this.startPerfMon();
        }
    }

    public void startPerfMon() {
        if (this.perfMon != null) {
            return;
        }
        String string = "Sender ";
        try {
            string = string + InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        String string2 = this.tp.getAddress().toString();
        int n = string2.indexOf("/");
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        string = string + "  mc address " + string2;
        this.perfMon = new PerfMon(this.tramblk, string);
    }

    public void stopPerfMon() {
        if (this.perfMon != null) {
            this.perfMon.stop();
            this.perfMon = null;
        }
    }

    public void setDataRate(long l) {
        this.curDataRate = l > this.tp.getMaxDataRate() ? this.tp.getMaxDataRate() : (l <= 0L ? 1L : l);
    }

    public long getActualDataRate(int n) {
        int n2 = this.tramblk.getHighestSequenceAllowed() - n;
        if (n2 >= this.tp.getAckWindow()) {
            return this.curDataRate;
        }
        if (n2 < 1) {
            return 1L;
        }
        return this.tp.getMinDataRate() + (long)((double)n2 / (double)this.tp.getAckWindow() * (double)(this.curDataRate - this.tp.getMinDataRate()));
    }

    public long getActualDataRate() {
        long l = this.getActualDataRate(this.outSequenceNumber);
        return this.getActualDataRate(this.outSequenceNumber);
    }

    public long getOpenWindowDataRate() {
        return this.curDataRate;
    }

    public int getWindow() {
        int n = this.tramblk.getHighestSequenceAllowed() - this.outSequenceNumber;
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public void adjustRate(TRAMDataPacket tRAMDataPacket) {
        this.outSequenceNumber = tRAMDataPacket.getSequenceNumber();
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "averageWindowSize = " + this.averageWindowSize + " last avg " + this.lastAverageWindowSize + " window " + this.getWindow());
        }
        this.averageWindowSize += this.getWindow();
        if (this.outSequenceNumber % this.tp.getAckWindow() == 0) {
            this.calculateAverageDataRate();
        }
        if (this.slowStart) {
            if (this.outSequenceNumber > this.tramblk.getHighestSequenceAllowed()) {
                this.slowStart = false;
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "slowStart being set to false");
                }
            }
            if (this.curDataRate == this.tp.getMaxDataRate()) {
                this.slowStart = false;
            }
        }
        if (this.slowStart) {
            this.setDataRate(this.curDataRate + this.rateIncrement);
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Setting rate to " + this.curDataRate + " increment " + this.rateIncrement);
            }
            if (this.rateIncrement < (this.tp.getMaxDataRate() - this.tp.getMinDataRate()) / 4L) {
                this.rateIncrement += 1000L;
            }
            if (this.perfMon != null) {
                this.perfMon.newDataRate(this.curDataRate);
            }
            this.logRateInfo(null);
        } else if (this.outSequenceNumber <= this.tramblk.getHighestSequenceAllowed()) {
            if (this.windowClosed) {
                this.windowClosed = false;
                long l = this.curDataRate;
                this.setDataRate(this.getAverageDataRate());
                this.rateIncrement = Math.max(2500L, (long)((double)this.curDataRate * this.tp.getRateIncreaseFactor()));
                if (this.logger.requiresLogging(16)) {
                    this.logger.putPacketln(this, "Window reopened (" + (this.getWindow() + 1) + ").  Old rate " + l + " new rate " + this.curDataRate + " rate inc " + this.rateIncrement);
                }
                this.logRateInfo(null);
            } else {
                if (this.outSequenceNumber % this.tp.getAckWindow() == 0) {
                    if (this.averageWindowSize > this.lastAverageWindowSize || this.averageWindowSize == this.lastAverageWindowSize && this.averageWindowSize >= this.tp.getAckWindow() * this.tp.getMaxCongestionWindowMultiple() - 1) {
                        this.setDataRate(this.getAverageDataRate() + this.rateIncrement);
                    } else {
                        this.setDataRate(this.getAverageDataRate());
                    }
                    this.logRateInfo(null);
                }
                this.rateIncrement = Math.max(2500L, (long)((double)this.curDataRate * this.tp.getRateIncreaseFactor()));
            }
            if (this.perfMon != null) {
                this.perfMon.newDataRate(this.curDataRate);
            }
        } else if (!this.windowClosed) {
            if (this.logger.requiresLogging(16)) {
                this.logger.putPacketln(this, "Window closed.");
            }
            this.windowClosed = true;
            this.windowClosedSinceLastLog = true;
        }
        if (this.outSequenceNumber % this.tp.getAckWindow() == 0) {
            this.lastAverageWindowSize = this.averageWindowSize;
            this.averageWindowSize = 0;
        }
    }

    public void congestion(InetAddress inetAddress) {
        this.slowStart = false;
        this.logRateInfo(inetAddress);
        this.timeToPrune = this.outSequenceNumber >= 5 * this.tp.getAckWindow() && this.getAverageDataRate() <= this.tp.getMinDataRate();
        if (this.timeToPrune && this.logger.requiresLogging(16)) {
            this.logger.putPacketln(this, "Time to prune!  Current data rate " + this.curDataRate + " averageRate " + this.averageDataRate);
            this.logger.putPacketln(this, "Ack Window is " + this.tp.getAckWindow() + " outSequenceNumber is " + this.outSequenceNumber);
        }
    }

    public long getAverageDataRate() {
        return this.averageDataRate;
    }

    public void calculateAverageDataRate() {
        long l = System.currentTimeMillis();
        try {
            if (this.tp.getTmode() == 1) {
                this.totalBytesTransferred = this.tramStats.getTotalDataSent();
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "totalBytesSent " + this.totalBytesTransferred);
                }
            } else {
                this.totalBytesTransferred = this.tramStats.getTotalDataReceive();
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "totalBytesReceived " + this.totalBytesTransferred);
                }
            }
        }
        catch (UnsupportedException unsupportedException) {
            // empty catch block
        }
        this.rateInfo.addElement(new RateInfo(l, this.totalBytesTransferred));
        if (this.rateInfo.size() > 1000) {
            this.rateInfo.removeElementAt(0);
        }
        if (this.tp.getTimeForAvgRateCalc() != 0) {
            int n = 0;
            try {
                n = 0;
                while (n < this.rateInfo.size()) {
                    RateInfo rateInfo = (RateInfo)this.rateInfo.elementAt(n);
                    if (l - rateInfo.startTime < (long)(this.tp.getTimeForAvgRateCalc() * 1000)) break;
                    ++n;
                }
                if (n > 0 && this.rateInfo.size() > 2) {
                    this.rateInfo.rmRange(0, n);
                    if (this.logger.requiresLogging(7)) {
                        this.logger.putPacketln(this, "removing up to " + n + " keeping " + this.rateInfo.size());
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        RateInfo rateInfo = (RateInfo)this.rateInfo.elementAt(0);
        long l2 = l - rateInfo.startTime;
        if (l2 == 0L) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Elapsed time is 0!");
            }
            return;
        }
        this.averageDataRate = (this.totalBytesTransferred - rateInfo.bytesTransferred) * 1000L / l2;
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "avg " + this.averageDataRate + " total " + this.totalBytesTransferred + " first " + rateInfo.bytesTransferred + " now " + l + " start " + rateInfo.startTime + " elapsed " + l2);
        }
        if (this.tp.getTmode() == 1 && this.averageDataRate > this.tp.getMaxDataRate()) {
            this.averageDataRate = this.tp.getMaxDataRate();
        }
    }

    public void adjustCongestionWindowUp() {
        this.tp.setCongestionWindow(this.tp.getCongestionWindow() + 2);
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "increasing congestion window by 2, New value is " + this.tp.getCongestionWindow());
        }
    }

    public void adjustCongestionWindowDown() {
        if (this.tp.getCongestionWindow() > this.tp.getAckWindow()) {
            int n = this.tp.getCongestionWindow();
            this.tp.setCongestionWindow((int)(0.75 * (double)this.tp.getCongestionWindow()));
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Reducing congestion window, old " + n + " new " + this.tp.getCongestionWindow());
            }
        }
    }

    public boolean timeToPrune() {
        if (!this.timeToPrune) {
            return false;
        }
        this.timeToPrune = false;
        return true;
    }

    private void logRateInfo(InetAddress inetAddress) {
        int n;
        String string;
        if (this.doOnce) {
            this.doOnce = false;
            if (this.logger.requiresLogging(16)) {
                this.logger.putPacketln(this, "\tNextOut\tWindow\tCongestion    rateIncr\tRate\tInfo");
            }
        }
        if (inetAddress != null) {
            string = inetAddress.toString();
            n = string.indexOf("/");
            string = " " + string.substring(0, n) + "               ";
            string = string.substring(0, 15);
        } else {
            string = " NC        ";
        }
        n = this.tramblk.getHighestSequenceAllowed() - this.outSequenceNumber + 1;
        if (n < 0) {
            n = 0;
        }
        String string2 = "";
        if (n < 10) {
            string2 = "  ";
        }
        if (n < 100) {
            string2 = " ";
        }
        String string3 = "";
        if (this.windowClosedSinceLastLog) {
            this.windowClosedSinceLastLog = false;
            string3 = " * ";
        }
        if (this.logger.requiresLogging(16)) {
            this.logger.putPacketln(this, "\t" + this.outSequenceNumber + "\t" + n + "\t" + string + "\t" + this.rateIncrement + "\t" + this.getActualDataRate(this.outSequenceNumber) + "\t" + "avg " + this.getAverageDataRate() + " flow " + this.getGroupFlowControlInfo() + string3);
        }
    }

    public int getGroupFlowControlInfo() {
        GroupMgmtBlk groupMgmtBlk = this.tramblk.getGroupMgmtBlk();
        int n = this.myFlowControlInfo;
        int n2 = 0;
        while (n2 < groupMgmtBlk.getDirectMemberCount()) {
            block3: {
                try {
                    MemberBlock memberBlock = groupMgmtBlk.getMember(n2);
                    if (!this.isWorse(memberBlock.getFlowControlInfo(), n)) break block3;
                    n = memberBlock.getFlowControlInfo();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    break;
                }
            }
            ++n2;
        }
        return n;
    }

    public boolean IsSubtreeWorse() {
        GroupMgmtBlk groupMgmtBlk = this.tramblk.getGroupMgmtBlk();
        return groupMgmtBlk.getDirectMemberCount() != 0 && !this.isWorse(this.myFlowControlInfo, this.getGroupFlowControlInfo());
    }

    public int getMyFlowControlInfo() {
        return this.myFlowControlInfo;
    }

    public void setMyFlowControlInfo(int n, int n2) {
        int n3;
        if (n == 0 || n2 == 0) {
            n3 = 0;
        } else {
            n3 = 100 * n2 / n;
            if (n3 > 100 && this.logger.requiresLogging(16)) {
                this.logger.putPacketln(this, "new flow info > 100: " + n3 + " packets " + n + " missing " + n2);
            }
        }
        int n4 = this.myFlowControlInfo;
        this.myFlowControlInfo = (int)(0.75 * (double)this.myFlowControlInfo + 0.25 * (double)n3);
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "packets " + n + " missing " + n2 + " oldflow " + n4 + " newFlow " + n3 + " .25new + .75old " + this.myFlowControlInfo + " group flow " + this.getGroupFlowControlInfo());
        }
    }

    private boolean isWorse(int n, int n2) {
        return n > n2;
    }

    private boolean isBadEnough(int n, int n2) {
        return 1.05 * (double)n >= (double)n2;
    }

    public synchronized void findMemberToPrune(int n) {
        block15: {
            GroupMgmtBlk groupMgmtBlk = this.tramblk.getGroupMgmtBlk();
            if (this.tp.decentralizedPruning()) {
                int n2 = this.tramblk.getLastKnownSequenceNumber();
                int n3 = (int)(this.tp.getPruningWindow() * (double)this.tp.getAckWindow());
                if (this.logger.requiresLogging(16)) {
                    this.logger.putPacketln(this, "decentralized: looking for member to prune.  highestSeq = " + n2 + " worstHCR = " + groupMgmtBlk.getLowestPacketAcked() + " diff = " + (n2 - groupMgmtBlk.getLowestPacketAcked()));
                }
                int n4 = n2 - n3;
                if (groupMgmtBlk.getLowestPacketAcked() >= n4) {
                    return;
                }
                int n5 = 0;
                while (n5 < groupMgmtBlk.getDirectMemberCount()) {
                    block16: {
                        try {
                            MemberBlock memberBlock = groupMgmtBlk.getMember(n5);
                            if (memberBlock == null) break block15;
                            if (memberBlock.getSubTreeFlowControlInfo()) break block16;
                            int n6 = memberBlock.getLastPacketAcked();
                            if (this.logger.requiresLogging(16)) {
                                this.logger.putPacketln(this, memberBlock.getAddress() + " HCR " + n6);
                            }
                            if (n6 >= n4) break block16;
                            if (this.logger.requiresLogging(16)) {
                                this.logger.putPacketln(this, "pruneMember!!! " + memberBlock.getAddress());
                            }
                            this.tramblk.getGroupMgmtThread().handleMemberLoss(memberBlock);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            break;
                        }
                    }
                    ++n5;
                }
            } else {
                if (this.logger.requiresLogging(16)) {
                    this.logger.putPacketln(this, "Searching for member to prune.  worstFlowControlInfo is " + n);
                }
                int n7 = 0;
                while (n7 < groupMgmtBlk.getDirectMemberCount()) {
                    block17: {
                        try {
                            MemberBlock memberBlock = groupMgmtBlk.getMember(n7);
                            int n8 = memberBlock.getFlowControlInfo();
                            if (this.logger.requiresLogging(16)) {
                                this.logger.putPacketln(this, memberBlock.getAddress() + " group flow control info " + this.getGroupFlowControlInfo() + " member flow control info " + n8 + " subtree flag is " + memberBlock.getSubTreeFlowControlInfo());
                            }
                            if (memberBlock.getSubTreeFlowControlInfo() || !this.isBadEnough(n8, n)) break block17;
                            if (this.logger.requiresLogging(16)) {
                                this.logger.putPacketln(this, "pruneMember!!! " + memberBlock.getAddress() + ", member control flow info " + n8 + ", group flow control info " + this.getGroupFlowControlInfo());
                            }
                            this.tramblk.getGroupMgmtThread().handleMemberLoss(memberBlock);
                            if (!this.logger.requiresLogging(16)) break block17;
                            this.logger.putPacketln(this, "group flow control info " + this.getGroupFlowControlInfo());
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            break;
                        }
                    }
                    ++n7;
                }
            }
        }
    }

    class RateInfo {
        long startTime;
        long bytesTransferred;

        RateInfo(long l, long l2) {
            this.startTime = l;
            this.bytesTransferred = l2;
        }
    }
}

