/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.authentication.AuthenticationModule;
import com.sun.multicast.reliable.transport.IrrecoverableDataException;
import com.sun.multicast.reliable.transport.MemberPrunedException;
import com.sun.multicast.reliable.transport.NoMembersException;
import com.sun.multicast.reliable.transport.RMPacketSocket;
import com.sun.multicast.reliable.transport.RMStatistics;
import com.sun.multicast.reliable.transport.SessionDoneException;
import com.sun.multicast.reliable.transport.SessionDownException;
import com.sun.multicast.reliable.transport.TransportProfile;
import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMControlBlockException;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacket;
import com.sun.multicast.reliable.transport.tram.TRAMInputOutput;
import com.sun.multicast.reliable.transport.tram.TRAMLogger;
import com.sun.multicast.reliable.transport.tram.TRAMSeqNumber;
import com.sun.multicast.reliable.transport.tram.TRAMSimulator;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.security.SignatureException;

public class TRAMPacketSocket
implements RMPacketSocket {
    private TRAMControlBlock tramblk = null;
    private TRAMInputOutput pktio = null;
    private TRAMTransportProfile tp = null;
    private TRAMLogger logger = null;
    private TRAMSeqNumber outSeqNumber = null;
    private boolean dataEnd = false;
    private boolean sender;
    private boolean headonly = false;
    private TRAMSimulator simulator = null;

    public TRAMPacketSocket() {
    }

    public TRAMPacketSocket(TRAMSimulator tRAMSimulator) {
        this.simulator = tRAMSimulator;
    }

    void connect(TRAMTransportProfile tRAMTransportProfile, InetAddress inetAddress) throws IOException {
        this.tp = (TRAMTransportProfile)tRAMTransportProfile.clone();
        this.sender = (this.tp.getTmode() & 0xFF) == 1;
        this.headonly = this.tp.getSAhead();
        MulticastSocket multicastSocket = null;
        if (this.simulator == null) {
            InetAddress inetAddress2;
            multicastSocket = new MulticastSocket(this.tp.getPort());
            boolean bl = false;
            if (this.tp.getReceiveBufferSize() != 0) {
                try {
                    multicastSocket.setReceiveBufferSize(this.tp.getReceiveBufferSize());
                    bl = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!bl) {
                try {
                    int n = multicastSocket.getReceiveBufferSize();
                    int n2 = 262144;
                    while (n2 > n) {
                        try {
                            multicastSocket.setReceiveBufferSize(n2);
                            break;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (Exception exception) {
                            break;
                        }
                        n2 -= 1024;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((inetAddress2 = inetAddress) == null) {
                inetAddress2 = InetAddress.getLocalHost();
            }
            try {
                multicastSocket.setInterface(inetAddress2);
            }
            catch (SocketException socketException) {
                throw new IOException(socketException + " Unable to set multicast interface address to " + inetAddress2);
            }
            multicastSocket.joinGroup(this.tp.getAddress());
        }
        try {
            this.tramblk = this.simulator == null ? new TRAMControlBlock(multicastSocket, this.tp) : new TRAMControlBlock(multicastSocket, this.tp, this.simulator);
        }
        catch (TRAMControlBlockException tRAMControlBlockException) {
            throw new IOException(tRAMControlBlockException + "Unable to Create TRAMControlBlock");
        }
        if (this.tp.getTmode() != 2) {
            this.outSeqNumber = new TRAMSeqNumber(1);
        }
        this.pktio = this.tramblk.getPacketDb();
        this.logger = this.tramblk.getLogger();
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Receiver buffer size is " + multicastSocket.getReceiveBufferSize());
        }
    }

    public InetAddress getInterface() throws SocketException {
        MulticastSocket multicastSocket = this.tramblk.getMulticastSocket();
        return multicastSocket.getInterface();
    }

    public void setInterface(InetAddress inetAddress) throws SocketException {
        MulticastSocket multicastSocket = this.tramblk.getMulticastSocket();
        multicastSocket.setInterface(inetAddress);
    }

    public void send(DatagramPacket datagramPacket) throws IOException {
        this.send(datagramPacket, 0);
    }

    public int send(DatagramPacket datagramPacket, int n) throws IOException {
        if (this.tp.getTmode() == 2) {
            throw new IOException("RECEIVE ONLY Transport Profile");
        }
        if (this.tramblk.getTRAMStats().getReceiverCount() == 0) {
            throw new NoMembersException();
        }
        int n2 = datagramPacket.getLength();
        int n3 = 0;
        AuthenticationModule authenticationModule = this.tramblk.getAuthenticationModule();
        if (this.tp.isUsingAuthentication() && authenticationModule != null) {
            n3 = authenticationModule.getSignatureSize();
        }
        if (n2 > this.tp.getMaxBuf() - 28 - 10 - n3) {
            throw new IOException("DatagramPacket exceeds maximum buffer size of " + this.tp.getMaxBuf());
        }
        byte[] byArray = null;
        int n4 = 0;
        byArray = datagramPacket.getData();
        n4 = datagramPacket.getLength();
        TRAMDataPacket tRAMDataPacket = new TRAMDataPacket(this.tramblk, byArray, n4, n3);
        tRAMDataPacket.setAddress(this.tp.getAddress());
        tRAMDataPacket.setPort(this.tp.getPort());
        tRAMDataPacket.setSequenceNumber(this.outSeqNumber.getSeqNumber());
        if (n != 0) {
            if (n > tRAMDataPacket.getSequenceNumber() || n < this.tramblk.getLastKnownForgetBeforeSeqNum()) {
                throw new IOException("forgetBeforeSeqNum (" + n + ") must be less than or equal to the sequence number (" + tRAMDataPacket.getSequenceNumber() + ") and greater than or equal to the previous " + "forgetBeforeSeqNum (" + this.tramblk.getLastKnownForgetBeforeSeqNum() + ")");
            }
            tRAMDataPacket.setForgetBeforeSeqNum(n);
            this.tramblk.setLastKnownForgetBeforeSeqNum(n);
        }
        this.tramblk.setLastFirstTimeTxmSequenceNumber(this.outSeqNumber.getSeqNumber());
        tRAMDataPacket.setHaInterval((short)0);
        if (authenticationModule != null) {
            int n5 = 38 + tRAMDataPacket.getDataLength();
            int n6 = 38;
            int n7 = tRAMDataPacket.getSubType();
            tRAMDataPacket.setSubType(0);
            byte[] byArray2 = tRAMDataPacket.getBuffer();
            try {
                byte[] byArray3 = authenticationModule.sign(byArray2, 0, n5);
                if (this.logger.requiresLogging(519)) {
                    this.logger.putPacketln(this, "Signature Length is " + byArray3.length + "Mesg Length is " + n5 + " BufferLen is " + byArray2.length + " DataLen is " + tRAMDataPacket.getDataLength());
                }
                tRAMDataPacket.writeBuffer(byArray3, byArray3.length, tRAMDataPacket.getDataLength());
                tRAMDataPacket.setSubType(n7);
            }
            catch (SignatureException signatureException) {
                if (this.logger.requiresLogging(1023)) {
                    this.logger.putPacketln(this, "Signature Exception!!!");
                }
                throw new IOException("Unable to Sign");
            }
        }
        try {
            this.tramblk.getTRAMStats().addBytesSent(n4);
            this.tramblk.getTRAMStats().addPacketsSent();
            tRAMDataPacket.setForgetBeforeSeqNum(n);
            this.pktio.putPacket(tRAMDataPacket);
            this.outSeqNumber.incrSeqNumber();
            if (this.tramblk.getTRAMState() == 2) {
                this.tramblk.setTRAMState((byte)3);
            }
        }
        catch (IOException iOException) {
            if (this.logger.requiresLogging(67)) {
                this.logger.putPacketln(this, "Unable to send packet");
            }
            throw new IOException();
        }
        return tRAMDataPacket.getSequenceNumber();
    }

    public DatagramPacket receive() throws IOException, SessionDoneException, IrrecoverableDataException, SessionDownException, MemberPrunedException {
        DatagramPacket datagramPacket;
        if (this.headonly) {
            this.monitor();
            return null;
        }
        if (this.dataEnd) {
            throw new SessionDoneException();
        }
        if (this.sender) {
            throw new IOException("Senders may not receive their own data");
        }
        TRAMDataPacket tRAMDataPacket = (TRAMDataPacket)this.pktio.getPacket();
        if ((tRAMDataPacket.getFlags() & 2) != 0) {
            this.dataEnd = true;
            throw new SessionDoneException();
        }
        if ((tRAMDataPacket.getFlags() & 0x20) != 0) {
            throw new SessionDownException();
        }
        if ((tRAMDataPacket.getFlags() & 0x10) != 0) {
            if (this.logger.requiresLogging(71)) {
                this.logger.putPacketln(this, "IrrecoverableDataException for sequence number " + tRAMDataPacket.getSequenceNumber());
            }
            throw new IrrecoverableDataException();
        }
        if ((tRAMDataPacket.getFlags() & 0x40) != 0) {
            throw new MemberPrunedException();
        }
        byte[] byArray = tRAMDataPacket.getData();
        int n = tRAMDataPacket.getDataLength();
        if (this.logger.requiresLogging(71)) {
            this.logger.putPacketln(this, "Passing Packet # " + tRAMDataPacket.getSequenceNumber() + " and forgetBeforeSeq # " + tRAMDataPacket.getForgetBeforeSeqNum() + " of size " + n + " to the application.");
        }
        try {
            datagramPacket = new DatagramPacket(byArray, 0, n, tRAMDataPacket.getAddress(), tRAMDataPacket.getPort());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            datagramPacket = new DatagramPacket(byArray, n, tRAMDataPacket.getAddress(), tRAMDataPacket.getPort());
        }
        return datagramPacket;
    }

    public void monitor() throws IOException, SessionDoneException, IrrecoverableDataException, SessionDownException {
        TRAMDataPacket tRAMDataPacket;
        do {
            if (((tRAMDataPacket = (TRAMDataPacket)this.pktio.getPacket()).getFlags() & 2) != 0) {
                throw new SessionDoneException();
            }
            if ((tRAMDataPacket.getFlags() & 0x20) == 0) continue;
            throw new SessionDownException();
        } while ((tRAMDataPacket.getFlags() & 0x10) == 0);
        throw new IrrecoverableDataException();
    }

    public void abort() {
        if (this.tramblk != null) {
            this.tramblk.doTRAMAbort();
        }
    }

    public void close() {
        if (this.logger != null && this.logger.requiresLogging(135)) {
            this.logger.putPacketln(this, "TRAMPacketSocket: Closing the Socket");
        }
        if (this.tramblk == null) {
            return;
        }
        if (this.tp.getTmode() != 2) {
            this.tramblk.setTRAMState((byte)10);
        }
        this.tramblk.doTRAMClose();
        this.tramblk = null;
    }

    public int getMaxLength() {
        return this.tp.getMaxBuf();
    }

    public TransportProfile getTransportProfile() {
        return (TransportProfile)this.tp.clone();
    }

    public RMStatistics getRMStatistics() {
        return (RMStatistics)this.tramblk.getTRAMStats().clone();
    }

    public void simulateMulticastPacketReceive(DatagramPacket datagramPacket) {
        this.tramblk.simulateMulticastPacketReceive(datagramPacket);
    }

    public void simulateUnicastPacketReceive(DatagramPacket datagramPacket) {
        this.tramblk.simulateUnicastPacketReceive(datagramPacket);
    }

    public void setReceiverMaxDataRate(long l) {
        this.tp.setReceiverMaxDataRate(l);
    }

    public long getReceiverMaxDataRate() {
        return this.tp.getReceiverMaxDataRate();
    }
}

