/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.util.Util;
import java.net.DatagramPacket;
import java.net.InetAddress;

class TRAMPacket {
    public static final int TRAMVERSION = 0;
    public static final int TRAMMESSAGETYPE = 1;
    public static final int TRAMSUBTYPE = 2;
    public static final int TRAMFLAGS = 3;
    public static final int TRAMSESSIONID = 4;
    public static final int TRAMLENGTH = 8;
    public static final int TRAMDATA = 10;
    public static final int TRAMHEADERLENGTH = 10;
    public static final int TRAM_VERSION = 2;
    private int version = 2;
    private int messageType;
    private int subType;
    private int flags = 0;
    private int sessionId;
    private int length;
    private byte[] b;
    private int port;
    private InetAddress address;
    private boolean transmit;
    private boolean transmitPending;
    private long lastTransmitTime;

    public TRAMPacket(DatagramPacket datagramPacket) {
        this.b = datagramPacket.getData();
        this.version = this.b[0] & 0xFF;
        this.messageType = this.b[1] & 0xFF;
        this.subType = this.b[2] & 0xFF;
        this.flags = this.b[3] & 0xFF;
        this.length = Util.readUnsignedShort(this.b, 8);
        this.sessionId = Util.readInt(this.b, 4);
        this.address = datagramPacket.getAddress();
        this.port = datagramPacket.getPort();
        this.transmit = false;
    }

    public TRAMPacket(byte[] byArray, int n, int n2, int n3) {
        this.buildPacket(byArray, n, n2, n3, 0);
    }

    public TRAMPacket(byte[] byArray, int n, int n2, int n3, int n4) {
        this.buildPacket(byArray, n, n2, n3, n4);
    }

    public TRAMPacket(int n, int n2) {
        this(null, 0, n, n2);
    }

    private void buildPacket(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = n2 + 10;
        this.b = new byte[n + n5 + n4];
        if (n != 0) {
            System.arraycopy(byArray, 0, this.b, n5, n);
        }
        this.b[0] = (byte)this.version;
        this.b[1] = (byte)this.messageType;
        this.b[2] = (byte)this.subType;
        this.b[3] = (byte)this.flags;
        Util.writeInt(n3, this.b, 4);
        this.sessionId = n3;
        this.length = this.b.length;
        Util.writeShort((short)this.length, this.b, 8);
        this.transmit = true;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public static int getMessageType(DatagramPacket datagramPacket) {
        byte[] byArray = datagramPacket.getData();
        return byArray[1] & 0xFF;
    }

    public static int getVersionNumber(DatagramPacket datagramPacket) {
        byte[] byArray = datagramPacket.getData();
        return byArray[0] & 0xFF;
    }

    public static int getId(DatagramPacket datagramPacket) {
        byte[] byArray = datagramPacket.getData();
        return Util.readInt(byArray, 4);
    }

    public static int getSubType(DatagramPacket datagramPacket) {
        byte[] byArray = datagramPacket.getData();
        return byArray[2] & 0xFF;
    }

    public int getVersion() {
        return this.version;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public int getSubType() {
        return this.subType;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getLength() {
        return this.length - 10;
    }

    public byte[] getBuffer() {
        return this.b;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isTransmit() {
        return this.transmit;
    }

    public void setMessageType(int n) {
        this.messageType = n;
        this.b[1] = (byte)n;
    }

    public void setSubType(int n) {
        this.subType = n;
        this.b[2] = (byte)n;
    }

    public void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setFlags(byte by) {
        this.flags = by & 0xFF;
        this.b[3] = by;
    }

    public DatagramPacket createDatagramPacket() {
        return new DatagramPacket(this.b, this.length, this.address, this.port & 0xFFFF);
    }

    public void writeByte(byte by, int n) {
        this.b[n += 10] = by;
    }

    public void writeShort(short s, int n) {
        Util.writeShort(s, this.b, n += 10);
    }

    public void writeInt(int n, int n2) {
        Util.writeInt(n, this.b, n2 += 10);
    }

    public void writeBuffer(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, 0, this.b, n2 += 10, n);
    }

    public byte readByte(int n) {
        return this.b[n += 10];
    }

    public short readShort(int n) {
        return (short)Util.readUnsignedShort(this.b, n += 10);
    }

    public int readInt(int n) {
        return Util.readInt(this.b, n += 10);
    }

    public byte[] readBuffer(int n, int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.b, n += 10, byArray, 0, n2);
        return byArray;
    }

    public byte[] readBuffer(int n) {
        byte[] byArray = new byte[this.length - (n += 10)];
        System.arraycopy(this.b, n, byArray, 0, byArray.length);
        return byArray;
    }

    public void setTransmitPending(boolean bl) {
        this.transmitPending = bl;
    }

    public boolean isTransmitPending() {
        return this.transmitPending;
    }

    public long getLastTransmitTime() {
        return this.lastTransmitTime;
    }

    public void setLastTransmitTime(long l) {
        this.lastTransmitTime = l;
    }
}

