/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.authentication.AuthenticationModule;
import com.sun.multicast.reliable.transport.NoMembersException;
import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacket;
import com.sun.multicast.reliable.transport.tram.TRAMInputOutput;
import com.sun.multicast.reliable.transport.tram.TRAMLogger;
import com.sun.multicast.reliable.transport.tram.TRAMRateAdjuster;
import com.sun.multicast.reliable.transport.tram.TRAMSeqNumber;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.security.SignatureException;

class TRAMOutputStream
extends OutputStream {
    private TRAMControlBlock tramblk = null;
    private TRAMTransportProfile tp;
    private TRAMInputOutput pktio = null;
    private int maxBuf;
    private DatagramPacket dp = null;
    private byte[] writebuffer;
    private TRAMSeqNumber seqNumber = new TRAMSeqNumber();
    private int index = 0;
    private TRAMLogger logger = null;
    private boolean closeDone = false;
    private TRAMRateAdjuster rateAdjuster;
    private int sigLen = 0;
    private AuthenticationModule authMod = null;

    public TRAMOutputStream(TRAMControlBlock tRAMControlBlock, TRAMInputOutput tRAMInputOutput) {
        this.tramblk = tRAMControlBlock;
        this.tp = tRAMControlBlock.getTransportProfile();
        this.pktio = tRAMInputOutput;
        this.sigLen = 0;
        this.authMod = tRAMControlBlock.getAuthenticationModule();
        if (this.tp.isUsingAuthentication() && this.authMod != null) {
            this.sigLen = this.authMod.getSignatureSize();
        } else {
            this.authMod = null;
        }
        this.logger = tRAMControlBlock.getLogger();
        this.maxBuf = this.tp.getMaxBuf() - 28 - 10 - this.sigLen;
        this.writebuffer = new byte[this.maxBuf];
        this.rateAdjuster = tRAMControlBlock.getRateAdjuster();
    }

    public void write(int n) throws IOException {
        if (this.tp.getTmode() == 2) {
            throw new IOException("RECEIVE ONLY Transport Mode");
        }
        if (this.tramblk.getTRAMStats().getReceiverCount() == 0) {
            throw new NoMembersException();
        }
        this.writebuffer[this.index] = (byte)n;
        ++this.index;
        if (this.index >= this.maxBuf) {
            this.sendbuffer(this.writebuffer);
            this.index = 0;
        }
    }

    public void write(byte[] byArray) throws IOException {
        if (this.tp.getTmode() == 2) {
            throw new IOException("RECEIVE ONLY Transport Mode");
        }
        if (this.tramblk.getTRAMStats().getReceiverCount() == 0) {
            throw new NoMembersException();
        }
        int n = 0;
        while (n < byArray.length) {
            this.writebuffer[this.index] = byArray[n];
            ++this.index;
            if (this.index >= this.maxBuf) {
                this.sendbuffer(this.writebuffer);
                this.index = 0;
            }
            ++n;
        }
    }

    private void sendbuffer(byte[] byArray) throws IOException {
        TRAMDataPacket tRAMDataPacket = new TRAMDataPacket(this.tramblk, byArray, this.index, this.sigLen);
        tRAMDataPacket.setAddress(this.tp.getAddress());
        tRAMDataPacket.setPort(this.tp.getPort());
        int n = this.seqNumber.getSeqNumber();
        tRAMDataPacket.setSequenceNumber(n);
        this.tramblk.setLastFirstTimeTxmSequenceNumber(n);
        this.tramblk.getTRAMStats().addBytesSent(tRAMDataPacket.getDataLength());
        this.tramblk.getTRAMStats().addPacketsSent();
        tRAMDataPacket.setHaInterval((short)0);
        if (this.authMod != null) {
            int n2 = 38 + tRAMDataPacket.getDataLength();
            int n3 = tRAMDataPacket.getSubType();
            tRAMDataPacket.setSubType(0);
            byte[] byArray2 = tRAMDataPacket.getBuffer();
            try {
                byte[] byArray3 = this.authMod.sign(byArray2, 0, n2);
                if (this.logger.requiresLogging(519)) {
                    this.logger.putPacketln(this, "Signature Length is " + byArray3.length + "Mesg Length is " + n2 + " BufferLen is " + byArray2.length);
                }
                tRAMDataPacket.writeBuffer(byArray3, byArray3.length, tRAMDataPacket.getDataLength());
                tRAMDataPacket.setSubType(n3);
            }
            catch (SignatureException signatureException) {
                if (this.logger.requiresLogging(515)) {
                    this.logger.putPacketln(this, "Signature Exception!!!");
                }
                throw new IOException("Unable to Sign");
            }
        }
        try {
            this.pktio.putPacket(tRAMDataPacket);
            this.seqNumber.incrSeqNumber();
            if (this.tramblk.getTRAMState() == 2) {
                this.tramblk.setTRAMState((byte)3);
            }
        }
        catch (IOException iOException) {
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, "TRAMOutputStream: IOexception in sendbuffer");
            }
            throw new IOException();
        }
    }

    public void flush() throws IOException {
        this.sendbuffer(this.writebuffer);
        this.index = 0;
    }

    public void close() throws IOException {
        if (this.closeDone) {
            return;
        }
        if (this.index != 0) {
            this.flush();
            this.index = 0;
        }
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Closing the Socket");
        }
        if (this.tp.getTmode() != 2) {
            this.tramblk.setTRAMState((byte)10);
        }
        this.tramblk.doTRAMClose();
        this.tramblk = null;
        this.closeDone = true;
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "TRAMOutputSreamSocket: Exiting");
        }
    }
}

