/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMPacket;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import com.sun.multicast.util.Util;
import java.net.DatagramPacket;
import java.net.InetAddress;

class TRAMMsPacket
extends TRAMPacket {
    public static final byte FLAGBIT_V6ADDRESS = -128;
    private static final short TTL = 0;
    private static final short MROLE = 1;
    private static final short RXLEVEL = 2;
    private static final short RESERVED = 3;
    private static final short UCAST_PORT = 4;
    private static final short SOURCE_ADDR = 6;
    private static final short MSDATA = 10;
    private byte ttl = 0;
    private byte mrole = 0;
    private InetAddress dataSrcAddress = null;
    private byte rxLevel = 0;
    private short unicastPort = 0;

    public TRAMMsPacket(DatagramPacket datagramPacket) {
        super(datagramPacket);
        this.ttl = super.readByte(0);
        this.mrole = (byte)(super.readByte(1) >>> 4 & 0xF);
        this.rxLevel = super.readByte(2);
        int n = super.readInt(6);
        this.dataSrcAddress = Util.intToInetAddress(n);
        this.unicastPort = super.readShort(4);
    }

    public TRAMMsPacket(TRAMControlBlock tRAMControlBlock, int n, byte by) {
        super(10, tRAMControlBlock.getSessionId());
        this.setMessageType(1);
        this.setSubType(4);
        this.rxLevel = (byte)tRAMControlBlock.getGroupMgmtBlk().getRxLevel();
        this.mrole = tRAMControlBlock.getTransportProfile().getMrole();
        TRAMTransportProfile tRAMTransportProfile = tRAMControlBlock.getTransportProfile();
        this.unicastPort = (short)tRAMControlBlock.getUnicastPort();
        this.dataSrcAddress = tRAMTransportProfile.getDataSourceAddress();
        this.ttl = by;
        this.setAddress(tRAMTransportProfile.getAddress());
        this.setPort(tRAMTransportProfile.getPort());
    }

    public DatagramPacket createDatagramPacket() {
        super.writeByte(this.ttl, 0);
        short s = (short)(this.mrole << 4);
        s = (short)(s & 0xF0);
        super.writeByte((byte)s, 1);
        super.writeByte(this.rxLevel, 2);
        super.writeShort(this.unicastPort, 4);
        super.writeInt(Util.InetAddressToInt(this.dataSrcAddress), 6);
        return super.createDatagramPacket();
    }

    public byte getTTL() {
        return this.ttl;
    }

    public void setTTL(byte by) {
        this.ttl = by;
    }

    public byte getMrole() {
        return this.mrole;
    }

    public void setMrole(byte by) {
        this.mrole = by;
    }

    public InetAddress getDataSrcAddress() {
        return this.dataSrcAddress;
    }

    public void setDataSrcAddress(InetAddress inetAddress) {
        this.dataSrcAddress = inetAddress;
    }

    public byte getRxLevel() {
        return this.rxLevel;
    }

    public void setRxLevel(byte by) {
        this.rxLevel = by;
    }

    public int getUnicastPort() {
        return this.unicastPort & 0xFFFF;
    }

    public void setUnicastPort(int n) {
        this.unicastPort = (short)n;
    }
}

