/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.BeaconPacket;
import com.sun.multicast.reliable.transport.tram.BeaconPacketEvent;
import com.sun.multicast.reliable.transport.tram.BeaconPacketListener;
import com.sun.multicast.reliable.transport.tram.GroupMgmtBlk;
import com.sun.multicast.reliable.transport.tram.GroupMgmtThread;
import com.sun.multicast.reliable.transport.tram.HeadBlock;
import com.sun.multicast.reliable.transport.tram.MissingPacket;
import com.sun.multicast.reliable.transport.tram.SUBMESGTYPE;
import com.sun.multicast.reliable.transport.tram.TRAMAckPacket;
import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacket;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMLogger;
import com.sun.multicast.reliable.transport.tram.TRAMMembershipEvent;
import com.sun.multicast.reliable.transport.tram.TRAMMembershipListener;
import com.sun.multicast.reliable.transport.tram.TRAMRateAdjuster;
import com.sun.multicast.reliable.transport.tram.TRAMSeqNumber;
import com.sun.multicast.reliable.transport.tram.TRAMSimpleTimer;
import com.sun.multicast.reliable.transport.tram.TRAMTimerEventHandler;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Vector;

class TRAMMemberAck
implements TRAMDataPacketListener,
BeaconPacketListener,
TRAMTimerEventHandler,
TRAMMembershipListener {
    TRAMControlBlock tramblk;
    TRAMTransportProfile tp;
    TRAMRateAdjuster rateAdjuster;
    TRAMLogger logger;
    TRAMSeqNumber nextPacket = new TRAMSeqNumber();
    public Vector missingPackets = new Vector();
    TRAMSeqNumber nextAck;
    boolean dataEnd = false;
    boolean finalAckSent = false;
    TRAMSimpleTimer tramTimer = null;
    long lastAckTime = 0L;
    int lastAckPacket = 0;
    int previousMissing = 0;
    int highestSequenceAllowed;
    int ackWindowSize;
    int windowCongestionMessageSent = 0;
    boolean dataCacheProcessedMembershipEvent = false;
    boolean needToWaitForCacheToProcessMembershipEvent = false;
    long joinTime = 0L;
    boolean init = true;
    int lateJoin;
    Vector holdingTank;
    byte[] maskBase = new byte[]{1, 3, 7, 15, 31, 63, 127, -1};
    byte[] maskOffset = new byte[]{-1, -2, -4, -8, -16, -32, -64, -128};

    public TRAMMemberAck(TRAMControlBlock tRAMControlBlock) {
        this.tramblk = tRAMControlBlock;
        this.tp = tRAMControlBlock.getTransportProfile();
        this.rateAdjuster = tRAMControlBlock.getRateAdjuster();
        this.logger = tRAMControlBlock.getLogger();
        tRAMControlBlock.getInputDispThread().addTRAMDataPacketListener(this);
        tRAMControlBlock.getInputDispThread().addBeaconPacketListener(this);
        this.ackWindowSize = this.tp.getAckWindow();
        this.nextAck = new TRAMSeqNumber((int)(Math.random() * (double)this.ackWindowSize));
        this.tramblk.getGroupMgmtThread().addTRAMMembershipListener(this);
        if (tRAMControlBlock.getTransportProfile().getTmode() != 1) {
            this.lateJoin = this.tp.getLateJoinPreference();
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, "TRAMMemberAck: late join is " + this.lateJoin);
            }
            this.holdingTank = null;
            switch (this.lateJoin) {
                case 1: 
                case 2: {
                    if (this.logger.requiresLogging(7)) {
                        this.logger.putPacketln(this, "Creating holding tank");
                    }
                    this.holdingTank = new Vector();
                    break;
                }
                case 3: {
                    if (!this.logger.requiresLogging(7)) break;
                    this.logger.putPacketln(this, "No holding tank necessary");
                    break;
                }
                default: {
                    if (!this.logger.requiresLogging(3)) break;
                    this.logger.putPacketln(this, "The Late Join Preference is Invalid");
                }
            }
        }
    }

    public synchronized void receiveDataPacket(TRAMDataPacketEvent tRAMDataPacketEvent) {
        HeadBlock headBlock;
        if (this.init) {
            if (this.holdingTank != null) {
                this.holdingTank.addElement(tRAMDataPacketEvent);
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "Loading packet " + tRAMDataPacketEvent.getPacket().getSequenceNumber() + " into the holding tank");
                }
            }
            return;
        }
        if (this.needToWaitForCacheToProcessMembershipEvent) {
            if (!this.getDataCacheProcessedMembershipEvent()) {
                return;
            }
            this.needToWaitForCacheToProcessMembershipEvent = false;
        }
        TRAMDataPacket tRAMDataPacket = tRAMDataPacketEvent.getPacket();
        int n = tRAMDataPacket.getSequenceNumber();
        boolean bl = false;
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Received " + SUBMESGTYPE.mcastData[tRAMDataPacket.getSubType()] + " packet " + n + " Rate " + tRAMDataPacket.getDataRate());
        }
        if (this.ackWindowSize != tRAMDataPacket.getAckWindow()) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "ACK Window " + this.ackWindowSize + " Doesn't match value in data packet of " + tRAMDataPacket.getAckWindow() + ".  Using value in data packet");
            }
            this.ackWindowSize = tRAMDataPacket.getAckWindow();
            this.tp.setAckWindow((short)this.ackWindowSize);
        }
        if (n % this.tp.getAckWindow() == 0) {
            this.rateAdjuster.calculateAverageDataRate();
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Average data rate is " + this.rateAdjuster.getAverageDataRate());
            }
        }
        if (n % 500 == 0 && this.logger.requiresLogging(23)) {
            this.logger.putPacketln(this, "Packet " + n + ", group flow control info " + this.rateAdjuster.getGroupFlowControlInfo() + ", highest seq " + this.highestSequenceAllowed + ",  C win " + this.tp.getCongestionWindow() + ", rate " + this.rateAdjuster.getOpenWindowDataRate());
        }
        this.rateAdjuster.setDataRate(tRAMDataPacket.getDataRate());
        if (this.nextPacket.isEqualTo(n)) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Got EXPECTED Data packet " + n);
            }
            this.nextPacket.incrSeqNumber();
            this.tramblk.getTRAMStats().addBytesRcvd(tRAMDataPacket.getLength());
        } else if (this.nextPacket.isLessThan(n)) {
            if (this.logger.requiresLogging(275)) {
                this.logger.putPacketln(this, "Got HIGHER than expected Data packet " + n + " (expected " + this.nextPacket.getSeqNumber() + ")");
            }
            if (this.logger.requiresLogging(16)) {
                this.logger.putPacketln(this, "Duplicate pkt count before recovering missing packets " + this.tramblk.getTRAMStats().getDuplicatePackets());
            }
            this.addMissing(n);
            this.nextPacket.setSeqNumber(n + 1);
            this.tramblk.getTRAMStats().addBytesRcvd(tRAMDataPacket.getLength());
        } else if (this.missingPackets.size() != 0 && this.checkMissing(n)) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Got missing packet " + n);
            }
            if (this.missingPackets.size() == 0) {
                bl = true;
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, " got packet " + n + " Force an ACK...");
                }
                if (this.logger.requiresLogging(16)) {
                    this.logger.putPacketln(this, "Duplicate packet count after last  missing packet has been recovered:  " + this.tramblk.getTRAMStats().getDuplicatePackets());
                }
            }
            this.tramblk.getTRAMStats().addBytesRcvd(tRAMDataPacket.getLength());
            if (tRAMDataPacket.getSubType() == 2) {
                this.tramblk.getTRAMStats().addRetransBytesRcvd(tRAMDataPacket.getLength());
                this.tramblk.getTRAMStats().incRetransRcvd();
            }
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "got missing packet " + n + " nextPacket " + this.nextPacket.getSeqNumber() + " packets ranges still missing " + this.missingPackets.size() + " ack seq " + this.nextAck.getSeqNumber());
            }
        } else {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Duplicate packet " + n + " ignored.");
            }
            this.tramblk.getTRAMStats().addDuplicatePackets();
            this.tramblk.getTRAMStats().addDuplicateBytes(tRAMDataPacket.getLength());
        }
        GroupMgmtBlk groupMgmtBlk = this.tramblk.getGroupMgmtBlk();
        if (groupMgmtBlk.getDirectMemberCount() != 0 && (tRAMDataPacket.getFlags() & 1) != 0) {
            if (this.logger.requiresLogging(16)) {
                this.logger.putPacketln(this, "Find member to prune.  FLAGBIT_PRUNE is set.  flow " + tRAMDataPacket.getFlowControlInfo());
            }
            this.rateAdjuster.findMemberToPrune(tRAMDataPacket.getFlowControlInfo());
        }
        if ((headBlock = groupMgmtBlk.getHeadBlock()) != null) {
            if (bl) {
                this.sendAck((byte)0, headBlock, 2);
            } else if (this.nextAck.isLessThanOrEqual(n) && tRAMDataPacket.getSubType() == 1) {
                this.sendAck((byte)0, headBlock, 0);
            }
            if (headBlock.getAddress().equals(tRAMDataPacket.getAddress())) {
                headBlock.setLastheard(System.currentTimeMillis());
            }
        }
        if (this.tramblk.getTRAMState() == 13) {
            try {
                HeadBlock headBlock2 = this.tramblk.getGroupMgmtThread().getReAffiliationHead();
                if (headBlock2.getAddress().equals(tRAMDataPacket.getAddress())) {
                    headBlock2.setLastheard(System.currentTimeMillis());
                }
                GroupMgmtThread groupMgmtThread = this.tramblk.getGroupMgmtThread();
                if (this.checkPriorMissing(headBlock2.getStartSeqNumber())) {
                    groupMgmtThread.makeReAffilHeadToBeMainHead();
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private synchronized void addMissing(int n) {
        MissingPacket missingPacket = new MissingPacket(this.nextPacket.getSeqNumber(), n - 1);
        if (this.logger.requiresLogging(323)) {
            this.logger.putPacketln(this, "CREATED a new missing entry with start = " + this.nextPacket.getSeqNumber() + " End = " + (n - 1));
        }
        this.missingPackets.addElement(missingPacket);
    }

    private synchronized boolean checkMissing(int n) {
        Object object;
        boolean bl = false;
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Checking for missing packet " + n);
            this.logger.putPacketln(this, this.missingPackets.size() + " missing packets");
        }
        int n2 = 0;
        while (n2 < this.missingPackets.size()) {
            object = (MissingPacket)this.missingPackets.elementAt(n2);
            TRAMSeqNumber tRAMSeqNumber = ((MissingPacket)object).getEndPacket();
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Checking missing packet end = " + tRAMSeqNumber.getSeqNumber());
            }
            if (tRAMSeqNumber.isGreaterThan(n)) {
                TRAMSeqNumber tRAMSeqNumber2 = ((MissingPacket)object).getStartPacket();
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "Checking missing packet start = " + tRAMSeqNumber2.getSeqNumber());
                    this.logger.putPacketln(this, "Got earlier packet " + n);
                }
                if (tRAMSeqNumber2.isLessThan(n)) {
                    bl = true;
                    MissingPacket missingPacket = new MissingPacket(tRAMSeqNumber2.getSeqNumber(), n - 1);
                    tRAMSeqNumber2.setSeqNumber(n + 1);
                    this.missingPackets.insertElementAt(missingPacket, n2);
                    if (!this.logger.requiresLogging(3)) break;
                    this.logger.putPacketln(this, "Got a missing packet " + n);
                    break;
                }
                if (tRAMSeqNumber2.isEqualTo(n)) {
                    if (this.logger.requiresLogging(3)) {
                        this.logger.putPacketln(this, "Got a missing packet " + n);
                    }
                    bl = true;
                    if (tRAMSeqNumber2.isEqualTo(tRAMSeqNumber.getSeqNumber())) {
                        this.missingPackets.removeElementAt(n2);
                        continue;
                    }
                    if (this.logger.requiresLogging(7)) {
                        this.logger.putPacketln(this, "Bumping start seq");
                    }
                    tRAMSeqNumber2.setSeqNumber(n + 1);
                    break;
                }
            } else if (tRAMSeqNumber.isEqualTo(n)) {
                if (this.logger.requiresLogging(3)) {
                    this.logger.putPacketln(this, "Got missing packet " + n);
                }
                bl = true;
                if (tRAMSeqNumber.isEqualTo(((MissingPacket)object).getStartPacket().getSeqNumber())) {
                    this.missingPackets.removeElementAt(n2);
                    continue;
                }
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "Decrementing end seq number");
                }
                tRAMSeqNumber.setSeqNumber(n - 1);
                break;
            }
            ++n2;
        }
        if (this.dataEnd && !this.finalAckSent && this.missingPackets.size() == 0) {
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, "Sending final ACK. All packets received");
            }
            if ((object = this.tramblk.getGroupMgmtBlk().getHeadBlock()) != null) {
                this.sendAck((byte)2, (HeadBlock)object, 9);
            }
            this.finalAckSent = true;
            this.notify();
        }
        return bl;
    }

    private boolean congested() {
        if (System.currentTimeMillis() - this.joinTime < 10000L) {
            return false;
        }
        if (this.windowCongestionMessageSent == this.nextAck.getSeqNumber() / this.ackWindowSize) {
            return false;
        }
        int n = this.countMissing();
        if (n < this.tp.getMissingPacketThreshold() || n <= this.previousMissing) {
            this.previousMissing = n;
            return false;
        }
        if (this.logger.requiresLogging(23)) {
            this.logger.putPacketln(this, "Congestion!  window " + this.nextAck.getSeqNumber() / this.ackWindowSize + ", data rate " + this.rateAdjuster.getOpenWindowDataRate() + ", group flow info " + this.rateAdjuster.getGroupFlowControlInfo() + ", Missing " + n + ", highest allowed " + this.highestSequenceAllowed + ", C win " + this.tp.getCongestionWindow());
        }
        this.rateAdjuster.adjustCongestionWindowDown();
        this.windowCongestionMessageSent = this.nextAck.getSeqNumber() / this.ackWindowSize;
        this.previousMissing = n;
        return true;
    }

    public void sendAckToNonAffiliatedHead(InetAddress inetAddress, int n, byte by) {
        block6: {
            int n2 = this.nextPacket.getSeqNumber() - 1;
            TRAMAckPacket tRAMAckPacket = new TRAMAckPacket(this.tramblk, (long)n2);
            tRAMAckPacket.setAddress(inetAddress);
            tRAMAckPacket.setPort(n);
            by = (byte)(by | 4);
            tRAMAckPacket.setFlags(by);
            tRAMAckPacket.setHighestSequenceAllowed(this.getHighestSequenceAllowed());
            DatagramSocket datagramSocket = this.tramblk.getUnicastSocket();
            DatagramPacket datagramPacket = tRAMAckPacket.createDatagramPacket();
            try {
                if (this.tramblk.getSimulator() != null) {
                    this.tramblk.getSimulator().simulateUnicastPacket(datagramPacket);
                    break block6;
                }
                try {
                    this.tramblk.getTRAMStats().setSendCntlMsgCounters(tRAMAckPacket);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                datagramSocket.send(datagramPacket);
                if (this.logger.requiresLogging(3)) {
                    this.logger.putPacketln(this, "Sent ACK with TERM to " + inetAddress);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean checkPriorMissing(int n) {
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Checking for missing packets before " + n);
            this.logger.putPacketln(this, this.missingPackets.size() + " missing packets");
        }
        int n2 = 0;
        if (n2 < this.missingPackets.size()) {
            MissingPacket missingPacket = (MissingPacket)this.missingPackets.elementAt(n2);
            TRAMSeqNumber tRAMSeqNumber = missingPacket.getEndPacket();
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Checking missing packet end = " + tRAMSeqNumber.getSeqNumber());
            }
            if (tRAMSeqNumber.isLessThan(n)) {
                return true;
            }
            tRAMSeqNumber = missingPacket.getStartPacket();
            return tRAMSeqNumber.isLessThan(n);
        }
        return false;
    }

    public synchronized void sendAck(byte by, HeadBlock headBlock) {
        this.sendAck(by, headBlock, 6);
    }

    public synchronized void sendAck(byte by, HeadBlock headBlock, int n) {
        String string;
        int n2;
        int n3;
        int n4;
        block44: {
            Object object;
            Object object2;
            TRAMAckPacket tRAMAckPacket;
            MissingPacket missingPacket;
            this.abortTimer();
            n4 = 0;
            n3 = this.nextPacket.getSeqNumber() - 1;
            n2 = 7;
            if (n == 1 || n == 5) {
                n2 = 16;
            }
            string = "Outside";
            switch (n) {
                case 0: {
                    string = "OnSchedule";
                    break;
                }
                case 1: {
                    string = "Timeout";
                    break;
                }
                case 2: {
                    string = "Forced";
                    break;
                }
                case 3: {
                    string = "SeekRepairs";
                    break;
                }
                case 4: {
                    string = "GrpMgmt";
                    break;
                }
                case 5: {
                    string = "Hello";
                    break;
                }
                case 6: {
                    string = "Outside";
                    break;
                }
                case 8: {
                    string = "FinalAck";
                    break;
                }
                case 9: {
                    string = "Terminate";
                }
            }
            long l = 0L;
            while (this.missingPackets.size() > 0) {
                missingPacket = (MissingPacket)this.missingPackets.firstElement();
                if (missingPacket.getEndPacket().getSeqNumber() < this.tramblk.getLastKnownForgetBeforeSeqNum()) {
                    this.missingPackets.removeElementAt(0);
                    if (this.logger.requiresLogging(3)) {
                        this.logger.putPacketln(this, "TRAMMemberAck sendAck() : Flushed missing packets " + missingPacket.getStartPacket().getSeqNumber() + " through " + missingPacket.getEndPacket().getSeqNumber());
                    }
                    l = missingPacket.getEndPacket().getSeqNumber() - missingPacket.getStartPacket().getSeqNumber() + 1;
                    this.tramblk.getTRAMStats().addPacketsNotRecovered(l);
                    continue;
                }
                if (missingPacket.getStartPacket().getSeqNumber() > this.tramblk.getLastKnownForgetBeforeSeqNum()) break;
                int n5 = missingPacket.getStartPacket().getSeqNumber();
                missingPacket.getStartPacket().setSeqNumber(this.tramblk.getLastKnownForgetBeforeSeqNum());
                if (this.logger.requiresLogging(3)) {
                    this.logger.putPacketln(this, "TRAMMemberAck sendAck() : Flushed some  packets " + n5 + " through " + (missingPacket.getStartPacket().getSeqNumber() - 1));
                }
                l = missingPacket.getStartPacket().getSeqNumber() - n5;
                this.tramblk.getTRAMStats().addPacketsNotRecovered(l);
                break;
            }
            if (this.missingPackets.size() == 0) {
                if (this.logger.requiresLogging(3)) {
                    this.logger.putPacketln(this, "Sending a simple ack for " + n3);
                }
                this.rateAdjuster.adjustCongestionWindowUp();
                int n6 = (n3 + this.ackWindowSize) / this.ackWindowSize * this.ackWindowSize + this.tp.getCongestionWindow();
                this.highestSequenceAllowed = Math.max(this.highestSequenceAllowed, n6);
                string = "ACK(" + string + ")";
                n4 = 1;
                this.rateAdjuster.setMyFlowControlInfo(0, 0);
                tRAMAckPacket = new TRAMAckPacket(this.tramblk, (long)n3);
            } else {
                TRAMSeqNumber tRAMSeqNumber = new TRAMSeqNumber();
                object2 = new TRAMSeqNumber();
                missingPacket = (MissingPacket)this.missingPackets.firstElement();
                n4 = missingPacket.getStartPacket().getSeqNumber();
                object = new byte[(n3 - n4 + 8) / 8];
                int n7 = 0;
                while (n7 < ((byte[])object).length) {
                    object[n7] = 0;
                    ++n7;
                }
                int n8 = 0;
                while (n8 < this.missingPackets.size()) {
                    try {
                        missingPacket = (MissingPacket)this.missingPackets.elementAt(n8);
                        tRAMSeqNumber.setSeqNumber(missingPacket.getStartPacket().getSeqNumber());
                        ((TRAMSeqNumber)object2).setSeqNumber(missingPacket.getEndPacket().getSeqNumber());
                        int n9 = tRAMSeqNumber.getSeqNumber();
                        int n10 = ((TRAMSeqNumber)object2).getSeqNumber();
                        if (this.logger.requiresLogging(7)) {
                            this.logger.putPacketln(this, "Processing missing packets element " + n9 + " to " + n10);
                        }
                        if (this.logger.requiresLogging(7)) {
                            this.logger.putPacketln(this, "TRAMMemberAck sendAck() :  Processing missing packets element " + n9 + " to " + n10);
                        }
                        while (tRAMSeqNumber.isLessThanOrEqual(n10)) {
                            int n11 = Math.abs(n9 - n4) % 8;
                            int n12 = Math.abs(n9 - n4) / 8;
                            if (this.logger.requiresLogging(7)) {
                                this.logger.putPacketln(this, "offset = " + n11 + " Index = " + n12);
                            }
                            if (Math.abs(n10 - n4) / 8 == n12) {
                                int n13 = n12;
                                object[n13] = (byte)(object[n13] | ~(this.maskOffset[n11] ^ this.maskBase[Math.abs(n10 - n4) % 8]));
                                if (this.logger.requiresLogging(7)) {
                                    this.logger.putPacketln(this, "maskOffset = " + this.maskOffset[n11] + "maskBase = " + this.maskBase[Math.abs(n10 - n4) % 8]);
                                    this.logger.putPacketln(this, "Setting partial byte " + object[n12] + " for " + n12);
                                }
                            } else {
                                if (this.logger.requiresLogging(7)) {
                                    this.logger.putPacketln(this, "Setting full mask " + this.maskOffset[n11] + " for " + n12);
                                }
                                int n14 = n12;
                                object[n14] = (byte)(object[n14] | this.maskOffset[n11]);
                            }
                            tRAMSeqNumber.setSeqNumber(n9 += 8 - n11);
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        break;
                    }
                    ++n8;
                }
                int n15 = (n4 - 1 + this.ackWindowSize) / this.ackWindowSize * this.ackWindowSize + this.tp.getCongestionWindow();
                this.highestSequenceAllowed = Math.max(this.highestSequenceAllowed, n15);
                this.rateAdjuster.setMyFlowControlInfo(n3 - n4, this.countMissing());
                tRAMAckPacket = new TRAMAckPacket(this.tramblk, (byte[])object, (long)n4, Math.abs(n3 - n4) + 1);
                string = "NACK(" + string + ")";
                n2 = 16;
            }
            try {
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "Sending an Ack packet, base " + n4 + " max " + n3);
                }
                if ((by & 2) != 0 && this.logger.requiresLogging(3)) {
                    this.logger.putPacketln(this, "Sending an Ack packet with TERMINATE_MEMBERSHIP to " + headBlock.getAddress());
                }
                tRAMAckPacket.setAddress(headBlock.getAddress());
                tRAMAckPacket.setPort(headBlock.getPort());
                GroupMgmtBlk groupMgmtBlk = this.tramblk.getGroupMgmtBlk();
                tRAMAckPacket.setDirectMemberCount(groupMgmtBlk.getDirectMemberCount());
                tRAMAckPacket.setIndirectMemberCount(groupMgmtBlk.getIndirectMemberCount());
                tRAMAckPacket.setDirectHeadsAdvertising(groupMgmtBlk.getDirectAdvertisingMemberCount());
                tRAMAckPacket.setIndirectHeadsAdvertising(groupMgmtBlk.getIndirectAdvertisingMemberCount());
                tRAMAckPacket.setHighestSequenceAllowed(this.getHighestSequenceAllowed());
                tRAMAckPacket.setFlowControlInfo(this.rateAdjuster.getGroupFlowControlInfo());
                tRAMAckPacket.setDataRate((int)this.tramblk.getRateAdjuster().getOpenWindowDataRate());
                if (this.rateAdjuster.IsSubtreeWorse()) {
                    by = (byte)(by | 0x10);
                }
                if (this.congested()) {
                    by = (byte)(by | 8);
                }
                by = (byte)(by | 4);
                tRAMAckPacket.setFlags(by);
                object2 = this.tramblk.getUnicastSocket();
                object = tRAMAckPacket.createDatagramPacket();
                if (this.tramblk.getSimulator() != null) {
                    this.tramblk.getSimulator().simulateUnicastPacket((DatagramPacket)object);
                    break block44;
                }
                try {
                    this.tramblk.getTRAMStats().setSendCntlMsgCounters(tRAMAckPacket);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                ((DatagramSocket)object2).send((DatagramPacket)object);
            }
            catch (NullPointerException nullPointerException) {
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "No Head address yet.");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int n16 = this.nextAck.getSeqNumber();
        if (this.nextAck.isLessThanOrEqual(this.nextPacket.getSeqNumber())) {
            this.nextAck.setSeqNumber(n3 + this.ackWindowSize);
        }
        this.loadTimer();
        if (this.logger.requiresLogging(n2)) {
            this.logger.putPacketln(this, string + " for [" + n4 + "-" + n3 + "], missing " + this.countMissing() + " thisAck " + n16 + " nextAck " + this.nextAck.getSeqNumber() + " flow " + this.rateAdjuster.getGroupFlowControlInfo());
        }
        this.lastAckTime = System.currentTimeMillis();
        this.lastAckPacket = n3;
    }

    public void loadTimer() {
        this.abortTimer();
        int n = this.nextPacket.getSeqNumber() - 1;
        long l = System.currentTimeMillis();
        int n2 = n - this.lastAckPacket;
        if (n2 >= this.ackWindowSize / 2 && this.lastAckTime != 0L) {
            long l2 = 2L * ((l - this.lastAckTime) * (long)this.ackWindowSize / (long)n2);
            if (l2 > 0L) {
                if (this.logger.requiresLogging(3)) {
                    this.logger.putPacketln(this, "Set Ack interval to " + l2);
                }
                this.tramblk.setAckInterval(l2);
            } else if (this.logger.requiresLogging(16)) {
                this.logger.putPacketln(this, "negative timeout value " + l2 + " using previous value of " + this.tramblk.getAckInterval());
            }
        }
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Ack timeout " + this.tramblk.getAckInterval() + ", " + n2 + " packets in " + (l - this.lastAckTime) + " ms");
        }
        this.tramTimer = new TRAMSimpleTimer(this.tramblk.getAckInterval(), this, this.logger);
    }

    public synchronized void abortTimer() {
        if (this.tramTimer != null) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Killing off old ACK timer");
            }
            this.tramTimer.abortTimer();
        }
        this.tramTimer = null;
    }

    public void handleTimeout() {
        HeadBlock headBlock = this.tramblk.getGroupMgmtBlk().getHeadBlock();
        if (headBlock != null) {
            if (this.missingPackets.size() != 0) {
                this.sendAck((byte)0, headBlock, 1);
                return;
            }
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "No ack necessary from handle timeout routine.");
            }
        } else if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "ack timeout, head block is null");
        }
        this.loadTimer();
    }

    public void printMissing(Vector vector, String string) {
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "missing packets " + this.countMissing() + ", next expected " + this.nextPacket.getSeqNumber() + ", Highest allowed " + this.highestSequenceAllowed + ", C Win " + this.tp.getCongestionWindow());
        }
        int n = 0;
        while (n < vector.size()) {
            MissingPacket missingPacket = (MissingPacket)vector.elementAt(n);
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, string + " Missing packets " + missingPacket.getStartPacket().getSeqNumber() + " to " + missingPacket.getEndPacket().getSeqNumber());
            }
            ++n;
        }
    }

    public synchronized int countMissing() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.missingPackets.size()) {
            MissingPacket missingPacket = (MissingPacket)this.missingPackets.elementAt(n2);
            n += Math.abs(missingPacket.getEndPacket().getSeqNumber() - missingPacket.getStartPacket().getSeqNumber()) + 1;
            ++n2;
        }
        return n;
    }

    public synchronized void receiveBeaconPacket(BeaconPacketEvent beaconPacketEvent) {
        HeadBlock headBlock;
        BeaconPacket beaconPacket = beaconPacketEvent.getPacket();
        byte by = (byte)beaconPacket.getFlags();
        try {
            headBlock = this.tramblk.getGroupMgmtBlk().getHeadBlock();
        }
        catch (NullPointerException nullPointerException) {
            headBlock = null;
        }
        if ((by & 2) != 0) {
            if (this.logger.requiresLogging(167)) {
                this.logger.putPacketln(this, "Received Data End Beacon. Last Pkt Seq Num is " + beaconPacket.getSeqNumber());
            }
            this.handleDataTransmissionComplete(headBlock, beaconPacket.getSeqNumber());
            return;
        }
        if ((by & 4) != 0) {
            if (this.logger.requiresLogging(39)) {
                this.logger.putPacketln(this, "Received Filler Beacon. Last Reported Packet is " + beaconPacket.getSeqNumber());
            }
            this.seekRepairsForPendingPkts(headBlock, beaconPacket.getSeqNumber());
        }
    }

    public synchronized void seekRepairsForPendingPkts(HeadBlock headBlock, int n) {
        if (this.finalAckSent) {
            return;
        }
        if (this.init) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Can't seek repairs 'cause we're still initializing...");
            }
            return;
        }
        if (headBlock == null) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Can't seek repairs 'cause we're not bound to a head...");
            }
            return;
        }
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "seekRepairs next seq " + this.nextPacket.getSeqNumber() + " reportLastSeq " + n);
        }
        if (this.nextPacket.isLessThanOrEqual(n)) {
            this.addMissing(n + 1);
            this.nextPacket.setSeqNumber(n + 1);
        }
        if (this.missingPackets.size() != 0) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "seekRepairs next seq " + this.nextPacket.getSeqNumber() + ", reportLastSeq " + n + ", previousMissing " + this.previousMissing + ", currentMissing " + this.countMissing());
            }
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Sending ack... requesting repairs  Reported last " + n + ". Expected next packet is " + this.nextPacket.getSeqNumber());
            }
            this.sendAck((byte)0, headBlock, 3);
        }
    }

    public synchronized void handleDataTransmissionComplete(HeadBlock headBlock, int n) {
        if (!this.tramblk.isDataTransmissionComplete()) {
            this.tramblk.setDataTransmissionComplete(true);
            this.tramblk.setLastKnownSequenceNumber(n);
        }
        if (this.nextPacket.isLessThanOrEqual(n)) {
            this.addMissing(n + 1);
            this.nextPacket.setSeqNumber(n + 1);
        }
        if (this.missingPackets.size() == 0) {
            if (this.logger.requiresLogging(163)) {
                this.logger.putPacketln(this, "Sending final ack.  All packets received");
            }
            if (headBlock != null) {
                this.sendAck((byte)2, headBlock, 8);
            }
            this.finalAckSent = true;
            this.notify();
        } else if (headBlock != null) {
            this.sendAck((byte)0, headBlock, 8);
        }
        this.dataEnd = true;
    }

    private synchronized void removeUnrecoverableMissingPkts(int n, int n2, int[] nArray, boolean bl) {
        if (this.logger.requiresLogging(3)) {
            this.logger.putPacketln(this, "Handling UNRECOVERABLE packets up to (not including) " + n);
        }
        int n3 = 0;
        while (n3 < this.missingPackets.size()) {
            MissingPacket missingPacket = (MissingPacket)this.missingPackets.elementAt(n3);
            if (missingPacket.getEndPacket().isLessThan(n)) {
                this.missingPackets.removeElementAt(n3);
                continue;
            }
            if (missingPacket.getStartPacket().isLessThan(n)) {
                missingPacket.getStartPacket().setSeqNumber(n + 1);
                ++n3;
                continue;
            }
            ++n3;
        }
    }

    public synchronized void waitToComplete() {
        while (true) {
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, "Waiting for member task to complete");
            }
            if (this.finalAckSent) break;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void printDataCounts() {
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "MissingPackets = " + this.missingPackets.size());
        }
    }

    public int getNextPktSeqNumberToReceive() {
        return this.nextPacket.getSeqNumber();
    }

    public synchronized void receiveTRAMMembership(TRAMMembershipEvent tRAMMembershipEvent) {
        block24: {
            HeadBlock headBlock;
            block23: {
                headBlock = this.tramblk.getGroupMgmtBlk().getHeadBlock();
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "Received membership notification from " + headBlock.getAddress());
                }
                this.highestSequenceAllowed = headBlock.getStartSeqNumber() + this.tp.getCongestionWindow();
                this.joinTime = System.currentTimeMillis();
                if (!this.init) break block23;
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "The init flag is set. carry on");
                }
                this.init = false;
                this.clearDataCacheProcessedMembershipEvent();
                switch (this.tp.getLateJoinPreference()) {
                    case 2: {
                        if (this.nextPacket.isLessThan(headBlock.getStartSeqNumber())) {
                            this.addMissing(headBlock.getStartSeqNumber());
                        }
                        if (this.logger.requiresLogging(387)) {
                            this.logger.putPacketln(this, "Setting the starting sequence number to " + headBlock.getStartSeqNumber());
                        }
                        if (this.logger.requiresLogging(263)) {
                            this.logger.putPacketln(this, "Replaying the " + this.holdingTank.size() + " packets in the holdingTank");
                        }
                        this.nextPacket.setSeqNumber(headBlock.getStartSeqNumber());
                        int n = 0;
                        while (n < this.holdingTank.size()) {
                            this.receiveDataPacket((TRAMDataPacketEvent)this.holdingTank.elementAt(n));
                            ++n;
                        }
                        this.holdingTank = null;
                        if (this.logger.requiresLogging(7)) {
                            this.logger.putPacketln(this, "The holding tank has been deleted");
                            break;
                        }
                        break block24;
                    }
                    case 1: {
                        this.nextPacket.setSeqNumber(headBlock.getStartSeqNumber());
                        if (this.logger.requiresLogging(259)) {
                            this.logger.putPacketln(this, "Setting the starting sequence number to " + headBlock.getStartSeqNumber());
                        }
                        if (this.logger.requiresLogging(263)) {
                            this.logger.putPacketln(this, "Replaying the " + this.holdingTank.size() + " packets in the holdingTank");
                        }
                        int n = 0;
                        while (n < this.holdingTank.size()) {
                            this.receiveDataPacket((TRAMDataPacketEvent)this.holdingTank.elementAt(n));
                            ++n;
                        }
                        this.holdingTank = null;
                        if (this.logger.requiresLogging(7)) {
                            this.logger.putPacketln(this, "The holding tank has been deleted");
                            break;
                        }
                        break block24;
                    }
                    case 3: {
                        if (this.logger.requiresLogging(387)) {
                            this.logger.putPacketln(this, "Setting the starting sequence number to " + headBlock.getStartSeqNumber());
                        }
                        this.nextPacket.setSeqNumber(headBlock.getStartSeqNumber());
                        this.needToWaitForCacheToProcessMembershipEvent = true;
                        break;
                    }
                    default: {
                        this.init = true;
                        break;
                    }
                }
                break block24;
            }
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "The init flag is not Set.  Must be head switch");
            }
            switch (this.tp.getLateJoinPreference()) {
                case 1: 
                case 2: {
                    if (!this.nextPacket.isLessThan(headBlock.getStartSeqNumber())) break;
                    this.addMissing(headBlock.getStartSeqNumber());
                    this.nextPacket.setSeqNumber(headBlock.getStartSeqNumber());
                    break;
                }
                case 3: {
                    int n = headBlock.getStartSeqNumber();
                    this.removeUnrecoverableMissingPkts(n, 0, null, false);
                    if (!this.nextPacket.isLessThan(n)) break;
                    this.nextPacket.setSeqNumber(n);
                    break;
                }
                default: {
                    if (!this.logger.requiresLogging(3)) break;
                    this.logger.putPacketln(this, "Invalid LateJoin Recovery Pref");
                }
            }
            if (this.logger.requiresLogging(263)) {
                this.logger.putPacketln(this, "Next Packet to Receive sequence # " + this.nextPacket.getSeqNumber() + " Head StartSeq # " + headBlock.getStartSeqNumber());
            }
        }
    }

    public synchronized void dataCacheProcessedMembershipEvent() {
        this.dataCacheProcessedMembershipEvent = true;
    }

    public synchronized void clearDataCacheProcessedMembershipEvent() {
        this.dataCacheProcessedMembershipEvent = false;
    }

    public boolean getDataCacheProcessedMembershipEvent() {
        return this.dataCacheProcessedMembershipEvent;
    }

    public synchronized void dealWithUnrecoverablePkts(int n) {
        switch (this.tp.getLateJoinPreference()) {
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                this.removeUnrecoverableMissingPkts(n, 0, null, false);
                break;
            }
            default: {
                if (!this.logger.requiresLogging(3)) break;
                this.logger.putPacketln(this, "Invalid LateJoin Recovery Pref");
            }
        }
    }

    private int getHighestSequenceAllowed() {
        GroupMgmtBlk groupMgmtBlk = this.tramblk.getGroupMgmtBlk();
        if (groupMgmtBlk.getDirectMemberCount() == 0) {
            return this.highestSequenceAllowed;
        }
        int n = groupMgmtBlk.getHighestSequenceAllowed();
        if (this.highestSequenceAllowed < n) {
            return this.highestSequenceAllowed;
        }
        return n;
    }
}

