/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.TRAMPacket;
import com.sun.multicast.util.Util;
import java.net.DatagramPacket;
import java.net.InetAddress;

class TRAMLoggingOptionPacket
extends TRAMPacket {
    public static final byte FLAGBIT_ALLNODES = 1;
    public static final byte FLAGBIT_IGNORE_ID_ADDRESS = 2;
    public static final byte FLAGBIT_V6ADDRESS = -128;
    private static final int IPV4_ADDRESS_SIZE = 4;
    private static final int ADDRESS_COUNT = 0;
    private static final int LOG_OPTION = 2;
    private static final int SOURCE_ADDR = 6;
    private static final int HOST1_ADDRESS = 10;
    private int logOption = 0;
    private InetAddress srcAddress = null;
    private int addressCount = 0;
    private InetAddress[] addressList = null;

    public TRAMLoggingOptionPacket(DatagramPacket datagramPacket) {
        super(datagramPacket);
        int n = super.readInt(6);
        this.srcAddress = Util.intToInetAddress(n);
        this.logOption = super.readInt(2);
        this.addressCount = super.readShort(0) & 0xFFFF;
        if (this.addressCount == 0) {
            return;
        }
        this.addressList = new InetAddress[this.addressCount];
        int n2 = 10;
        n = 0;
        while (n < this.addressCount) {
            this.addressList[n] = Util.intToInetAddress(super.readInt(n2));
            n2 += 4;
            ++n;
        }
    }

    public TRAMLoggingOptionPacket(InetAddress inetAddress, int n, int n2, InetAddress inetAddress2, int n3, InetAddress[] inetAddressArray, int n4) {
        super(10 + n4 * 4, n2);
        this.setAddress(inetAddress);
        this.setPort(n);
        this.setLogOption(n3);
        this.srcAddress = inetAddress2;
        this.setMessageType(1);
        this.setSubType(90);
        this.addressCount = n4;
        this.addressList = inetAddressArray;
        byte by = 0;
        if (inetAddress2 == null || n2 == 0) {
            by = (byte)(by | 2);
        }
        if (inetAddressArray == null || inetAddressArray.length == 0) {
            by = (byte)(by | 1);
        }
        this.setFlags(by);
    }

    public DatagramPacket createDatagramPacket() {
        if (this.srcAddress == null) {
            super.writeInt(0, 6);
        } else {
            super.writeInt(Util.InetAddressToInt(this.srcAddress), 6);
        }
        super.writeInt(this.logOption, 2);
        if (this.addressList == null || this.addressList.length == 0) {
            this.addressCount = 0;
        } else {
            int n = 10;
            this.addressCount = this.addressList.length;
            int n2 = 0;
            while (n2 < this.addressCount) {
                super.writeInt(Util.InetAddressToInt(this.addressList[n2]), n);
                n += 4;
                ++n2;
            }
        }
        super.writeShort((short)this.addressCount, 0);
        return super.createDatagramPacket();
    }

    public int getAddressCount() {
        return this.addressCount;
    }

    public void setAddressCount(int n) {
        this.addressCount = n;
        super.writeShort((short)n, 0);
    }

    public int getLogOption() {
        return this.logOption;
    }

    public void setLogOption(int n) {
        this.logOption = n;
        super.writeInt(n, 2);
    }

    public InetAddress getSrcAddress() {
        return this.srcAddress;
    }

    public void setSrcAddress(InetAddress inetAddress) {
        this.srcAddress = inetAddress;
    }

    public InetAddress[] getAddressList() {
        return this.addressList;
    }

    public void setAddressList(InetAddress[] inetAddressArray) {
        this.addressList = inetAddressArray;
    }
}

