/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMLogData;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;

class TRAMLogger {
    public static final int LOG_INFO = 1;
    public static final int LOG_TEST = 1;
    public static final int LOG_DIAGNOSTICS = 3;
    public static final int LOG_VERBOSE = 7;
    public static final int LOG_FATAL_ERROR = 8;
    public static final int LOG_CONG = 16;
    public static final int LOG_CNTLMESG = 32;
    public static final int LOG_DATAMESG = 64;
    public static final int LOG_SESSION = 128;
    public static final int LOG_DATACACHE = 256;
    public static final int LOG_SECURITY = 512;
    public static final int LOG_PERFMON = 1024;
    public static final int LOG_ABORT_TRAM = Integer.MIN_VALUE;
    public static final int LOG_NONE = 0;
    public static final int LOG_ANY_BASIC = 7;
    public static final int LOG_ANY_FUNCTIONAL = 1008;
    public static final int LOG_ANY = 1023;
    private static final String NEWLINE = "\n";
    private static final byte[] NEWLINE_IN_BYTES = "\n".getBytes();
    PrintStream out;
    TRAMControlBlock tramblk;
    long time;

    public TRAMLogger(TRAMControlBlock tRAMControlBlock) {
        this.tramblk = tRAMControlBlock;
        this.out = System.err;
        this.time = System.currentTimeMillis();
    }

    private synchronized void writePacket(TRAMLogData tRAMLogData, boolean bl) throws IOException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = tRAMLogData.getSource().toString();
        if (string5.indexOf("Thread") == 0) {
            int n;
            if ((string5 = string5.substring(6)).indexOf("[TRAM ") == 0) {
                string5 = string5.substring(6);
            }
            if ((n = string5.indexOf(",5,main]")) > 0) {
                string5 = string5.substring(0, n) + string5.substring(n + 8);
            }
        }
        String string6 = tRAMLogData.getString();
        int n = string5.lastIndexOf(".");
        int n2 = string5.indexOf("@");
        n = n == -1 ? 0 : ++n;
        if (n2 == -1) {
            n2 = string5.length();
        }
        string5 = string5.substring(n, n2).concat(": ");
        Calendar calendar = Calendar.getInstance();
        String string7 = "" + calendar.get(11);
        if (string7.length() == 1) {
            string7 = "0" + string7;
        }
        if ((string4 = "" + calendar.get(12)).length() == 1) {
            string4 = "0" + string4;
        }
        if ((string3 = "" + calendar.get(13)).length() == 1) {
            string3 = "0" + string3;
        }
        if ((string2 = "" + calendar.get(14)).length() == 1) {
            string2 = "00" + string2;
        } else if (string2.length() == 2) {
            string2 = "0" + string2;
        }
        String string8 = "" + (calendar.get(2) + 1);
        if (string8.length() == 1) {
            string8 = "0" + string8;
        }
        if ((string = "" + calendar.get(5)).length() == 1) {
            string = "0" + string;
        }
        String string9 = string8 + "/" + string + " " + string7 + ":" + string4 + ":" + string3 + "." + string2 + " ";
        if (bl) {
            this.out.println(string9 + string5 + string6);
        } else {
            ((FilterOutputStream)this.out).write(string9.getBytes());
            ((FilterOutputStream)this.out).write(string5.getBytes());
            ((FilterOutputStream)this.out).write(string6.getBytes());
        }
    }

    public void putPacket(Object object, String string) {
        TRAMLogData tRAMLogData = new TRAMLogData(object, string);
        try {
            this.writePacket(tRAMLogData, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void putPacket(Object object, int n, String string) {
        if (this.requiresLogging(n)) {
            TRAMLogData tRAMLogData = new TRAMLogData(object, string);
            try {
                this.writePacket(tRAMLogData, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void putPacketln(Object object, String string) {
        TRAMLogData tRAMLogData = new TRAMLogData(object, string);
        try {
            this.writePacket(tRAMLogData, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void putPacketln(Object object, int n, String string) {
        if (this.requiresLogging(n)) {
            TRAMLogData tRAMLogData = new TRAMLogData(object, string);
            try {
                this.writePacket(tRAMLogData, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized void flush() throws IOException {
        if (this.tramblk.getTransportProfile().isLoggingEnabled()) {
            this.out.flush();
        }
    }

    public boolean requiresLogging(int n) {
        if ((n & 8) != 0) {
            return true;
        }
        int n2 = this.tramblk.getTransportProfile().getLogMask();
        switch (n2) {
            case 0: {
                return false;
            }
            case 1023: {
                break;
            }
            default: {
                int n3 = n & 7;
                if (n3 != 0 && (n2 & 7) >= n3 || (n2 & n & 0x3F0) != 0) break;
                return false;
            }
        }
        return true;
    }

    public void timeStampPacket(String string, int n) {
        long l = System.currentTimeMillis();
        this.out.println(string + " " + (l - this.time) + " " + n);
        this.time = l;
    }

    public void timeStampPacket(String string, long l) {
        long l2 = System.currentTimeMillis();
        this.out.println(string + " " + (l2 - this.time) + " " + l);
        this.time = l2;
    }

    public static final boolean isLoggingEnabled(int n, int n2) {
        return (n & n2) != 0;
    }
}

