/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMPacket;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import com.sun.multicast.util.Util;
import java.net.DatagramPacket;
import java.net.InetAddress;

class TRAMHelloUniPacket
extends TRAMPacket {
    public static final byte FLAGBIT_DISOWNED = 1;
    public static final byte FLAGBIT_V6ADDRESS = -128;
    private static final short RXLEVEL = 0;
    private static final short RESERVED = 1;
    private static final short SOURCE_ADDR = 2;
    private static final short HELLO_UNIDATA = 6;
    private byte rxLevel = 0;
    private InetAddress srcAddress = null;

    public TRAMHelloUniPacket(DatagramPacket datagramPacket) {
        super(datagramPacket);
        this.rxLevel = super.readByte(0);
        int n = super.readInt(2);
        this.srcAddress = Util.intToInetAddress(n);
    }

    public TRAMHelloUniPacket(TRAMControlBlock tRAMControlBlock) {
        super(6, tRAMControlBlock.getSessionId());
        this.setMessageType(3);
        this.setSubType(3);
        TRAMTransportProfile tRAMTransportProfile = tRAMControlBlock.getTransportProfile();
        this.srcAddress = tRAMTransportProfile.getDataSourceAddress();
        this.rxLevel = (byte)tRAMControlBlock.getGroupMgmtBlk().getRxLevel();
    }

    public DatagramPacket createDatagramPacket() {
        super.writeByte(this.rxLevel, 0);
        super.writeInt(Util.InetAddressToInt(this.srcAddress), 2);
        return super.createDatagramPacket();
    }

    public byte getRxLevel() {
        return this.rxLevel;
    }

    public void setRxLevel(byte by) {
        this.rxLevel = by;
    }

    public InetAddress getSrcAddress() {
        return this.srcAddress;
    }

    public void setSrcAddress(InetAddress inetAddress) {
        this.srcAddress = inetAddress;
    }
}

