/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMPacket;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import com.sun.multicast.util.Util;
import java.net.DatagramPacket;
import java.net.InetAddress;

class TRAMHelloPacket
extends TRAMPacket {
    public static final byte FLAGBIT_ACK = 1;
    public static final byte FLAGBIT_TXDONE = 2;
    public static final byte FLAGBIT_V6ADDRESS = -128;
    private static final short V4_ADDR_SIZE = 4;
    private static final short TTL = 0;
    private static final short HSTATE = 1;
    private static final short RESERVED = 1;
    private static final short RESERVED1 = 2;
    private static final short ACKMEM_COUNT = 4;
    private static final short RXLEVEL = 5;
    private static final short UCAST_PORT = 6;
    private static final short MEMBER_COUNT = 8;
    private static final short RESERVED2 = 9;
    private static final short LOW_SEQ_NUMBER = 10;
    private static final short HIGH_SEQ_NUMBER = 14;
    private static final short SOURCE_ADDR = 18;
    private static final short MEMBER_ADDR = 22;
    private static final short HELLODATA = 22;
    private byte ttl = 0;
    private byte rxLevel = 0;
    private byte hstate = 0;
    private int ackMemberCount = 0;
    private int unicastPort = 0;
    private int memberCount = 0;
    private byte reserv1 = 0;
    private InetAddress srcAddress = null;
    private int timeStamp = 0;
    private int lowSeqNumber = 0;
    private int highSeqNumber = 0;
    private InetAddress[] addressList = null;

    public TRAMHelloPacket(DatagramPacket datagramPacket) {
        super(datagramPacket);
        this.ttl = super.readByte(0);
        this.rxLevel = super.readByte(5);
        this.hstate = (byte)(super.readByte(1) >>> 4 & 0xF);
        this.ackMemberCount = super.readByte(4) & 0xFF;
        this.unicastPort = super.readShort(6) & 0xFFFF;
        this.memberCount = super.readByte(8) & 0xFF;
        int n = super.readInt(18);
        this.srcAddress = Util.intToInetAddress(n);
        byte by = (byte)this.getFlags();
        this.lowSeqNumber = super.readInt(10);
        this.highSeqNumber = super.readInt(14);
        if ((by & 1) != 0) {
            this.addressList = new InetAddress[this.ackMemberCount];
            int n2 = 0;
            short s = 0;
            int n3 = 0;
            while (n3 < this.ackMemberCount) {
                Object var7_7 = null;
                s = (short)(22 + (short)n3 * 4);
                n2 = super.readInt(s);
                this.addressList[n3] = Util.intToInetAddress(n2);
                ++n3;
            }
        }
    }

    public TRAMHelloPacket(TRAMControlBlock tRAMControlBlock, byte by, int n) {
        super(22, tRAMControlBlock.getSessionId());
        this.setMessageType(1);
        this.setSubType(2);
        TRAMTransportProfile tRAMTransportProfile = tRAMControlBlock.getTransportProfile();
        this.setAddress(tRAMTransportProfile.getAddress());
        this.setPort(tRAMTransportProfile.getPort());
        this.ttl = by;
        this.srcAddress = tRAMTransportProfile.getDataSourceAddress();
        this.rxLevel = (byte)tRAMControlBlock.getGroupMgmtBlk().getRxLevel();
        this.hstate = tRAMControlBlock.getGroupMgmtBlk().getHstate();
        this.unicastPort = tRAMControlBlock.getUnicastPort();
        try {
            this.memberCount = tRAMControlBlock.getGroupMgmtBlk().getDirectMemberCount();
        }
        catch (NullPointerException nullPointerException) {
            this.memberCount = 0;
        }
        this.highSeqNumber = n;
        this.lowSeqNumber = tRAMControlBlock.getTRAMDataCache().getLowestSequenceNumber();
        this.ackMemberCount = 0;
    }

    public TRAMHelloPacket(TRAMControlBlock tRAMControlBlock, byte by, int n, int n2, InetAddress[] inetAddressArray) {
        super(22 + n * 4, tRAMControlBlock.getSessionId());
        this.setMessageType(1);
        this.setSubType(2);
        TRAMTransportProfile tRAMTransportProfile = tRAMControlBlock.getTransportProfile();
        this.setAddress(tRAMTransportProfile.getAddress());
        this.setPort(tRAMTransportProfile.getPort());
        this.ttl = by;
        this.srcAddress = tRAMTransportProfile.getDataSourceAddress();
        this.rxLevel = (byte)tRAMControlBlock.getGroupMgmtBlk().getRxLevel();
        this.hstate = tRAMControlBlock.getGroupMgmtBlk().getHstate();
        this.unicastPort = tRAMControlBlock.getUnicastPort();
        this.highSeqNumber = n2;
        this.lowSeqNumber = tRAMControlBlock.getTRAMDataCache().getLowestSequenceNumber();
        try {
            this.memberCount = tRAMControlBlock.getGroupMgmtBlk().getDirectMemberCount();
        }
        catch (NullPointerException nullPointerException) {
            this.memberCount = 0;
        }
        this.ackMemberCount = n & 0xFF;
        this.addressList = inetAddressArray;
    }

    public DatagramPacket createDatagramPacket() {
        super.writeByte(this.ttl, 0);
        byte by = (byte)(this.hstate << 4 & 0xF0);
        super.writeByte(by, 1);
        super.writeByte(this.rxLevel, 5);
        super.writeInt(Util.InetAddressToInt(this.srcAddress), 18);
        super.writeByte((byte)this.ackMemberCount, 4);
        super.writeShort((short)this.unicastPort, 6);
        super.writeByte((byte)this.memberCount, 8);
        super.writeInt(this.lowSeqNumber, 10);
        super.writeInt(this.highSeqNumber, 14);
        int n = 22;
        int n2 = 0;
        while (n2 < this.ackMemberCount) {
            super.writeInt(Util.InetAddressToInt(this.addressList[n2]), n);
            n += 4;
            ++n2;
        }
        return super.createDatagramPacket();
    }

    public byte getTTL() {
        return this.ttl;
    }

    public void setTTL(byte by) {
        this.ttl = by;
    }

    public byte getRxLevel() {
        return this.rxLevel;
    }

    public void setRxLevel(byte by) {
        this.rxLevel = by;
    }

    public byte getHstate() {
        return this.hstate;
    }

    public void setHstate(byte by) {
        this.hstate = by;
    }

    public int getUnicastPort() {
        return this.unicastPort & 0xFFFF;
    }

    public void setUnicastPort(int n) {
        this.unicastPort = (short)n;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public void setMemberCount(int n) {
        this.memberCount = (byte)n;
    }

    public int getAckMemberCount() {
        return this.ackMemberCount & 0xFF;
    }

    public void setAckMemberCount(int n) {
        this.ackMemberCount = (byte)n;
    }

    public int getLowSeqNumber() {
        return this.lowSeqNumber;
    }

    public void setLowSeqNumber(int n) {
        this.lowSeqNumber = n;
    }

    public int getHighSeqNumber() {
        return this.highSeqNumber;
    }

    public void setHighSeqNumber(int n) {
        this.highSeqNumber = n;
    }

    public InetAddress getSrcAddress() {
        return this.srcAddress;
    }

    public void setSrcAddress(InetAddress inetAddress) {
        this.srcAddress = inetAddress;
    }

    public InetAddress[] getAddressList() {
        return this.addressList;
    }

    public void setAddressList(InetAddress[] inetAddressArray) {
        this.addressList = inetAddressArray;
    }
}

