/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.BeaconPacket;
import com.sun.multicast.reliable.transport.tram.BeaconPacketEvent;
import com.sun.multicast.reliable.transport.tram.BeaconPacketListener;
import com.sun.multicast.reliable.transport.tram.GroupMgmtBlk;
import com.sun.multicast.reliable.transport.tram.MemberBlock;
import com.sun.multicast.reliable.transport.tram.TRAMAckPacket;
import com.sun.multicast.reliable.transport.tram.TRAMAckPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMAckPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMDataCache;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacket;
import com.sun.multicast.reliable.transport.tram.TRAMLogger;
import com.sun.multicast.reliable.transport.tram.TRAMMemberAck;
import com.sun.multicast.reliable.transport.tram.TRAMRateAdjuster;
import com.sun.multicast.reliable.transport.tram.TRAMSeqNumber;
import com.sun.multicast.reliable.transport.tram.TRAMStats;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.io.IOException;
import java.net.InetAddress;
import java.util.NoSuchElementException;
import java.util.Vector;

class TRAMHeadAck
implements TRAMAckPacketListener,
BeaconPacketListener {
    TRAMControlBlock tramblk;
    TRAMStats statsBlock;
    TRAMTransportProfile tp;
    TRAMLogger logger;
    Vector controlPacketList;
    GroupMgmtBlk gblk;
    boolean dataEnd = false;
    TRAMDataCache dataCache;
    int lastWindow = 0;

    public TRAMHeadAck(TRAMControlBlock tRAMControlBlock) {
        this.tramblk = tRAMControlBlock;
        this.statsBlock = tRAMControlBlock.getTRAMStats();
        this.tp = tRAMControlBlock.getTransportProfile();
        this.logger = tRAMControlBlock.getLogger();
        this.gblk = tRAMControlBlock.getGroupMgmtBlk();
        this.dataCache = tRAMControlBlock.getTRAMDataCache();
        tRAMControlBlock.getUcastInputDispThread().addTRAMAckPacketListener(this);
        tRAMControlBlock.getInputDispThread().addBeaconPacketListener(this);
    }

    public void receiveAckPacket(TRAMAckPacketEvent tRAMAckPacketEvent) {
        int n;
        int n2;
        TRAMMemberAck tRAMMemberAck;
        int n3;
        int n4;
        int n5;
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Got Ack...");
        }
        TRAMAckPacket tRAMAckPacket = tRAMAckPacketEvent.getPacket();
        MemberBlock memberBlock = null;
        InetAddress inetAddress = tRAMAckPacket.getAddress();
        int n6 = tRAMAckPacket.getPort();
        try {
            memberBlock = this.gblk.getMember(inetAddress, n6);
        }
        catch (NoSuchElementException noSuchElementException) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "No Member for " + inetAddress + " port " + n6);
            }
            return;
        }
        int n7 = tRAMAckPacket.getFlags();
        if ((n7 & 2) != 0) {
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, "Got a terminate membership ack packet");
            }
            return;
        }
        memberBlock.setFlowControlInfo(tRAMAckPacket.getFlowControlInfo());
        memberBlock.setSubTreeFlowControlInfo((n7 & 0x10) != 0);
        if ((n7 & 8) != 0) {
            int n8;
            if (this.logger.requiresLogging(16)) {
                this.logger.putPacketln(this, "Congestion flag set in ACK from " + inetAddress + " port " + n6);
            }
            if ((n8 = (int)tRAMAckPacket.getBasePacketNumber() / this.tp.getAckWindow()) > this.lastWindow) {
                this.lastWindow = n8;
                TRAMRateAdjuster tRAMRateAdjuster = this.tramblk.getRateAdjuster();
                TRAMMemberAck tRAMMemberAck2 = this.tramblk.getMemberAck();
                if (tRAMMemberAck2 == null) {
                    tRAMRateAdjuster.congestion(tRAMAckPacket.getAddress());
                } else {
                    tRAMMemberAck2.sendAck((byte)8, this.gblk.getHeadBlock(), 11);
                }
            }
        }
        if ((n7 & 4) == 0) {
            return;
        }
        byte[] byArray = tRAMAckPacket.getBitMask();
        if (byArray.length < ((n5 = tRAMAckPacket.getBitMaskLength()) + 7) / 8) {
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, "Bitmask too short. Specified length " + (n5 + 7) / 8 + " Actual length " + byArray.length);
            }
            return;
        }
        int n9 = (int)tRAMAckPacket.getBasePacketNumber();
        int n10 = 0;
        int n11 = 0;
        while (n11 < n5) {
            n4 = n11 % 8;
            n3 = n11 / 8;
            if (((byte)(1 << n4) & byArray[n3]) != 0) {
                this.retransmitPacket(n9 + 8 * n3 + n4, memberBlock);
                ++n10;
            }
            ++n11;
        }
        if (n5 != 0) {
            --n9;
        }
        if (n9 > memberBlock.getLastPacketAcked()) {
            memberBlock.setLastPacketAcked(n9);
        }
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Found member " + memberBlock.getMemberId() + " Set last packet acked to " + n9);
        }
        if (this.tramblk.isCacheFull()) {
            if (this.dataCache == null) {
                this.dataCache = this.tramblk.getTRAMDataCache();
            }
            this.dataCache.purgeCache(-1);
        }
        n3 = this.gblk.getHighestSequenceAllowed();
        memberBlock.setHighestSequenceAllowed(tRAMAckPacket.getHighestSequenceAllowed());
        n4 = this.gblk.getHighestSequenceAllowed();
        this.tramblk.setHighestSequenceAllowed(n4);
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Found member " + memberBlock.getMemberId() + " Set last packet acked to " + memberBlock.getLastPacketAcked());
        }
        if (n4 - n3 > this.tp.getAckWindow() / 2 && (tRAMMemberAck = this.tramblk.getMemberAck()) != null) {
            if (this.logger.requiresLogging(16)) {
                this.logger.putPacketln(this, "Sending ACK now.  oldHighest " + n3 + " newHighest " + n4);
            }
            tRAMMemberAck.sendAck((byte)0, this.gblk.getHeadBlock(), 10);
        }
        if (n5 == 0) {
            n2 = 1;
            n = n9;
        } else {
            n2 = n9 + 1;
            n = n9 + n5;
        }
        int n12 = 55;
        String string = "ACK";
        if (n10 > 0) {
            n12 |= 0x10;
            string = "NACK";
        }
        if (this.logger.requiresLogging(n12)) {
            this.logger.putPacketln(this, string + " from " + memberBlock.getAddress() + " [" + n2 + "-" + n + "], missing " + n10 + ", highest wanted " + tRAMAckPacket.getHighestSequenceAllowed() + ", allowed " + this.tramblk.getHighestSequenceAllowed() + ", next " + this.tramblk.getLastKnownSequenceNumber() + ", flow " + memberBlock.getFlowControlInfo() + (memberBlock.getSubTreeFlowControlInfo() ? ", subtree" : "") + ", flags " + n7);
        }
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Done with ACK Packet...");
        }
    }

    private void retransmitPacket(int n, MemberBlock memberBlock) {
        TRAMDataPacket tRAMDataPacket = null;
        if (this.dataCache == null) {
            if (this.logger.requiresLogging(263)) {
                this.logger.putPacketln(this, "Cache not loaded. Try loading it now");
            }
            if ((this.dataCache = this.tramblk.getTRAMDataCache()) == null) {
                if (this.logger.requiresLogging(263)) {
                    this.logger.putPacketln(this, "Cache is still null, skip retrans");
                }
                return;
            }
        }
        try {
            tRAMDataPacket = this.dataCache.getPacket(n);
        }
        catch (NoSuchElementException noSuchElementException) {
            block21: {
                TRAMSeqNumber tRAMSeqNumber = new TRAMSeqNumber(n);
                try {
                    if (tRAMSeqNumber.isLessThan(this.tramblk.getTRAMDataCache().getLowestSequenceNumber())) {
                        this.tramblk.getHelloThread().reportUnavailablePacket(n);
                        if (this.logger.requiresLogging(259)) {
                            this.logger.putPacketln(this, "Reporting packet unavailable " + n);
                        }
                        break block21;
                    }
                    if (this.logger.requiresLogging(263)) {
                        this.logger.putPacketln(this, "Packet " + n + " has not been recevied yet. Try again later");
                    }
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            return;
        }
        if (tRAMDataPacket.isTransmitPending()) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Packet " + n + " for " + memberBlock.getAddress() + " is already in retran queue");
            }
            return;
        }
        long l = 100L;
        if (tRAMDataPacket.getDataRate() != 0) {
            l = this.tp.getAckWindow() * this.tp.getMaxBuf() * 1000 / 2 / tRAMDataPacket.getDataRate();
        }
        if (l > 100L) {
            l = 100L;
        }
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "expected time is " + l + " rate is " + tRAMDataPacket.getDataRate());
        }
        if (System.currentTimeMillis() - tRAMDataPacket.getLastTransmitTime() < l) {
            if (this.logger.requiresLogging(23)) {
                this.logger.putPacketln(this, "Packet " + n + " for " + memberBlock.getAddress() + " retransmitted within " + l + " milliseconds.  Data rate " + tRAMDataPacket.getDataRate());
            }
            return;
        }
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Retransmitting packet " + n + " for " + memberBlock.getAddress() + " next seq " + this.tramblk.getLastKnownSequenceNumber());
        }
        tRAMDataPacket.setAddress(this.tp.getAddress());
        tRAMDataPacket.setPort(this.tp.getPort());
        tRAMDataPacket.setSubType(2);
        tRAMDataPacket.setTransmitPending(true);
        try {
            this.tramblk.getPacketDb().putPacket(tRAMDataPacket, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            tRAMDataPacket.setTransmitPending(false);
        }
    }

    public boolean isHeadTaskDone() {
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, " Members = " + this.gblk.getDirectMemberCount() + " dataEnd = " + this.dataEnd);
        }
        return this.gblk.getDirectMemberCount() == 0 && this.dataEnd;
    }

    public void waitToComplete() {
        while (!this.isHeadTaskDone()) {
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, "Waiting for Head to complete");
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void receiveBeaconPacket(BeaconPacketEvent beaconPacketEvent) {
        BeaconPacket beaconPacket = beaconPacketEvent.getPacket();
        byte by = (byte)beaconPacket.getFlags();
        if ((by & 2) != 0) {
            this.dataEnd = true;
        }
    }

    private void dealWithCongestion(MemberBlock memberBlock, TRAMAckPacket tRAMAckPacket) {
        TRAMMemberAck tRAMMemberAck;
        TRAMRateAdjuster tRAMRateAdjuster = this.tramblk.getRateAdjuster();
        int n = (int)tRAMAckPacket.getBasePacketNumber() / this.tp.getAckWindow();
        if (n <= this.lastWindow) {
            return;
        }
        this.lastWindow = n;
        if (this.logger.requiresLogging(16)) {
            this.logger.putPacketln(this, "congestion!  window " + n + ", " + tRAMAckPacket.getAddress() + ", groupFlowControlInfo " + tRAMRateAdjuster.getGroupFlowControlInfo() + ", packet flow " + tRAMAckPacket.getFlowControlInfo() + ", data rate " + tRAMRateAdjuster.getOpenWindowDataRate());
        }
        if (tRAMRateAdjuster.getOpenWindowDataRate() <= this.tp.getMinDataRate()) {
            if (this.tp.decentralizedPruning()) {
                if (this.logger.requiresLogging(16)) {
                    this.logger.putPacketln(this, "Member " + tRAMAckPacket.getAddress() + " sent congestion message.  " + "Sender at min rate." + " Average Rate " + tRAMRateAdjuster.getAverageDataRate() + " threshold " + (this.tp.getMinDataRate() + (this.tp.getMaxDataRate() - this.tp.getMinDataRate()) / 4L));
                }
                if (tRAMRateAdjuster.getAverageDataRate() < this.tp.getMinDataRate()) {
                    if (this.logger.requiresLogging(16)) {
                        this.logger.putPacketln(this, "Member " + tRAMAckPacket.getAddress() + " PRUNED because\n" + "\t\tit sent " + " a congestion message while sender is " + "sending at the minimum data rate!");
                    }
                    if ((tRAMAckPacket.getFlags() & 0x10) == 0 && memberBlock != null) {
                        if (this.logger.requiresLogging(16)) {
                            this.logger.putPacketln(this, "pruneMember!!! " + memberBlock.getAddress() + " Decentralized pruning was used");
                        }
                        this.tramblk.getGroupMgmtThread().handleMemberLoss(memberBlock);
                    }
                }
            } else if (tRAMRateAdjuster.getAverageDataRate() < this.tp.getMinDataRate() && (tRAMAckPacket.getFlags() & 0x10) == 0 && this.logger.requiresLogging(16)) {
                this.logger.putPacketln(this, "Member " + tRAMAckPacket.getAddress() + " would be pruned if decentralizedPruning " + " were enabled");
            }
        }
        if ((tRAMMemberAck = this.tramblk.getMemberAck()) == null) {
            tRAMRateAdjuster.congestion(tRAMAckPacket.getAddress());
        } else {
            tRAMMemberAck.sendAck((byte)8, this.gblk.getHeadBlock(), 11);
        }
    }
}

