/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMPacket;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import com.sun.multicast.util.Util;
import java.net.DatagramPacket;
import java.net.InetAddress;

class TRAMHbPacket
extends TRAMPacket {
    public static final byte FLAGBIT_V6ADDRESS = -128;
    private static final short TTL = 0;
    private static final short MROLE = 1;
    private static final short DIR_MEM = 2;
    private static final short INDIR_MEM = 4;
    private static final short SOURCE_ADDR = 6;
    private static final short HBDATA = 10;
    private byte ttl = 0;
    private byte mrole = 0;
    private InetAddress dataSrcAddress = null;
    private short directMemberCount = 0;
    private short indirectMemberCount = 0;

    public TRAMHbPacket(DatagramPacket datagramPacket) {
        super(datagramPacket);
        this.ttl = super.readByte(0);
        this.mrole = (byte)(super.readByte(1) >>> 4 & 0xF);
        int n = super.readInt(6);
        this.dataSrcAddress = Util.intToInetAddress(n);
        this.directMemberCount = super.readShort(2);
        this.indirectMemberCount = super.readShort(4);
    }

    public TRAMHbPacket(TRAMControlBlock tRAMControlBlock, byte by) {
        super(10, tRAMControlBlock.getSessionId());
        this.setMessageType(3);
        this.setSubType(5);
        this.mrole = tRAMControlBlock.getTransportProfile().getMrole();
        TRAMTransportProfile tRAMTransportProfile = tRAMControlBlock.getTransportProfile();
        this.dataSrcAddress = tRAMTransportProfile.getDataSourceAddress();
        this.ttl = by;
        this.directMemberCount = (short)tRAMControlBlock.getGroupMgmtBlk().getDirectMemberCount();
        this.indirectMemberCount = (short)tRAMControlBlock.getGroupMgmtBlk().getIndirectMemberCount();
    }

    public DatagramPacket createDatagramPacket() {
        super.writeByte(this.ttl, 0);
        short s = (short)(this.mrole << 4);
        s = (short)(s & 0xF0);
        super.writeByte((byte)s, 1);
        super.writeInt(Util.InetAddressToInt(this.dataSrcAddress), 6);
        super.writeShort(this.directMemberCount, 2);
        super.writeShort(this.indirectMemberCount, 4);
        return super.createDatagramPacket();
    }

    public byte getTTL() {
        return this.ttl;
    }

    public void setTTL(byte by) {
        this.ttl = by;
    }

    public byte getMrole() {
        return this.mrole;
    }

    public void setMrole(byte by) {
        this.mrole = by;
    }

    public InetAddress getDataSrcAddress() {
        return this.dataSrcAddress;
    }

    public void setDataSrcAddress(InetAddress inetAddress) {
        this.dataSrcAddress = inetAddress;
    }

    public short getDirectMemberCount() {
        return this.directMemberCount;
    }

    public void setDirectMemberCount(short s) {
        this.directMemberCount = s;
    }

    public short getIndirectMemberCount() {
        return this.indirectMemberCount;
    }

    public void setIndirectMemberCount(short s) {
        this.indirectMemberCount = s;
    }
}

