/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMPacket;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import com.sun.multicast.util.Util;
import java.net.DatagramPacket;
import java.net.InetAddress;

class TRAMHaPacket
extends TRAMPacket {
    public static final byte FLAGBIT_ELECT_LAN_HEAD = 1;
    public static final byte FLAGBIT_V6ADDRESS = -128;
    private static final short TTL = 0;
    private static final short HSTATE = 1;
    private static final short MROLE = 1;
    private static final short RXLEVEL = 2;
    private static final short LSTATE = 3;
    private static final short UCAST_PORT = 4;
    private static final short DIR_MEM = 6;
    private static final short CAPACITY = 8;
    private static final short SOURCE_ADDR = 10;
    private static final short HADATA = 14;
    private byte ttl = 0;
    private byte hstate = 0;
    private byte mRole = 0;
    private InetAddress dataSrcAddress = null;
    private byte rxLevel = 0;
    private byte lstate = 0;
    private short unicastPort = 0;
    private short directMemberCount = 0;
    private short capacity = 0;

    public TRAMHaPacket(DatagramPacket datagramPacket) {
        super(datagramPacket);
        this.ttl = super.readByte(0);
        this.hstate = (byte)(super.readByte(1) >>> 4 & 0xF);
        this.mRole = (byte)(super.readByte(1) & 0xF);
        this.rxLevel = super.readByte(2);
        this.lstate = super.readByte(3);
        int n = super.readInt(10);
        this.dataSrcAddress = Util.intToInetAddress(n);
        this.unicastPort = super.readShort(4);
        this.directMemberCount = super.readShort(6);
        this.capacity = super.readShort(8);
    }

    public TRAMHaPacket(TRAMControlBlock tRAMControlBlock, byte by, boolean bl) {
        super(14, tRAMControlBlock.getSessionId());
        this.setMessageType(1);
        this.setSubType(3);
        this.hstate = tRAMControlBlock.getGroupMgmtBlk().getHstate();
        this.mRole = tRAMControlBlock.getTransportProfile().getMrole();
        if (by == 1) {
            this.lstate = tRAMControlBlock.getGroupMgmtBlk().getLstate();
        }
        this.rxLevel = (byte)tRAMControlBlock.getGroupMgmtBlk().getRxLevel();
        TRAMTransportProfile tRAMTransportProfile = tRAMControlBlock.getTransportProfile();
        this.unicastPort = (short)tRAMControlBlock.getUnicastPort();
        this.setAddress(tRAMTransportProfile.getAddress());
        this.setPort(tRAMTransportProfile.getPort());
        this.dataSrcAddress = tRAMTransportProfile.getDataSourceAddress();
        this.ttl = by;
        this.directMemberCount = (short)tRAMControlBlock.getGroupMgmtBlk().getDirectMemberCount();
        this.capacity = tRAMTransportProfile.getMaxMembers();
        if (bl) {
            this.setFlags((byte)1);
        }
    }

    public DatagramPacket createDatagramPacket() {
        super.writeByte(this.ttl, 0);
        short s = (short)(this.hstate << 4);
        s = (short)(s | (short)this.mRole);
        super.writeByte((byte)s, 1);
        super.writeByte(this.rxLevel, 2);
        super.writeByte(this.lstate, 3);
        super.writeShort(this.unicastPort, 4);
        super.writeInt(Util.InetAddressToInt(this.dataSrcAddress), 10);
        super.writeShort(this.directMemberCount, 6);
        super.writeShort(this.capacity, 8);
        return super.createDatagramPacket();
    }

    public byte getTTL() {
        return this.ttl;
    }

    public void setTTL(byte by) {
        this.ttl = by;
    }

    public byte getHstate() {
        return this.hstate;
    }

    public void setHstate(byte by) {
        this.hstate = by;
    }

    public byte getMrole() {
        return this.mRole;
    }

    public void setMrole(byte by) {
        this.mRole = by;
    }

    public byte getLstate() {
        return this.lstate;
    }

    public void setLstate(byte by) {
        this.lstate = by;
    }

    public InetAddress getDataSrcAddress() {
        return this.dataSrcAddress;
    }

    public void setDataSrcAddress(InetAddress inetAddress) {
        this.dataSrcAddress = inetAddress;
    }

    public byte getRxLevel() {
        return this.rxLevel;
    }

    public void setRxLevel(byte by) {
        this.rxLevel = by;
    }

    public int getUnicastPort() {
        return this.unicastPort & 0xFFFF;
    }

    public void setUnicastPort(int n) {
        this.unicastPort = (short)n;
    }

    public short getDirectMemberCount() {
        return this.directMemberCount;
    }

    public void setDirectMemberCount(short s) {
        this.directMemberCount = s;
    }

    public short getCapacity() {
        return this.capacity;
    }

    public void setCapacity(short s) {
        this.capacity = s;
    }
}

