/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.BeaconPacket;
import com.sun.multicast.reliable.transport.tram.BeaconPacketEvent;
import com.sun.multicast.reliable.transport.tram.GroupMgmtBlk;
import com.sun.multicast.reliable.transport.tram.HeadBlock;
import com.sun.multicast.reliable.transport.tram.MemberBlock;
import com.sun.multicast.reliable.transport.tram.OrderedPacketHandler;
import com.sun.multicast.reliable.transport.tram.PacketDbIOManager;
import com.sun.multicast.reliable.transport.tram.TRAMCacheControl;
import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMDataCache;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacket;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMLogger;
import com.sun.multicast.reliable.transport.tram.TRAMMembershipEvent;
import com.sun.multicast.reliable.transport.tram.TRAMMembershipListener;
import com.sun.multicast.reliable.transport.tram.TRAMPacket;
import com.sun.multicast.reliable.transport.tram.TRAMPacketHandler;
import com.sun.multicast.reliable.transport.tram.TRAMSeqNumber;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import com.sun.multicast.reliable.transport.tram.TRAMVector;
import com.sun.multicast.reliable.transport.tram.UnorderedPacketHandler;
import java.util.NoSuchElementException;
import java.util.Vector;

class TRAMGenericDataCache
implements TRAMDataCache,
TRAMMembershipListener {
    public int cacheSize;
    public int lowWaterMark;
    public int highWaterMark;
    public int defaultHighWaterMark;
    private TRAMVector dataCache = new TRAMVector();
    private TRAMControlBlock tramblk;
    private TRAMTransportProfile tp;
    private TRAMSeqNumber nextPacket;
    private TRAMLogger logger;
    private Vector dataPacketListeners;
    private boolean dataEnd = false;
    private boolean lastPacketReceived = false;
    private int lastSequenceNumber;
    private TRAMPacketHandler packetHandler;
    private boolean init = false;
    private Vector holdingTank;
    private int lowestKnownMissingPacket = 1;

    public TRAMGenericDataCache(TRAMControlBlock tRAMControlBlock) {
        this.tramblk = tRAMControlBlock;
        this.tp = tRAMControlBlock.getTransportProfile();
        this.cacheSize = this.tp.getCacheSize();
        this.lowWaterMark = this.cacheSize / 3;
        this.highWaterMark = this.defaultHighWaterMark = this.cacheSize * 2 / 3;
        this.logger = tRAMControlBlock.getLogger();
        this.packetHandler = this.tp.isOrdered() ? new OrderedPacketHandler(tRAMControlBlock, this, 1) : new UnorderedPacketHandler(tRAMControlBlock, this, 1);
        byte by = tRAMControlBlock.getTransportProfile().getTmode();
        if (by != 1) {
            this.init = true;
            this.holdingTank = null;
            switch (this.tp.getLateJoinPreference()) {
                case 1: 
                case 2: {
                    if (this.logger.requiresLogging(263)) {
                        this.logger.putPacketln(this, "Creating holding tank");
                    }
                    this.holdingTank = new Vector();
                    break;
                }
                case 3: {
                    if (!this.logger.requiresLogging(263)) break;
                    this.logger.putPacketln(this, "No holding tank necessary");
                    break;
                }
                default: {
                    if (!this.logger.requiresLogging(3)) break;
                    this.logger.putPacketln(this, "The Late Join Preference is Invalid!");
                }
            }
        }
        this.tramblk.getInputDispThread().addTRAMDataPacketListener(this);
        this.tramblk.getInputDispThread().addBeaconPacketListener(this);
        this.tramblk.getGroupMgmtThread().addTRAMMembershipListener(this);
        this.nextPacket = new TRAMSeqNumber();
        this.dataPacketListeners = new Vector();
    }

    public TRAMPacket getPacket() {
        return null;
    }

    public TRAMPacket getPacketWithNoBlocking() throws NoSuchElementException {
        throw new NoSuchElementException("Unsupported Method");
    }

    public TRAMDataPacket getPacket(long l) throws NoSuchElementException {
        TRAMCacheControl tRAMCacheControl = this.getControlPacket((int)l);
        TRAMDataPacket tRAMDataPacket = tRAMCacheControl.getTRAMDataPacket();
        if (tRAMDataPacket != null) {
            return tRAMDataPacket;
        }
        throw new NoSuchElementException("Packet not received yet");
    }

    public void putPacket(TRAMPacket tRAMPacket) {
    }

    public void putPacket(TRAMPacket tRAMPacket, boolean bl) {
    }

    public void removePacket(long l) throws NoSuchElementException {
    }

    public int getPacketCount() {
        return this.dataCache.size();
    }

    public synchronized void receiveDataPacket(TRAMDataPacketEvent tRAMDataPacketEvent) {
        block31: {
            TRAMCacheControl tRAMCacheControl;
            if (this.init) {
                if (this.holdingTank != null) {
                    this.holdingTank.addElement(tRAMDataPacketEvent);
                    if (this.logger.requiresLogging(263)) {
                        this.logger.putPacketln(this, "Loading another packet into the holding tank");
                    }
                }
                return;
            }
            TRAMDataPacket tRAMDataPacket = tRAMDataPacketEvent.getPacket();
            int n = tRAMDataPacket.getSequenceNumber();
            if (this.tramblk.isCacheFull() && this.tramblk.getGroupMgmtBlk().getHeadBlock() == null) {
                try {
                    TRAMCacheControl tRAMCacheControl2 = (TRAMCacheControl)this.dataCache.elementAt(0);
                    if (tRAMCacheControl2.getTRAMDataPacket() == null) {
                        if (this.logger.requiresLogging(3)) {
                            this.logger.putPacketln(this, "Cache full and I have no head.  Dropping packet " + n);
                        }
                        return;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, "Packet " + n + " from " + tRAMDataPacket.getSourceAddress() + "(expected " + this.nextPacket.getSeqNumber() + ")");
            }
            while (this.nextPacket.isLessThan(n)) {
                if (this.logger.requiresLogging(3)) {
                    this.logger.putPacketln(this, "Creating cache control for missing packet " + this.nextPacket.getSeqNumber());
                }
                tRAMCacheControl = new TRAMCacheControl(this.nextPacket.getSeqNumber());
                byte by = this.tramblk.getTransportProfile().getTmode();
                if (by == 1) {
                    tRAMCacheControl.indicatePacketDeliveredToApplication();
                }
                this.dataCache.addElement(tRAMCacheControl);
                this.nextPacket.incrSeqNumber();
            }
            if (this.nextPacket.isEqualTo(n)) {
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "Cache EXPECTED Data packet " + n + " from " + tRAMDataPacket.getSourceAddress());
                }
                tRAMCacheControl = new TRAMCacheControl(tRAMDataPacket);
                byte by = this.tramblk.getTransportProfile().getTmode();
                if (by == 1) {
                    tRAMCacheControl.indicatePacketDeliveredToApplication();
                }
                this.dataCache.addElement(tRAMCacheControl);
                this.nextPacket.incrSeqNumber();
                this.packetHandler.newPacket(tRAMDataPacket);
                this.updateLowestKnownMissingPacketNumber();
            } else if (this.nextPacket.isGreaterThan(n)) {
                try {
                    TRAMDataPacket tRAMDataPacket2;
                    TRAMCacheControl tRAMCacheControl3 = this.getControlPacket(n);
                    if (this.logger.requiresLogging(3)) {
                        this.logger.putPacketln(this, "Out-of-sequence packet " + n);
                    }
                    if ((tRAMDataPacket2 = tRAMCacheControl3.getTRAMDataPacket()) == null || (tRAMDataPacket2.getFlags() & 0x10) != 0) {
                        tRAMCacheControl3.setTRAMDataPacket(tRAMDataPacket);
                        this.packetHandler.newPacket(tRAMDataPacket);
                        if (this.logger.requiresLogging(3)) {
                            this.logger.putPacketln(this, "Cache MISSING Data packet " + n + " (expected " + this.nextPacket.getSeqNumber() + ")" + " from " + tRAMDataPacket.getSourceAddress());
                        }
                        this.updateLowestKnownMissingPacketNumber();
                    } else if (this.logger.requiresLogging(3)) {
                        this.logger.putPacketln(this, "Out-of-sequence packet " + n + " is already in the cache.  flags " + tRAMDataPacket2.getFlags());
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (!this.logger.requiresLogging(3)) break block31;
                    this.logger.putPacketln(this, "Out-of-sequence packet " + n + ".  There is no TRAMCacheControl for this sequence!  " + "Why not?");
                }
            }
        }
        if (this.dataCache.size() >= this.highWaterMark) {
            int n = this.purgeCache(this.lowWaterMark);
            if (n >= this.highWaterMark) {
                if (this.findAndRemoveBadMembers()) {
                    n = this.purgeCache(this.lowWaterMark);
                }
                if (n >= this.highWaterMark) {
                    this.highWaterMark += this.tramblk.getTransportProfile().getAckWindow();
                    if (this.logger.requiresLogging(279)) {
                        this.logger.putPacketln(this, "cacheSize " + this.cacheSize + ", lowWaterMark " + this.lowWaterMark + ", highWaterMark " + this.highWaterMark);
                        this.logger.putPacketln(this, "Increasing cache high water mark to " + this.highWaterMark);
                    }
                    if (this.logger.requiresLogging(1023)) {
                        this.logger.putPacketln(this, "Congestion!  New high water mark is " + this.highWaterMark);
                    }
                }
            }
            if (n < this.defaultHighWaterMark) {
                this.highWaterMark = this.defaultHighWaterMark;
            }
        }
    }

    private synchronized void updateLowestKnownMissingPacketNumber() {
        if (this.nextPacket.isEqualTo(this.lowestKnownMissingPacket)) {
            return;
        }
        if (this.nextPacket.isGreaterThan(this.lowestKnownMissingPacket)) {
            int n = this.lowestKnownMissingPacket;
            while (this.nextPacket.isGreaterThan(n)) {
                block8: {
                    TRAMCacheControl tRAMCacheControl;
                    try {
                        tRAMCacheControl = this.getControlPacket(n);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        this.lowestKnownMissingPacket = n + 1;
                        break block8;
                    }
                    if (tRAMCacheControl.getTRAMDataPacket() == null) {
                        this.lowestKnownMissingPacket = n;
                        return;
                    }
                }
                ++n;
            }
            this.lowestKnownMissingPacket = this.nextPacket.getSeqNumber();
        } else {
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, "lowestKnownMissingPacket seqNumber is > nextPkt to receive!! lowest is " + this.lowestKnownMissingPacket + " Next to receive is " + this.nextPacket.getSeqNumber());
            }
            this.lowestKnownMissingPacket = this.nextPacket.getSeqNumber();
        }
    }

    private synchronized int getLowestKnownMissingPacketNumber() {
        return this.lowestKnownMissingPacket;
    }

    private boolean findAndRemoveBadMembers() {
        int n = this.getLowestSequenceNumber();
        GroupMgmtBlk groupMgmtBlk = this.tramblk.getGroupMgmtBlk();
        MemberBlock memberBlock = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < groupMgmtBlk.getDirectMemberCount()) {
            block8: {
                try {
                    MemberBlock memberBlock2 = groupMgmtBlk.getMember(n3);
                    if (memberBlock2.getLastPacketAcked() >= n) break block8;
                    if (memberBlock != null) {
                        if (memberBlock.getLastPacketAcked() < memberBlock2.getLastPacketAcked()) {
                            memberBlock = memberBlock2;
                            n2 = n3;
                        }
                    } else {
                        memberBlock = memberBlock2;
                        n2 = n3;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    break;
                }
            }
            ++n3;
        }
        if (memberBlock != null) {
            this.tramblk.getGroupMgmtThread().handleMemberLoss(memberBlock);
            this.tramblk.getTRAMStats().addPrunedMembers();
            if (this.logger.requiresLogging(279)) {
                this.logger.putPacketln(this, "Cache is above high water mark of " + this.highWaterMark + ".  Disown member " + memberBlock.getAddress());
            }
            return true;
        }
        return false;
    }

    public synchronized void markUnrecoverablePkts(int n) {
        TRAMSeqNumber tRAMSeqNumber = new TRAMSeqNumber(n);
        int n2 = this.getLowestKnownMissingPacketNumber();
        if (tRAMSeqNumber.isLessThanOrEqual(n2)) {
            return;
        }
        if (this.logger.requiresLogging(263)) {
            this.logger.putPacketln(this, "marking any missing packets from lowest missing  pkt # " + n + " as unrecoverable. Lowest Pkt in cache is " + this.getLowestSequenceNumber());
        }
        this.markUnrecoverablePackets(n2, n);
        if (this.nextPacket.isLessThan(n)) {
            this.nextPacket.setSeqNumber(n);
        }
        this.updateLowestKnownMissingPacketNumber();
    }

    private synchronized void markUnrecoverablePackets(int n, int n2) {
        TRAMDataPacket tRAMDataPacket = null;
        TRAMSeqNumber tRAMSeqNumber = new TRAMSeqNumber(n);
        while (tRAMSeqNumber.isLessThan(n2)) {
            TRAMCacheControl tRAMCacheControl;
            try {
                tRAMCacheControl = this.getControlPacket(tRAMSeqNumber.getSeqNumber());
            }
            catch (NoSuchElementException noSuchElementException) {
                if (this.logger.requiresLogging(263)) {
                    this.logger.putPacketln(this, "Adding a control block entry for pkt " + tRAMSeqNumber.getSeqNumber());
                }
                tRAMCacheControl = new TRAMCacheControl(tRAMSeqNumber.getSeqNumber());
                byte by = this.tramblk.getTransportProfile().getTmode();
                if (by == 1) {
                    tRAMCacheControl.indicatePacketDeliveredToApplication();
                }
                this.dataCache.addElement(tRAMCacheControl);
            }
            if (tRAMCacheControl.getTRAMDataPacket() == null) {
                tRAMDataPacket = new TRAMDataPacket(this.tramblk);
                tRAMDataPacket.setSequenceNumber(tRAMSeqNumber.getSeqNumber());
                tRAMDataPacket.setFlags((byte)16);
                tRAMCacheControl.setTRAMDataPacket(tRAMDataPacket);
                this.packetHandler.newPacket(tRAMDataPacket);
                if (this.logger.requiresLogging(263)) {
                    this.logger.putPacketln(this, "Marked pkt as Unrecoverable - Seq # " + tRAMSeqNumber.getSeqNumber());
                }
            }
            tRAMSeqNumber.incrSeqNumber();
        }
    }

    public synchronized void handleSessionDown() {
        if (!this.dataEnd) {
            this.packetHandler.reportException((byte)32);
        } else if (this.logger.requiresLogging(135)) {
            this.logger.putPacketln(this, "Ignoring SessionDown as the DataEnd has been Signalled");
        }
    }

    public synchronized void handlePrunedMember() {
        if (!this.dataEnd) {
            this.packetHandler.reportException((byte)64);
        } else if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Ignoring Member pruned as the DataEnd has been Signalled");
        }
    }

    private synchronized TRAMCacheControl getControlPacket(int n) throws NoSuchElementException {
        int n2;
        TRAMCacheControl tRAMCacheControl = (TRAMCacheControl)this.dataCache.firstElement();
        TRAMSeqNumber tRAMSeqNumber = tRAMCacheControl.getTRAMSeqNumber();
        if (tRAMSeqNumber.isLessThanOrEqual(n)) {
            n2 = Math.abs(n - tRAMSeqNumber.getSeqNumber());
            if (n2 >= this.dataCache.size()) {
                throw new NoSuchElementException("Requested packet beyond end of cache " + this.dataCache.size());
            }
        } else {
            throw new NoSuchElementException("Requested packet " + tRAMSeqNumber.getSeqNumber() + " already purged from cache " + this.dataCache.size());
        }
        tRAMCacheControl = (TRAMCacheControl)this.dataCache.elementAt(n2);
        if (tRAMCacheControl.getSequenceNumber() == n) {
            return tRAMCacheControl;
        }
        if (this.logger.requiresLogging(259)) {
            this.logger.putPacketln(this, "Control packet error. Looking for " + n + " and found " + tRAMCacheControl.getSequenceNumber() + " Index was " + n2);
        }
        if (this.logger.requiresLogging(263)) {
            this.logger.putPacketln(this, "First Element = " + ((TRAMCacheControl)this.dataCache.firstElement()).getSequenceNumber() + " Last Element = " + ((TRAMCacheControl)this.dataCache.lastElement()).getSequenceNumber());
        }
        throw new NoSuchElementException("Data Cache is corrupted " + n);
    }

    public void printDataCounts() {
        if (this.logger.requiresLogging(263)) {
            this.logger.putPacketln(this, "Data Cache contains " + this.dataCache.size() + " elements");
        }
    }

    public void addTRAMDataPacketListener(TRAMDataPacketListener tRAMDataPacketListener) {
        this.dataPacketListeners.addElement(tRAMDataPacketListener);
    }

    public synchronized void notifyTRAMDataPacketEvent(TRAMDataPacket tRAMDataPacket) {
        block6: {
            int n = 0;
            while (n < this.dataPacketListeners.size()) {
                TRAMDataPacketListener tRAMDataPacketListener = (TRAMDataPacketListener)this.dataPacketListeners.elementAt(n);
                tRAMDataPacketListener.receiveDataPacket(new TRAMDataPacketEvent(this, tRAMDataPacket));
                ++n;
            }
            try {
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "notifyTRAMDataPacketEvent:  seq " + tRAMDataPacket.getSequenceNumber());
                }
                TRAMCacheControl tRAMCacheControl = this.getControlPacket(tRAMDataPacket.getSequenceNumber());
                tRAMCacheControl.indicatePacketDeliveredToApplication();
            }
            catch (NoSuchElementException noSuchElementException) {
                if (!this.logger.requiresLogging(7)) break block6;
                this.logger.putPacketln(this, "notifyTRAMDataPacketEvent:  no such element for seq " + tRAMDataPacket.getSequenceNumber());
            }
        }
        if (this.dataEnd) {
            if (tRAMDataPacket.getSequenceNumber() >= this.lastSequenceNumber) {
                this.lastPacketReceived = true;
            }
            this.purgeCache(0);
        }
    }

    public synchronized int notifyInSequenceTRAMDataPacketEvents(TRAMDataPacket tRAMDataPacket) throws NoSuchElementException {
        TRAMCacheControl tRAMCacheControl = null;
        if ((tRAMDataPacket.getFlags() & 0x60) != 0) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Session down or member pruned.  Notify in sequence packet");
            }
            int n = 0;
            while (n < this.dataPacketListeners.size()) {
                TRAMDataPacketListener tRAMDataPacketListener = (TRAMDataPacketListener)this.dataPacketListeners.elementAt(n);
                tRAMDataPacketListener.receiveDataPacket(new TRAMDataPacketEvent(this, tRAMDataPacket));
                ++n;
            }
        } else {
            int n = this.getControlPacketIndex(tRAMDataPacket.getSequenceNumber());
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Notify in seq, pk seq " + tRAMDataPacket.getSequenceNumber() + " start ix " + n + " cache size " + this.dataCache.size());
            }
            int n2 = 0;
            while (n2 < this.dataPacketListeners.size()) {
                TRAMDataPacketListener tRAMDataPacketListener = (TRAMDataPacketListener)this.dataPacketListeners.elementAt(n2);
                int n3 = n;
                while (n3 < this.dataCache.size()) {
                    TRAMCacheControl tRAMCacheControl2 = (TRAMCacheControl)this.dataCache.elementAt(n3);
                    tRAMDataPacket = tRAMCacheControl2.getTRAMDataPacket();
                    if (tRAMDataPacket != null) {
                        tRAMDataPacketListener.receiveDataPacket(new TRAMDataPacketEvent(this, tRAMDataPacket));
                        tRAMCacheControl2.indicatePacketDeliveredToApplication();
                        if (this.logger.requiresLogging(7)) {
                            this.logger.putPacketln(this, "notifyInSequenceTRAMDataPacketEvents: seq " + tRAMDataPacket.getSequenceNumber());
                        }
                    } else {
                        if (this.logger.requiresLogging(7)) {
                            this.logger.putPacketln(this, "Stopping at index " + n3);
                        }
                        tRAMCacheControl = tRAMCacheControl2;
                        break;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        if (this.dataEnd) {
            if (this.nextPacket.isGreaterThan(this.lastSequenceNumber)) {
                this.lastPacketReceived = true;
            }
            this.purgeCache(0);
        }
        if (tRAMCacheControl == null) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "return next packet " + this.nextPacket.getSeqNumber());
            }
            return this.nextPacket.getSeqNumber();
        }
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "return last packet " + tRAMCacheControl.getSequenceNumber() + " next packet is " + this.nextPacket.getSeqNumber());
        }
        return tRAMCacheControl.getSequenceNumber();
    }

    private synchronized int getControlPacketIndex(int n) throws NoSuchElementException {
        TRAMCacheControl tRAMCacheControl = (TRAMCacheControl)this.dataCache.firstElement();
        TRAMSeqNumber tRAMSeqNumber = tRAMCacheControl.getTRAMSeqNumber();
        int n2 = Math.abs(n - tRAMSeqNumber.getSeqNumber());
        if (n2 >= this.dataCache.size()) {
            throw new NoSuchElementException();
        }
        try {
            tRAMCacheControl = (TRAMCacheControl)this.dataCache.elementAt(n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            TRAMCacheControl tRAMCacheControl2 = (TRAMCacheControl)this.dataCache.firstElement();
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, "Index computation error. Index is " + n2 + "Control Number is " + tRAMSeqNumber.getSeqNumber() + "Seq number is " + n + "First element is " + tRAMCacheControl2.getTRAMSeqNumber().getSeqNumber());
            }
            throw new NoSuchElementException();
        }
        if (tRAMCacheControl.getSequenceNumber() == n) {
            return n2;
        }
        if (this.logger.requiresLogging(259)) {
            this.logger.putPacketln(this, "Control packet error. Looking for " + n + " and found " + tRAMCacheControl.getSequenceNumber() + " Index was " + n2);
        }
        if (this.logger.requiresLogging(263)) {
            this.logger.putPacketln(this, "First Element = " + ((TRAMCacheControl)this.dataCache.firstElement()).getSequenceNumber() + " Last Element = " + ((TRAMCacheControl)this.dataCache.lastElement()).getSequenceNumber());
        }
        throw new NoSuchElementException("Data Cache is corrupted " + n);
    }

    public void receiveBeaconPacket(BeaconPacketEvent beaconPacketEvent) {
        BeaconPacket beaconPacket;
        byte by;
        if (!this.dataEnd && ((by = (byte)(beaconPacket = beaconPacketEvent.getPacket()).getFlags()) & 2) != 0) {
            if (this.logger.requiresLogging(387)) {
                this.logger.putPacketln(this, "Got a DATA END beacon packet last pkt is " + beaconPacket.getSeqNumber());
            }
            this.dataEnd = true;
            this.lastSequenceNumber = beaconPacket.getSeqNumber();
            if (this.nextPacket.isGreaterThan(this.lastSequenceNumber)) {
                if (this.logger.requiresLogging(387)) {
                    this.logger.putPacketln(this, "...and the LAST Packet was received");
                }
                this.lastPacketReceived = true;
            }
            this.purgeCache(0);
        }
    }

    public synchronized int purgeCache(int n) {
        if (n < 0) {
            n = this.lowWaterMark;
        }
        if (this.dataCache.size() > n) {
            Object object;
            int n2;
            if (this.tramblk.getGroupMgmtBlk().getDirectMemberCount() != 0) {
                n2 = this.tramblk.getGroupMgmtBlk().getLowestPacketAcked();
                ++n2;
                if (this.logger.requiresLogging(275)) {
                    this.logger.putPacketln(this, "Head purging its cache from " + this.dataCache.size() + " to " + n + " packets.  " + "Stop packet " + n2);
                }
            } else {
                n2 = this.nextPacket.getSeqNumber();
                if (this.logger.requiresLogging(275)) {
                    this.logger.putPacketln(this, "Member purging its cache from " + this.dataCache.size() + " to " + n + " packets.  " + "Stop packet " + n2);
                }
            }
            int n3 = 0;
            int n4 = this.dataCache.size();
            while (n4 - n3 > n) {
                try {
                    object = (TRAMCacheControl)this.dataCache.elementAt(n3);
                    if (((TRAMCacheControl)object).getSequenceNumber() >= n2 || !((TRAMCacheControl)object).isPacketDeliveredToApplication()) {
                        if (!this.logger.requiresLogging(275)) break;
                        this.logger.putPacketln(this, "hit a wall at " + ((TRAMCacheControl)object).getSequenceNumber() + " stopPacket = " + n2);
                        if (((TRAMCacheControl)object).getTRAMDataPacket() == null) {
                            this.logger.putPacketln(this, " cache control packet is null");
                            break;
                        }
                        this.logger.putPacketln(this, " delivered to app is " + ((TRAMCacheControl)object).isPacketDeliveredToApplication());
                        break;
                    }
                    ++n3;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
            }
            if (n3 != 0) {
                this.dataCache.rmRange(0, n3);
            }
            if (this.logger.requiresLogging(263)) {
                this.logger.putPacketln(this, "Purged cache size = " + this.dataCache.size());
                this.logger.putPacketln(this, "LastPacketReceived = " + this.lastPacketReceived + " " + this.lastSequenceNumber);
            }
            if (this.dataCache.size() == 0 && this.lastPacketReceived) {
                if (this.logger.requiresLogging(263)) {
                    this.logger.putPacketln(this, "Sending the null data end packet");
                }
                object = new TRAMDataPacket(this.tramblk);
                ((TRAMPacket)object).setFlags((byte)2);
                this.notifyTRAMDataPacketEvent((TRAMDataPacket)object);
            }
            if (this.logger.requiresLogging(275)) {
                this.logger.putPacketln(this, "Done with cache purge...");
            }
        }
        if (this.dataCache.size() >= this.cacheSize) {
            if (this.logger.requiresLogging(275)) {
                this.logger.putPacketln(this, "Cache Full!  " + this.dataCache.size() + " packets");
            }
            this.tramblk.setCacheFull(true);
        } else if (this.tramblk.isCacheFull()) {
            if (this.logger.requiresLogging(275)) {
                this.logger.putPacketln(this, "Cache no longer full.  " + this.dataCache.size() + " packets");
            }
            PacketDbIOManager packetDbIOManager = (PacketDbIOManager)this.tramblk.getPacketDb();
            this.tramblk.setCacheFull(false);
            packetDbIOManager.wake();
        }
        return this.dataCache.size();
    }

    public synchronized int getLowestSequenceNumber() {
        try {
            return ((TRAMCacheControl)this.dataCache.firstElement()).getSequenceNumber();
        }
        catch (NoSuchElementException noSuchElementException) {
            return this.nextPacket.getSeqNumber();
        }
    }

    public synchronized int getHighestSequenceNumber() {
        int n = this.nextPacket.getSeqNumber();
        return --n;
    }

    public synchronized int getHighestSequenceNumberinCache() {
        try {
            return ((TRAMCacheControl)this.dataCache.lastElement()).getSequenceNumber();
        }
        catch (NoSuchElementException noSuchElementException) {
            return this.nextPacket.getSeqNumber();
        }
    }

    public synchronized void receiveTRAMMembership(TRAMMembershipEvent tRAMMembershipEvent) {
        block22: {
            HeadBlock headBlock;
            block21: {
                if (this.logger.requiresLogging(3)) {
                    this.logger.putPacketln(this, "Received membership notification.");
                }
                headBlock = this.tramblk.getGroupMgmtBlk().getHeadBlock();
                if (!this.init) break block21;
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "The init flag is set. carry on");
                }
                this.init = false;
                switch (this.tp.getLateJoinPreference()) {
                    case 2: {
                        if (this.logger.requiresLogging(263)) {
                            this.logger.putPacketln(this, "The holding tank exists...");
                            this.logger.putPacketln(this, "Setting the starting sequence number to " + headBlock.getStartSeqNumber());
                            this.logger.putPacketln(this, "Replaying the " + this.holdingTank.size() + " packets in the holdingTank");
                        }
                        int n = 0;
                        while (n < this.holdingTank.size()) {
                            this.receiveDataPacket((TRAMDataPacketEvent)this.holdingTank.elementAt(n));
                            ++n;
                        }
                        this.holdingTank = null;
                        if (this.logger.requiresLogging(263)) {
                            this.logger.putPacketln(this, "The holding tank has been deleted");
                            break;
                        }
                        break block22;
                    }
                    case 1: {
                        if (this.logger.requiresLogging(263)) {
                            this.logger.putPacketln(this, "The holding tank exists...");
                            this.logger.putPacketln(this, "Setting the starting sequence number to " + headBlock.getStartSeqNumber());
                            this.logger.putPacketln(this, "Replaying the " + this.holdingTank.size() + " packets in the holdingTank");
                        }
                        int n = headBlock.getStartSeqNumber();
                        TRAMSeqNumber tRAMSeqNumber = new TRAMSeqNumber(n);
                        this.nextPacket.setSeqNumber(n);
                        this.packetHandler.setSeqNumber(n);
                        this.lowestKnownMissingPacket = n;
                        int n2 = 0;
                        while (n2 < this.holdingTank.size()) {
                            TRAMDataPacketEvent tRAMDataPacketEvent = (TRAMDataPacketEvent)this.holdingTank.elementAt(n2);
                            n = tRAMDataPacketEvent.getPacket().getSequenceNumber();
                            if (tRAMSeqNumber.isLessThanOrEqual(n)) {
                                this.receiveDataPacket(tRAMDataPacketEvent);
                            }
                            ++n2;
                        }
                        this.holdingTank = null;
                        if (this.logger.requiresLogging(263)) {
                            this.logger.putPacketln(this, "The holding tank has been deleted");
                            break;
                        }
                        break block22;
                    }
                    case 3: {
                        if (this.logger.requiresLogging(259)) {
                            this.logger.putPacketln(this, "Setting the starting sequence number to " + headBlock.getStartSeqNumber());
                        }
                        int n = headBlock.getStartSeqNumber();
                        this.nextPacket.setSeqNumber(n);
                        this.packetHandler.setSeqNumber(n);
                        this.lowestKnownMissingPacket = n;
                        break;
                    }
                    default: {
                        this.init = true;
                        if (this.logger.requiresLogging(3)) {
                            this.logger.putPacketln(this, "Invalid Late Join Preference");
                            break;
                        }
                        break block22;
                    }
                }
                break block22;
            }
            switch (this.tp.getLateJoinPreference()) {
                case 2: {
                    this.markUnrecoverablePkts(headBlock.getStartSeqNumber());
                    break;
                }
                case 1: 
                case 3: {
                    if (this.logger.requiresLogging(259)) {
                        this.logger.putPacketln(this, "Setting the starting sequence number to " + headBlock.getStartSeqNumber());
                    }
                    this.markUnrecoverablePkts(headBlock.getStartSeqNumber());
                    break;
                }
                default: {
                    if (!this.logger.requiresLogging(259)) break;
                    this.logger.putPacketln(this, "Invalid Late Join Preference");
                }
            }
        }
        this.tramblk.getMemberAck().dataCacheProcessedMembershipEvent();
    }

    public synchronized void dealWithUnrecoverablePkts(int n) {
        TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
        switch (tRAMTransportProfile.getLateJoinPreference()) {
            case 2: {
                this.markUnrecoverablePkts(n);
                break;
            }
            case 1: 
            case 3: {
                this.markUnrecoverablePkts(n);
                break;
            }
            default: {
                if (!this.logger.requiresLogging(259)) break;
                this.logger.putPacketln(this, "Invalid Late Join Preference");
            }
        }
    }

    public int getLimitedRecoverSequenceNumber() {
        if (this.dataCache.size() == 0) {
            return 1;
        }
        int n = this.dataCache.size() - 1 - (this.defaultHighWaterMark - this.lowWaterMark);
        if (n < 0) {
            n = 0;
        }
        TRAMCacheControl tRAMCacheControl = (TRAMCacheControl)this.dataCache.elementAt(n);
        if (this.logger.requiresLogging(275)) {
            this.logger.putPacketln(this, "Starting Seq " + tRAMCacheControl.getSequenceNumber() + " Cache Size " + this.dataCache.size() + " HighWater " + this.defaultHighWaterMark + " LowWater " + this.lowWaterMark);
        }
        return tRAMCacheControl.getSequenceNumber();
    }

    public boolean aboveHighWaterMark() {
        return this.dataCache.size() > this.highWaterMark;
    }
}

