/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMPacket;
import com.sun.multicast.util.Util;
import java.net.DatagramPacket;
import java.net.InetAddress;

class TRAMDataPacket
extends TRAMPacket {
    public static final byte FLAGBIT_PRUNE = 1;
    public static final byte FLAGBIT_TXDONE = 2;
    public static final byte FLAGBIT_RESET_FLOW_CONTROL_INFO = 4;
    public static final byte FLAGBIT_UNRECOVERABLE = 16;
    public static final byte FLAGBIT_SESSION_DOWN = 32;
    public static final byte FLAGBIT_MEMBER_PRUNED = 64;
    public static final byte FLAGBIT_V6ADDRESS = -128;
    public static final int HAINTERVAL = 0;
    public static final int SEQUENCENUMBER = 2;
    public static final int FORGETBEFORESEQNUM = 6;
    public static final int DATALENGTH = 10;
    public static final int ACK_WINDOW = 12;
    public static final int RESERVED = 14;
    public static final int FLOW_CONTROL_INFO = 16;
    public static final int DATA_RATE = 20;
    public static final int SOURCEADDRESS = 24;
    public static final int PAYLOAD = 28;
    public static final int TRAMDATAHEADERLENGTH = 28;
    public static final int TRAMMAXPKT = 65469;
    private InetAddress sourceAddress;
    private int sequenceNumber = 0;
    private int forgetBeforeSeqNum = 1;
    private short haInterval = 0;
    private byte ttl = 0;
    private short dataLength = 0;
    private short ackWindow = 0;
    private int flowControlInfo = 0;
    private int dataRate = 0;

    public TRAMDataPacket(DatagramPacket datagramPacket) {
        super(datagramPacket);
        this.sequenceNumber = super.readInt(2);
        this.forgetBeforeSeqNum = super.readInt(6);
        int n = super.readInt(24);
        this.sourceAddress = Util.intToInetAddress(n);
        this.haInterval = super.readShort(0);
        this.dataLength = super.readShort(10);
        this.ackWindow = super.readShort(12);
        this.flowControlInfo = super.readInt(16);
        this.dataRate = super.readInt(20);
    }

    public TRAMDataPacket(TRAMControlBlock tRAMControlBlock, byte[] byArray, int n) {
        super(byArray, n, 28, tRAMControlBlock.getSessionId());
        this.dataLength = (short)n;
        super.writeShort(this.dataLength, 10);
        this.setMessageType(2);
        this.setSubType(1);
        this.sourceAddress = tRAMControlBlock.getLocalHost();
        super.writeInt(Util.InetAddressToInt(this.sourceAddress), 24);
        super.writeInt(0, 14);
    }

    public TRAMDataPacket(TRAMControlBlock tRAMControlBlock, byte[] byArray, int n, int n2) {
        super(byArray, n, 28, tRAMControlBlock.getSessionId(), n2);
        this.dataLength = (short)n;
        super.writeShort(this.dataLength, 10);
        this.setMessageType(2);
        this.setSubType(1);
        this.sourceAddress = tRAMControlBlock.getLocalHost();
        super.writeInt(Util.InetAddressToInt(this.sourceAddress), 24);
        super.writeInt(0, 14);
    }

    public TRAMDataPacket(TRAMControlBlock tRAMControlBlock) {
        super(28, tRAMControlBlock.getSessionId());
        this.setMessageType(2);
        this.setSubType(1);
        this.sourceAddress = tRAMControlBlock.getLocalHost();
        super.writeInt(0, 14);
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int getForgetBeforeSeqNum() {
        return this.forgetBeforeSeqNum;
    }

    public byte getTTL() {
        return this.ttl;
    }

    public int getLength() {
        return super.getLength() - 28;
    }

    public short getHaInterval() {
        return this.haInterval;
    }

    public byte[] getData() {
        return super.readBuffer(28);
    }

    public int getAckWindow() {
        return this.ackWindow & 0xFFFF;
    }

    public void setAckWindow(short s) {
        this.ackWindow = s;
        super.writeShort(s, 12);
    }

    public int getFlowControlInfo() {
        return this.flowControlInfo;
    }

    public void setFlowControlInfo(int n) {
        this.flowControlInfo = n;
        super.writeInt(n, 16);
    }

    public int getDataRate() {
        return this.dataRate;
    }

    public void setDataRate(int n) {
        this.dataRate = n;
        super.writeInt(n, 20);
    }

    public void setHaInterval(short s) {
        if (this.isTransmit()) {
            this.haInterval = s;
            super.writeShort(s, 0);
        }
    }

    public void setSequenceNumber(int n) {
        if (this.isTransmit()) {
            this.sequenceNumber = n;
            super.writeInt(n, 2);
        }
    }

    public void setForgetBeforeSeqNum(int n) {
        if (this.isTransmit()) {
            this.forgetBeforeSeqNum = n;
            super.writeInt(n, 6);
        }
    }

    public void setTTL(byte by) {
        this.ttl = by;
    }

    public DatagramPacket createDatagramPacket() {
        DatagramPacket datagramPacket = super.createDatagramPacket();
        return datagramPacket;
    }

    public InetAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setSourceAddress(InetAddress inetAddress) {
        this.sourceAddress = inetAddress;
        super.writeInt(Util.InetAddressToInt(this.sourceAddress), 24);
    }

    public void writeByte(byte by, int n) {
        super.writeByte(by, n += 28);
    }

    public void writeShort(short s, int n) {
        super.writeShort(s, n += 28);
    }

    public void writeInt(int n, int n2) {
        super.writeInt(n, n2 += 28);
    }

    public void writeBuffer(byte[] byArray, int n, int n2) {
        super.writeBuffer(byArray, n, n2 += 28);
    }

    public byte readByte(int n) {
        return super.readByte(n += 28);
    }

    public short readShort(int n) {
        return super.readShort(n += 28);
    }

    public int readInt(int n) {
        return super.readInt(n += 28);
    }

    public byte[] readBuffer(int n, int n2) {
        return super.readBuffer(n += 28, n2);
    }

    public byte[] readBuffer(int n) {
        return super.readBuffer(n += 28);
    }
}

