/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.authentication.AuthenticationModule;
import com.sun.multicast.reliable.authentication.AuthenticationSpec;
import com.sun.multicast.reliable.transport.tram.BeaconGenThread;
import com.sun.multicast.reliable.transport.tram.GroupMgmtBlk;
import com.sun.multicast.reliable.transport.tram.GroupMgmtThread;
import com.sun.multicast.reliable.transport.tram.HeadBlock;
import com.sun.multicast.reliable.transport.tram.HelloThread;
import com.sun.multicast.reliable.transport.tram.InputDispThread;
import com.sun.multicast.reliable.transport.tram.OutputDispThread;
import com.sun.multicast.reliable.transport.tram.PacketDbIOManager;
import com.sun.multicast.reliable.transport.tram.TRAMControlBlockException;
import com.sun.multicast.reliable.transport.tram.TRAMDataCache;
import com.sun.multicast.reliable.transport.tram.TRAMGenericDataCache;
import com.sun.multicast.reliable.transport.tram.TRAMHeadAck;
import com.sun.multicast.reliable.transport.tram.TRAMInputOutput;
import com.sun.multicast.reliable.transport.tram.TRAMLogger;
import com.sun.multicast.reliable.transport.tram.TRAMMemberAck;
import com.sun.multicast.reliable.transport.tram.TRAMRateAdjuster;
import com.sun.multicast.reliable.transport.tram.TRAMSimulator;
import com.sun.multicast.reliable.transport.tram.TRAMStats;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import com.sun.multicast.reliable.transport.tram.UcastInputDispThread;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.security.SignatureException;

class TRAMControlBlock {
    private TRAMTransportProfile tp;
    private MulticastSocket multicastSocket;
    private DatagramSocket unicastSocket;
    private long lastRetrans;
    private int unicastPort;
    private long dataTxmStartTime;
    private long dataTxmEndTime;
    private long avgMinRate;
    private long dataRate;
    private long beaconRate;
    private byte tramState;
    private byte beaconTTL;
    private byte msTTL;
    private GroupMgmtBlk groupMgmtBlk;
    private TRAMStats statsBlock;
    private GroupMgmtThread groupMgmtThread;
    private InputDispThread inputDispThread;
    private OutputDispThread outputDispThread;
    private UcastInputDispThread ucastInputDispThread;
    private TRAMMemberAck memberAck;
    private TRAMHeadAck headAck;
    private HelloThread helloThread;
    private BeaconGenThread beaconGenThread;
    private PacketDbIOManager packetdb;
    private TRAMLogger logger;
    private TRAMRateAdjuster tramRateAdjuster;
    private TRAMSimulator simulator;
    private TRAMDataCache dataCache;
    private int lastKnownSequenceNumber;
    private int lastKnownForgetBeforeSeqNum;
    private int lastFirstTimeTxmSequenceNumber;
    private boolean dataTransmissionComplete;
    private long lastHeardFromTheSender;
    private long ackInterval;
    private boolean cacheFull;
    private int sessionId;
    private int highestSequenceAllowed;
    private InetAddress myLocalAddress;
    private AuthenticationModule authenticationModule;

    public TRAMControlBlock(MulticastSocket multicastSocket, TRAMTransportProfile tRAMTransportProfile) throws TRAMControlBlockException {
        this(multicastSocket, tRAMTransportProfile, null);
    }

    /*
     * Unable to fully structure code
     */
    public TRAMControlBlock(MulticastSocket var1_1, TRAMTransportProfile var2_2, TRAMSimulator var3_3) throws TRAMControlBlockException {
        block14: {
            super();
            this.tp = null;
            this.multicastSocket = null;
            this.unicastSocket = null;
            this.lastRetrans = 0L;
            this.unicastPort = 0;
            this.dataTxmStartTime = 0L;
            this.dataTxmEndTime = 0L;
            this.avgMinRate = 0L;
            this.dataRate = 0L;
            this.beaconRate = 0L;
            this.tramState = 1;
            this.beaconTTL = 1;
            this.msTTL = 1;
            this.groupMgmtBlk = null;
            this.statsBlock = null;
            this.groupMgmtThread = null;
            this.inputDispThread = null;
            this.outputDispThread = null;
            this.ucastInputDispThread = null;
            this.memberAck = null;
            this.headAck = null;
            this.helloThread = null;
            this.beaconGenThread = null;
            this.simulator = null;
            this.dataTransmissionComplete = false;
            this.lastHeardFromTheSender = 0L;
            this.ackInterval = 30000L;
            this.cacheFull = false;
            this.sessionId = 0;
            this.authenticationModule = null;
            this.simulator = var3_3;
            this.multicastSocket = var1_1;
            this.tp = var2_2;
            this.dataTxmStartTime = System.currentTimeMillis();
            this.logger = new TRAMLogger(this);
            this.statsBlock = new TRAMStats(this);
            this.tramRateAdjuster = new TRAMRateAdjuster(this);
            try {
                this.startAuthenticationModule(var2_2);
            }
            catch (IOException var4_4) {
                throw new TRAMControlBlockException(var4_4 + " Unable to find/read Authentication Spec file");
            }
            catch (SignatureException var5_8) {
                throw new TRAMControlBlockException(var5_8 + " Unable to create Authentication module");
            }
            if (var2_2.getDataSourceAddress() != null) {
                this.statsBlock.addSender(var2_2.getDataSourceAddress());
            }
            this.unicastPort = var2_2.getUnicastPort();
            try {
                this.myLocalAddress = var1_1.getInterface();
            }
            catch (SocketException var4_5) {
                throw new TRAMControlBlockException(var4_5 + " Unable to set multicast socket interface to " + this.myLocalAddress);
            }
            if (var3_3 == null) {
                if (this.unicastPort == 0) {
                    try {
                        this.unicastSocket = new DatagramSocket(0, this.myLocalAddress);
                        this.unicastPort = this.unicastSocket.getLocalPort();
                    }
                    catch (SocketException var4_6) {
                        throw new TRAMControlBlockException(var4_6 + " Unable to create Unicast Socket");
                    }
                }
                try {
                    this.unicastSocket = new DatagramSocket(this.unicastPort, this.myLocalAddress);
                }
                catch (SocketException var4_7) {
                    throw new TRAMControlBlockException(var4_7 + " Unable to create Unicast Socket, Port inuse");
                }
            }
            if (this.logger.requiresLogging(16)) {
                this.logger.putPacketln(this, "Listening on " + this.myLocalAddress + ", Unicast port " + this.unicastPort);
            }
            this.outputDispThread = new OutputDispThread(this);
            this.inputDispThread = new InputDispThread(this);
            this.ucastInputDispThread = new UcastInputDispThread(this);
            this.groupMgmtBlk = new GroupMgmtBlk(this);
            this.groupMgmtThread = new GroupMgmtThread(this);
            if (var2_2.getTmode() == 1) ** GOTO lbl78
            this.memberAck = new TRAMMemberAck(this);
            break block14;
lbl-1000:
            // 1 sources

            {
                this.sessionId = (int)(Math.random() * 2.147483647E9);
lbl78:
                // 2 sources

                ** while (this.sessionId == 0)
            }
lbl79:
            // 1 sources

            var2_2.setSessionId(this.sessionId);
            this.tp.setSessionId(this.sessionId);
            this.ackInterval = 5L * var2_2.getPruneHelloRate();
        }
        this.dataCache = new TRAMGenericDataCache(this);
        this.packetdb = new PacketDbIOManager(this);
    }

    public TRAMTransportProfile getTransportProfile() {
        return this.tp;
    }

    public void setTransportProfile(TRAMTransportProfile tRAMTransportProfile) {
        this.tp = tRAMTransportProfile;
    }

    public MulticastSocket getMulticastSocket() {
        return this.multicastSocket;
    }

    public void setMulticastSocket(MulticastSocket multicastSocket) {
        this.multicastSocket = multicastSocket;
    }

    public DatagramSocket getUnicastSocket() {
        return this.unicastSocket;
    }

    public void setUnicastSocket(DatagramSocket datagramSocket) {
        this.unicastSocket = datagramSocket;
    }

    public int getUnicastPort() {
        return this.unicastPort;
    }

    public void setUnicastPort(int n) {
        this.unicastPort = n;
    }

    public void getDataTxmStartTime(long l) {
        this.dataTxmStartTime = l;
    }

    public void setDataTxmStartTime(long l) {
        this.dataTxmStartTime = l;
    }

    public long getDataTxmStartTime() {
        return this.dataTxmStartTime;
    }

    public void setDataTxmEndTime(long l) {
        this.dataTxmEndTime = l;
    }

    public long getAvgMinRate() {
        return this.avgMinRate;
    }

    public void setAvgMinRate(long l) {
        this.avgMinRate = l;
    }

    public long getBeaconRate() {
        return this.beaconRate;
    }

    public void setBeaconRate(long l) {
        this.beaconRate = l;
    }

    public byte getTRAMState() {
        return this.tramState;
    }

    public void setTRAMState(byte by) {
        this.tramState = by;
    }

    public byte getBeaconTTL() {
        return this.beaconTTL;
    }

    public void setBeaconTTL(byte by) {
        this.beaconTTL = by;
    }

    public byte getMsTTL() {
        return this.msTTL;
    }

    public void setMsTTL(byte by) {
        this.msTTL = by;
    }

    public GroupMgmtBlk getGroupMgmtBlk() {
        return this.groupMgmtBlk;
    }

    public void setGroupMgmtBlk(GroupMgmtBlk groupMgmtBlk) {
        this.groupMgmtBlk = groupMgmtBlk;
    }

    public TRAMStats getTRAMStats() {
        return this.statsBlock;
    }

    public void setTRAMStats(TRAMStats tRAMStats) {
        this.statsBlock = tRAMStats;
    }

    public synchronized GroupMgmtThread getGroupMgmtThread() {
        return this.groupMgmtThread;
    }

    public synchronized void setGroupMgmtThread(GroupMgmtThread groupMgmtThread) {
        this.groupMgmtThread = groupMgmtThread;
    }

    public synchronized InputDispThread getInputDispThread() {
        return this.inputDispThread;
    }

    public synchronized void setInputDispThread(InputDispThread inputDispThread) {
        this.inputDispThread = inputDispThread;
    }

    public synchronized UcastInputDispThread getUcastInputDispThread() {
        return this.ucastInputDispThread;
    }

    public synchronized void setUcastInputDispThread(UcastInputDispThread ucastInputDispThread) {
        this.ucastInputDispThread = ucastInputDispThread;
    }

    public synchronized BeaconGenThread getBeaconGenThread() {
        return this.beaconGenThread;
    }

    public synchronized void setBeaconGenThread(BeaconGenThread beaconGenThread) {
        this.beaconGenThread = beaconGenThread;
    }

    public synchronized HelloThread getHelloThread() {
        return this.helloThread;
    }

    public synchronized void setHelloThread(HelloThread helloThread) {
        this.helloThread = helloThread;
    }

    public TRAMInputOutput getPacketDb() {
        return this.packetdb;
    }

    public TRAMLogger getLogger() {
        return this.logger;
    }

    public TRAMHeadAck getHeadAck() {
        return this.headAck;
    }

    public void setHeadAck(TRAMHeadAck tRAMHeadAck) {
        this.headAck = tRAMHeadAck;
    }

    public TRAMMemberAck getMemberAck() {
        return this.memberAck;
    }

    public void setMemberAck(TRAMMemberAck tRAMMemberAck) {
        this.memberAck = tRAMMemberAck;
    }

    public OutputDispThread getOutputDispThread() {
        return this.outputDispThread;
    }

    public void setOutputDispThread(OutputDispThread outputDispThread) {
        this.outputDispThread = outputDispThread;
    }

    public final void doTRAMClose() {
        this.close(false);
    }

    public final void doTRAMAbort() {
        this.close(true);
    }

    private void close(boolean bl) {
        if (this.multicastSocket == null || this.unicastSocket == null) {
            if (this.logger.requiresLogging(1)) {
                this.logger.putPacketln(this, "close called when sockets already closed!  ignored.");
            }
            return;
        }
        if (this.logger.requiresLogging(135)) {
            this.logger.putPacketln(this, "Attemting to close HeadAck Module");
        }
        if (this.headAck != null && !bl) {
            this.headAck.waitToComplete();
        }
        if (this.logger.requiresLogging(135)) {
            this.logger.putPacketln(this, "Attemting to close MemberAck Module");
        }
        if (this.memberAck != null) {
            if (!bl) {
                this.memberAck.waitToComplete();
            } else {
                HeadBlock headBlock = this.groupMgmtBlk.getHeadBlock();
                if (headBlock != null) {
                    this.memberAck.sendAck((byte)2, headBlock, 9);
                    this.groupMgmtBlk.setHeadBlock(null);
                }
                this.memberAck.abortTimer();
            }
        }
        if (this.logger.requiresLogging(135)) {
            this.logger.putPacketln(this, "Attemting to close GroupMgmtThread Module");
        }
        if (this.groupMgmtThread != null && this.groupMgmtThread.isAlive()) {
            this.groupMgmtThread.terminate();
        }
        if (this.logger.requiresLogging(135)) {
            this.logger.putPacketln(this, "Attemting to close BeaconGenThread Module");
        }
        if (this.beaconGenThread != null && this.beaconGenThread.isAlive()) {
            this.beaconGenThread.terminate();
        }
        if (this.logger.requiresLogging(135)) {
            this.logger.putPacketln(this, "Attemting to close Hello Thread Module");
        }
        if (this.helloThread != null && this.helloThread.isAlive()) {
            this.helloThread.terminate();
        }
        if (this.logger.requiresLogging(135)) {
            this.logger.putPacketln(this, "Attemting to close InputDispatcher Module");
        }
        if (this.inputDispThread != null && this.inputDispThread.isAlive()) {
            this.inputDispThread.terminate();
        }
        if (this.logger.requiresLogging(135)) {
            this.logger.putPacketln(this, "Attemting to close OutputDispatcher Module");
        }
        if (this.outputDispThread != null && this.outputDispThread.isAlive()) {
            this.outputDispThread.terminate();
        }
        if (this.logger.requiresLogging(135)) {
            this.logger.putPacketln(this, "Attemting to close UnicastOutputDisp Module");
        }
        if (this.ucastInputDispThread != null && this.ucastInputDispThread.isAlive()) {
            this.ucastInputDispThread.terminate();
        }
        if (this.simulator == null) {
            this.multicastSocket.close();
            this.unicastSocket.close();
            this.multicastSocket = null;
            this.unicastSocket = null;
        }
    }

    TRAMSimulator getSimulator() {
        return this.simulator;
    }

    void simulateMulticastPacketReceive(DatagramPacket datagramPacket) {
        this.getInputDispThread().dispatchPacket(datagramPacket);
    }

    void simulateUnicastPacketReceive(DatagramPacket datagramPacket) {
        this.getUcastInputDispThread().dispatchPacket(datagramPacket);
    }

    public TRAMRateAdjuster getRateAdjuster() {
        return this.tramRateAdjuster;
    }

    public void setLastKnownSequenceNumber(int n) {
        this.lastKnownSequenceNumber = n;
    }

    public int getLastKnownSequenceNumber() {
        return this.lastKnownSequenceNumber;
    }

    public void setLastKnownForgetBeforeSeqNum(int n) {
        if (this.lastKnownForgetBeforeSeqNum > n) {
            if (this.logger.requiresLogging(71)) {
                this.logger.putPacketln(this, "Cannot decrease value of forgetBeforeSeqNum from " + this.lastKnownForgetBeforeSeqNum + " to " + n);
            }
        } else {
            this.lastKnownForgetBeforeSeqNum = n;
        }
    }

    public int getLastKnownForgetBeforeSeqNum() {
        return this.lastKnownForgetBeforeSeqNum;
    }

    public void setLastFirstTimeTxmSequenceNumber(int n) {
        this.lastFirstTimeTxmSequenceNumber = n;
    }

    public int getLastFirstTimeTxmSequenceNumber() {
        return this.lastFirstTimeTxmSequenceNumber;
    }

    public TRAMDataCache getTRAMDataCache() {
        return this.dataCache;
    }

    public boolean isDataTransmissionComplete() {
        return this.dataTransmissionComplete;
    }

    public synchronized void setDataTransmissionComplete(boolean bl) {
        this.dataTransmissionComplete = bl;
    }

    public long getLastHeardFromTheSender() {
        return this.lastHeardFromTheSender;
    }

    public synchronized void setLastHeardFromTheSender(long l) {
        this.lastHeardFromTheSender = l;
    }

    public void setAckInterval(long l) {
        this.ackInterval = l;
    }

    public long getAckInterval() {
        return this.ackInterval;
    }

    public void setCacheFull(boolean bl) {
        this.cacheFull = bl;
    }

    public boolean isCacheFull() {
        return this.cacheFull;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(int n) {
        this.sessionId = n;
    }

    public AuthenticationModule getAuthenticationModule() {
        return this.authenticationModule;
    }

    public void setAuthenticationModule(AuthenticationModule authenticationModule) {
        this.authenticationModule = authenticationModule;
    }

    private void startAuthenticationModule(TRAMTransportProfile tRAMTransportProfile) throws IOException, SignatureException {
        this.authenticationModule = null;
        if (!tRAMTransportProfile.isUsingAuthentication()) {
            return;
        }
        AuthenticationSpec authenticationSpec = null;
        String string = tRAMTransportProfile.getAuthenticationSpecFileName();
        if (string == null) {
            if (this.logger.requiresLogging(1023)) {
                this.logger.putPacketln(this, "No authentication FileName Specified. Using Default file - JRMSAuth.spec");
            }
            string = "JRMSAuth.spec";
            tRAMTransportProfile.setAuthenticationSpecFileName(string);
        }
        authenticationSpec = AuthenticationSpec.readFromFile(string);
        if (this.logger.requiresLogging(519)) {
            this.logger.putPacketln(this, "Starting Authentication Module");
        }
        this.authenticationModule = new AuthenticationModule(authenticationSpec, tRAMTransportProfile.getAuthenticationSpecPassword());
    }

    public void setHighestSequenceAllowed(int n) {
        if (n > this.highestSequenceAllowed) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "current highest " + this.highestSequenceAllowed + " new highest " + n + " C Win " + this.tp.getCongestionWindow());
            }
            this.highestSequenceAllowed = n;
        } else if (n < this.highestSequenceAllowed && this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "current " + this.highestSequenceAllowed + " is greater than new " + n + " C Win " + this.tp.getCongestionWindow());
        }
    }

    public int getHighestSequenceAllowed() {
        return this.highestSequenceAllowed;
    }

    public InetAddress getLocalHost() {
        return this.myLocalAddress;
    }

    public MulticastSocket newMulticastSocket() throws IOException {
        MulticastSocket multicastSocket = new MulticastSocket();
        multicastSocket.setInterface(this.myLocalAddress);
        return multicastSocket;
    }
}

