/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.InvalidMulticastAddressException;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;

final class TRAMConfigurator {
    static final String str_MROLE = "MROLE";
    static final String str_TMODE = "TMODE";
    static final String str_MAX_MEMBERS = "MAX_MEMBERS";
    static final String str_HELLO_RATE = "HELLO_RATE";
    static final String str_MS_RATE = "MS_RATE";
    static final String str_BEACON_RATE = "BEACON_RATE";
    static final String str_ACK_WINDOW = "ACK_WINDOW";
    static final String str_NACK_REPORT_WINDOW = "NACK_REPORT_WINDOW";
    static final String str_MAX_HELLO_MISSES = "MAX_HELLO_MISSES";
    static final String str_MS_TTL_INCREMENTS = "MS_TTL_INCREMENTS";
    static final String str_BEACON_TTL_INCREMENTS = "BEACON_TTL_INCREMENTS";
    static final String str_UNICAST_PORT = "UNICAST_PORT";
    static final String str_TFR_DATA_SIZE = "TFR_DATA_SIZE";
    static final String str_TFR_DURATION = "TFR_DURATION";
    static final String str_MADDR = "MADDR";
    static final String str_MPORT = "MPORT";
    static final String str_MDATA_SOURCE = "MDATA_SOURCE";
    static final String str_MEMBER_ONLY = "MEMBER_ONLY";
    static final String str_MEMBER_EAGERHEAD = "MEMBER_EAGERHEAD";
    static final String str_MEMBER_RELUCTANTHEAD = "MEMBER_RELUCTANTHEAD";
    static final String str_SEND_ONLY = "SEND_ONLY";
    static final String str_RECEIVE_ONLY = "RECEIVE_ONLY";
    static final String str_SEND_RECEIVE = "SEND_RECEIVE";

    TRAMConfigurator() {
    }

    public static final void LoadConfig(String string, TRAMTransportProfile tRAMTransportProfile) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(string);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        String string2 = null;
        string2 = properties.getProperty(str_MROLE);
        if (string2 != null) {
            n = 0;
            if (str_MEMBER_ONLY.equals(string2)) {
                n = 1;
                System.out.println("Mrole = MemberOnly");
            } else if (str_MEMBER_EAGERHEAD.equals(string2)) {
                System.out.println("Mrole = MemberEagerHead");
                n = 2;
            } else if (str_MEMBER_RELUCTANTHEAD.equals(string2)) {
                System.out.println("Mrole = MemberReluctant HEad");
                n = 3;
            }
            if (n != 0) {
                tRAMTransportProfile.setMrole((byte)n);
            }
        }
        if ((string2 = properties.getProperty(str_TMODE)) != null) {
            n = 0;
            if (str_SEND_ONLY.equals(string2)) {
                n = 1;
            } else if (str_RECEIVE_ONLY.equals(string2)) {
                n = 2;
            }
            tRAMTransportProfile.setTmode((byte)n);
        }
        if ((string2 = properties.getProperty(str_MAX_MEMBERS)) != null) {
            Integer n2 = new Integer(string2);
            tRAMTransportProfile.setMaxMembers((short)n2.intValue());
        }
        if ((string2 = properties.getProperty(str_HELLO_RATE)) != null) {
            Long l = new Long(string2);
            tRAMTransportProfile.setHelloRate(l);
        }
        if ((string2 = properties.getProperty(str_MS_RATE)) != null) {
            Long l = new Long(string2);
            tRAMTransportProfile.setMsRate(l);
        }
        if ((string2 = properties.getProperty(str_BEACON_RATE)) != null) {
            Long l = new Long(string2);
            tRAMTransportProfile.setBeaconRate(l);
        }
        if ((string2 = properties.getProperty(str_ACK_WINDOW)) != null) {
            Integer n3 = new Integer(string2);
            tRAMTransportProfile.setAckWindow((short)n3.intValue());
        }
        if ((string2 = properties.getProperty(str_NACK_REPORT_WINDOW)) != null) {
            Integer n4 = new Integer(string2);
            tRAMTransportProfile.setNackReportWindow((short)n4.intValue());
        }
        if ((string2 = properties.getProperty(str_MAX_HELLO_MISSES)) != null) {
            Integer n5 = new Integer(string2);
            tRAMTransportProfile.setMaxHelloMisses((byte)n5.intValue());
        }
        if ((string2 = properties.getProperty(str_MS_TTL_INCREMENTS)) != null) {
            Integer n6 = new Integer(string2);
            tRAMTransportProfile.setMsTTLIncrements((byte)n6.intValue());
        }
        if ((string2 = properties.getProperty(str_BEACON_TTL_INCREMENTS)) != null) {
            Integer n7 = new Integer(string2);
            tRAMTransportProfile.setBeaconTTLIncrements((byte)n7.intValue());
        }
        if ((string2 = properties.getProperty(str_UNICAST_PORT)) != null) {
            Integer n8 = new Integer(string2);
            tRAMTransportProfile.setUnicastPort(n8);
        }
        if ((string2 = properties.getProperty(str_TFR_DATA_SIZE)) != null) {
            Long l = new Long(string2);
            tRAMTransportProfile.setTransferDataSize(l.longValue());
        }
        if ((string2 = properties.getProperty(str_TFR_DURATION)) != null) {
            Long l = new Long(string2);
            tRAMTransportProfile.setTransferDuration(l);
        }
        if ((string2 = properties.getProperty(str_MADDR)) != null) {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                System.out.println("Invalid MAddress");
            }
            try {
                tRAMTransportProfile.setAddress(inetAddress);
            }
            catch (InvalidMulticastAddressException invalidMulticastAddressException) {
                System.out.println("Invalid Mcast address ");
            }
        }
        if ((string2 = properties.getProperty(str_MDATA_SOURCE)) != null) {
            try {
                tRAMTransportProfile.setDataSourceAddress(InetAddress.getByName(string2));
            }
            catch (UnknownHostException unknownHostException) {
                System.out.println("Invalid Data SourceAddress");
            }
        }
        if ((string2 = properties.getProperty(str_MPORT)) != null) {
            Integer n9 = new Integer(string2);
            tRAMTransportProfile.setPort(n9);
        }
    }
}

