/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMPacket;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import com.sun.multicast.util.Util;
import java.net.DatagramPacket;
import java.net.InetAddress;

class TRAMAmPacket
extends TRAMPacket {
    public static final byte FLAGBIT_V6ADDRESS = -128;
    private static final int BITMASKLENGTH = 0;
    private static final int RXLEVEL = 1;
    private static final int START_SEQ_NUMBER = 2;
    private static final int SOURCE_ADDR = 6;
    private static final int AMDATA = 10;
    private static final int BITMASK = 10;
    private byte rxLevel;
    private InetAddress dataSrcAddress = null;
    private int startSeqNumber;

    public TRAMAmPacket(DatagramPacket datagramPacket) {
        super(datagramPacket);
        this.rxLevel = super.readByte(1);
        int n = super.readInt(6);
        this.dataSrcAddress = Util.intToInetAddress(n);
        this.startSeqNumber = super.readInt(2);
    }

    public TRAMAmPacket(TRAMControlBlock tRAMControlBlock) {
        super(10, tRAMControlBlock.getSessionId());
        this.setMessageType(3);
        this.setSubType(1);
        this.rxLevel = (byte)tRAMControlBlock.getGroupMgmtBlk().getRxLevel();
        TRAMTransportProfile tRAMTransportProfile = tRAMControlBlock.getTransportProfile();
        this.dataSrcAddress = tRAMTransportProfile.getDataSourceAddress();
    }

    public DatagramPacket createDatagramPacket() {
        super.writeByte(this.rxLevel, 1);
        super.writeInt(Util.InetAddressToInt(this.dataSrcAddress), 6);
        super.writeInt(this.startSeqNumber, 2);
        return super.createDatagramPacket();
    }

    public InetAddress getDataSrcAddress() {
        return this.dataSrcAddress;
    }

    public void setDataSrcAddress(InetAddress inetAddress) {
        this.dataSrcAddress = inetAddress;
    }

    public int getStartSeqNumber() {
        return this.startSeqNumber;
    }

    public void setStartSeqNumber(int n) {
        this.startSeqNumber = n;
    }

    public byte getRxLevel() {
        return this.rxLevel;
    }
}

