/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMPacket;
import com.sun.multicast.util.Util;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;

class TRAMAckPacket
extends TRAMPacket {
    public static final byte FLAGBIT_HELLO_NOT_RECVD = 1;
    public static final byte FLAGBIT_TERMINATE_MEMBERSHIP = 2;
    public static final byte FLAGBIT_ACK = 4;
    public static final byte FLAGBIT_CONGESTION = 8;
    public static final byte FLAGBIT_SUBTREE_FLOW_CONTROL_INFO = 16;
    public static final byte FLAGBIT_DATA_RATE = 32;
    public static final byte FLAGBIT_V6ADDRESS = -128;
    public static final int BITMASKLENGTH = 0;
    public static final int ACTUALTTL = 2;
    public static final int RESERVED = 3;
    public static final int STARTNUMBER = 6;
    public static final int DIRECTMEMBERS = 10;
    public static final int INDIRECTMEMBERS = 12;
    public static final int DIRECTHEADSADV = 14;
    public static final int INDIRECTHEADSADV = 16;
    public static final int HIGHESTSEQUENCEALLOWED = 18;
    public static final int FLOWCONTROLINFO = 22;
    public static final int DATARATE = 26;
    public static final int SOURCEADDRESS = 30;
    public static final int ACKHEADER = 34;
    public static final int BITMASK = 34;
    private InetAddress sourceAddress;
    private InetAddress dataSourceAddress;
    private int port;
    private int actualTTL;
    private long basePacketNumber;
    private int bitMaskLength;
    private int directMemberCount = 0;
    private int indirectMemberCount = 0;
    private int directHeadsAdvertising = 0;
    private int indirectHeadsAdvertising = 0;
    private byte[] bitmask;
    private int highestSequenceAllowed;
    private int flowControlInfo;
    private int dataRate;

    public TRAMAckPacket(DatagramPacket datagramPacket) throws UnknownHostException {
        super(datagramPacket);
        this.sourceAddress = datagramPacket.getAddress();
        this.port = datagramPacket.getPort();
        this.actualTTL = super.readByte(2) & 0xFF;
        int n = super.readInt(30);
        this.dataSourceAddress = Util.intToInetAddress(n);
        this.basePacketNumber = super.readInt(6);
        this.bitMaskLength = super.readShort(0) & 0xFFFF;
        this.directMemberCount = super.readShort(10) & 0xFFFF;
        this.indirectMemberCount = super.readShort(12) & 0xFFFF;
        this.directHeadsAdvertising = super.readShort(14) & 0xFFFF;
        this.indirectHeadsAdvertising = super.readShort(16) & 0xFFFF;
        this.highestSequenceAllowed = super.readInt(18);
        this.flowControlInfo = super.readInt(22);
        this.dataRate = super.readInt(26);
        this.bitmask = super.readBuffer(34, (this.bitMaskLength + 7) / 8);
    }

    public TRAMAckPacket(TRAMControlBlock tRAMControlBlock, byte[] byArray, long l, int n) {
        super(byArray, byArray.length, 34, tRAMControlBlock.getSessionId());
        this.setMessageType(3);
        this.setSubType(4);
        this.setBasePacketNumber(l);
        this.setBitMaskLength(n);
        this.setBitMask(byArray);
        this.setDataSourceAddress(tRAMControlBlock.getTransportProfile().getDataSourceAddress());
    }

    public TRAMAckPacket(TRAMControlBlock tRAMControlBlock, long l) {
        super(34, tRAMControlBlock.getSessionId());
        this.setMessageType(3);
        this.setSubType(4);
        this.setBasePacketNumber(l);
        this.setBitMaskLength(0);
        this.setBitMask(null);
        this.setDataSourceAddress(tRAMControlBlock.getTransportProfile().getDataSourceAddress());
    }

    public DatagramPacket createDatagramPacket() {
        super.writeInt(Util.InetAddressToInt(this.dataSourceAddress), 30);
        DatagramPacket datagramPacket = super.createDatagramPacket();
        return datagramPacket;
    }

    public long getBasePacketNumber() {
        return this.basePacketNumber;
    }

    public int getBitMaskLength() {
        return this.bitMaskLength;
    }

    public byte[] getBitMask() {
        return this.bitmask;
    }

    public int getDirectMemberCount() {
        return this.directMemberCount;
    }

    public int getIndirectMemberCount() {
        return this.indirectMemberCount;
    }

    public void setDirectMemberCount(int n) {
        this.directMemberCount = n;
        super.writeShort((short)n, 10);
    }

    public void setIndirectMemberCount(int n) {
        this.indirectMemberCount = n;
        super.writeShort((short)n, 12);
    }

    public int getDirectHeadsAdvertising() {
        return this.directHeadsAdvertising;
    }

    public int getIndirectHeadsAdvertising() {
        return this.indirectHeadsAdvertising;
    }

    public void setDirectHeadsAdvertising(int n) {
        this.directHeadsAdvertising = n;
        super.writeShort((short)n, 14);
    }

    public void setIndirectHeadsAdvertising(int n) {
        this.indirectHeadsAdvertising = n;
        super.writeShort((short)n, 16);
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public InetAddress getDataSourceAddress() {
        return this.dataSourceAddress;
    }

    public void setDataSourceAddress(InetAddress inetAddress) {
        this.dataSourceAddress = inetAddress;
    }

    private void setBasePacketNumber(long l) {
        this.basePacketNumber = l;
        super.writeInt((int)l, 6);
    }

    private void setBitMaskLength(int n) {
        this.bitMaskLength = n;
        super.writeShort((short)n, 0);
    }

    public void setBitMask(byte[] byArray) {
        this.bitmask = byArray;
    }

    public int getTTL() {
        return this.actualTTL;
    }

    public void setActualTTL(int n) {
        this.actualTTL = n;
    }

    public void setHighestSequenceAllowed(int n) {
        this.highestSequenceAllowed = n;
        super.writeInt(n, 18);
    }

    public int getHighestSequenceAllowed() {
        return this.highestSequenceAllowed;
    }

    public void setFlowControlInfo(int n) {
        this.flowControlInfo = n;
        super.writeInt(n, 22);
    }

    public int getFlowControlInfo() {
        return this.flowControlInfo;
    }

    public void setDataRate(int n) {
        this.dataRate = n;
        super.writeInt(n, 26);
    }

    public int getDataRate() {
        return this.dataRate;
    }
}

