/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.PerfMonCanvas;
import com.sun.multicast.reliable.transport.tram.PerfObservable;
import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMStats;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.ScrollPane;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class PerfMon
extends Frame
implements Runnable {
    private PerfMonCanvas pmc;
    private Thread dispThread;
    private TRAMTransportProfile tp;
    private TRAMStats tramStats;
    private TRAMControlBlock tramblk;
    private int height = 500;
    private int width = 700;
    private boolean quit = false;

    public PerfMon(TRAMControlBlock tRAMControlBlock, String string) {
        super("Performance Monitor:  " + string);
        this.tp = tRAMControlBlock.getTransportProfile();
        if (this.tp.getTmode() != 1) {
            return;
        }
        this.tramblk = tRAMControlBlock;
        this.tramStats = tRAMControlBlock.getTRAMStats();
        this.addWindowListener(new DWAdapter());
        ((Component)this).setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.pmc = new PerfMonCanvas(new PerfObservable());
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.add("Center", this.pmc);
        this.add(scrollPane);
        ((Component)this).setSize(800, 600);
        ((Component)this).setVisible(true);
        this.show();
        this.dispThread = new Thread(this);
        this.dispThread.setDaemon(true);
        this.dispThread.start();
    }

    public void stop() {
        this.quit = true;
    }

    public void newDataRate(long l) {
    }

    public void run() {
        while (!this.quit) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.pmc.erase();
            this.pmc.addElement(this.pmc.rateVector, (int)(this.tramblk.getRateAdjuster().getAverageDataRate() / 1000L));
            int n = this.tramblk.getHighestSequenceAllowed();
            int n2 = this.tramblk.getRateAdjuster().getWindow();
            this.pmc.addElement(this.pmc.windowSizeVector, n2);
            this.pmc.paint();
        }
    }

    class DWAdapter
    extends WindowAdapter {
        DWAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }
}

