/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.OutputDispThread;
import com.sun.multicast.reliable.transport.tram.PacketDb;
import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacket;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMInputOutput;
import com.sun.multicast.reliable.transport.tram.TRAMLogger;
import com.sun.multicast.reliable.transport.tram.TRAMPacket;
import com.sun.multicast.reliable.transport.tram.TRAMRateAdjuster;
import java.io.IOException;
import java.util.NoSuchElementException;

class PacketDbIOManager
implements TRAMDataPacketListener,
TRAMInputOutput {
    TRAMControlBlock tramblk;
    PacketDb outputDatabase;
    PacketDb inputDatabase;
    OutputDispThread outputDispatcher;
    TRAMLogger logger = null;
    boolean sender;

    public PacketDbIOManager(TRAMControlBlock tRAMControlBlock) {
        this.tramblk = tRAMControlBlock;
        this.outputDatabase = new PacketDb(tRAMControlBlock, 15);
        this.outputDatabase.setInbound(false);
        this.inputDatabase = new PacketDb(tRAMControlBlock);
        this.inputDatabase.setInbound(true);
        this.logger = tRAMControlBlock.getLogger();
        this.outputDispatcher = tRAMControlBlock.getOutputDispThread();
        this.outputDispatcher.setPacketDB(this.outputDatabase);
        boolean bl = this.sender = (tRAMControlBlock.getTransportProfile().getTmode() & 0xFF) == 1;
        if (!this.sender) {
            tRAMControlBlock.getTRAMDataCache().addTRAMDataPacketListener(this);
        }
    }

    public void receiveDataPacket(TRAMDataPacketEvent tRAMDataPacketEvent) {
        TRAMDataPacket tRAMDataPacket = tRAMDataPacketEvent.getPacket();
        this.inputDatabase.putPacket(tRAMDataPacket);
    }

    public synchronized void putPacket(TRAMPacket tRAMPacket) throws IOException {
        while (this.tramblk.isCacheFull()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (tRAMPacket.getMessageType() == 2 && tRAMPacket.getSubType() == 1) {
            this.setFlowControlFlags(tRAMPacket);
        }
        this.outputDatabase.putPacket(tRAMPacket);
    }

    public void putPacket(TRAMPacket tRAMPacket, boolean bl) throws IOException {
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "PacketDbIOManager: Putpacket priority packet");
        }
        if (tRAMPacket.getMessageType() == 2 && tRAMPacket.getSubType() == 1) {
            this.setFlowControlFlags(tRAMPacket);
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "PacketDbIOManager: Packet Number is " + ((TRAMDataPacket)tRAMPacket).getSequenceNumber());
            }
        }
        this.outputDatabase.putPacket(tRAMPacket, bl);
    }

    public TRAMPacket getPacket() {
        TRAMPacket tRAMPacket = this.inputDatabase.getPacket();
        return tRAMPacket;
    }

    public TRAMPacket getPacketWithNoBlocking() throws NoSuchElementException {
        throw new NoSuchElementException("Unsupported Method");
    }

    public TRAMDataPacket getPacket(long l) throws NoSuchElementException {
        return this.inputDatabase.getPacket(l);
    }

    public void removePacket(long l) throws NoSuchElementException {
        this.inputDatabase.removePacket(l);
    }

    public void printDataCounts() {
        if (this.logger.requiresLogging(263)) {
            this.logger.putPacketln(this, "Input Database  = " + this.inputDatabase.getPacketCount());
            this.logger.putPacketln(this, "Output Database = " + this.outputDatabase.getPacketCount());
        }
    }

    public synchronized void wake() {
        this.notifyAll();
    }

    private void setFlowControlFlags(TRAMPacket tRAMPacket) {
        TRAMRateAdjuster tRAMRateAdjuster = this.tramblk.getRateAdjuster();
        byte by = (byte)(tRAMPacket.getFlags() & 0xFF);
        if (tRAMRateAdjuster.timeToPrune()) {
            int n = tRAMRateAdjuster.getGroupFlowControlInfo();
            tRAMPacket.setFlags((byte)(by | 1));
            ((TRAMDataPacket)tRAMPacket).setFlowControlInfo(n);
            if (this.logger.requiresLogging(16)) {
                this.logger.putPacketln(this, "Setting FLAGBIT_PRUNE. flow " + n);
            }
            tRAMRateAdjuster.findMemberToPrune(n);
        }
    }

    public int getRetxDbSize() {
        return this.outputDatabase.getRetxDbSize();
    }
}

