/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacket;
import com.sun.multicast.reliable.transport.tram.TRAMInputOutput;
import com.sun.multicast.reliable.transport.tram.TRAMPacket;
import com.sun.multicast.reliable.transport.tram.TRAMSeqNumber;
import java.util.NoSuchElementException;
import java.util.Vector;

class PacketDb
implements TRAMInputOutput {
    private static final int DB_INCREMENTS = 100;
    private Vector db = null;
    private Vector retxDb = null;
    private long dataSize = 0L;
    private int capacity = 0;
    private TRAMControlBlock tramblk;
    boolean inbound = false;
    boolean shutdown = false;

    public PacketDb(TRAMControlBlock tRAMControlBlock) {
        this.tramblk = tRAMControlBlock;
        this.db = new Vector();
        this.retxDb = new Vector();
    }

    public PacketDb(TRAMControlBlock tRAMControlBlock, int n) {
        this.tramblk = tRAMControlBlock;
        this.capacity = n;
        this.db = new Vector();
        this.retxDb = new Vector();
    }

    public synchronized TRAMPacket getPacket() {
        TRAMPacket tRAMPacket = null;
        while (!this.shutdown) {
            if (!this.inbound && this.retxDb.size() > 0) {
                tRAMPacket = (TRAMPacket)this.retxDb.firstElement();
                this.retxDb.removeElementAt(0);
                this.dataSize -= (long)tRAMPacket.getLength();
                this.notify();
                return tRAMPacket;
            }
            try {
                tRAMPacket = (TRAMPacket)this.db.firstElement();
                this.db.removeElementAt(0);
                this.dataSize -= (long)tRAMPacket.getLength();
                this.notifyAll();
                return tRAMPacket;
            }
            catch (NoSuchElementException noSuchElementException) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        tRAMPacket = null;
        return tRAMPacket;
    }

    public synchronized TRAMPacket getPacketWithNoBlocking() throws NoSuchElementException {
        TRAMPacket tRAMPacket = null;
        if (!this.inbound && this.retxDb.size() > 0) {
            tRAMPacket = (TRAMPacket)this.retxDb.firstElement();
            this.retxDb.removeElementAt(0);
        }
        if (tRAMPacket == null) {
            tRAMPacket = (TRAMPacket)this.db.firstElement();
            this.db.removeElementAt(0);
        }
        this.dataSize -= (long)tRAMPacket.getLength();
        this.notifyAll();
        return tRAMPacket;
    }

    public synchronized void terminate() {
        this.shutdown = true;
        this.notifyAll();
    }

    public TRAMDataPacket getPacket(long l) throws NoSuchElementException {
        return this.getPacket(l, false);
    }

    public synchronized TRAMDataPacket getPacket(long l, boolean bl) throws NoSuchElementException {
        TRAMDataPacket tRAMDataPacket = null;
        if (!this.inbound) {
            tRAMDataPacket = (TRAMDataPacket)this.findPacket(this.retxDb, l);
        }
        if (tRAMDataPacket != null) {
            if (!bl) {
                this.retxDb.removeElement(tRAMDataPacket);
            }
        } else {
            tRAMDataPacket = (TRAMDataPacket)this.findPacket(this.db, l);
            if (tRAMDataPacket == null) {
                throw new NoSuchElementException();
            }
            if (!bl) {
                this.db.removeElement(tRAMDataPacket);
                this.dataSize -= (long)tRAMDataPacket.getLength();
            }
        }
        this.notifyAll();
        return tRAMDataPacket;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void putPacket(TRAMPacket var1_1) {
        if (this.inbound || var1_1.getMessageType() != 2 || var1_1.getSubType() != 2) ** GOTO lbl11
        this.retxDb.addElement(var1_1);
        this.dataSize += (long)var1_1.getLength();
        this.notify();
        return;
lbl-1000:
        // 1 sources

        {
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException var2_2) {
                // empty catch block
            }
lbl11:
            // 3 sources

            ** while (this.capacity != 0 && this.db.size() > this.capacity)
        }
lbl12:
        // 1 sources

        this.db.addElement(var1_1);
        this.dataSize += (long)var1_1.getLength();
        this.notify();
    }

    public synchronized void putPacket(TRAMPacket tRAMPacket, boolean bl) {
        if (!this.inbound && tRAMPacket.getMessageType() == 2 && tRAMPacket.getSubType() == 2) {
            this.retxDb.addElement(tRAMPacket);
            this.dataSize += (long)tRAMPacket.getLength();
            this.notify();
            return;
        }
        if (bl) {
            this.db.addElement(tRAMPacket);
        } else {
            if (this.capacity != 0 && this.db.size() > this.capacity) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.db.addElement(tRAMPacket);
        }
        this.dataSize += (long)tRAMPacket.getLength();
        this.notify();
    }

    public synchronized void removePacket(long l) throws NoSuchElementException {
        TRAMDataPacket tRAMDataPacket = this.getPacket(l);
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public int getPacketCount() {
        if (!this.inbound) {
            return this.db.size() + this.retxDb.size();
        }
        return this.db.size();
    }

    private TRAMPacket findPacket(Vector vector, long l) {
        TRAMPacket tRAMPacket = null;
        int n = 0;
        while (n < vector.size()) {
            try {
                tRAMPacket = (TRAMPacket)vector.elementAt(n);
                if (tRAMPacket.getMessageType() == 2 && (long)((TRAMDataPacket)tRAMPacket).getSequenceNumber() == l) {
                    return tRAMPacket;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++n;
        }
        return null;
    }

    public int getLowestSeqNumber() {
        TRAMSeqNumber tRAMSeqNumber = null;
        TRAMPacket tRAMPacket = null;
        boolean bl = false;
        int n = 0;
        while (n < this.db.size()) {
            try {
                tRAMPacket = (TRAMPacket)this.db.elementAt(n);
                if (tRAMPacket.getMessageType() == 2) {
                    int n2 = ((TRAMDataPacket)tRAMPacket).getSequenceNumber();
                    if (!bl) {
                        tRAMSeqNumber = new TRAMSeqNumber(n2);
                        bl = true;
                    } else if (tRAMSeqNumber.compareSeqNumber(n2) > 0) {
                        tRAMSeqNumber = new TRAMSeqNumber(n2);
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++n;
        }
        if (!bl) {
            return 0;
        }
        return tRAMSeqNumber.getSeqNumber();
    }

    public int getHighestSeqNumber() {
        TRAMSeqNumber tRAMSeqNumber = null;
        TRAMPacket tRAMPacket = null;
        boolean bl = false;
        int n = 0;
        while (n < this.db.size()) {
            try {
                tRAMPacket = (TRAMPacket)this.db.elementAt(n);
                if (tRAMPacket.getMessageType() == 2) {
                    int n2 = ((TRAMDataPacket)tRAMPacket).getSequenceNumber();
                    if (!bl) {
                        tRAMSeqNumber = new TRAMSeqNumber(n2);
                        bl = true;
                    } else if (tRAMSeqNumber.compareSeqNumber(n2) < 0) {
                        tRAMSeqNumber = new TRAMSeqNumber(n2);
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++n;
        }
        if (!bl) {
            return 0;
        }
        return tRAMSeqNumber.getSeqNumber();
    }

    public boolean getInbound() {
        return this.inbound;
    }

    public void setInbound(boolean bl) {
        this.inbound = bl;
    }

    public int getRetxDbSize() {
        return this.retxDb.size();
    }
}

