/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.PacketDb;
import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacket;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMLogger;
import com.sun.multicast.reliable.transport.tram.TRAMPacket;
import com.sun.multicast.reliable.transport.tram.TRAMRateAdjuster;
import com.sun.multicast.reliable.transport.tram.TRAMStats;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.util.Vector;

class OutputDispThread
extends Thread {
    private TRAMControlBlock tramblk;
    private TRAMTransportProfile tp;
    private TRAMStats tramStats;
    private TRAMRateAdjuster rateAdjuster;
    private TRAMLogger logger;
    private MulticastSocket ms;
    private static final String name = "TRAM OutputDispThread";
    private PacketDb packetDB;
    private long lastPktSentTime;
    private Vector sentPktListeners;
    private long prevData;
    private long prevRetr;
    private long sendStart;
    private boolean done;

    public OutputDispThread(TRAMControlBlock tRAMControlBlock) {
        block5: {
            super(name);
            this.ms = null;
            this.lastPktSentTime = 0L;
            this.sentPktListeners = new Vector();
            this.prevData = 0L;
            this.prevRetr = 0L;
            this.sendStart = 0L;
            this.done = false;
            this.tramblk = tRAMControlBlock;
            this.tp = tRAMControlBlock.getTransportProfile();
            this.tramStats = tRAMControlBlock.getTRAMStats();
            this.logger = tRAMControlBlock.getLogger();
            this.rateAdjuster = tRAMControlBlock.getRateAdjuster();
            if (tRAMControlBlock.getSimulator() == null) {
                try {
                    this.ms = tRAMControlBlock.newMulticastSocket();
                    try {
                        this.ms.setTimeToLive(this.tp.getTTL());
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        this.ms.setTTL(this.tp.getTTL());
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    if (!this.logger.requiresLogging(1023)) break block5;
                    this.logger.putPacketln(this, "Unable to open Multicast socket");
                }
            }
        }
        this.packetDB = null;
        this.setDaemon(true);
        this.start();
    }

    public void run() {
        if (this.packetDB == null) {
            this.stall();
        }
        long l = 0L;
        block8: while (!this.done) {
            boolean bl = false;
            long l2 = System.currentTimeMillis();
            TRAMPacket tRAMPacket = this.packetDB.getPacket();
            if (tRAMPacket == null) continue;
            this.sendStart = System.currentTimeMillis();
            long l3 = this.sendStart - l2;
            l = l3 >= l ? 0L : (l -= l3);
            byte by = (byte)tRAMPacket.getSubType();
            int n = ((TRAMDataPacket)tRAMPacket).getSequenceNumber();
            switch (by) {
                case 1: {
                    if (this.logger.requiresLogging(71)) {
                        this.logger.putPacketln(this, "Sending Data packet " + ((TRAMDataPacket)tRAMPacket).getSequenceNumber() + " and size = " + tRAMPacket.getLength());
                    }
                    TRAMDataPacketEvent tRAMDataPacketEvent = new TRAMDataPacketEvent(this, (TRAMDataPacket)tRAMPacket);
                    this.notifyTRAMDataPacketEvent(tRAMDataPacketEvent);
                    this.rateAdjuster.adjustRate((TRAMDataPacket)tRAMPacket);
                    break;
                }
                case 2: {
                    if (this.logger.requiresLogging(71)) {
                        this.logger.putPacketln(this, "Sending Retxm packet " + ((TRAMDataPacket)tRAMPacket).getSequenceNumber() + " and size = " + tRAMPacket.getLength() + " rate " + this.rateAdjuster.getOpenWindowDataRate());
                    }
                    this.tramStats.incRetransSent();
                    this.tramStats.addBytesReSent(tRAMPacket.getLength());
                    bl = true;
                    if (!this.logger.requiresLogging(71)) break;
                    this.logger.putPacketln(this, "rate " + this.rateAdjuster.getActualDataRate(n) + " retrans rate " + this.rateAdjuster.getOpenWindowDataRate() + " seq " + n);
                    break;
                }
                default: {
                    if (!this.logger.requiresLogging(7)) continue block8;
                    this.logger.putPacketln(this, "Sending bad packet type " + by);
                    continue block8;
                }
            }
            ((TRAMDataPacket)tRAMPacket).setAckWindow(this.tp.getAckWindow());
            ((TRAMDataPacket)tRAMPacket).setLastTransmitTime(System.currentTimeMillis());
            ((TRAMDataPacket)tRAMPacket).setDataRate((int)this.rateAdjuster.getOpenWindowDataRate());
            ((TRAMDataPacket)tRAMPacket).setHaInterval(this.tramblk.getGroupMgmtThread().getDataHaInterval());
            if ((((TRAMDataPacket)tRAMPacket).getFlags() & 1) != 0 && this.logger.requiresLogging(16)) {
                this.logger.putPacketln(this, "Sending packet with FLAGBIT_PRUNE set!");
            }
            DatagramPacket datagramPacket = tRAMPacket.createDatagramPacket();
            if (this.tramblk.getSimulator() != null) {
                this.tramblk.getSimulator().simulateMulticastData(datagramPacket, this.tramblk.getTransportProfile().getTTL());
            } else {
                try {
                    this.ms.send(datagramPacket);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            tRAMPacket.setTransmitPending(false);
            if (!bl || this.tp.getTmode() == 2) {
                this.lastPktSentTime = System.currentTimeMillis();
            }
            if (this.tramStats.getDataStartTime() == 0L) {
                this.tramStats.setDataStartTime(System.currentTimeMillis());
            }
            long l4 = bl ? this.rateAdjuster.getOpenWindowDataRate() : this.rateAdjuster.getActualDataRate(n);
            long l5 = this.computeRate(datagramPacket.getLength(), l4);
            if (l > l5) {
                l -= l5;
                continue;
            }
            l5 -= l;
            l = 0L;
            if (l5 == 0L) continue;
            if (l5 > 1000L) {
                if (this.logger.requiresLogging(71)) {
                    this.logger.putPacketln(this, "time to sleep is " + l5 + " seq " + n);
                }
                l5 = 1000L;
            }
            try {
                Thread.sleep(l5);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l = System.currentTimeMillis() - this.sendStart - l5;
            if (l >= 0L) continue;
            l = 0L;
        }
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Thread Exit!!");
        }
    }

    public long computeRate(int n, long l) {
        if (l != 0L) {
            return (long)(n * 1000) / l;
        }
        return 0L;
    }

    public void setPacketDB(PacketDb packetDb) {
        if (this.packetDB == null) {
            this.packetDB = packetDb;
            this.wake();
        }
    }

    public long getLastPktSentTime() {
        return this.lastPktSentTime;
    }

    public synchronized void addTRAMDataPacketListener(TRAMDataPacketListener tRAMDataPacketListener) {
        this.sentPktListeners.addElement(tRAMDataPacketListener);
    }

    public synchronized void removeTRAMDataPacketListener(TRAMDataPacketListener tRAMDataPacketListener) {
        this.sentPktListeners.removeElement(tRAMDataPacketListener);
    }

    public void notifyTRAMDataPacketEvent(TRAMDataPacketEvent tRAMDataPacketEvent) {
        Vector vector = this.sentPktListeners;
        synchronized (vector) {
            TRAMDataPacket tRAMDataPacket = tRAMDataPacketEvent.getPacket();
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Sending Receive notify for Packet " + tRAMDataPacket.getSequenceNumber() + " listeners = " + this.sentPktListeners.size());
            }
            int n = 0;
            while (n < this.sentPktListeners.size()) {
                ((TRAMDataPacketListener)this.sentPktListeners.elementAt(n)).receiveDataPacket(tRAMDataPacketEvent);
                ++n;
            }
        }
    }

    private synchronized void stall() {
        block2: {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                if (this.done) break block2;
                interruptedException.printStackTrace();
            }
        }
    }

    private synchronized void wake() {
        this.notify();
    }

    public synchronized void terminate() {
        this.done = true;
        this.wake();
        this.interrupt();
        if (this.packetDB != null) {
            this.packetDB.terminate();
        }
    }
}

