/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMDataCache;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacket;
import com.sun.multicast.reliable.transport.tram.TRAMLogger;
import com.sun.multicast.reliable.transport.tram.TRAMPacketHandler;
import com.sun.multicast.reliable.transport.tram.TRAMSeqNumber;

class OrderedPacketHandler
implements TRAMPacketHandler {
    TRAMDataCache dataCache;
    TRAMSeqNumber nextPacket;
    TRAMControlBlock tramblk = null;
    TRAMLogger logger = null;

    public void setSeqNumber(int n) {
        this.nextPacket.setSeqNumber(n);
    }

    public OrderedPacketHandler(TRAMControlBlock tRAMControlBlock, TRAMDataCache tRAMDataCache, int n) {
        this.nextPacket = new TRAMSeqNumber(n);
        this.dataCache = tRAMDataCache;
        this.tramblk = tRAMControlBlock;
        this.logger = tRAMControlBlock.getLogger();
    }

    public void newPacket(TRAMDataPacket tRAMDataPacket) {
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "newPacket.  pk seq " + tRAMDataPacket.getSequenceNumber() + " nextPacket " + this.nextPacket.getSeqNumber());
        }
        if (this.nextPacket.isEqualTo(tRAMDataPacket.getSequenceNumber())) {
            int n = this.dataCache.notifyInSequenceTRAMDataPacketEvents(tRAMDataPacket);
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "newPacket. next is " + n);
            }
            this.nextPacket.setSeqNumber(n);
        } else if (this.nextPacket.isGreaterThan(tRAMDataPacket.getSequenceNumber()) && this.logger.requiresLogging(263)) {
            this.logger.putPacketln(this, "Packet " + tRAMDataPacket.getSequenceNumber() + "Has already been been forwarded!!!");
        }
    }

    public void reportException(byte by) {
        TRAMDataPacket tRAMDataPacket = new TRAMDataPacket(this.tramblk);
        tRAMDataPacket.setSequenceNumber(this.nextPacket.getSeqNumber());
        tRAMDataPacket.setFlags(by);
        this.dataCache.notifyInSequenceTRAMDataPacketEvents(tRAMDataPacket);
    }
}

