/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import java.net.InetAddress;

class MemberBlock {
    private InetAddress address = null;
    private int port = 0;
    private byte mrole = 1;
    private byte cstate = 1;
    private byte hstate = 1;
    private long lastheard = 0L;
    private int dmemCount = 0;
    private int indmemCount = 0;
    private int AdvertmemCount = 0;
    private int memberId;
    private int missedAcks = 0;
    private long rtt = 0L;
    private byte ttl = 0;
    private int lastPacketAcked = 0;
    private boolean demandAck = false;
    private int highestSequenceAllowed;
    private int flowControlInfo;
    private boolean subTreeFlowControlInfo = true;

    public MemberBlock(InetAddress inetAddress, int n, int n2) {
        this.address = inetAddress;
        this.port = n;
        this.memberId = n2;
    }

    public MemberBlock(InetAddress inetAddress, int n) {
        this.address = inetAddress;
        this.port = n;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public byte getMrole() {
        return this.mrole;
    }

    public int getHstate() {
        return this.hstate & 0xFF;
    }

    public byte getCstate() {
        return this.cstate;
    }

    public long getLastheard() {
        return this.lastheard;
    }

    public int getDmemCount() {
        return this.dmemCount;
    }

    public int getAdvertmemCount() {
        return this.AdvertmemCount;
    }

    public int getIndmemCount() {
        return this.indmemCount;
    }

    public int getMemberId() {
        return this.memberId;
    }

    public long getRTT() {
        return this.rtt;
    }

    public byte getTTL() {
        return this.ttl;
    }

    public int getLastPacketAcked() {
        return this.lastPacketAcked;
    }

    public void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setMrole(byte by) {
        this.mrole = by;
    }

    public void setCstate(byte by) {
        this.cstate = by;
    }

    public void setHstate(int n) {
        this.hstate = (byte)(n & 0xFF);
    }

    public void setLastheard(long l) {
        this.lastheard = l;
    }

    public void setDmemCount(int n) {
        this.dmemCount = n;
    }

    public void setAdvertmemCount(int n) {
        this.AdvertmemCount = n;
    }

    public void setIndmemCount(int n) {
        this.indmemCount = n;
    }

    public void setMemberId(int n) {
        this.memberId = n;
    }

    public void setRTT(long l) {
        this.rtt = l;
    }

    public void setTTL(byte by) {
        this.ttl = by;
    }

    public void setLastPacketAcked(int n) {
        this.lastPacketAcked = n;
    }

    public synchronized boolean getDemandAck() {
        return this.demandAck;
    }

    public synchronized void setDemandAck(boolean bl) {
        this.demandAck = bl;
    }

    public int getMissedAcks() {
        return this.missedAcks;
    }

    public synchronized void clearMissedAcks() {
        this.missedAcks = 0;
    }

    public synchronized int incrMissedAcks() {
        ++this.missedAcks;
        return this.missedAcks;
    }

    public void setHighestSequenceAllowed(int n) {
        if (n > this.highestSequenceAllowed) {
            this.highestSequenceAllowed = n;
        }
    }

    public int getHighestSequenceAllowed() {
        return this.highestSequenceAllowed;
    }

    public void setFlowControlInfo(int n) {
        this.flowControlInfo = n;
    }

    public int getFlowControlInfo() {
        return this.flowControlInfo;
    }

    public void setSubTreeFlowControlInfo(boolean bl) {
        this.subTreeFlowControlInfo = bl;
    }

    public boolean getSubTreeFlowControlInfo() {
        return this.subTreeFlowControlInfo;
    }
}

