/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.authentication.AuthenticationModule;
import com.sun.multicast.reliable.transport.tram.AbortTRAM;
import com.sun.multicast.reliable.transport.tram.BeaconPacket;
import com.sun.multicast.reliable.transport.tram.BeaconPacketEvent;
import com.sun.multicast.reliable.transport.tram.BeaconPacketListener;
import com.sun.multicast.reliable.transport.tram.SUBMESGTYPE;
import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacket;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMHaPacket;
import com.sun.multicast.reliable.transport.tram.TRAMHaPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMHaPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMHelloPacket;
import com.sun.multicast.reliable.transport.tram.TRAMHelloPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMHelloPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMLogger;
import com.sun.multicast.reliable.transport.tram.TRAMLoggingOptionPacket;
import com.sun.multicast.reliable.transport.tram.TRAMMsPacket;
import com.sun.multicast.reliable.transport.tram.TRAMMsPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMMsPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMPacket;
import com.sun.multicast.reliable.transport.tram.TRAMStats;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.security.KeyException;
import java.security.SignatureException;
import java.util.Vector;

class InputDispThread
extends Thread
implements TRAMDataPacketListener {
    private TRAMControlBlock tramblk = null;
    private TRAMLogger logger;
    private TRAMStats tramStats = null;
    private TRAMTransportProfile tp;
    private static final String name = "TRAM InputDispThread";
    private Vector dataListeners = new Vector();
    private Vector beaconListeners = new Vector();
    private Vector msListeners = new Vector();
    private Vector haListeners = new Vector();
    private Vector helloListeners = new Vector();
    private boolean done = false;
    private boolean idreset = true;

    public InputDispThread(TRAMControlBlock tRAMControlBlock) {
        super(name);
        this.setDaemon(true);
        this.tramblk = tRAMControlBlock;
        this.logger = tRAMControlBlock.getLogger();
        this.tramStats = tRAMControlBlock.getTRAMStats();
        this.tp = tRAMControlBlock.getTransportProfile();
        if (this.tp.getTmode() != 2) {
            tRAMControlBlock.getOutputDispThread().addTRAMDataPacketListener(this);
        }
        this.start();
    }

    public void run() {
        if (this.tramblk.getSimulator() == null) {
            MulticastSocket multicastSocket = this.tramblk.getMulticastSocket();
            while (!this.done) {
                try {
                    byte[] byArray = new byte[this.tp.getMaxBuf()];
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, this.tp.getMaxBuf());
                    if (datagramPacket == null) continue;
                    multicastSocket.receive(datagramPacket);
                    this.dispatchPacket(datagramPacket);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    outOfMemoryError.printStackTrace();
                    this.printDataCounts();
                }
                catch (Exception exception) {
                    if (this.done) continue;
                    exception.printStackTrace();
                }
            }
        }
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Input Dispatcher exiting !");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dispatchPacket(DatagramPacket datagramPacket) {
        if (TRAMPacket.getVersionNumber(datagramPacket) != 2) {
            if (!this.logger.requiresLogging(247)) return;
            this.logger.putPacketln(this, "Dropping packet due to Version# mismatch. Expect 2 Got " + TRAMPacket.getVersionNumber(datagramPacket));
            return;
        }
        int n = this.tramblk.getSessionId();
        if (n == 0) {
            this.idreset = false;
        } else {
            int n2 = TRAMPacket.getId(datagramPacket);
            if (n2 != n) {
                if (TRAMPacket.getMessageType(datagramPacket) != 1 || TRAMPacket.getSubType(datagramPacket) != 90) {
                    if (!this.logger.requiresLogging(16)) return;
                    this.logger.putPacketln(this, "Dropping packet from " + datagramPacket.getAddress() + " " + SUBMESGTYPE.toString(TRAMPacket.getMessageType(datagramPacket), TRAMPacket.getSubType(datagramPacket)) + " with id " + n2 + " actual session id is " + n);
                    return;
                }
            } else if (!this.idreset) {
                this.idreset = true;
                if (this.logger.requiresLogging(3)) {
                    this.logger.putPacketln(this, "sessionId = " + n);
                }
            }
        }
        switch (TRAMPacket.getMessageType(datagramPacket)) {
            case 1: {
                switch (TRAMPacket.getSubType(datagramPacket)) {
                    case 1: {
                        if (this.logger.requiresLogging(39)) {
                            this.logger.putPacketln(this, "Got a Beacon Packet from " + datagramPacket.getAddress());
                        }
                        try {
                            BeaconPacket beaconPacket = new BeaconPacket(datagramPacket);
                            if (this.signatureVerifies(beaconPacket)) {
                                BeaconPacketEvent beaconPacketEvent = new BeaconPacketEvent(this, beaconPacket);
                                this.notifyBeaconPacketEvent(beaconPacketEvent);
                                this.updateSenderLiveliness(beaconPacket);
                                this.tramblk.setLastKnownForgetBeforeSeqNum(beaconPacket.getForgetBeforeSeqNum());
                                if (!this.logger.requiresLogging(71)) return;
                                this.logger.putPacketln(this, "Got Beacon message: Sequence# " + beaconPacket.getSeqNumber() + " ForgetBeforeSeq# " + beaconPacket.getForgetBeforeSeqNum());
                                return;
                            }
                            if (!this.logger.requiresLogging(547)) return;
                            this.logger.putPacketln(this, "Discarding Beacon: Signature Does not verify!");
                            return;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            if (!this.logger.requiresLogging(35)) return;
                            this.logger.putPacketln(this, "Error in parsing the received Beacon packet");
                            return;
                        }
                    }
                    case 4: {
                        if (this.logger.requiresLogging(39)) {
                            this.logger.putPacketln(this, "Got an MS packet from " + datagramPacket.getAddress());
                        }
                        try {
                            TRAMMsPacket tRAMMsPacket = new TRAMMsPacket(datagramPacket);
                            TRAMMsPacketEvent tRAMMsPacketEvent = new TRAMMsPacketEvent(this, tRAMMsPacket);
                            this.notifyTRAMMsPacketEvent(tRAMMsPacketEvent);
                            return;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            if (!this.logger.requiresLogging(35)) return;
                            this.logger.putPacketln(this, exception.toString());
                            return;
                        }
                    }
                    case 3: {
                        if (this.logger.requiresLogging(39)) {
                            this.logger.putPacketln(this, "Got an HA packet from " + datagramPacket.getAddress());
                        }
                        try {
                            TRAMHaPacket tRAMHaPacket = new TRAMHaPacket(datagramPacket);
                            TRAMHaPacketEvent tRAMHaPacketEvent = new TRAMHaPacketEvent(this, tRAMHaPacket);
                            this.notifyTRAMHaPacketEvent(tRAMHaPacketEvent);
                            return;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            if (!this.logger.requiresLogging(35)) return;
                            this.logger.putPacketln(this, exception.toString());
                            return;
                        }
                    }
                    case 2: {
                        if (this.logger.requiresLogging(55)) {
                            this.logger.putPacketln(this, "Got a Hello packet from " + datagramPacket.getAddress());
                        }
                        try {
                            TRAMHelloPacket tRAMHelloPacket = new TRAMHelloPacket(datagramPacket);
                            TRAMHelloPacketEvent tRAMHelloPacketEvent = new TRAMHelloPacketEvent(this, tRAMHelloPacket);
                            this.notifyTRAMHelloPacketEvent(tRAMHelloPacketEvent);
                            return;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            if (!this.logger.requiresLogging(35)) return;
                            this.logger.putPacketln(this, exception.toString());
                            return;
                        }
                    }
                    case 90: {
                        InetAddress[] inetAddressArray;
                        TRAMLoggingOptionPacket tRAMLoggingOptionPacket = new TRAMLoggingOptionPacket(datagramPacket);
                        if ((tRAMLoggingOptionPacket.getFlags() & 2) == 0) {
                            inetAddressArray = this.tramblk.getTransportProfile().getDataSourceAddress();
                            if (this.tramblk.getSessionId() != TRAMPacket.getId(datagramPacket)) return;
                            if (!inetAddressArray.equals(tRAMLoggingOptionPacket.getAddress())) {
                                return;
                            }
                        }
                        if ((tRAMLoggingOptionPacket.getFlags() & 1) == 0) {
                            inetAddressArray = tRAMLoggingOptionPacket.getAddressList();
                            if (inetAddressArray == null) {
                                return;
                            }
                            InetAddress inetAddress = null;
                            inetAddress = this.tramblk.getLocalHost();
                            boolean bl = false;
                            int n3 = 0;
                            while (n3 < inetAddressArray.length) {
                                if (inetAddressArray[n3].equals(inetAddress)) {
                                    bl = true;
                                    break;
                                }
                                ++n3;
                            }
                            if (!bl) {
                                return;
                            }
                        }
                        if (this.logger.requiresLogging(35)) {
                            this.logger.putPacketln(this, "Got a LoggingOptionPacket. From " + tRAMLoggingOptionPacket.getAddress() + " New LogOption value is " + tRAMLoggingOptionPacket.getLogOption());
                        }
                        if ((tRAMLoggingOptionPacket.getLogOption() & Integer.MIN_VALUE) != 0) {
                            this.logger.putPacketln(this, "Abort requested by CHANGE_LOG_OPTION LOG_ABORT_TRAM");
                            this.tramblk.getTRAMDataCache().handleSessionDown();
                            new AbortTRAM("LOG_ABORT_TRAM", this.tramblk);
                        }
                        this.tp.setLogMask(tRAMLoggingOptionPacket.getLogOption());
                        if ((tRAMLoggingOptionPacket.getLogOption() & 0x400) != 0) {
                            this.tramblk.getRateAdjuster().startPerfMon();
                            return;
                        }
                        this.tramblk.getRateAdjuster().stopPerfMon();
                    }
                }
                return;
            }
            case 2: {
                switch (TRAMPacket.getSubType(datagramPacket)) {
                    case 1: 
                    case 2: {
                        TRAMDataPacket tRAMDataPacket = new TRAMDataPacket(datagramPacket);
                        if (this.tramStats.getDataStartTime() == 0L) {
                            this.tramStats.setDataStartTime(System.currentTimeMillis());
                        }
                        if (TRAMPacket.getSubType(datagramPacket) == 1) {
                            this.tramStats.incPacketsRcvd();
                        }
                        if (this.tp.getTmode() != 2) return;
                        try {
                            if (!this.signatureVerifies(tRAMDataPacket)) {
                                if (!this.logger.requiresLogging(67)) return;
                                this.logger.putPacketln(this, "Signature Verification Fails");
                                return;
                            }
                            String string = "";
                            if (TRAMPacket.getSubType(datagramPacket) != 1) {
                                string = "RETXM ";
                            }
                            if (this.logger.requiresLogging(71)) {
                                this.logger.putPacketln(this, "Got " + string + "data packet with Seq# " + tRAMDataPacket.getSequenceNumber() + " forgetBeforeSeq# " + tRAMDataPacket.getForgetBeforeSeqNum() + ", Rate " + tRAMDataPacket.getDataRate());
                            }
                            TRAMDataPacketEvent tRAMDataPacketEvent = new TRAMDataPacketEvent(this, tRAMDataPacket);
                            this.notifyTRAMDataPacketEvent(tRAMDataPacketEvent);
                            if (2 == (byte)tRAMDataPacket.getSubType()) return;
                            this.updateSenderLiveliness(tRAMDataPacket);
                            return;
                        }
                        catch (Exception exception) {
                            if (this.logger.requiresLogging(87)) {
                                this.logger.putPacketln(this, "InputDispatcher: Dropping Data Packet " + tRAMDataPacket.getSequenceNumber());
                            }
                            exception.printStackTrace();
                        }
                    }
                }
                return;
            }
        }
        if (!this.logger.requiresLogging(99)) return;
        this.logger.putPacketln(this, "Got an Unsupported message Type" + TRAMPacket.getMessageType(datagramPacket));
    }

    public synchronized void receiveDataPacket(TRAMDataPacketEvent tRAMDataPacketEvent) {
        TRAMDataPacket tRAMDataPacket = tRAMDataPacketEvent.getPacket();
        TRAMDataPacketEvent tRAMDataPacketEvent2 = new TRAMDataPacketEvent(this, tRAMDataPacket);
        if (this.signatureVerifies(tRAMDataPacket)) {
            this.tramblk.setLastKnownForgetBeforeSeqNum(tRAMDataPacket.getForgetBeforeSeqNum());
            this.notifyTRAMDataPacketEvent(tRAMDataPacketEvent2);
        } else if (this.logger.requiresLogging(1023)) {
            this.logger.putPacketln(this, "My own Signature Fails!!");
        }
    }

    public synchronized void addTRAMDataPacketListener(TRAMDataPacketListener tRAMDataPacketListener) {
        this.dataListeners.addElement(tRAMDataPacketListener);
    }

    public synchronized void removeTRAMDataPacketListener(TRAMDataPacketListener tRAMDataPacketListener) {
        this.dataListeners.removeElement(tRAMDataPacketListener);
    }

    public void printDataCounts() {
        int n = 0;
        while (n < this.dataListeners.size()) {
            TRAMDataPacketListener tRAMDataPacketListener = (TRAMDataPacketListener)this.dataListeners.elementAt(n);
            tRAMDataPacketListener.printDataCounts();
            ++n;
        }
    }

    public void notifyTRAMDataPacketEvent(TRAMDataPacketEvent tRAMDataPacketEvent) {
        if (this.tp.getReceiverMaxDataRate() > 0L && this.tramblk.getRateAdjuster().getAverageDataRate() > (long)(1.07 * (double)this.tp.getReceiverMaxDataRate()) && Math.random() < 0.3) {
            this.tramblk.getRateAdjuster().calculateAverageDataRate();
            if (this.logger.requiresLogging(23)) {
                this.logger.putPacketln(this, "Dropping packet " + tRAMDataPacketEvent.getPacket().getSequenceNumber() + " to lower average rate of " + this.tramblk.getRateAdjuster().getAverageDataRate() + " to " + this.tp.getReceiverMaxDataRate());
            }
            return;
        }
        this.tramblk.setLastKnownForgetBeforeSeqNum(tRAMDataPacketEvent.getPacket().getForgetBeforeSeqNum());
        this.tramblk.setLastKnownSequenceNumber(tRAMDataPacketEvent.getPacket().getSequenceNumber());
        TRAMDataPacketListener tRAMDataPacketListener = null;
        Vector vector = this.dataListeners;
        synchronized (vector) {
            int n = 0;
            while (n < this.dataListeners.size()) {
                tRAMDataPacketListener = (TRAMDataPacketListener)this.dataListeners.elementAt(n);
                tRAMDataPacketListener.receiveDataPacket(tRAMDataPacketEvent);
                ++n;
            }
        }
    }

    public synchronized void addTRAMHaPacketListener(TRAMHaPacketListener tRAMHaPacketListener) {
        this.haListeners.addElement(tRAMHaPacketListener);
    }

    public synchronized void removeTRAMHaPacketListener(TRAMHaPacketListener tRAMHaPacketListener) {
        this.haListeners.removeElement(tRAMHaPacketListener);
    }

    public void notifyTRAMHaPacketEvent(TRAMHaPacketEvent tRAMHaPacketEvent) {
        Vector vector;
        InputDispThread inputDispThread = this;
        synchronized (inputDispThread) {
            vector = (Vector)this.haListeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            ((TRAMHaPacketListener)vector.elementAt(n)).receiveTRAMHaPacket(tRAMHaPacketEvent);
            ++n;
        }
    }

    public void addBeaconPacketListener(BeaconPacketListener beaconPacketListener) {
        Vector vector = this.beaconListeners;
        synchronized (vector) {
            this.beaconListeners.addElement(beaconPacketListener);
        }
    }

    public void removeBeaconPacketListener(BeaconPacketListener beaconPacketListener) {
        Vector vector = this.beaconListeners;
        synchronized (vector) {
            this.beaconListeners.removeElement(beaconPacketListener);
        }
    }

    public void notifyBeaconPacketEvent(BeaconPacketEvent beaconPacketEvent) {
        Vector vector = this.beaconListeners;
        synchronized (vector) {
            Vector vector2 = this.beaconListeners;
            int n = 0;
            while (n < vector2.size()) {
                ((BeaconPacketListener)vector2.elementAt(n)).receiveBeaconPacket(beaconPacketEvent);
                ++n;
            }
        }
    }

    public void addTRAMHelloPacketListener(TRAMHelloPacketListener tRAMHelloPacketListener) {
        Vector vector = this.helloListeners;
        synchronized (vector) {
            this.helloListeners.addElement(tRAMHelloPacketListener);
        }
    }

    public void removeTRAMHelloPacketListener(TRAMHelloPacketListener tRAMHelloPacketListener) {
        Vector vector = this.helloListeners;
        synchronized (vector) {
            this.helloListeners.removeElement(tRAMHelloPacketListener);
        }
    }

    public void notifyTRAMHelloPacketEvent(TRAMHelloPacketEvent tRAMHelloPacketEvent) {
        Vector vector = this.helloListeners;
        synchronized (vector) {
            Vector vector2 = this.helloListeners;
            int n = 0;
            while (n < vector2.size()) {
                ((TRAMHelloPacketListener)vector2.elementAt(n)).receiveTRAMHelloPacket(tRAMHelloPacketEvent);
                ++n;
            }
        }
    }

    public void addTRAMMsPacketListener(TRAMMsPacketListener tRAMMsPacketListener) {
        Vector vector = this.msListeners;
        synchronized (vector) {
            this.msListeners.addElement(tRAMMsPacketListener);
        }
    }

    public void removeTRAMMsPacketListener(TRAMMsPacketListener tRAMMsPacketListener) {
        Vector vector = this.msListeners;
        synchronized (vector) {
            this.msListeners.removeElement(tRAMMsPacketListener);
        }
    }

    public void notifyTRAMMsPacketEvent(TRAMMsPacketEvent tRAMMsPacketEvent) {
        Vector vector = this.msListeners;
        synchronized (vector) {
            Vector vector2 = this.msListeners;
            int n = 0;
            while (n < vector2.size()) {
                ((TRAMMsPacketListener)vector2.elementAt(n)).receiveTRAMMsPacket(tRAMMsPacketEvent);
                ++n;
            }
        }
    }

    private void updateSenderLiveliness(TRAMPacket tRAMPacket) {
        InetAddress inetAddress = this.tramblk.getTransportProfile().getDataSourceAddress();
        if (inetAddress != null) {
            if (inetAddress.equals(tRAMPacket.getAddress())) {
                this.tramblk.setLastHeardFromTheSender(System.currentTimeMillis());
            } else if (this.logger.requiresLogging(99)) {
                this.logger.putPacketln(this, "Packet not from the sender");
            }
        }
    }

    public void terminate() {
        this.done = true;
    }

    private synchronized boolean signatureVerifies(TRAMPacket tRAMPacket) {
        block13: {
            Object object;
            int n;
            int n2;
            AuthenticationModule authenticationModule = this.tramblk.getAuthenticationModule();
            if (authenticationModule == null) {
                return true;
            }
            short s = 0;
            byte[] byArray = tRAMPacket.getBuffer();
            byte by = 0;
            InetAddress inetAddress = null;
            TRAMDataPacket tRAMDataPacket = null;
            if (tRAMPacket instanceof TRAMDataPacket) {
                tRAMDataPacket = (TRAMDataPacket)tRAMPacket;
                s = tRAMDataPacket.getHaInterval();
                tRAMDataPacket.setHaInterval((short)0);
                by = (byte)tRAMDataPacket.getSubType();
                tRAMDataPacket.setSubType(0);
                int n3 = 38;
                n2 = n3 + tRAMDataPacket.getDataLength();
                n = tRAMDataPacket.getLength() - tRAMDataPacket.getDataLength();
                inetAddress = tRAMDataPacket.getSourceAddress();
            } else if (tRAMPacket instanceof BeaconPacket) {
                int n4;
                object = (BeaconPacket)tRAMPacket;
                n2 = n4 = 24;
                n = ((BeaconPacket)object).getLength();
                inetAddress = ((BeaconPacket)object).getSrcAddress();
            } else {
                if (this.logger.requiresLogging(99)) {
                    this.logger.putPacketln(this, "ERROR: Only Beacon and Data PAckets are signed. Not " + tRAMPacket.getMessageType() + "SubMesg Type " + tRAMPacket.getSubType());
                }
                return false;
            }
            if (n <= 0) {
                if (this.logger.requiresLogging(67)) {
                    this.logger.putPacketln(this, "Malformed packet??? No Signature Found");
                }
                return false;
            }
            object = new byte[n];
            System.arraycopy(byArray, n2, object, 0, n);
            try {
                boolean bl = authenticationModule.verify(byArray, 0, n2, (byte[])object, inetAddress.getHostAddress());
                if (tRAMDataPacket != null) {
                    tRAMDataPacket.setHaInterval(s);
                    tRAMDataPacket.setSubType(by);
                }
                return bl;
            }
            catch (KeyException keyException) {
                if (this.logger.requiresLogging(1023)) {
                    this.logger.putPacketln(this, "Invalid Signature verification Key");
                }
            }
            catch (SignatureException signatureException) {
                if (!this.logger.requiresLogging(1023)) break block13;
                this.logger.putPacketln(this, "Error During Signature verification");
            }
        }
        return false;
    }
}

