/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.GroupMgmtBlk;
import com.sun.multicast.reliable.transport.tram.GroupMgmtThread;
import com.sun.multicast.reliable.transport.tram.HeadBlock;
import com.sun.multicast.reliable.transport.tram.MemberBlock;
import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMGenericDataCache;
import com.sun.multicast.reliable.transport.tram.TRAMHelloPacket;
import com.sun.multicast.reliable.transport.tram.TRAMLogger;
import com.sun.multicast.reliable.transport.tram.TRAMMemberAck;
import com.sun.multicast.reliable.transport.tram.TRAMPacket;
import com.sun.multicast.reliable.transport.tram.TRAMTimer;
import com.sun.multicast.reliable.transport.tram.TRAMTimerEventHandler;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Vector;

class HelloThread
extends Thread
implements TRAMTimerEventHandler {
    private TRAMControlBlock tramblk;
    private static String name = "TRAM HelloThread";
    private Vector pktsToProcess;
    private boolean sendLowestAvailablePktInfo;
    private TRAMTimer timer;
    private TRAMLogger logger;
    private boolean sendHelloFlag;
    private int helloSent;
    private long lastHelloSent;
    private boolean done;
    private MulticastSocket ms;

    public HelloThread(TRAMControlBlock tRAMControlBlock) {
        block3: {
            super(name);
            this.tramblk = null;
            this.pktsToProcess = new Vector(10, 10);
            this.sendLowestAvailablePktInfo = false;
            this.timer = null;
            this.logger = null;
            this.sendHelloFlag = false;
            this.helloSent = 0;
            this.lastHelloSent = 0L;
            this.done = false;
            this.ms = null;
            this.tramblk = tRAMControlBlock;
            this.logger = tRAMControlBlock.getLogger();
            this.timer = new TRAMTimer(name + " Timer", this, this.logger);
            tRAMControlBlock.setHelloThread(this);
            this.setDaemon(true);
            if (tRAMControlBlock.getSimulator() == null) {
                try {
                    this.ms = tRAMControlBlock.newMulticastSocket();
                }
                catch (IOException iOException) {
                    if (!this.logger.requiresLogging(1023)) break block3;
                    this.logger.putPacketln(this, "Unable to open Multicast socket");
                }
            }
        }
        this.start();
    }

    public void run() {
        GroupMgmtBlk groupMgmtBlk = this.tramblk.getGroupMgmtBlk();
        long l = Math.max(3000L, this.tramblk.getAckInterval());
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Initial hello Interval is " + l);
        }
        this.timer.loadTimer(l);
        while (!this.done) {
            if (this.getSendHelloFlag()) {
                this.buildAndDispatchHelloPacket();
                this.setSendHelloFlag(false);
            }
            this.stall();
        }
    }

    private synchronized void stall() {
        block2: {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                if (!this.logger.requiresLogging(3)) break block2;
                this.logger.putPacketln(this, "Interrupted!");
            }
        }
    }

    private synchronized void wake() {
        this.notifyAll();
    }

    private boolean memberHasMissedAcks() {
        GroupMgmtBlk groupMgmtBlk = this.tramblk.getGroupMgmtBlk();
        int n = groupMgmtBlk.getDirectMemberCount();
        int n2 = 0;
        while (n2 < n) {
            try {
                MemberBlock memberBlock = groupMgmtBlk.getMember(n2);
                if (memberBlock.getMissedAcks() > 0) {
                    return true;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                break;
            }
            ++n2;
        }
        return false;
    }

    public void handleTimeout() {
        HeadBlock headBlock;
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "In handleTimeout");
        }
        TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
        long l = Math.max(3000L, this.tramblk.getAckInterval());
        GroupMgmtBlk groupMgmtBlk = this.tramblk.getGroupMgmtBlk();
        if (groupMgmtBlk.getDirectMemberCount() != 0) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Member Count " + groupMgmtBlk.getDirectMemberCount());
            }
            if (this.memberHasMissedAcks()) {
                if (this.logger.requiresLogging(16)) {
                    this.logger.putPacketln(this, "Missed ACk's!");
                }
                if (((TRAMGenericDataCache)this.tramblk.getTRAMDataCache()).aboveHighWaterMark() || this.tramblk.getRateAdjuster().getOpenWindowDataRate() != this.tramblk.getRateAdjuster().getActualDataRate()) {
                    l = tRAMTransportProfile.getPruneHelloRate();
                    if (this.logger.requiresLogging(16)) {
                        this.logger.putPacketln(this, "Using Prune Hello Rate...");
                    }
                }
            }
            this.setSendHelloFlag(true);
            this.wake();
        }
        if ((headBlock = groupMgmtBlk.getHeadBlock()) != null) {
            this.validateHeadsLiveliness(headBlock, false);
        }
        try {
            headBlock = this.tramblk.getGroupMgmtThread().getReAffiliationHead();
            if (headBlock != null) {
                this.validateHeadsLiveliness(headBlock, true);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (tRAMTransportProfile.getTmode() == 2 && !this.tramblk.isDataTransmissionComplete()) {
            this.tramblk.getGroupMgmtThread().validateSenderLiveliness();
        }
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Loading Hello interval as " + l);
        }
        if (!this.done && this.tramblk.getHelloThread() != null) {
            this.timer.loadTimer(l);
        } else {
            this.timer.killTimer();
        }
    }

    public synchronized void reportUnavailablePacket(int n) {
        this.sendLowestAvailablePktInfo = true;
    }

    public void terminate() {
        if (this.logger.requiresLogging(3)) {
            this.logger.putPacketln(this, "Stopping the Hello thread.");
        }
        if (this.timer != null && this.timer.isAlive()) {
            this.timer.stopTimer();
            this.timer.killTimer();
        }
        this.tramblk.setHelloThread(null);
        if (this.tramblk.getSimulator() == null) {
            this.ms.close();
        }
        this.done = true;
        this.interrupt();
    }

    private synchronized boolean getSendHelloFlag() {
        return this.sendHelloFlag;
    }

    private synchronized void setSendHelloFlag(boolean bl) {
        this.sendHelloFlag = bl;
    }

    private void buildAndDispatchHelloPacket() {
        GroupMgmtBlk groupMgmtBlk = this.tramblk.getGroupMgmtBlk();
        MemberBlock memberBlock = null;
        Vector<MemberBlock> vector = new Vector<MemberBlock>(10, 10);
        long l = System.currentTimeMillis();
        long l2 = Math.max(3000L, this.tramblk.getAckInterval());
        GroupMgmtThread groupMgmtThread = this.tramblk.getGroupMgmtThread();
        int n = groupMgmtBlk.getDirectMemberCount();
        int n2 = 0;
        while (n2 < n) {
            block18: {
                try {
                    memberBlock = groupMgmtBlk.getMember(n2);
                    if (memberBlock.getMissedAcks() > 0 && this.logger.requiresLogging(16)) {
                        this.logger.putPacketln(this, "Hello?  " + memberBlock.getAddress() + ", Missed ACK's " + memberBlock.getMissedAcks() + ", Hello rate " + l2 + ", current time " + l + ", lastheard " + memberBlock.getLastheard());
                    }
                    if (l - memberBlock.getLastheard() <= 2L * l2) break block18;
                    if (memberBlock.getMissedAcks() > 4) {
                        groupMgmtThread.handleMemberLoss(memberBlock);
                        this.tramblk.getTRAMStats().addLostMembers();
                        --n2;
                    } else {
                        memberBlock.incrMissedAcks();
                        vector.addElement(memberBlock);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    break;
                }
            }
            ++n2;
        }
        switch (this.tramblk.getTRAMState()) {
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                if (vector.size() != 0 || this.isSendLowestAvailablePktInfo()) break;
                return;
            }
        }
        TRAMPacket tRAMPacket = null;
        byte by = 0;
        if (vector.size() != 0) {
            InetAddress[] inetAddressArray = new InetAddress[vector.size()];
            int n3 = 0;
            while (n3 < vector.size()) {
                memberBlock = (MemberBlock)vector.elementAt(n3);
                inetAddressArray[n3] = memberBlock.getAddress();
                if (this.logger.requiresLogging(39)) {
                    this.logger.putPacketln(this, "Adding " + memberBlock.getAddress() + " to hello packet");
                }
                ++n3;
            }
            int n4 = this.tramblk.getTRAMDataCache().getHighestSequenceNumber();
            tRAMPacket = new TRAMHelloPacket(this.tramblk, groupMgmtBlk.getRetransmitTTL(), vector.size(), n4, inetAddressArray);
            by = (byte)(by | 1);
        }
        if (tRAMPacket == null && !this.canSuppressHello()) {
            int n5 = this.tramblk.getTRAMDataCache().getHighestSequenceNumber();
            tRAMPacket = new TRAMHelloPacket(this.tramblk, groupMgmtBlk.getRetransmitTTL(), 0, n5, null);
        }
        if (tRAMPacket != null) {
            if (this.tramblk.isDataTransmissionComplete()) {
                by = (byte)(by | 2);
                ((TRAMHelloPacket)tRAMPacket).setHighSeqNumber(this.tramblk.getLastKnownSequenceNumber());
            }
            tRAMPacket.setFlags(by);
            if (this.dispatchHelloPacket(((TRAMHelloPacket)tRAMPacket).createDatagramPacket())) {
                try {
                    this.tramblk.getTRAMStats().setSendCntlMsgCounters(tRAMPacket);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean dispatchHelloPacket(DatagramPacket datagramPacket) {
        try {
            if (this.tramblk.getSimulator() != null) {
                this.tramblk.getSimulator().simulateMulticastPacket(datagramPacket, 2, this.tramblk.getGroupMgmtBlk().getRetransmitTTL());
            } else {
                this.ms.send(datagramPacket, this.tramblk.getGroupMgmtBlk().getRetransmitTTL());
            }
            if (this.logger.requiresLogging(55)) {
                this.logger.putPacketln(this, "Sent a Hello Packet to " + datagramPacket.getAddress() + " " + datagramPacket.getPort() + ", retransmit ttl is " + this.tramblk.getGroupMgmtBlk().getRetransmitTTL());
            }
            this.lastHelloSent = System.currentTimeMillis();
        }
        catch (IOException iOException) {
            if (this.logger.requiresLogging(39)) {
                this.logger.putPacketln(this, "unable to send Hello packet ");
            }
            return false;
        }
        return true;
    }

    private boolean canSuppressHello() {
        long l;
        long l2;
        long l3 = System.currentTimeMillis();
        if (l3 - (l2 = this.tramblk.getOutputDispThread().getLastPktSentTime()) > (l = Math.max(3000L, this.tramblk.getAckInterval())) / 2L) {
            return false;
        }
        if (this.logger.requiresLogging(39)) {
            this.logger.putPacketln(this, "Recommending to suppress HELLO Lastsent within " + (l3 - l2));
        }
        return true;
    }

    private void validateHeadsLiveliness(HeadBlock headBlock, boolean bl) {
        TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
        long l = Math.max(3000L, this.tramblk.getAckInterval());
        long l2 = System.currentTimeMillis() - headBlock.getLastheard();
        byte by = this.tramblk.getTRAMState();
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "HeadsLiveliness:  helloInterval " + l + " lastHeard " + l2 + " state " + by);
        }
        if ((by == 9 || by == 13) && l2 > 2L * l) {
            if (bl) {
                if (this.logger.requiresLogging(51)) {
                    this.logger.putPacketln(this, "HELLOs are NOT being RECEIVED from ReAffil Head");
                }
            } else if (this.logger.requiresLogging(51)) {
                this.logger.putPacketln(this, "HELLOs are NOT being RECEIVED");
            }
            if (headBlock.incrAndGetMissedHellos() > tRAMTransportProfile.getMaxHelloMisses()) {
                if (bl) {
                    this.tramblk.getGroupMgmtThread().handleReAffiliatedHeadLoss();
                } else {
                    this.tramblk.getGroupMgmtThread().handleHeadLoss();
                }
            } else {
                TRAMMemberAck tRAMMemberAck;
                if (this.logger.requiresLogging(51)) {
                    this.logger.putPacketln(this, "Reporting Hellos are not being received");
                }
                if ((tRAMMemberAck = this.tramblk.getMemberAck()) != null) {
                    tRAMMemberAck.sendAck((byte)1, headBlock, 5);
                }
            }
        } else {
            headBlock.clearMissedHellos();
        }
    }

    private synchronized boolean isSendLowestAvailablePktInfo() {
        return this.sendLowestAvailablePktInfo;
    }

    private synchronized void setSendLowestAvailablePktInfo(boolean bl) {
        this.sendLowestAvailablePktInfo = bl;
    }

    public void sendDemandAck() {
        GroupMgmtBlk groupMgmtBlk = this.tramblk.getGroupMgmtBlk();
        InetAddress[] inetAddressArray = new InetAddress[groupMgmtBlk.getDirectMemberCount()];
        int n = 0;
        while (n < inetAddressArray.length) {
            inetAddressArray[n] = groupMgmtBlk.getMember(n).getAddress();
            ++n;
        }
        int n2 = this.tramblk.getTRAMDataCache().getHighestSequenceNumber();
        TRAMHelloPacket tRAMHelloPacket = new TRAMHelloPacket(this.tramblk, groupMgmtBlk.getRetransmitTTL(), inetAddressArray.length, n2, inetAddressArray);
        if (this.tramblk.isDataTransmissionComplete()) {
            tRAMHelloPacket.setFlags((byte)3);
            tRAMHelloPacket.setHighSeqNumber(this.tramblk.getLastKnownSequenceNumber());
        } else {
            tRAMHelloPacket.setFlags((byte)1);
        }
        if (this.dispatchHelloPacket(tRAMHelloPacket.createDatagramPacket())) {
            try {
                this.tramblk.getTRAMStats().setSendCntlMsgCounters(tRAMHelloPacket);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void sendSimpleHello() {
        GroupMgmtBlk groupMgmtBlk = this.tramblk.getGroupMgmtBlk();
        int n = this.tramblk.getTRAMDataCache().getHighestSequenceNumber();
        TRAMHelloPacket tRAMHelloPacket = new TRAMHelloPacket(this.tramblk, groupMgmtBlk.getRetransmitTTL(), 0, n, null);
        if (this.dispatchHelloPacket(tRAMHelloPacket.createDatagramPacket())) {
            try {
                this.tramblk.getTRAMStats().setSendCntlMsgCounters(tRAMHelloPacket);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }
}

