/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.TRAMSeqNumber;
import java.net.InetAddress;

class HeadBlock {
    private InetAddress address = null;
    private int port = 0;
    private byte hstate = 1;
    private byte cstate = 1;
    private byte lstate = 0;
    private long lastheard = 0L;
    private int directMemberCount = 0;
    private int indirectMemberCount = 0;
    private byte ttl = 0;
    private int missedHellos = 0;
    TRAMSeqNumber startSeqNumber = null;
    private int rxLevel = 0;
    private boolean rootLanHead = false;

    public HeadBlock(InetAddress inetAddress, int n) {
        this.address = inetAddress;
        this.port = n;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public byte getHstate() {
        return this.hstate;
    }

    public byte getLstate() {
        return this.lstate;
    }

    public byte getCstate() {
        return this.cstate;
    }

    public synchronized long getLastheard() {
        return this.lastheard;
    }

    public int getDirectMemberCount() {
        return this.directMemberCount;
    }

    public int getIndirectMemberCount() {
        return this.indirectMemberCount;
    }

    public byte getTTL() {
        return this.ttl;
    }

    public int getRxLevel() {
        return this.rxLevel;
    }

    public int getMissedHellos() {
        return this.missedHellos;
    }

    public int incrAndGetMissedHellos() {
        ++this.missedHellos;
        return this.missedHellos;
    }

    public void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setHstate(byte by) {
        this.hstate = by;
    }

    public void setLstate(byte by) {
        this.lstate = by;
    }

    public void setCstate(byte by) {
        this.cstate = by;
    }

    public synchronized void setLastheard(long l) {
        this.lastheard = l;
    }

    public void setDirectMemberCount(int n) {
        this.directMemberCount = n;
    }

    public void setIndirectMemberCount(int n) {
        this.indirectMemberCount = n;
    }

    public void setTTL(byte by) {
        this.ttl = by;
    }

    public void setRxLevel(int n) {
        this.rxLevel = n;
    }

    public void clearMissedHellos() {
        this.missedHellos = 0;
    }

    public int getStartSeqNumber() {
        return this.startSeqNumber.getSeqNumber();
    }

    public void setStartSeqNumber(int n) {
        this.startSeqNumber = new TRAMSeqNumber(n);
    }

    public boolean isRootLanHead() {
        return this.rootLanHead;
    }

    public void setRootLanHead(boolean bl) {
        this.rootLanHead = bl;
    }
}

