/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.AbortTRAM;
import com.sun.multicast.reliable.transport.tram.BeaconGenThread;
import com.sun.multicast.reliable.transport.tram.BeaconPacket;
import com.sun.multicast.reliable.transport.tram.BeaconPacketEvent;
import com.sun.multicast.reliable.transport.tram.BeaconPacketListener;
import com.sun.multicast.reliable.transport.tram.GroupMgmtBlk;
import com.sun.multicast.reliable.transport.tram.HeadBlock;
import com.sun.multicast.reliable.transport.tram.HelloThread;
import com.sun.multicast.reliable.transport.tram.MemberBlock;
import com.sun.multicast.reliable.transport.tram.SUBMESGTYPE;
import com.sun.multicast.reliable.transport.tram.TRAMAckPacket;
import com.sun.multicast.reliable.transport.tram.TRAMAckPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMAckPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMAmPacket;
import com.sun.multicast.reliable.transport.tram.TRAMAmPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMAmPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacket;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMDataPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMGenericDataCache;
import com.sun.multicast.reliable.transport.tram.TRAMHaPacket;
import com.sun.multicast.reliable.transport.tram.TRAMHaPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMHaPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMHbPacket;
import com.sun.multicast.reliable.transport.tram.TRAMHbPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMHbPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMHeadAck;
import com.sun.multicast.reliable.transport.tram.TRAMHelloPacket;
import com.sun.multicast.reliable.transport.tram.TRAMHelloPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMHelloPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMHelloUniPacket;
import com.sun.multicast.reliable.transport.tram.TRAMHelloUniPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMHelloUniPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMLogger;
import com.sun.multicast.reliable.transport.tram.TRAMMemberAck;
import com.sun.multicast.reliable.transport.tram.TRAMMembershipEvent;
import com.sun.multicast.reliable.transport.tram.TRAMMembershipListener;
import com.sun.multicast.reliable.transport.tram.TRAMMsPacket;
import com.sun.multicast.reliable.transport.tram.TRAMMsPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMMsPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMPacket;
import com.sun.multicast.reliable.transport.tram.TRAMRmPacket;
import com.sun.multicast.reliable.transport.tram.TRAMRmPacketEvent;
import com.sun.multicast.reliable.transport.tram.TRAMRmPacketListener;
import com.sun.multicast.reliable.transport.tram.TRAMSeqNumber;
import com.sun.multicast.reliable.transport.tram.TRAMStats;
import com.sun.multicast.reliable.transport.tram.TRAMTimer;
import com.sun.multicast.reliable.transport.tram.TRAMTimerEventHandler;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import com.sun.multicast.reliable.transport.tram.TRAM_STATE;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.NoSuchElementException;
import java.util.Vector;

class GroupMgmtThread
extends Thread
implements TRAMDataPacketListener,
BeaconPacketListener,
TRAMHelloPacketListener,
TRAMAckPacketListener,
TRAMHelloUniPacketListener,
TRAMMsPacketListener,
TRAMHaPacketListener,
TRAMAmPacketListener,
TRAMRmPacketListener,
TRAMHbPacketListener,
TRAMTimerEventHandler {
    private static final byte FREE = 0;
    private static final byte HA_POLLING = 1;
    private static final byte MS_XMIT = 2;
    private static final byte MAX_HB_RETXMIT = 3;
    private static final long HB_TIMEOUT = 2000L;
    private TRAMControlBlock tramblk;
    private TRAMLogger logger;
    private static final String name = "TRAM GroupMgmtThread";
    private Vector pktsToProcess;
    private GroupMgmtBlk gblk;
    private Vector toBeMembers;
    private HeadBlock toBeHead;
    private boolean done;
    private int haPacketsToProcess;
    private int msPacketsToProcess;
    private boolean weAreBestLanVolunteer;
    private boolean weAreCurrentLanHead;
    private boolean needNewLanHead;
    private boolean rootLanHeadExists;
    private boolean rootLanHeadIsAffiliated;
    private Vector backUpHeads;
    private TRAMTimer timer;
    private byte timerState;
    private byte hbReTxmitCount;
    private MulticastSocket ms;
    private int haTTL;
    private short haInterval;
    private int haTimeoutCount;
    private int msTTL;
    private InetAddress myAddr;
    private int haIncrementSuppressionCounter;
    private Vector membershipListeners;
    private boolean dataTxmStarted;
    private int advertisingHeads;
    private int indirectAdvertisingHeads;
    private String cfgfile;
    private boolean staticConfig;
    private boolean iAmStaticHead;
    private Vector staticHeads;
    private int sessionUPort;

    public GroupMgmtThread(TRAMControlBlock tRAMControlBlock) {
        block4: {
            super(name);
            this.tramblk = null;
            this.pktsToProcess = null;
            this.gblk = null;
            this.toBeMembers = null;
            this.toBeHead = null;
            this.done = false;
            this.haPacketsToProcess = 0;
            this.msPacketsToProcess = 0;
            this.weAreBestLanVolunteer = false;
            this.weAreCurrentLanHead = false;
            this.needNewLanHead = false;
            this.rootLanHeadExists = false;
            this.rootLanHeadIsAffiliated = false;
            this.backUpHeads = new Vector(10, 10);
            this.timer = null;
            this.timerState = 0;
            this.hbReTxmitCount = 0;
            this.ms = null;
            this.haTTL = 0;
            this.haInterval = (short)1000;
            this.haTimeoutCount = 0;
            this.msTTL = 0;
            this.myAddr = null;
            this.haIncrementSuppressionCounter = 0;
            this.dataTxmStarted = false;
            this.advertisingHeads = 1;
            this.indirectAdvertisingHeads = 0;
            this.cfgfile = null;
            this.staticConfig = false;
            this.iAmStaticHead = false;
            this.staticHeads = new Vector();
            this.sessionUPort = 0;
            this.tramblk = tRAMControlBlock;
            this.logger = tRAMControlBlock.getLogger();
            this.gblk = tRAMControlBlock.getGroupMgmtBlk();
            this.pktsToProcess = new Vector(100, 10);
            this.membershipListeners = new Vector();
            if (tRAMControlBlock.getTransportProfile().getMrole() != 1) {
                this.toBeMembers = new Vector(10, 10);
            }
            this.timer = new TRAMTimer("GroupMgmtThread Timer", this, this.logger);
            this.setDaemon(true);
            if (tRAMControlBlock.getSimulator() == null) {
                try {
                    this.ms = tRAMControlBlock.newMulticastSocket();
                }
                catch (IOException iOException) {
                    if (!this.logger.requiresLogging(7)) break block4;
                    this.logger.putPacketln(this, "Unable to open Multicast socket");
                }
            }
        }
        this.myAddr = tRAMControlBlock.getLocalHost();
        this.cfgfile = "jrmstree.cfg." + this.myAddr.getHostName();
        this.start();
    }

    public void run() {
        Object object;
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Starting group management thread");
        }
        TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
        switch (tRAMTransportProfile.getTmode()) {
            case 1: 
            case 3: {
                this.tramblk.setTRAMState((byte)2);
                this.tramblk.getInputDispThread().addTRAMMsPacketListener(this);
                this.tramblk.getInputDispThread().addTRAMHaPacketListener(this);
                this.tramblk.getUcastInputDispThread().addTRAMHbPacketListener(this);
                this.tramblk.getUcastInputDispThread().addTRAMAckPacketListener(this);
                this.gblk.setRxLevel(1);
                this.gblk.setHstate((byte)2);
                TRAMHeadAck tRAMHeadAck = new TRAMHeadAck(this.tramblk);
                this.tramblk.setHeadAck(tRAMHeadAck);
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "Spawning the Beacon Gen Thread");
                }
                BeaconGenThread beaconGenThread = new BeaconGenThread(this.tramblk, this);
                this.tramblk.setBeaconGenThread(beaconGenThread);
                try {
                    object = this.tramblk.getLocalHost();
                    tRAMTransportProfile.setDataSourceAddress((InetAddress)object);
                    this.tramblk.getTRAMStats().addSender((InetAddress)object);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "LAN flag is " + tRAMTransportProfile.isLanTreeFormationEnabled());
                }
                if (tRAMTransportProfile.isLanTreeFormationEnabled()) {
                    if (this.logger.requiresLogging(7)) {
                        this.logger.putPacketln(this, "LAN Tree Formation is Enabled");
                    }
                    this.weAreBestLanVolunteer = true;
                    this.gblk.setLstate((byte)3);
                    this.weAreCurrentLanHead = true;
                    if (this.logger.requiresLogging(7)) {
                        this.logger.putPacketln(this, "Can accept member max of " + tRAMTransportProfile.getMaxMembers());
                    }
                }
                if (tRAMTransportProfile.getTreeFormationPreference(true) == 2) {
                    this.haInterval = 0;
                } else {
                    this.haInterval = (short)tRAMTransportProfile.getHaInterval();
                    this.loadTimerToSendHaPkt();
                }
                this.haTTL = tRAMTransportProfile.getHaTTLIncrements();
                break;
            }
            case 2: {
                this.sessionUPort = tRAMTransportProfile.getUnicastPort();
                if (tRAMTransportProfile.getTreeFormationPreference(false) >= 32) {
                    this.readTreeConfigFile();
                }
                this.tramblk.setTRAMState((byte)5);
                this.gblk.setRxLevel(0);
                if (tRAMTransportProfile.getMrole() != 1) {
                    this.gblk.setHstate((byte)2);
                }
                this.tramblk.getInputDispThread().addBeaconPacketListener(this);
                this.tramblk.getInputDispThread().addTRAMDataPacketListener(this);
                this.tramblk.getInputDispThread().addTRAMHelloPacketListener(this);
                this.tramblk.getInputDispThread().addTRAMHaPacketListener(this);
                this.tramblk.getUcastInputDispThread().addTRAMHbPacketListener(this);
                this.tramblk.getUcastInputDispThread().addTRAMAmPacketListener(this);
                this.tramblk.getUcastInputDispThread().addTRAMRmPacketListener(this);
                this.tramblk.getUcastInputDispThread().addTRAMHelloUniPacketListener(this);
                if (this.logger.requiresLogging(135)) {
                    this.logger.putPacketln(this, "Waiting  for Beacon/data message");
                }
                this.msTTL = tRAMTransportProfile.getMsTTLIncrements();
                break;
            }
        }
        while (!this.done) {
            if (this.pktsToProcess.size() != 0) {
                try {
                    while (true) {
                        object = (TRAMPacket)this.pktsToProcess.firstElement();
                        this.processIncomingPacket((TRAMPacket)object);
                        this.pktsToProcess.removeElement(object);
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            this.stall();
        }
    }

    private void readTreeConfigFile() {
        BufferedReader bufferedReader = null;
        int n = 0;
        int n2 = 0;
        InetAddress inetAddress = null;
        byte by = 1;
        HeadBlock headBlock = null;
        if (this.cfgfile != null) {
            try {
                bufferedReader = new BufferedReader(new FileReader(this.cfgfile));
                if (this.logger.requiresLogging(1023)) {
                    this.logger.putPacketln(this, "Reading tree config file " + this.cfgfile);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.logger.requiresLogging(1023)) {
                    this.logger.putPacketln(this, "Tree Config file " + this.cfgfile + " not found");
                }
                return;
            }
            try {
                StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
                streamTokenizer.ordinaryChars(46, 57);
                streamTokenizer.wordChars(46, 57);
                streamTokenizer.eolIsSignificant(true);
                int n3 = streamTokenizer.nextToken();
                while (n3 != -1) {
                    if (streamTokenizer.ttype == 10) {
                        if (n2 == 2) {
                            if (by != 0) {
                                if (this.logger.requiresLogging(1023)) {
                                    this.logger.putPacketln(this, "Setting static head to " + inetAddress + " ttl is " + by);
                                }
                                headBlock = new HeadBlock(inetAddress, this.sessionUPort);
                                headBlock.setTTL(by);
                                if (n < 10) {
                                    this.staticHeads.addElement(headBlock);
                                    this.staticConfig = true;
                                }
                            } else if (this.myAddr.equals(inetAddress)) {
                                this.iAmStaticHead = true;
                            }
                        } else if (n2 <= 0 && n2 == 0) break;
                        n2 = 0;
                    } else {
                        if (n2 == 0) {
                            inetAddress = InetAddress.getByName(streamTokenizer.sval);
                            ++n;
                        } else if (n2 == 1) {
                            by = (byte)Integer.parseInt(streamTokenizer.sval);
                        }
                        ++n2;
                    }
                    n3 = streamTokenizer.nextToken();
                }
                ((Reader)bufferedReader).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean checkAgainstStaticList(InetAddress inetAddress) {
        HeadBlock headBlock = null;
        int n = 0;
        while (n < this.staticHeads.size()) {
            try {
                headBlock = (HeadBlock)this.staticHeads.elementAt(n);
                if (headBlock.getAddress().equals(inetAddress)) {
                    if (this.logger.requiresLogging(1023)) {
                        this.logger.putPacketln(this, "Received message from static head " + inetAddress);
                    }
                    return true;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++n;
        }
        return false;
    }

    private void processIncomingPacket(TRAMPacket tRAMPacket) {
        int n = tRAMPacket.getSubType();
        TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
        TRAMStats tRAMStats = this.tramblk.getTRAMStats();
        if (tRAMStats != null) {
            tRAMStats.setRcvdCntlMsgCounters(tRAMPacket);
        }
        block0 : switch (tRAMPacket.getMessageType()) {
            case 1: {
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "Incoming pkt from " + tRAMPacket.getAddress() + " " + tRAMPacket.getPort() + ", type MCAST_CNTL, subtype " + SUBMESGTYPE.mcastControl[n]);
                }
                switch (n) {
                    case 1: {
                        this.processBeaconPacket((BeaconPacket)tRAMPacket);
                        break block0;
                    }
                    case 4: {
                        this.decrementMsPacketsToProcess();
                        this.processMsPacket((TRAMMsPacket)tRAMPacket);
                        break block0;
                    }
                    case 2: {
                        this.processHelloPacket((TRAMHelloPacket)tRAMPacket);
                        break block0;
                    }
                    case 3: {
                        this.decrementHaPacketsToProcess();
                        this.processHaPacket((TRAMHaPacket)tRAMPacket);
                        break block0;
                    }
                }
                return;
            }
            case 2: {
                if (tRAMTransportProfile.getTmode() != 1 && this.logger.requiresLogging(135)) {
                    this.logger.putPacketln(this, "Incoming pkt from " + tRAMPacket.getAddress() + " " + tRAMPacket.getPort() + ", type MCAST_DATA, subtype " + SUBMESGTYPE.mcastData[n]);
                }
                this.processDataPacket((TRAMDataPacket)tRAMPacket);
                break;
            }
            case 3: {
                if (this.logger.requiresLogging(135)) {
                    this.logger.putPacketln(this, "Incoming pkt from " + tRAMPacket.getAddress() + " " + tRAMPacket.getPort() + ", type UCAST_CNTL, subtype " + SUBMESGTYPE.ucastControl[n] + "");
                }
                switch (n) {
                    case 1: {
                        this.processAmPacket((TRAMAmPacket)tRAMPacket);
                        break block0;
                    }
                    case 2: {
                        this.processRmPacket((TRAMRmPacket)tRAMPacket);
                        break block0;
                    }
                    case 5: {
                        this.processHbPacket((TRAMHbPacket)tRAMPacket);
                        break block0;
                    }
                    case 4: {
                        this.processAckPacket((TRAMAckPacket)tRAMPacket);
                        break block0;
                    }
                    case 3: {
                        this.processHelloUniPacket((TRAMHelloUniPacket)tRAMPacket);
                        break block0;
                    }
                }
                return;
            }
            default: {
                return;
            }
        }
    }

    private void processBeaconPacket(BeaconPacket beaconPacket) {
        TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
        if (tRAMTransportProfile.getTmode() == 2) {
            this.haInterval = beaconPacket.getHaInterval();
        }
        if (this.logger.requiresLogging(135)) {
            this.logger.putPacketln(this, "Got Beacon... state " + TRAM_STATE.TRAMStateNames[this.tramblk.getTRAMState()] + " msttl " + this.msTTL + " haTTL " + this.haTTL);
        }
        switch (this.tramblk.getTRAMState()) {
            case 5: {
                if (!this.isAPacketFromTheDataSource(beaconPacket)) {
                    return;
                }
                if (this.tramblk.getTransportProfile().getMrole() != 1 && this.tramblk.getTransportProfile().isLanTreeFormationEnabled()) {
                    if (this.logger.requiresLogging(7)) {
                        this.logger.putPacketln(this, "LAN Tree Formation is Enabled. Volunteering.");
                    }
                    this.weAreBestLanVolunteer = true;
                    this.gblk.setLstate((byte)2);
                }
                if (this.tryStartingMTHA(tRAMTransportProfile)) break;
                if (this.logger.requiresLogging(135)) {
                    this.logger.putPacketln(this, "Changing state to SEEKING_HA_MEMBERSHIP");
                }
                this.tramblk.setTRAMState((byte)6);
                this.loadTimerToReceiveHaPacket();
                break;
            }
            case 9: {
                HeadBlock headBlock = this.gblk.getHeadBlock();
                this.tramblk.setLastKnownSequenceNumber(beaconPacket.getSeqNumber());
                if (!headBlock.getAddress().equals(beaconPacket.getAddress()) || this.tramblk.getSimulator() != null && headBlock.getPort() != 4322) break;
                headBlock.setLastheard(System.currentTimeMillis());
                break;
            }
            case 6: {
                this.tryStartingMTHA(tRAMTransportProfile);
                break;
            }
            case 7: {
                if (this.haInterval == 0) break;
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "Changing state to SEEKING_HA_MEMBERSHIP");
                }
                this.tramblk.setTRAMState((byte)6);
                this.loadTimerToReceiveHaPacket();
                break;
            }
        }
    }

    private boolean tryStartingMTHA(TRAMTransportProfile tRAMTransportProfile) {
        if (this.haInterval == 0) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Transitioning to MTHA Membership");
            }
            this.tramblk.setTRAMState((byte)7);
            if (this.weAreBestLanVolunteer) {
                this.lanVolunteer();
                this.timer.reloadTimer((this.tramblk.getTransportProfile().getMsRate() & 0xFFFFFFFFL) / 2L);
            } else {
                this.sendMsPacket();
                this.timer.reloadTimer(this.tramblk.getTransportProfile().getMsRate() & 0xFFFFFFFFL);
            }
            return true;
        }
        return false;
    }

    private void loadTimerToSendHaPkt() {
        if (this.haInterval != 0) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Starting the HA Timer");
            }
            this.timer.loadTimer((long)this.haInterval & 0xFFFFFFFFL);
        } else if (this.gblk.getLstate() != 0) {
            this.timer.loadTimer(this.tramblk.getTransportProfile().getHaInterval());
        }
    }

    private void loadTimerToReceiveHaPacket() {
        long l;
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Starting Timer to Receive HA Pkt");
        }
        if ((l = (long)this.haInterval & 0xFFFFFFFFL) > 20000L) {
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, "HA Wait time is more than 60secs. Adjusting to 60 secs");
            }
            l = 20000L;
        }
        this.timer.loadTimer(l);
        if (this.haTimeoutCount == 0) {
            this.haTimeoutCount = 3;
        }
    }

    private void processMsPacket(TRAMMsPacket tRAMMsPacket) {
        TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
        boolean bl = false;
        switch (this.tramblk.getTRAMState()) {
            case 2: {
                if (tRAMTransportProfile.getTmode() != 2) break;
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "Ignoring a Pre Data MS message");
                }
                return;
            }
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            default: {
                return;
            }
        }
        if (this.gblk.getHstate() == 5 || this.gblk.getHstate() == 4 || tRAMTransportProfile.getMrole() == 1 || tRAMMsPacket.getMrole() == 1 && this.gblk.getHstate() == 3) {
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, "Ignoring MS message as HSTATE is " + this.gblk.getHstate() + " and mRole is " + tRAMTransportProfile.getMrole());
            }
            return;
        }
        if (this.tramblk.getTransportProfile().isLanTreeFormationEnabled() && !this.weAreCurrentLanHead) {
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, "Not a LANHead. Ignoring the received MS message");
            }
            return;
        }
        if (tRAMMsPacket.getMrole() == 1 && this.gblk.getMemberOnlyCount() >= tRAMTransportProfile.getMaxNonHeads()) {
            return;
        }
        if (this.gblk.getDirectMemberCount() < tRAMTransportProfile.getMaxMembers()) {
            this.sendHaPacket(tRAMMsPacket.getTTL());
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Got MS Packet from " + tRAMMsPacket.getAddress().getHostName() + "Port " + tRAMMsPacket.getUnicastPort() + "TTL as " + tRAMMsPacket.getTTL());
            }
        }
    }

    private void processHelloPacket(TRAMHelloPacket tRAMHelloPacket) {
        if (this.logger.requiresLogging(39)) {
            this.logger.putPacketln(this, "Hello from " + tRAMHelloPacket.getAddress() + " " + tRAMHelloPacket.getUnicastPort());
        }
        switch (this.tramblk.getTRAMState()) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                if (!this.myAddr.equals(tRAMHelloPacket.getAddress()) || this.tramblk.getUnicastPort() != tRAMHelloPacket.getUnicastPort()) break;
                return;
            }
            default: {
                return;
            }
        }
        HeadBlock headBlock = this.gblk.getHeadBlock();
        if (headBlock != null && headBlock.getAddress().equals(tRAMHelloPacket.getAddress()) && headBlock.getPort() == tRAMHelloPacket.getUnicastPort()) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "My Head's address is " + headBlock.getAddress() + " " + headBlock.getPort());
            }
            this.processHeadsHelloPacket(tRAMHelloPacket, headBlock, false);
        } else if (this.tramblk.getTRAMState() == 13 && this.toBeHead != null && this.toBeHead.getAddress().equals(tRAMHelloPacket.getAddress()) && this.toBeHead.getPort() == tRAMHelloPacket.getUnicastPort()) {
            this.processHeadsHelloPacket(tRAMHelloPacket, this.toBeHead, true);
        } else {
            this.processOtherHeadsHelloPacket(tRAMHelloPacket);
        }
    }

    private void processHeadsHelloPacket(TRAMHelloPacket tRAMHelloPacket, HeadBlock headBlock, boolean bl) {
        InetAddress[] inetAddressArray;
        if (this.logger.requiresLogging(39)) {
            this.logger.putPacketln(this, "Received Hello from head " + headBlock.getAddress() + " " + tRAMHelloPacket.getUnicastPort());
        }
        boolean bl2 = false;
        headBlock.setLastheard(System.currentTimeMillis());
        byte by = tRAMHelloPacket.getTTL();
        if (by < headBlock.getTTL()) {
            headBlock.setTTL(by);
        }
        if (headBlock.getHstate() != tRAMHelloPacket.getHstate()) {
            headBlock.setHstate(tRAMHelloPacket.getHstate());
            if (tRAMHelloPacket.getHstate() == 5 && this.tramblk.getTRAMState() == 9) {
                if (this.logger.requiresLogging(55)) {
                    this.logger.putPacketln(this, "Head RESIGNING " + headBlock.getAddress());
                }
                this.tramblk.setTRAMState((byte)11);
                this.performHeadSelection();
                switch (this.tramblk.getTRAMState()) {
                    case 11: {
                        if (this.haInterval == 0) {
                            this.sendMsPacket();
                            this.timer.reloadTimer(this.tramblk.getTransportProfile().getMsRate() & 0xFFFFFFFFL);
                            break;
                        }
                        this.loadTimerToReceiveHaPacket();
                        break;
                    }
                    case 12: {
                        this.timer.reloadTimer(2000L);
                    }
                }
            }
        }
        if (headBlock.getRxLevel() != tRAMHelloPacket.getRxLevel()) {
            headBlock.setRxLevel(tRAMHelloPacket.getRxLevel());
            if (!bl) {
                this.gblk.setRxLevel(tRAMHelloPacket.getRxLevel() + 1);
                if (this.logger.requiresLogging(3)) {
                    this.logger.putPacketln(this, "Root LAN is affiliated");
                }
                this.rootLanHeadIsAffiliated = true;
            }
        }
        if (!bl) {
            inetAddressArray = this.tramblk.getMemberAck();
            if (inetAddressArray != null) {
                inetAddressArray.dealWithUnrecoverablePkts(tRAMHelloPacket.getLowSeqNumber());
            }
            this.tramblk.getTRAMDataCache().dealWithUnrecoverablePkts(tRAMHelloPacket.getLowSeqNumber());
        }
        if ((tRAMHelloPacket.getFlags() & 1) != 0) {
            if (this.logger.requiresLogging(16)) {
                this.logger.putPacketln(this, "Demand ACK from " + tRAMHelloPacket.getAddress() + " " + tRAMHelloPacket.getAckMemberCount() + " addrs " + "check for me " + this.tramblk.getLocalHost());
            }
            inetAddressArray = tRAMHelloPacket.getAddressList();
            InetAddress inetAddress = this.tramblk.getLocalHost();
            if (inetAddress != null) {
                int n = 0;
                while (n < tRAMHelloPacket.getAckMemberCount()) {
                    if (this.logger.requiresLogging(16)) {
                        this.logger.putPacketln(this, "my address " + inetAddress + ", address in hello pkt " + inetAddressArray[n]);
                    }
                    if (inetAddressArray[n].equals(inetAddress)) {
                        TRAMMemberAck tRAMMemberAck;
                        if (this.logger.requiresLogging(16)) {
                            this.logger.putPacketln(this, "Need to respond to Hello");
                        }
                        if ((tRAMMemberAck = this.tramblk.getMemberAck()) != null) {
                            if (this.tramblk.getTRAMState() != 13 && this.tramblk.getTRAMState() != 9) break;
                            if (this.logger.requiresLogging(16)) {
                                this.logger.putPacketln(this, "Dispatching ACK...");
                            }
                            bl2 = true;
                            if (!bl || !this.logger.requiresLogging(16)) break;
                            this.logger.putPacketln(this, "Ack'ing Hello from  ReAffiliated Head" + headBlock.getAddress());
                            break;
                        }
                    }
                    ++n;
                }
            }
        }
        if ((inetAddressArray = this.tramblk.getMemberAck()) != null) {
            if ((tRAMHelloPacket.getFlags() & 2) != 0) {
                inetAddressArray.handleDataTransmissionComplete(headBlock, tRAMHelloPacket.getHighSeqNumber());
                return;
            }
            if (bl2) {
                inetAddressArray.sendAck((byte)0, headBlock, 4);
            }
        }
    }

    private synchronized void processOtherHeadsHelloPacket(TRAMHelloPacket tRAMHelloPacket) {
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "received Hello from a local head " + tRAMHelloPacket.getAddress());
        }
        if (this.staticConfig && !this.checkAgainstStaticList(tRAMHelloPacket.getAddress())) {
            return;
        }
        HeadBlock headBlock = null;
        HeadBlock headBlock2 = null;
        boolean bl = false;
        int n = 0;
        while (n < this.backUpHeads.size()) {
            try {
                headBlock = (HeadBlock)this.backUpHeads.elementAt(n);
                if (headBlock.getAddress().equals(tRAMHelloPacket.getAddress()) && headBlock.getPort() == tRAMHelloPacket.getUnicastPort()) {
                    if (!this.isASuitableBackupHstate(tRAMHelloPacket.getHstate()) || this.gblk.getLstate() == 3 && headBlock.getLstate() != 0) {
                        this.backUpHeads.removeElement(headBlock);
                        return;
                    }
                    bl = true;
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++n;
        }
        if (!bl) {
            if (!this.isASuitableBackupHstate(tRAMHelloPacket.getHstate()) || this.gblk.getLstate() == 3) {
                return;
            }
            if (this.toBeHead != null && this.toBeHead.getAddress().equals(tRAMHelloPacket.getAddress()) && this.toBeHead.getPort() == tRAMHelloPacket.getUnicastPort()) {
                this.toBeHead.setLastheard(System.currentTimeMillis());
                byte by = tRAMHelloPacket.getTTL();
                if (by < this.toBeHead.getTTL()) {
                    this.toBeHead.setTTL(by);
                }
                this.toBeHead.setRxLevel(tRAMHelloPacket.getRxLevel());
                return;
            }
            headBlock = new HeadBlock(tRAMHelloPacket.getAddress(), tRAMHelloPacket.getUnicastPort());
            headBlock.setTTL(tRAMHelloPacket.getTTL());
            headBlock.setHstate(tRAMHelloPacket.getHstate());
            headBlock.setLastheard(System.currentTimeMillis());
            headBlock.setRxLevel(tRAMHelloPacket.getRxLevel());
            if (!this.addedToTheBackupHeadList(headBlock)) {
                return;
            }
        } else {
            headBlock.setHstate(tRAMHelloPacket.getHstate());
            headBlock.setLastheard(System.currentTimeMillis());
            headBlock.setRxLevel(tRAMHelloPacket.getRxLevel());
            byte by = tRAMHelloPacket.getTTL();
            if (by < headBlock.getTTL()) {
                headBlock.setTTL(by);
            }
        }
        if ((headBlock2 = this.gblk.getHeadBlock()) != null && headBlock.getTTL() < headBlock2.getTTL()) {
            switch (this.tramblk.getTRAMState()) {
                case 12: 
                case 13: {
                    break;
                }
                case 9: {
                    if (this.logger.requiresLogging(3)) {
                        this.logger.putPacketln(this, "ReAffiliating with a new headCurrentHead TTL = " + headBlock2.getTTL() + "New Heads TTL = " + headBlock.getTTL());
                    }
                    if (headBlock.getRxLevel() >= this.gblk.getRxLevel()) {
                        return;
                    }
                    this.toBeHead = headBlock;
                    this.backUpHeads.removeElement(headBlock);
                    this.sendHbPacket();
                    if (this.logger.requiresLogging(7)) {
                        this.logger.putPacketln(this, "Reaffiliating with " + headBlock.getAddress() + headBlock.getPort());
                    }
                    this.hbReTxmitCount = 0;
                    this.tramblk.setTRAMState((byte)12);
                    this.timer.reloadTimer(2000L);
                    break;
                }
            }
        }
    }

    private void processHbPacket(TRAMHbPacket tRAMHbPacket) {
        TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Got HB Pkt state " + TRAM_STATE.TRAMStateNames[this.tramblk.getTRAMState()] + " from " + tRAMHbPacket.getAddress() + " " + tRAMHbPacket.getPort() + " msttl " + this.msTTL + " haTTL " + this.haTTL);
        }
        boolean bl = tRAMTransportProfile.isLanTreeFormationEnabled();
        switch (this.tramblk.getTRAMState()) {
            case 6: 
            case 7: {
                if (!bl || this.gblk.getLstate() != 3) {
                    return;
                }
            }
            case 9: {
                if (tRAMTransportProfile.getMrole() == 1 || this.tramblk.getMemberAck() == null) {
                    if (this.logger.requiresLogging(7)) {
                        this.logger.putPacketln(this, "Ignoring the HB message");
                    }
                    return;
                }
                if (!bl || this.gblk.getLstate() == 3) break;
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "Not a LAN head. Ignoring HB message");
                }
                this.sendRmPacket(tRAMHbPacket.getAddress(), tRAMHbPacket.getPort(), 5);
                return;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                return;
            }
        }
        MemberBlock memberBlock = null;
        try {
            memberBlock = this.gblk.getMember(tRAMHbPacket.getAddress(), tRAMHbPacket.getPort());
            memberBlock.setLastheard(System.currentTimeMillis());
            TRAMSeqNumber tRAMSeqNumber = new TRAMSeqNumber(this.computeStartPacketForMember());
            memberBlock.setLastPacketAcked(tRAMSeqNumber.getPreviousSeqNumber());
            this.sendAmPacket(tRAMHbPacket.getAddress(), tRAMHbPacket.getPort());
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Already a member Ignoring");
            }
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            Object object;
            block27: {
                try {
                    memberBlock = this.getToBeMember(tRAMHbPacket.getAddress(), tRAMHbPacket.getPort());
                    this.toBeMembers.removeElement(memberBlock);
                    memberBlock.setTTL(tRAMHbPacket.getTTL());
                    object = new TRAMSeqNumber(this.computeStartPacketForMember());
                    memberBlock.setLastPacketAcked(((TRAMSeqNumber)object).getPreviousSeqNumber());
                    this.sendAmPacket(tRAMHbPacket.getAddress(), tRAMHbPacket.getPort());
                }
                catch (NoSuchElementException noSuchElementException2) {
                    if (this.gblk.getHstate() == 5) {
                        this.sendRmPacket(tRAMHbPacket.getAddress(), tRAMHbPacket.getPort(), 4);
                        return;
                    }
                    if (tRAMHbPacket.getMrole() == 1 && this.gblk.getMemberOnlyCount() >= tRAMTransportProfile.getMaxNonHeads()) {
                        this.sendRmPacket(tRAMHbPacket.getAddress(), tRAMHbPacket.getPort(), 1);
                        return;
                    }
                    if (this.gblk.getDirectMemberCount() < tRAMTransportProfile.getMaxMembers()) {
                        memberBlock = new MemberBlock(tRAMHbPacket.getAddress(), tRAMHbPacket.getPort());
                        memberBlock.setTTL(tRAMHbPacket.getTTL());
                        TRAMSeqNumber tRAMSeqNumber = new TRAMSeqNumber(this.computeStartPacketForMember());
                        memberBlock.setLastPacketAcked(tRAMSeqNumber.getPreviousSeqNumber());
                        this.sendAmPacket(tRAMHbPacket.getAddress(), tRAMHbPacket.getPort());
                        if (tRAMHbPacket.getMrole() != 1) {
                            this.loadHaIncrementSuppressionCounter();
                        }
                        break block27;
                    }
                    this.sendRmPacket(tRAMHbPacket.getAddress(), tRAMHbPacket.getPort(), 2);
                    return;
                }
            }
            memberBlock.setLastheard(System.currentTimeMillis());
            memberBlock.setMrole(tRAMHbPacket.getMrole());
            if (this.tramblk.getHeadAck() == null) {
                object = new TRAMHeadAck(this.tramblk);
                this.tramblk.setHeadAck((TRAMHeadAck)object);
            }
            if (this.tramblk.getHelloThread() == null) {
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "Spawned the Hello thread");
                }
                object = new HelloThread(this.tramblk);
            }
            if (this.gblk.getHstate() == 1) {
                this.gblk.setHstate((byte)2);
            }
            this.gblk.putMember(memberBlock);
            if (this.gblk.getDirectMemberCount() >= tRAMTransportProfile.getMaxMembers()) {
                this.gblk.setHstate((byte)4);
            } else if (this.gblk.getMemberOnlyCount() + this.getMembersOnlyInToBeMembers() >= tRAMTransportProfile.getMaxNonHeads()) {
                this.gblk.setHstate((byte)3);
            }
            this.updateRepairTTL();
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, "Added a member. Total mem cnt = " + this.gblk.getDirectMemberCount() + " Member details : Address " + memberBlock.getAddress() + " " + memberBlock.getPort());
            }
            return;
        }
    }

    private void processDataPacket(TRAMDataPacket tRAMDataPacket) {
        TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
        switch (this.tramblk.getTRAMState()) {
            case 5: 
            case 6: {
                if (!this.isAPacketFromTheDataSource(tRAMDataPacket)) {
                    return;
                }
                if (tRAMDataPacket.getSubType() != 1) break;
                if (tRAMTransportProfile.getTmode() == 2) {
                    this.haInterval = tRAMDataPacket.getHaInterval();
                }
                if (!this.tryStartingMTHA(tRAMTransportProfile)) {
                    if (this.logger.requiresLogging(7)) {
                        this.logger.putPacketln(this, "Changing state to SEEKING_HA_MEMBERSHIP");
                    }
                    this.tramblk.setTRAMState((byte)6);
                    this.loadTimerToReceiveHaPacket();
                }
                this.tramblk.getInputDispThread().removeTRAMDataPacketListener(this);
                this.dataTxmStarted = true;
                break;
            }
            case 3: 
            case 9: {
                if (tRAMDataPacket.getSubType() == 1) {
                    this.haInterval = tRAMDataPacket.getHaInterval();
                    this.dataTxmStarted = true;
                }
            }
            default: {
                this.tramblk.getInputDispThread().removeTRAMDataPacketListener(this);
            }
        }
    }

    private boolean isAPacketFromTheDataSource(TRAMPacket tRAMPacket) {
        InetAddress inetAddress = tRAMPacket.getAddress();
        int n = tRAMPacket.getSessionId();
        TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
        if (tRAMTransportProfile.getDataSourceAddress() == null) {
            if (tRAMPacket.getMessageType() == 2 && tRAMPacket.getSubType() == 2) {
                return false;
            }
            tRAMTransportProfile.setDataSourceAddress(inetAddress);
            this.tramblk.setSessionId(n);
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, "Changed the data source address!!!");
            }
            try {
                TRAMStats tRAMStats = this.tramblk.getTRAMStats();
                tRAMStats.addSender(inetAddress);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return true;
        }
        return inetAddress.equals(tRAMTransportProfile.getDataSourceAddress()) && n == this.tramblk.getSessionId();
    }

    private void processHaPacket(TRAMHaPacket tRAMHaPacket) {
        if (this.staticConfig && !this.checkAgainstStaticList(tRAMHaPacket.getAddress())) {
            return;
        }
        try {
            if (this.myAddr.equals(tRAMHaPacket.getAddress()) && this.tramblk.getUnicastPort() == tRAMHaPacket.getUnicastPort()) {
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        switch (this.tramblk.getTRAMState()) {
            case 2: 
            case 3: 
            case 4: {
                if (tRAMHaPacket.getLstate() != 3 || this.gblk.getHstate() != 2 || tRAMHaPacket.getDirectMemberCount() != 0) break;
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, tRAMHaPacket.getAddress() + " is claiming to be a LAN HEAD. " + "Need to send a LAN Volunteer message");
                }
                this.lanVolunteer();
                break;
            }
            case 9: {
                if ((tRAMHaPacket.getFlags() & 1) != 0 && this.gblk.getLstate() == 4 && (this.gblk.getHstate() == 2 || this.gblk.getHstate() == 3)) {
                    if (this.logger.requiresLogging(3)) {
                        this.logger.putPacketln(this, "Re-election requested.  Volunteering to be LAN head");
                    }
                    this.weAreBestLanVolunteer = true;
                    this.lanVolunteer();
                    this.loadTimerToReceiveHaPacket();
                }
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                HeadBlock headBlock;
                HeadBlock headBlock2 = this.gblk.getHeadBlock();
                if (headBlock2 != null) {
                    if (headBlock2.getAddress().equals(tRAMHaPacket.getAddress()) && headBlock2.getPort() == tRAMHaPacket.getUnicastPort()) {
                        headBlock2.setLastheard(System.currentTimeMillis());
                        if (this.tramblk.getTRAMState() == 9 && tRAMHaPacket.getLstate() == 3 && tRAMHaPacket.getRxLevel() != 0 && headBlock2.isRootLanHead()) {
                            this.rootLanHeadIsAffiliated = true;
                            if (this.logger.requiresLogging(3)) {
                                this.logger.putPacketln(this, "Root LAN Head is affiliated");
                            }
                        }
                        return;
                    }
                    headBlock = this.getReAffiliationHead();
                    if (headBlock != null && headBlock.getAddress().equals(tRAMHaPacket.getAddress()) && headBlock.getPort() == tRAMHaPacket.getUnicastPort()) {
                        headBlock.setLastheard(System.currentTimeMillis());
                        return;
                    }
                }
                headBlock = null;
                if (tRAMHaPacket.getLstate() == 2 || tRAMHaPacket.getLstate() == 4) {
                    if (this.gblk.getLstate() == 3 && !this.needNewLanHead) {
                        this.lanVolunteer();
                        if (this.logger.requiresLogging(7)) {
                            this.logger.putPacketln(this, "Informing the volunteers that I am a better LAN head");
                        }
                    } else if (this.weAreBestLanVolunteer && this.isBetterLanHead(tRAMHaPacket)) {
                        if (this.logger.requiresLogging(7)) {
                            this.logger.putPacketln(this, "Giving up... BETTER Lan head FOUND in " + tRAMHaPacket.getAddress());
                        }
                        this.weAreBestLanVolunteer = false;
                        this.gblk.setLstate((byte)4);
                    }
                } else if (tRAMHaPacket.getLstate() == 3 && this.weAreCurrentLanHead) {
                    this.needNewLanHead = false;
                    this.weAreCurrentLanHead = false;
                    if (this.gblk.getDirectMemberCount() == 0) {
                        this.gblk.setLstate((byte)4);
                    }
                    if (this.logger.requiresLogging(7)) {
                        this.logger.putPacketln(this, "Giving up...In favor of " + tRAMHaPacket.getAddress() + " as a LAN head");
                    }
                }
                boolean bl = this.isASuitableBackupHstate(tRAMHaPacket.getHstate());
                if (this.gblk.getLstate() == 3 && tRAMHaPacket.getLstate() != 0) {
                    bl = false;
                }
                try {
                    headBlock = this.getBackupHead(tRAMHaPacket.getAddress(), tRAMHaPacket.getUnicastPort());
                    if (this.gblk.getLstate() == 3 && headBlock.getLstate() != 0) {
                        bl = false;
                    }
                    if (!bl) {
                        this.backUpHeads.removeElement(headBlock);
                        return;
                    }
                    headBlock.setLastheard(System.currentTimeMillis());
                    headBlock.setDirectMemberCount(tRAMHaPacket.getDirectMemberCount());
                    headBlock.setRxLevel(tRAMHaPacket.getRxLevel());
                    headBlock.setHstate(tRAMHaPacket.getHstate());
                    if (tRAMHaPacket.getLstate() != 0) {
                        headBlock.setLstate(tRAMHaPacket.getLstate());
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (bl) {
                        headBlock = new HeadBlock(tRAMHaPacket.getAddress(), tRAMHaPacket.getUnicastPort());
                        headBlock.setTTL(tRAMHaPacket.getTTL());
                        headBlock.setRxLevel(tRAMHaPacket.getRxLevel());
                        headBlock.setHstate(tRAMHaPacket.getHstate());
                        headBlock.setDirectMemberCount(tRAMHaPacket.getDirectMemberCount());
                        headBlock.setLastheard(System.currentTimeMillis());
                        if (tRAMHaPacket.getLstate() != 0) {
                            headBlock.setLstate(tRAMHaPacket.getLstate());
                        }
                        if (!this.addedToTheBackupHeadList(headBlock)) {
                            return;
                        }
                    }
                    return;
                }
                int n = this.gblk.getDirectMemberCount();
                if (this.tramblk.getTRAMState() == 9 && this.gblk.getLstate() != 3 && headBlock2.getTTL() > headBlock.getTTL() && (n == 0 || n != 0 && this.gblk.getRxLevel() > headBlock.getRxLevel())) {
                    this.tramblk.setTRAMState((byte)11);
                    if (this.logger.requiresLogging(7)) {
                        this.logger.putPacketln(this, "Changing the TRAMState to Seeking Affil Head");
                    }
                    this.loadTimerToReceiveHaPacket();
                }
                if (tRAMHaPacket.getLstate() != 3 || !this.weAreBestLanVolunteer) break;
                this.weAreBestLanVolunteer = false;
                this.gblk.setLstate((byte)4);
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "Giving up..Better LAN Head discovered in " + tRAMHaPacket.getAddress());
                }
                if (tRAMHaPacket.getRxLevel() == 0) {
                    headBlock.setRootLanHead(true);
                    this.rootLanHeadExists = true;
                    break;
                }
                if (!headBlock.isRootLanHead()) break;
                this.rootLanHeadIsAffiliated = true;
                if (!this.logger.requiresLogging(7)) break;
                this.logger.putPacketln(this, "Root LAN head is affiliated");
                break;
            }
        }
    }

    private boolean isASuitableBackupHstate(byte by) {
        TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
        byte by2 = tRAMTransportProfile.getMrole();
        if (by2 == 1 && by == 2 || by2 != 1 && (by == 2 || by == 3)) {
            return true;
        }
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "HeadState " + by + " found Unsuitable");
        }
        return false;
    }

    private void processAmPacket(TRAMAmPacket tRAMAmPacket) {
        switch (this.tramblk.getTRAMState()) {
            case 8: {
                this.performHeadBinding(tRAMAmPacket);
                break;
            }
            case 12: {
                this.performReaffilHeadBinding(tRAMAmPacket);
                break;
            }
            case 9: {
                HeadBlock headBlock = this.gblk.getHeadBlock();
                if (headBlock.getAddress().equals(tRAMAmPacket.getAddress()) && headBlock.getPort() == tRAMAmPacket.getPort()) {
                    return;
                }
            }
            case 13: {
                if (this.toBeHead != null && this.toBeHead.getAddress().equals(tRAMAmPacket.getAddress()) && this.toBeHead.getPort() == tRAMAmPacket.getPort()) {
                    return;
                }
            }
            default: {
                TRAMMemberAck tRAMMemberAck = this.tramblk.getMemberAck();
                if (tRAMMemberAck == null) break;
                tRAMMemberAck.sendAckToNonAffiliatedHead(tRAMAmPacket.getAddress(), tRAMAmPacket.getPort(), (byte)2);
            }
        }
    }

    private void performHeadBinding(TRAMAmPacket tRAMAmPacket) {
        if (!tRAMAmPacket.getAddress().equals(this.toBeHead.getAddress()) || tRAMAmPacket.getPort() != this.toBeHead.getPort()) {
            return;
        }
        this.toBeHead.setStartSeqNumber(tRAMAmPacket.getStartSeqNumber());
        this.gblk.setHeadBlock(this.toBeHead);
        this.gblk.setRxLevel(this.toBeHead.getRxLevel() + 1);
        if (this.toBeHead.getLstate() == 3) {
            this.gblk.setLstate((byte)4);
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, "Assuming the role of a member - head " + this.toBeHead.getAddress() + " is a LAN HEAD");
            }
        }
        if (this.logger.requiresLogging(23)) {
            this.logger.putPacketln(this, "Binding to head " + tRAMAmPacket.getAddress() + " " + tRAMAmPacket.getPort() + ", starting seq " + tRAMAmPacket.getStartSeqNumber() + ", My Address is: " + this.myAddr + ", TTL is: " + this.toBeHead.getTTL());
        }
        this.toBeHead = null;
        this.hbReTxmitCount = 0;
        this.tramblk.setTRAMState((byte)9);
        if (this.gblk.getHstate() == 1 && this.tramblk.getTransportProfile().getMrole() != 1) {
            this.gblk.setHstate((byte)2);
        }
        if (this.logger.requiresLogging(3)) {
            this.logger.putPacketln(this, "Changing State to ATTAINED_MEMBERSHIP");
        }
        this.timer.stopTimer();
        TRAMMemberAck tRAMMemberAck = this.tramblk.getMemberAck();
        if (tRAMMemberAck == null) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Starting the MemberAckThread");
            }
            if ((tRAMMemberAck = new TRAMMemberAck(this.tramblk)) == null) {
                return;
            }
            this.tramblk.setMemberAck(tRAMMemberAck);
        }
        if (this.tramblk.getHelloThread() == null) {
            HelloThread helloThread = new HelloThread(this.tramblk);
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Spawned the Hello thread");
            }
        }
        if (this.tramblk.getTransportProfile().getMrole() != 1) {
            this.loadTimerToSendHaPkt();
            this.tramblk.getInputDispThread().addTRAMMsPacketListener(this);
            this.tramblk.getUcastInputDispThread().addTRAMAckPacketListener(this);
        }
        this.notifyMembershipListeners(new TRAMMembershipEvent(this));
    }

    private void performReaffilHeadBinding(TRAMAmPacket tRAMAmPacket) {
        if (tRAMAmPacket.getAddress().equals(this.toBeHead.getAddress()) && tRAMAmPacket.getPort() == this.toBeHead.getPort()) {
            this.toBeHead.setStartSeqNumber(tRAMAmPacket.getStartSeqNumber());
            TRAMSeqNumber tRAMSeqNumber = new TRAMSeqNumber(tRAMAmPacket.getStartSeqNumber());
            TRAMMemberAck tRAMMemberAck = this.tramblk.getMemberAck();
            if (!(tRAMMemberAck == null || tRAMMemberAck.checkPriorMissing(tRAMAmPacket.getStartSeqNumber()) && this.gblk.getHeadBlock() != null)) {
                if (this.logger.requiresLogging(23)) {
                    this.logger.putPacketln(this, "Reaffiliating now to head " + tRAMAmPacket.getAddress() + " " + tRAMAmPacket.getPort() + ", starting seq " + tRAMAmPacket.getStartSeqNumber() + ", My Address is: " + this.myAddr + ", TTL is: " + this.toBeHead.getTTL());
                }
                this.makeReAffilHeadToBeMainHead();
            } else {
                if (this.logger.requiresLogging(3)) {
                    this.logger.putPacketln(this, "Changing State to REAFFILIATED");
                }
                this.tramblk.setTRAMState((byte)13);
            }
            this.hbReTxmitCount = 0;
            this.timer.stopTimer();
            TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
            if (tRAMTransportProfile.getMrole() != 1) {
                if (this.gblk.getHstate() == 5) {
                    this.gblk.setHstate((byte)2);
                    if (this.gblk.getDirectMemberCount() >= tRAMTransportProfile.getMaxMembers()) {
                        this.gblk.setHstate((byte)4);
                    } else if (this.gblk.getMemberOnlyCount() + this.getMembersOnlyInToBeMembers() >= tRAMTransportProfile.getMaxNonHeads()) {
                        this.gblk.setHstate((byte)3);
                    }
                }
                this.loadTimerToSendHaPkt();
            }
        }
    }

    private void processRmPacket(TRAMRmPacket tRAMRmPacket) {
        if (this.tramblk.getTRAMState() != 8 && this.tramblk.getTRAMState() != 12) {
            return;
        }
        if (this.toBeHead.getAddress().equals(tRAMRmPacket.getAddress()) && this.toBeHead.getPort() == tRAMRmPacket.getPort()) {
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, " Received RM from the ToBeHead" + this.toBeHead.getAddress() + " " + this.toBeHead.getPort());
            }
            this.hbReTxmitCount = 0;
            if (this.tramblk.getTRAMState() == 12) {
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "Changing to Attained membership. Re-Affil head sent RM message");
                }
                this.tramblk.setTRAMState((byte)9);
                this.toBeHead = null;
                return;
            }
            if (this.haInterval == 0) {
                this.tramblk.setTRAMState((byte)7);
            } else {
                this.tramblk.setTRAMState((byte)6);
            }
            this.toBeHead = null;
            this.performHeadSelection();
            switch (this.tramblk.getTRAMState()) {
                case 6: {
                    this.loadTimerToReceiveHaPacket();
                    return;
                }
                case 7: {
                    this.sendMsPacket();
                    this.timer.reloadTimer(this.tramblk.getTransportProfile().getMsRate() & 0xFFFFFFFFL);
                    break;
                }
                case 8: {
                    this.timer.reloadTimer(2000L);
                    break;
                }
                default: {
                    if (this.logger.requiresLogging(7)) {
                        this.logger.putPacketln(this, "Invalid TRAM STATE. ERROR");
                    }
                    return;
                }
            }
        }
    }

    private void processAckPacket(TRAMAckPacket tRAMAckPacket) {
        if (this.gblk.getHstate() == 1) {
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, "Received ACK in INIT state");
            }
            return;
        }
        MemberBlock memberBlock = null;
        try {
            memberBlock = this.gblk.getMember(tRAMAckPacket.getAddress(), tRAMAckPacket.getPort());
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
        memberBlock.setLastheard(System.currentTimeMillis());
        memberBlock.clearMissedAcks();
        byte by = (byte)tRAMAckPacket.getFlags();
        if ((by & 1) != 0) {
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, "Hellos are not reaching member " + memberBlock.getAddress());
            }
            this.sendHelloUniPacket(memberBlock, (byte)0);
        }
        memberBlock.setDmemCount(tRAMAckPacket.getDirectMemberCount());
        memberBlock.setIndmemCount(tRAMAckPacket.getIndirectMemberCount());
        if (this.haInterval != 0) {
            TRAMTransportProfile tRAMTransportProfile;
            int n = tRAMAckPacket.getDirectHeadsAdvertising() + tRAMAckPacket.getIndirectHeadsAdvertising();
            boolean bl = false;
            if (n != memberBlock.getAdvertmemCount()) {
                this.indirectAdvertisingHeads += n;
                this.indirectAdvertisingHeads -= memberBlock.getAdvertmemCount();
                memberBlock.setAdvertmemCount(n);
                bl = true;
            }
            if ((tRAMTransportProfile = this.tramblk.getTransportProfile()).getTmode() != 2 && bl) {
                byte by2;
                int n2 = this.indirectAdvertisingHeads + this.gblk.getDirectAdvertisingMemberCount();
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "Sender Advt Count " + n2 + "indirect " + this.indirectAdvertisingHeads);
                }
                if ((by2 = this.gblk.getHstate()) == 2 || by2 == 3) {
                    ++n2;
                }
                if (n2 != this.advertisingHeads) {
                    if (this.logger.requiresLogging(7)) {
                        this.logger.putPacketln(this, "Previous Headcount " + this.advertisingHeads + " New ADVERTISING HEAD COUNT " + n2);
                    }
                    this.advertisingHeads = n2;
                    long l = 0L;
                    long l2 = tRAMTransportProfile.getMaxHABWWhileDataTransfer();
                    if (l2 != 0L) {
                        long l3 = (long)(this.advertisingHeads * 320) / l2;
                        long l4 = this.advertisingHeads / 30;
                        l = 1000L;
                        if (l < l3) {
                            l = l3;
                        }
                        if (l < l4) {
                            l = l4;
                        }
                        this.haInterval = (short)l;
                        if (this.logger.requiresLogging(7)) {
                            this.logger.putPacketln(this, "Adjusted HA Interval to " + this.haInterval);
                        }
                    }
                }
            }
        }
        if ((by & 2) != 0) {
            if (this.logger.requiresLogging(16)) {
                this.logger.putPacketln(this, "Member " + memberBlock.getAddress() + " " + memberBlock.getPort() + " has requested TERMINATION of membership");
            }
            this.disownMember(memberBlock, false);
            this.tramblk.getTRAMDataCache().purgeCache(0);
        }
    }

    private void processHelloUniPacket(TRAMHelloUniPacket tRAMHelloUniPacket) {
        HeadBlock headBlock = null;
        if (this.logger.requiresLogging(39)) {
            this.logger.putPacketln(this, "got a Hello Uni packet from " + tRAMHelloUniPacket.getAddress() + " TRAM State is " + this.tramblk.getTRAMState());
        }
        if ((headBlock = this.gblk.getHeadBlock()) == null) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "headblk is null...");
            }
        } else if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "head addr " + headBlock.getAddress() + ", pkt addr " + tRAMHelloUniPacket.getAddress() + ", head port " + headBlock.getPort() + ", pkt port " + tRAMHelloUniPacket.getPort());
        }
        switch (this.tramblk.getTRAMState()) {
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            default: {
                return;
            }
        }
        headBlock = this.gblk.getHeadBlock();
        if (headBlock != null && headBlock.getAddress().equals(tRAMHelloUniPacket.getAddress()) && headBlock.getPort() == tRAMHelloUniPacket.getPort()) {
            if ((tRAMHelloUniPacket.getFlags() & 1) != 0) {
                if (this.logger.requiresLogging(3)) {
                    this.logger.putPacketln(this, "Head is Disowning membership");
                }
                if (!this.tramblk.getTransportProfile().reaffiliateAfterBeingDisowned()) {
                    if (this.logger.requiresLogging(3)) {
                        this.logger.putPacketln(this, "Head is Disowning membership, exit now.");
                    }
                    System.exit(4);
                }
                this.gblk.setHeadBlock(null);
                this.handleHeadLoss();
                if (this.gblk.getDirectMemberCount() != 0) {
                    this.gblk.setHstate((byte)5);
                    this.tramblk.getHelloThread().sendSimpleHello();
                }
                this.tramblk.getTRAMDataCache().handlePrunedMember();
                return;
            }
            headBlock.setLastheard(System.currentTimeMillis());
        } else if (this.tramblk.getTRAMState() == 13 && (headBlock = this.getReAffiliationHead()) != null && headBlock.getAddress().equals(tRAMHelloUniPacket.getAddress()) && headBlock.getPort() == tRAMHelloUniPacket.getPort()) {
            if ((tRAMHelloUniPacket.getFlags() & 1) != 0) {
                if (this.logger.requiresLogging(3)) {
                    this.logger.putPacketln(this, "Reaffiliated Head is Disowning membership");
                }
                this.toBeHead = null;
                this.handleReAffiliatedHeadLoss();
                return;
            }
            headBlock.setLastheard(System.currentTimeMillis());
        }
    }

    public void receiveBeaconPacket(BeaconPacketEvent beaconPacketEvent) {
        this.pktsToProcess.addElement(beaconPacketEvent.getPacket());
        this.wake();
    }

    public void receiveTRAMHelloPacket(TRAMHelloPacketEvent tRAMHelloPacketEvent) {
        this.pktsToProcess.addElement(tRAMHelloPacketEvent.getPacket());
        this.wake();
    }

    public void receiveDataPacket(TRAMDataPacketEvent tRAMDataPacketEvent) {
        this.pktsToProcess.addElement(tRAMDataPacketEvent.getPacket());
        this.wake();
    }

    public void receiveTRAMHelloUniPacket(TRAMHelloUniPacketEvent tRAMHelloUniPacketEvent) {
        this.pktsToProcess.addElement(tRAMHelloUniPacketEvent.getPacket());
        this.wake();
    }

    public void receiveAckPacket(TRAMAckPacketEvent tRAMAckPacketEvent) {
        this.pktsToProcess.addElement(tRAMAckPacketEvent.getPacket());
        this.wake();
    }

    public void receiveTRAMAmPacket(TRAMAmPacketEvent tRAMAmPacketEvent) {
        this.pktsToProcess.addElement(tRAMAmPacketEvent.getPacket());
        this.wake();
    }

    public void receiveTRAMRmPacket(TRAMRmPacketEvent tRAMRmPacketEvent) {
        this.pktsToProcess.addElement(tRAMRmPacketEvent.getPacket());
        this.wake();
    }

    public void receiveTRAMHaPacket(TRAMHaPacketEvent tRAMHaPacketEvent) {
        if (this.getHaPacketsToProcess() < 25) {
            this.pktsToProcess.addElement(tRAMHaPacketEvent.getPacket());
            this.incrementHaPacketsToProcess();
            this.wake();
        }
    }

    public void receiveTRAMMsPacket(TRAMMsPacketEvent tRAMMsPacketEvent) {
        if (this.getMsPacketsToProcess() < 31) {
            this.pktsToProcess.addElement(tRAMMsPacketEvent.getPacket());
            this.incrementMsPacketsToProcess();
            this.wake();
        }
    }

    public void receiveTRAMHbPacket(TRAMHbPacketEvent tRAMHbPacketEvent) {
        this.pktsToProcess.addElement(tRAMHbPacketEvent.getPacket());
        this.wake();
    }

    private synchronized int getHaPacketsToProcess() {
        return this.haPacketsToProcess;
    }

    private synchronized void incrementHaPacketsToProcess() {
        ++this.haPacketsToProcess;
    }

    private synchronized void decrementHaPacketsToProcess() {
        if (this.haPacketsToProcess > 0) {
            --this.haPacketsToProcess;
        }
    }

    private synchronized int getMsPacketsToProcess() {
        return this.msPacketsToProcess;
    }

    private synchronized void incrementMsPacketsToProcess() {
        ++this.msPacketsToProcess;
    }

    private synchronized void decrementMsPacketsToProcess() {
        if (this.msPacketsToProcess > 0) {
            --this.msPacketsToProcess;
        }
    }

    private MemberBlock getToBeMember(InetAddress inetAddress, int n) throws NoSuchElementException {
        MemberBlock memberBlock = null;
        int n2 = 0;
        while (n2 < this.toBeMembers.size()) {
            memberBlock = (MemberBlock)this.toBeMembers.elementAt(n2);
            if (inetAddress.equals(memberBlock.getAddress()) && memberBlock.getPort() == n) {
                return memberBlock;
            }
            ++n2;
        }
        throw new NoSuchElementException();
    }

    public void handleTimeout() {
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "In handleTimeout routine");
        }
        TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
        switch (this.tramblk.getTRAMState()) {
            case 6: {
                if (--this.haTimeoutCount == 0 && this.backUpHeads.size() != 0) {
                    this.performHeadSelection();
                    if (this.tramblk.getTRAMState() == 8) {
                        this.timer.loadTimer(2000L);
                    }
                }
                if (this.tramblk.getTRAMState() != 8) {
                    this.loadTimerToReceiveHaPacket();
                }
                if (!this.weAreBestLanVolunteer) break;
                if (this.haTimeoutCount == 1) {
                    this.becomeLanHead();
                    break;
                }
                if (this.haTimeoutCount != 2) break;
                this.lanVolunteer();
                break;
            }
            case 7: {
                if (this.weAreBestLanVolunteer) {
                    this.becomeLanHead();
                }
                if (this.backUpHeads.size() != 0) {
                    this.performHeadSelection();
                    if (this.tramblk.getTRAMState() == 8) {
                        this.timer.loadTimer(2000L);
                        return;
                    }
                }
                this.sendMsPacket();
                this.timer.loadTimer(tRAMTransportProfile.getMsRate() & 0xFFFFFFFFL);
                break;
            }
            case 8: {
                this.hbReTxmitCount = (byte)(this.hbReTxmitCount + 1);
                if (this.hbReTxmitCount > 3) {
                    this.hbReTxmitCount = 0;
                    if (this.tryStartingMTHA(tRAMTransportProfile)) break;
                    this.tramblk.setTRAMState((byte)6);
                    if (this.logger.requiresLogging(7)) {
                        this.logger.putPacketln(this, "Changing to SEEKING_HA_MEMBERSHIP");
                    }
                    this.loadTimerToReceiveHaPacket();
                    break;
                }
                this.sendHbPacket();
                this.timer.loadTimer(2000L);
                break;
            }
            case 11: {
                if (this.backUpHeads.size() != 0) {
                    this.performHeadSelection();
                    if (this.tramblk.getTRAMState() == 12) {
                        this.timer.loadTimer(2000L);
                        return;
                    }
                }
                if (this.haInterval == 0) {
                    this.sendMsPacket();
                    this.timer.loadTimer(tRAMTransportProfile.getMsRate() & 0xFFFFFFFFL);
                    break;
                }
                this.loadTimerToReceiveHaPacket();
                break;
            }
            case 12: {
                this.hbReTxmitCount = (byte)(this.hbReTxmitCount + 1);
                if (this.hbReTxmitCount > 3) {
                    this.hbReTxmitCount = 0;
                    this.tramblk.setTRAMState((byte)9);
                    if (this.logger.requiresLogging(7)) {
                        this.logger.putPacketln(this, "Changing to Attained Mebership from Reaff head binding");
                    }
                    if (this.tramblk.getTransportProfile().getMrole() == 1) {
                        return;
                    }
                    this.loadTimerToSendHaPkt();
                    break;
                }
                this.sendHbPacket();
                this.timer.loadTimer(2000L);
                break;
            }
            case 2: {
                if (this.haInterval == 0 || this.gblk.getHstate() != 2 && this.gblk.getHstate() != 3) break;
                this.sendHaPacket();
                this.loadTimerToSendHaPkt();
                break;
            }
            case 3: {
                if (tRAMTransportProfile.getTreeFormationPreference(true) != 1) {
                    this.haInterval = 0;
                }
                if (this.gblk.getHstate() != 2 && this.gblk.getHstate() != 3) break;
                if (tRAMTransportProfile.getTreeFormationPreference(true) == 1) {
                    this.sendHaPacket();
                } else {
                    this.lanVolunteer();
                }
                this.loadTimerToSendHaPkt();
                break;
            }
            case 9: 
            case 13: {
                if (tRAMTransportProfile.getMrole() == 1 || this.gblk.getHstate() != 2 && this.gblk.getHstate() != 3) break;
                if (this.haInterval != 0) {
                    this.sendHaPacket();
                } else if (this.gblk.getLstate() == 3) {
                    this.lanVolunteer();
                }
                this.loadTimerToSendHaPkt();
                this.haTimeoutCount = this.haTimeoutCount == 0 ? 3 : --this.haTimeoutCount;
                if (!this.weAreBestLanVolunteer) break;
                if (this.haTimeoutCount == 1) {
                    this.becomeLanHead();
                    break;
                }
                if (this.haTimeoutCount != 2) break;
                this.lanVolunteer();
                break;
            }
            default: {
                if (!this.logger.requiresLogging(3)) break;
                this.logger.putPacketln(this, "No Timer Action for the TRAM State " + this.tramblk.getTRAMState());
            }
        }
    }

    private void sendAmPacket(InetAddress inetAddress, int n) {
        block6: {
            TRAMAmPacket tRAMAmPacket = new TRAMAmPacket(this.tramblk);
            tRAMAmPacket.setAddress(inetAddress);
            tRAMAmPacket.setPort(n);
            tRAMAmPacket.setStartSeqNumber(this.computeStartPacketForMember());
            if (this.logger.requiresLogging(51)) {
                this.logger.putPacketln(this, "Sending Am Packet to " + inetAddress + " " + n + " Starting sequence number is " + tRAMAmPacket.getStartSeqNumber());
            }
            DatagramPacket datagramPacket = tRAMAmPacket.createDatagramPacket();
            try {
                if (this.tramblk.getSimulator() != null) {
                    this.tramblk.getSimulator().simulateUnicastPacket(datagramPacket);
                    break block6;
                }
                try {
                    this.tramblk.getTRAMStats().setSendCntlMsgCounters(tRAMAmPacket);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.tramblk.getUnicastSocket().send(datagramPacket);
            }
            catch (IOException iOException) {
                if (!this.logger.requiresLogging(35)) break block6;
                this.logger.putPacketln(this, "Unable to dispatch an Am Packet");
            }
        }
    }

    private void sendRmPacket(InetAddress inetAddress, int n, int n2) {
        block9: {
            TRAMRmPacket tRAMRmPacket = new TRAMRmPacket(this.tramblk, n2);
            tRAMRmPacket.setAddress(inetAddress);
            tRAMRmPacket.setPort(n);
            DatagramPacket datagramPacket = tRAMRmPacket.createDatagramPacket();
            try {
                if (this.tramblk.getSimulator() != null) {
                    this.tramblk.getSimulator().simulateUnicastPacket(datagramPacket);
                } else {
                    try {
                        this.tramblk.getTRAMStats().setSendCntlMsgCounters(tRAMRmPacket);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    this.tramblk.getUnicastSocket().send(datagramPacket);
                }
                if (this.logger.requiresLogging(39)) {
                    this.logger.putPacketln(this, "Sent an Rm Packet");
                }
            }
            catch (IOException iOException) {
                if (!this.logger.requiresLogging(39)) break block9;
                this.logger.putPacketln(this, "Unable to dispatch an Rm Packet");
            }
        }
        if (this.weAreCurrentLanHead && !this.needNewLanHead) {
            this.needNewLanHead = true;
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "!!!Informing members to elect a new LAN HEAD");
            }
            this.lanVolunteer();
        }
    }

    private void sendHelloUniPacket(MemberBlock memberBlock, byte by) {
        block7: {
            long l = this.tramblk.getGroupMgmtBlk().getRttToSender();
            long l2 = l + memberBlock.getRTT() & 0xFFFFFFFFL;
            TRAMHelloUniPacket tRAMHelloUniPacket = new TRAMHelloUniPacket(this.tramblk);
            tRAMHelloUniPacket.setAddress(memberBlock.getAddress());
            tRAMHelloUniPacket.setPort(memberBlock.getPort());
            tRAMHelloUniPacket.setFlags(by);
            DatagramPacket datagramPacket = tRAMHelloUniPacket.createDatagramPacket();
            try {
                if (this.tramblk.getSimulator() != null) {
                    this.tramblk.getSimulator().simulateUnicastPacket(datagramPacket);
                } else {
                    try {
                        this.tramblk.getTRAMStats().setSendCntlMsgCounters(tRAMHelloUniPacket);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    this.tramblk.getUnicastSocket().send(datagramPacket);
                }
                if (this.logger.requiresLogging(39)) {
                    this.logger.putPacketln(this, "Sent a Hello Uni Packet to " + memberBlock.getAddress() + " " + memberBlock.getPort());
                }
            }
            catch (IOException iOException) {
                if (!this.logger.requiresLogging(39)) break block7;
                this.logger.putPacketln(this, "Unable to dispatch an HelloUni Packet to " + memberBlock.getAddress() + " " + memberBlock.getPort());
            }
        }
    }

    private void performHeadSelection() {
        HeadBlock headBlock;
        block20: {
            headBlock = null;
            HeadBlock headBlock2 = this.gblk.getHeadBlock();
            if (this.tramblk.getTRAMState() == 11 && this.gblk.getDirectMemberCount() != 0) {
                try {
                    headBlock = this.getBestSuitedHeadOnRxLevel(this.gblk.getRxLevel());
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (headBlock2 != null) {
                        if (headBlock2.getHstate() != 5) {
                            if (this.logger.requiresLogging(7)) {
                                this.logger.putPacketln(this, "Reverting to ATTAINED membership  from seeking reaffil head as head  is not resigning");
                            }
                            this.tramblk.setTRAMState((byte)9);
                        }
                        return;
                    }
                    this.gblk.setHstate((byte)5);
                    return;
                }
            }
            if (headBlock == null && headBlock2 != null) {
                try {
                    headBlock = this.getBestSuitedHeadOnTTL(headBlock2.getTTL());
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (this.tramblk.getTRAMState() != 11 || headBlock2.getHstate() == 5) break block20;
                    if (this.logger.requiresLogging(7)) {
                        this.logger.putPacketln(this, "CHANGING BACK to ATTAINED!!");
                    }
                    TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
                    this.tramblk.setTRAMState((byte)9);
                    if (tRAMTransportProfile.getTreeFormationPreference(true) == 1) {
                        this.loadTimerToSendHaPkt();
                    } else if (tRAMTransportProfile.getTreeFormationPreference(true) == 2 && !this.dataTxmStarted) {
                        this.loadTimerToSendHaPkt();
                    }
                    return;
                }
            }
        }
        if (headBlock == null) {
            try {
                headBlock = this.getBestSuitedHeadOnTTL();
            }
            catch (NoSuchElementException noSuchElementException) {
                return;
            }
        }
        if (this.tramblk.getTRAMState() == 11) {
            this.tramblk.setTRAMState((byte)12);
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Changing to REAFFIL HEAD BINDING Selected " + headBlock.getAddress() + " " + headBlock.getPort() + " As Reaffiliation Head");
            }
        } else {
            this.tramblk.setTRAMState((byte)8);
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Changing to HEAD BINDING Selected " + headBlock.getAddress() + " " + headBlock.getPort() + " As Head");
            }
        }
        this.toBeHead = headBlock;
        this.backUpHeads.removeElement(headBlock);
        this.hbReTxmitCount = 0;
        this.sendHbPacket();
    }

    private synchronized HeadBlock getBestSuitedHeadOnTTL() throws NoSuchElementException {
        HeadBlock headBlock = (HeadBlock)this.backUpHeads.firstElement();
        int n = headBlock.getRxLevel();
        int n2 = headBlock.getTTL() & 0xFF;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        while (n5 < this.backUpHeads.size()) {
            block4: {
                try {
                    HeadBlock headBlock2 = (HeadBlock)this.backUpHeads.elementAt(n5);
                    n3 = headBlock2.getTTL() & 0xFF;
                    n4 = headBlock2.getRxLevel();
                    if (n3 < n2) {
                        n2 = n3;
                        headBlock = headBlock2;
                        n = n4;
                        break block4;
                    }
                    if (n3 != n2 || n4 >= n) break block4;
                    headBlock = headBlock2;
                    n = n4;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    break;
                }
            }
            ++n5;
        }
        return headBlock;
    }

    private synchronized HeadBlock getBestSuitedHeadOnTTL(byte by) throws NoSuchElementException {
        int n = by & 0xFF;
        HeadBlock headBlock = this.getBestSuitedHeadOnTTL();
        int n2 = headBlock.getTTL() & 0xFF;
        if (n2 < n) {
            return headBlock;
        }
        throw new NoSuchElementException();
    }

    private synchronized HeadBlock getBestSuitedHeadOnRxLevel() throws NoSuchElementException {
        HeadBlock headBlock = (HeadBlock)this.backUpHeads.firstElement();
        int n = headBlock.getRxLevel();
        int n2 = headBlock.getTTL() & 0xFF;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        while (n5 < this.backUpHeads.size()) {
            block4: {
                try {
                    HeadBlock headBlock2 = (HeadBlock)this.backUpHeads.elementAt(n5);
                    n3 = headBlock2.getTTL() & 0xFF;
                    n4 = headBlock2.getRxLevel();
                    if (n4 < n) {
                        n2 = n3;
                        headBlock = headBlock2;
                        n = n4;
                        break block4;
                    }
                    if (n4 != n || n3 >= n2) break block4;
                    headBlock = headBlock2;
                    n2 = n3;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    break;
                }
            }
            ++n5;
        }
        return headBlock;
    }

    private synchronized HeadBlock getBestSuitedHeadOnRxLevel(int n) throws NoSuchElementException {
        HeadBlock headBlock = this.getBestSuitedHeadOnRxLevel();
        if (headBlock.getRxLevel() < n) {
            return headBlock;
        }
        throw new NoSuchElementException();
    }

    private void sendHaPacket() {
        block11: {
            if (this.gblk.getLstate() == 4) {
                return;
            }
            if (this.gblk.getLstate() != 0 && this.rootLanHeadExists && !this.rootLanHeadIsAffiliated) {
                return;
            }
            long l = System.currentTimeMillis() - this.gblk.getLastHASentTime();
            this.augmentHaTTL();
            if (l < 300L && this.gblk.getLastHaTTLSent() >= this.haTTL) {
                if (this.logger.requiresLogging(3)) {
                    this.logger.putPacketln(this, "Suppressing a HA. One was sent within 300ms");
                }
                return;
            }
            TRAMHaPacket tRAMHaPacket = new TRAMHaPacket(this.tramblk, (byte)this.haTTL, false);
            DatagramPacket datagramPacket = tRAMHaPacket.createDatagramPacket();
            try {
                if (this.tramblk.getSimulator() != null) {
                    this.tramblk.getSimulator().simulateMulticastPacket(datagramPacket, 3, this.haTTL);
                    break block11;
                }
                try {
                    this.tramblk.getTRAMStats().setSendCntlMsgCounters(tRAMHaPacket);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.ms.send(datagramPacket, (byte)this.haTTL);
                this.gblk.setLastHASentTime(System.currentTimeMillis());
                this.gblk.setLastHaTTLSent(this.haTTL);
                if (this.logger.requiresLogging(39)) {
                    this.logger.putPacketln(this, "Dispatched a HA message");
                }
            }
            catch (IOException iOException) {
                if (!this.logger.requiresLogging(39)) break block11;
                this.logger.putPacketln(this, "Unable to dispatch an HA Packet");
            }
        }
        if (this.haTTL > 1) {
            this.lanVolunteer();
        }
    }

    private void sendHaPacket(byte by) {
        block10: {
            if (this.gblk.getLstate() == 4) {
                return;
            }
            if (this.gblk.getLstate() != 0 && this.rootLanHeadExists && !this.rootLanHeadIsAffiliated) {
                return;
            }
            long l = System.currentTimeMillis() - this.gblk.getLastHASentTime();
            if (l < 300L && this.gblk.getLastHaTTLSent() >= by) {
                if (this.logger.requiresLogging(35)) {
                    this.logger.putPacketln(this, "Suppressing a HA. Last to the TTL is within 300ms");
                }
                return;
            }
            TRAMHaPacket tRAMHaPacket = new TRAMHaPacket(this.tramblk, by, false);
            DatagramPacket datagramPacket = tRAMHaPacket.createDatagramPacket();
            try {
                if (this.tramblk.getSimulator() != null) {
                    this.tramblk.getSimulator().simulateMulticastPacket(datagramPacket, 3, by);
                    break block10;
                }
                try {
                    this.tramblk.getTRAMStats().setSendCntlMsgCounters(tRAMHaPacket);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.ms.send(datagramPacket, by);
                this.gblk.setLastHASentTime(System.currentTimeMillis());
                this.gblk.setLastHaTTLSent(by);
                if (this.logger.requiresLogging(39)) {
                    this.logger.putPacketln(this, "Dispatched a HA message");
                }
            }
            catch (IOException iOException) {
                if (!this.logger.requiresLogging(35)) break block10;
                this.logger.putPacketln(this, "Unable to dispatch an HA Packet");
            }
        }
    }

    private void lanVolunteer() {
        block7: {
            if (this.tramblk.getTransportProfile().isLanTreeFormationEnabled() && this.weAreBestLanVolunteer) {
                TRAMHaPacket tRAMHaPacket = new TRAMHaPacket(this.tramblk, 1, this.needNewLanHead);
                DatagramPacket datagramPacket = tRAMHaPacket.createDatagramPacket();
                try {
                    if (this.tramblk.getSimulator() != null) {
                        this.tramblk.getSimulator().simulateMulticastPacket(datagramPacket, 3, 1);
                        break block7;
                    }
                    try {
                        this.tramblk.getTRAMStats().setSendCntlMsgCounters(tRAMHaPacket);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    this.ms.send(datagramPacket, (byte)1);
                    if (this.logger.requiresLogging(39)) {
                        this.logger.putPacketln(this, "Sent a Lan Volunteer (HA) Packet");
                    }
                }
                catch (IOException iOException) {
                    if (!this.logger.requiresLogging(35)) break block7;
                    this.logger.putPacketln(this, "Unable to dispatch a Lan Volunteer (HA) Packet");
                }
            }
        }
    }

    private void becomeLanHead() {
        if (this.tramblk.getTransportProfile().isLanTreeFormationEnabled() && this.gblk.getLstate() != 3) {
            this.gblk.setLstate((byte)3);
            this.weAreCurrentLanHead = true;
            if (this.logger.requiresLogging(3)) {
                this.logger.putPacketln(this, "Assumed the role of a LAN HEAD");
            }
            this.lanVolunteer();
        }
    }

    private boolean isBetterLanHead(TRAMHaPacket tRAMHaPacket) {
        if (this.isAPacketFromTheDataSource(tRAMHaPacket)) {
            return true;
        }
        if (tRAMHaPacket.getMrole() == 2) {
            if (this.tramblk.getTransportProfile().getMrole() == 3) {
                return true;
            }
        } else if (this.tramblk.getTransportProfile().getMrole() == 2) {
            return false;
        }
        if (tRAMHaPacket.getRxLevel() < this.gblk.getRxLevel()) {
            return true;
        }
        if (tRAMHaPacket.getRxLevel() > this.gblk.getRxLevel()) {
            return false;
        }
        int n = tRAMHaPacket.getAddress().getHostAddress().compareTo(this.myAddr.getHostAddress());
        if (n < 0) {
            return true;
        }
        if (n > 0) {
            return false;
        }
        return tRAMHaPacket.getUnicastPort() < this.tramblk.getUnicastPort();
    }

    public void validateSenderLiveliness() {
        long l = this.tramblk.getLastHeardFromTheSender();
        if (l != 0L) {
            long l2 = System.currentTimeMillis() - l;
            if (l2 < 250000L) {
                return;
            }
            if (this.logger.requiresLogging(167)) {
                this.logger.putPacketln(this, "Sender is OFFLINE.. reporting to the Application");
            }
            this.tramblk.getTRAMDataCache().handleSessionDown();
            AbortTRAM abortTRAM = new AbortTRAM("AbortTRAM", this.tramblk);
        }
    }

    private void sendMsPacket() {
        block7: {
            this.validateSenderLiveliness();
            this.augmentMsTTL();
            TRAMMsPacket tRAMMsPacket = new TRAMMsPacket(this.tramblk, (int)System.currentTimeMillis(), (byte)this.msTTL);
            DatagramPacket datagramPacket = tRAMMsPacket.createDatagramPacket();
            try {
                if (this.tramblk.getSimulator() != null) {
                    this.tramblk.getSimulator().simulateMulticastPacket(datagramPacket, 4, this.msTTL);
                } else {
                    try {
                        this.tramblk.getTRAMStats().setSendCntlMsgCounters(tRAMMsPacket);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    this.ms.send(datagramPacket, (byte)this.msTTL);
                }
                if (this.logger.requiresLogging(39)) {
                    this.logger.putPacketln(this, "Dispatched a MS Packet");
                }
            }
            catch (IOException iOException) {
                if (!this.logger.requiresLogging(35)) break block7;
                this.logger.putPacketln(this, "Unable to dispatch an MS Packet");
            }
        }
    }

    private void sendHbPacket() {
        block10: {
            try {
                TRAMHbPacket tRAMHbPacket = new TRAMHbPacket(this.tramblk, this.toBeHead.getTTL());
                tRAMHbPacket.setAddress(this.toBeHead.getAddress());
                tRAMHbPacket.setPort(this.toBeHead.getPort());
                DatagramPacket datagramPacket = tRAMHbPacket.createDatagramPacket();
                DatagramSocket datagramSocket = this.tramblk.getUnicastSocket();
                try {
                    if (this.tramblk.getSimulator() != null) {
                        this.tramblk.getSimulator().simulateUnicastPacket(datagramPacket);
                    } else {
                        try {
                            this.tramblk.getTRAMStats().setSendCntlMsgCounters(tRAMHbPacket);
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                        datagramSocket.send(datagramPacket);
                    }
                    if (this.logger.requiresLogging(35)) {
                        this.logger.putPacketln(this, " Sending a head bind packet to " + this.toBeHead.getAddress() + " " + this.toBeHead.getPort());
                    }
                }
                catch (IOException iOException) {
                    if (this.logger.requiresLogging(39)) {
                        this.logger.putPacketln(this, "Unable to dispatch an HB Packet");
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!this.logger.requiresLogging(35)) break block10;
                this.logger.putPacketln(this, " Unable to send HB message. No Head Block");
            }
        }
    }

    private synchronized void augmentHaTTL() {
        TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
        if (this.haTTL == (tRAMTransportProfile.getTTL() & 0xFF)) {
            return;
        }
        if (this.haTTL == (tRAMTransportProfile.getHaTTLLimit() & 0xFF)) {
            return;
        }
        if (this.isHaIncrementSuppressionRequired()) {
            this.decrementHaIncrementSuppressionCounter();
            return;
        }
        if (this.haTTL < (tRAMTransportProfile.getTTL() & 0xFF)) {
            this.haTTL += tRAMTransportProfile.getHaTTLIncrements() & 0xFF;
        }
        if (this.haTTL > (tRAMTransportProfile.getTTL() & 0xFF)) {
            this.haTTL = tRAMTransportProfile.getTTL() & 0xFF;
        }
        if (this.haTTL > (tRAMTransportProfile.getHaTTLLimit() & 0xFF)) {
            this.haTTL = tRAMTransportProfile.getHaTTLLimit() & 0xFF;
        }
    }

    private synchronized void augmentMsTTL() {
        TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "msTTL is " + this.msTTL + " session TTL is " + (tRAMTransportProfile.getTTL() & 0xFF));
        }
        if (this.msTTL == (tRAMTransportProfile.getTTL() & 0xFF)) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "msTTL is at max value of " + this.msTTL);
            }
            return;
        }
        if (this.msTTL < (tRAMTransportProfile.getTTL() & 0xFF)) {
            this.msTTL += tRAMTransportProfile.getMsTTLIncrements() & 0xFF;
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "msTTL incremented by " + (tRAMTransportProfile.getMsTTLIncrements() & 0xFF) + " to " + this.msTTL);
            }
        }
        if (this.msTTL > (tRAMTransportProfile.getTTL() & 0xFF)) {
            this.msTTL = tRAMTransportProfile.getTTL() & 0xFF;
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "msTTL reset to " + (tRAMTransportProfile.getTTL() & 0xFF));
            }
        }
    }

    private synchronized void updateRepairTTL() {
        MemberBlock memberBlock = null;
        int n = 0;
        try {
            memberBlock = this.gblk.getMember(0);
            n = memberBlock.getTTL() & 0xFF;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (this.gblk.getRetransmitTTL() != 0) {
                this.gblk.setRetransmitTTL((byte)0);
            }
            return;
        }
        int n2 = 0;
        int n3 = 1;
        while (n3 < this.gblk.getDirectMemberCount()) {
            block7: {
                try {
                    memberBlock = this.gblk.getMember(n3);
                    n2 = memberBlock.getTTL() & 0xFF;
                    if (n2 <= n) break block7;
                    n = n2;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    break;
                }
            }
            ++n3;
        }
        n2 = this.gblk.getRetransmitTTL() & 0xFF;
        if (n > n2) {
            this.gblk.setRetransmitTTL((byte)n);
        }
    }

    private synchronized boolean isHaIncrementSuppressionRequired() {
        return this.haIncrementSuppressionCounter != 0;
    }

    private synchronized void decrementHaIncrementSuppressionCounter() {
        if (this.haIncrementSuppressionCounter != 0) {
            --this.haIncrementSuppressionCounter;
        }
    }

    private synchronized void loadHaIncrementSuppressionCounter() {
        this.haIncrementSuppressionCounter = 7;
    }

    public synchronized void handleHeadLoss() {
        long l = 0L;
        if (this.logger.requiresLogging(3)) {
            this.logger.putPacketln(this, "Head Loss DETECTED, Re-affiliating");
        }
        if (this.tramblk.getTRAMState() == 13) {
            this.makeReAffilHeadToBeMainHead();
            return;
        }
        this.sendTerminateMembershipMessage(this.gblk.getHeadBlock());
        if (this.gblk.getDirectMemberCount() == 0) {
            if (this.haInterval == 0) {
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "Transitioning to MTHA membership");
                }
                this.tramblk.setTRAMState((byte)7);
            } else {
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "Transitioning to HA Membership");
                }
                this.tramblk.setTRAMState((byte)6);
            }
        } else {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Transitioning to SEEKING RE_AFFIL HEAD.Hd loss");
            }
            this.tramblk.setTRAMState((byte)11);
        }
        this.gblk.setHeadBlock(null);
        if (this.backUpHeads.size() != 0) {
            this.performHeadSelection();
        }
        switch (this.tramblk.getTRAMState()) {
            case 8: {
                this.timer.reloadTimer(2000L);
                break;
            }
            case 6: {
                this.loadTimerToReceiveHaPacket();
                break;
            }
            case 7: {
                this.sendMsPacket();
                this.timer.reloadTimer(this.tramblk.getTransportProfile().getMsRate());
                break;
            }
        }
    }

    public synchronized void handleReAffiliatedHeadLoss() {
        long l = 0L;
        if (this.logger.requiresLogging(3)) {
            this.logger.putPacketln(this, "Re-AffiliatedHead Loss DETECTED. Transitioning to Attained membership");
        }
        this.tramblk.setTRAMState((byte)9);
        this.sendTerminateMembershipMessage(this.toBeHead);
        this.toBeHead = null;
    }

    public void makeReAffilHeadToBeMainHead() {
        this.sendTerminateMembershipMessage(this.gblk.getHeadBlock());
        this.gblk.setHeadBlock(this.toBeHead);
        if (this.logger.requiresLogging(3)) {
            this.logger.putPacketln(this, "Changing State to ATTAINED MEMBERSHIP");
        }
        this.tramblk.setTRAMState((byte)9);
        this.gblk.setRxLevel(this.toBeHead.getRxLevel() + 1);
        this.toBeHead = null;
        this.notifyMembershipListeners(new TRAMMembershipEvent(this));
    }

    private void sendTerminateMembershipMessage(HeadBlock headBlock) {
        TRAMMemberAck tRAMMemberAck = this.tramblk.getMemberAck();
        if (tRAMMemberAck != null && headBlock != null) {
            tRAMMemberAck.sendAck((byte)2, headBlock);
        }
    }

    public synchronized void handleMemberLoss(MemberBlock memberBlock) {
        long l = 0L;
        if (this.logger.requiresLogging(3)) {
            this.logger.putPacketln(this, "Member Loss DETECTED. Disowning Member " + memberBlock.getAddress() + " " + memberBlock.getPort());
        }
        this.sendHelloUniPacket(memberBlock, (byte)1);
        this.disownMember(memberBlock, false);
    }

    public void showMemberInfo() {
        MemberBlock memberBlock = null;
        int n = 0;
        while (n < this.gblk.getDirectMemberCount()) {
            block3: {
                try {
                    memberBlock = this.gblk.getMember(n);
                    if (!this.logger.requiresLogging(135)) break block3;
                    this.logger.putPacketln(this, memberBlock.getAddress() + " Direct Mem " + memberBlock.getDmemCount() + ", Indir Mem " + memberBlock.getIndmemCount() + ", lastAck " + memberBlock.getLastPacketAcked() + ", High seq " + memberBlock.getHighestSequenceAllowed() + ", Flow control info " + memberBlock.getFlowControlInfo() + ", Group flow control info " + this.tramblk.getRateAdjuster().getGroupFlowControlInfo());
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    break;
                }
            }
            ++n;
        }
    }

    private synchronized void disownMember(MemberBlock memberBlock, boolean bl) {
        this.showMemberInfo();
        this.gblk.removeMember(memberBlock);
        if (!bl) {
            this.tramblk.getTRAMStats().addPrunedMembers();
        }
        this.tramblk.setHighestSequenceAllowed(this.gblk.getHighestSequenceAllowed());
        if (this.logger.requiresLogging(151)) {
            String string = "";
            if (bl) {
                string = "(REAFFILIATED) ";
            }
            this.logger.putPacketln(this, "Disown Member " + string + memberBlock.getAddress() + " " + memberBlock.getPort() + " highest allowed before disown " + this.tramblk.getHighestSequenceAllowed() + " highest allowed after disown " + this.tramblk.getHighestSequenceAllowed());
        }
        int n = this.gblk.getDirectMemberCount();
        TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
        switch (this.gblk.getHstate()) {
            case 3: {
                if (n + this.getMembersOnlyInToBeMembers() >= tRAMTransportProfile.getMaxNonHeads()) break;
                this.gblk.setHstate((byte)2);
                break;
            }
            case 4: {
                if (n + this.getMembersOnlyInToBeMembers() < tRAMTransportProfile.getMaxNonHeads()) {
                    this.gblk.setHstate((byte)2);
                    break;
                }
                if (n >= tRAMTransportProfile.getMaxMembers()) break;
                this.gblk.setHstate((byte)3);
                break;
            }
            case 5: {
                if (n != 0 || this.gblk.getHeadBlock() != null) break;
                this.gblk.setHstate((byte)1);
                break;
            }
        }
    }

    public void terminate() {
        if (this.logger.requiresLogging(3)) {
            this.logger.putPacketln(this, "Terminating Group Management thread");
        }
        PrintWriter printWriter = null;
        InetAddress inetAddress = null;
        String string = null;
        InetAddress inetAddress2 = null;
        TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
        if (tRAMTransportProfile.getTreeFormationPreference(false) >= 96) {
            block17: {
                try {
                    printWriter = new PrintWriter(new FileWriter(this.cfgfile));
                    if (this.logger.requiresLogging(1023)) {
                        this.logger.putPacketln(this, "Writing tree config file");
                    }
                }
                catch (IOException iOException) {
                    if (!this.logger.requiresLogging(1023)) break block17;
                    this.logger.putPacketln(this, iOException.toString());
                }
            }
            HeadBlock headBlock = this.gblk.getHeadBlock();
            if (this.gblk.getDirectMemberCount() > 0) {
                printWriter.println(this.myAddr + " 0");
            }
            if (headBlock != null) {
                inetAddress2 = headBlock.getAddress();
                string = inetAddress2.getHostAddress();
                printWriter.println(string + " " + headBlock.getTTL());
            }
            int n = 0;
            while (n < this.backUpHeads.size()) {
                try {
                    headBlock = (HeadBlock)this.backUpHeads.elementAt(n);
                    inetAddress = headBlock.getAddress();
                    if (!inetAddress.equals(inetAddress2)) {
                        string = inetAddress.getHostAddress();
                        printWriter.println(string + " " + headBlock.getTTL());
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                ++n;
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
        if (this.gblk.getDirectMemberCount() != 0) {
            this.gblk.setHstate((byte)5);
            try {
                this.tramblk.getHelloThread().sendSimpleHello();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (this.timer != null && this.timer.isAlive()) {
            this.timer.stopTimer();
            this.timer.killTimer();
        }
        this.tramblk.setGroupMgmtThread(null);
        if (this.tramblk.getSimulator() == null) {
            this.ms.close();
        }
        this.done = true;
        this.interrupt();
    }

    private synchronized boolean addedToTheBackupHeadList(HeadBlock headBlock) {
        HeadBlock headBlock2 = null;
        if (this.backUpHeads.size() < 10) {
            this.backUpHeads.addElement(headBlock);
            return true;
        }
        int n = 0;
        while (n < this.backUpHeads.size()) {
            try {
                headBlock2 = (HeadBlock)this.backUpHeads.elementAt(n);
                long l = System.currentTimeMillis() - headBlock2.getLastheard();
                if (l > 10000L) {
                    this.backUpHeads.removeElementAt(n);
                    this.backUpHeads.addElement(headBlock);
                    return true;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                break;
            }
            ++n;
        }
        HeadBlock headBlock3 = null;
        try {
            headBlock3 = (HeadBlock)this.backUpHeads.firstElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            this.backUpHeads.addElement(headBlock);
            return true;
        }
        n = 1;
        while (n < this.backUpHeads.size()) {
            try {
                headBlock2 = (HeadBlock)this.backUpHeads.elementAt(n);
                if (headBlock3.getTTL() < headBlock2.getTTL()) {
                    headBlock3 = headBlock2;
                } else if (headBlock3.getTTL() == headBlock2.getTTL() && headBlock3.getRxLevel() < headBlock2.getRxLevel()) {
                    headBlock3 = headBlock2;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++n;
        }
        if (headBlock3.getTTL() > headBlock.getTTL() || headBlock3.getTTL() == headBlock.getTTL() && headBlock3.getRxLevel() > headBlock.getRxLevel()) {
            this.backUpHeads.removeElement(headBlock3);
            this.backUpHeads.addElement(headBlock);
            return true;
        }
        return false;
    }

    private HeadBlock getBackupHead(InetAddress inetAddress, int n) throws NoSuchElementException {
        HeadBlock headBlock = null;
        int n2 = 0;
        while (n2 < this.backUpHeads.size()) {
            try {
                headBlock = (HeadBlock)this.backUpHeads.elementAt(n2);
                if (inetAddress.equals(headBlock.getAddress()) && n == headBlock.getPort()) {
                    return headBlock;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++n2;
        }
        throw new NoSuchElementException();
    }

    private int getMembersOnlyInToBeMembers() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.toBeMembers.size()) {
            MemberBlock memberBlock = null;
            try {
                memberBlock = (MemberBlock)this.toBeMembers.elementAt(n2);
                if (memberBlock.getMrole() == 1) {
                    ++n;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++n2;
        }
        return n;
    }

    public HeadBlock getReAffiliationHead() {
        return this.toBeHead;
    }

    public void printDataCounts() {
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Packets to process = " + this.pktsToProcess.size());
            this.logger.putPacketln(this, "To be members      = " + this.toBeMembers.size());
            this.logger.putPacketln(this, "Back up Heads       = " + this.backUpHeads.size());
        }
    }

    short getHaInterval() {
        return this.haInterval;
    }

    short getDataHaInterval() {
        if (this.tramblk.getTransportProfile().getTreeFormationPreference(true) == 1) {
            return this.haInterval;
        }
        return 0;
    }

    public void addTRAMMembershipListener(TRAMMembershipListener tRAMMembershipListener) {
        this.membershipListeners.addElement(tRAMMembershipListener);
    }

    public void removeTRAMMembershipListener(TRAMMembershipListener tRAMMembershipListener) {
        this.membershipListeners.removeElement(tRAMMembershipListener);
    }

    public void notifyMembershipListeners(TRAMMembershipEvent tRAMMembershipEvent) {
        int n = 0;
        while (n < this.membershipListeners.size()) {
            ((TRAMMembershipListener)this.membershipListeners.elementAt(n)).receiveTRAMMembership(tRAMMembershipEvent);
            ++n;
        }
    }

    private synchronized void stall() {
        block2: {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                if (!this.logger.requiresLogging(7)) break block2;
                this.logger.putPacketln(this, "Interrupted!");
            }
        }
    }

    private synchronized void wake() {
        this.notifyAll();
    }

    private int computeStartPacketForMember() {
        int n;
        TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
        if (tRAMTransportProfile.getLateJoinPreference() == 3) {
            if (tRAMTransportProfile.getTmode() == 1) {
                n = this.tramblk.getTRAMDataCache().getHighestSequenceNumberinCache();
                if (n == 0) {
                    n = 1;
                }
            } else {
                TRAMMemberAck tRAMMemberAck = this.tramblk.getMemberAck();
                TRAMSeqNumber tRAMSeqNumber = new TRAMSeqNumber(tRAMMemberAck.getNextPktSeqNumberToReceive());
                n = tRAMSeqNumber.getSeqNumber();
            }
        } else {
            n = ((TRAMGenericDataCache)this.tramblk.getTRAMDataCache()).getLimitedRecoverSequenceNumber();
        }
        if (this.logger.requiresLogging(16)) {
            this.logger.putPacketln(this, "starting seq number is " + n);
        }
        return n;
    }
}

