/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.GroupMembershipMask;
import com.sun.multicast.reliable.transport.tram.HeadBlock;
import com.sun.multicast.reliable.transport.tram.MemberBlock;
import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMLogger;
import com.sun.multicast.reliable.transport.tram.TRAMSeqNumber;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.net.InetAddress;
import java.util.NoSuchElementException;
import java.util.Vector;

class GroupMgmtBlk {
    TRAMControlBlock tramblk;
    TRAMLogger logger;
    TRAMTransportProfile tp;
    private long rttToSender = 0L;
    private byte currentMrole = (byte)2;
    private int rxLevel = 0;
    private HeadBlock headBlock = null;
    private Vector memberList = null;
    private GroupMembershipMask memberMask = null;
    private byte retransmitTTL = 0;
    private byte cstate = 1;
    private byte hstate = 1;
    private byte lstate = 0;
    private long helloPeriod = 0L;
    private int peakMemberCount;
    private long lastHaSentTime = 0L;
    private int lastHaTTLSent = 0;

    public GroupMgmtBlk(TRAMControlBlock tRAMControlBlock) {
        this.tramblk = tRAMControlBlock;
        this.tp = tRAMControlBlock.getTransportProfile();
        this.logger = tRAMControlBlock.getLogger();
        if (this.tp.getMrole() != 1) {
            int n = this.tp.getMaxMembers() & 0xFFFF;
            this.memberList = new Vector(n);
            this.memberMask = new GroupMembershipMask(n, this.logger);
        }
    }

    public MemberBlock getMember(InetAddress inetAddress, int n) throws NoSuchElementException {
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Retrieve member with address " + inetAddress.toString() + " and port = " + n);
        }
        int n2 = 0;
        while (n2 < this.memberList.size()) {
            MemberBlock memberBlock = (MemberBlock)this.memberList.elementAt(n2);
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Member = " + memberBlock.getAddress().toString() + " and port = " + memberBlock.getPort());
            }
            if (inetAddress.equals(memberBlock.getAddress()) && memberBlock.getPort() == n) {
                return memberBlock;
            }
            ++n2;
        }
        throw new NoSuchElementException();
    }

    public MemberBlock getMember(int n) throws IndexOutOfBoundsException {
        MemberBlock memberBlock = (MemberBlock)this.memberList.elementAt(n);
        return memberBlock;
    }

    public void putMember(MemberBlock memberBlock) {
        int n;
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Adding member with address " + memberBlock.getAddress().toString() + " " + memberBlock.getPort());
        }
        if ((n = this.memberMask.assignNewMemberBit()) == 0) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Unable to add the Member to the MemberList");
            }
            return;
        }
        memberBlock.setMemberId(n);
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Member id = " + n);
        }
        if (memberBlock.getLastPacketAcked() + this.tp.getCongestionWindow() > this.getHighestSequenceAllowed()) {
            memberBlock.setHighestSequenceAllowed(memberBlock.getLastPacketAcked() + this.tp.getCongestionWindow());
        } else {
            memberBlock.setHighestSequenceAllowed(this.getHighestSequenceAllowed());
        }
        this.memberList.addElement(memberBlock);
        this.tramblk.setHighestSequenceAllowed(this.getHighestSequenceAllowed());
        if (this.logger.requiresLogging(23)) {
            this.logger.putPacketln(this, "putMember " + memberBlock.getAddress() + " " + memberBlock.getPort() + ", Member id = " + n + ", lastAcked " + memberBlock.getLastPacketAcked() + ", mb highest seq " + memberBlock.getHighestSequenceAllowed() + ", highest seq " + this.tramblk.getHighestSequenceAllowed());
        }
        if (this.memberList.size() > this.peakMemberCount) {
            this.peakMemberCount = this.memberList.size();
        }
        if (this.tramblk.getSimulator() != null) {
            this.tramblk.getSimulator().memberCountChange(this.tramblk.getTransportProfile().getUnicastPort(), this.memberList.size());
        }
    }

    public void removeMember(MemberBlock memberBlock) {
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Removing member with address " + memberBlock.getAddress().toString() + " Port " + memberBlock.getPort());
        }
        if (this.memberList.removeElement(memberBlock)) {
            this.memberMask.clearMemberBit(memberBlock.getMemberId());
            if (this.tramblk.getSimulator() != null) {
                this.tramblk.getSimulator().memberCountChange(this.tramblk.getTransportProfile().getUnicastPort(), this.memberList.size());
            }
        }
        this.tramblk.getTRAMDataCache().purgeCache(-1);
    }

    public HeadBlock getHeadBlock() {
        return this.headBlock;
    }

    public void setHeadBlock(HeadBlock headBlock) {
        this.headBlock = headBlock;
        if (this.tramblk.getSimulator() != null) {
            if (headBlock != null) {
                this.tramblk.getSimulator().headChange(this.tp.getUnicastPort(), headBlock.getPort());
            } else {
                this.tramblk.getSimulator().headChange(this.tp.getUnicastPort(), 0);
            }
        }
    }

    public GroupMembershipMask getMemberMask() {
        GroupMembershipMask groupMembershipMask;
        block2: {
            groupMembershipMask = null;
            try {
                groupMembershipMask = (GroupMembershipMask)this.memberMask.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                if (!this.logger.requiresLogging(7)) break block2;
                this.logger.putPacketln(this, "Clone not supported ERROR");
            }
        }
        return groupMembershipMask;
    }

    public byte getCstate() {
        return this.cstate;
    }

    public byte getHstate() {
        return this.hstate;
    }

    public void setHstate(byte by) {
        this.hstate = by;
        if (this.tramblk.getSimulator() != null) {
            this.tramblk.getSimulator().stateChange(this.tp.getUnicastPort(), by);
        }
    }

    public byte getLstate() {
        return this.lstate;
    }

    public void setLstate(byte by) {
        this.lstate = this.tp.isLanTreeFormationEnabled() ? by : (byte)0;
    }

    public byte getRetransmitTTL() {
        return this.retransmitTTL;
    }

    public long getRttToSender() {
        return this.rttToSender;
    }

    public byte getCurrentMrole() {
        return this.currentMrole;
    }

    public int getRxLevel() {
        return this.rxLevel;
    }

    public long getHelloPeriod() {
        return this.helloPeriod;
    }

    public void setHelloPeriod(long l) {
        this.helloPeriod = l;
    }

    public void setCstate(byte by) {
        this.cstate = by;
    }

    public void setRetransmitTTL(byte by) {
        this.retransmitTTL = by;
    }

    public void setRttToSender(long l) {
        this.rttToSender = l;
    }

    public void setRxLevel(int n) {
        this.rxLevel = n;
        if (this.tramblk.getSimulator() != null) {
            this.tramblk.getSimulator().levelChange(this.tp.getUnicastPort(), n);
        }
    }

    public synchronized void createMemberList(int n) {
        if (this.memberList == null) {
            this.memberList = new Vector(n);
        }
    }

    public synchronized void deleteMemberList() {
        if (this.memberList != null) {
            this.memberList.removeAllElements();
            this.memberList = null;
        }
        if (this.tramblk.getSimulator() != null) {
            this.tramblk.getSimulator().memberCountChange(this.tramblk.getTransportProfile().getUnicastPort(), 0);
        }
    }

    public int getDirectMemberCount() {
        if (this.memberList == null) {
            return 0;
        }
        return this.memberList.size();
    }

    public int getIndirectMemberCount() {
        if (this.memberList == null) {
            return 0;
        }
        int n = 0;
        Vector vector = this.memberList;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < this.memberList.size()) {
                MemberBlock memberBlock = (MemberBlock)this.memberList.elementAt(n2);
                n += memberBlock.getDmemCount() + memberBlock.getIndmemCount();
                ++n2;
            }
        }
        return n;
    }

    public int getPeakMemberCount() {
        return this.peakMemberCount;
    }

    public int getMemberOnlyCount() {
        if (this.memberList == null) {
            return 0;
        }
        int n = 0;
        Vector vector = this.memberList;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < this.memberList.size()) {
                MemberBlock memberBlock = (MemberBlock)this.memberList.elementAt(n2);
                if (memberBlock.getMrole() == 1) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    public int getIndirectAdvertisingMemberCount() {
        if (this.memberList == null) {
            return 0;
        }
        int n = 0;
        Vector vector = this.memberList;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < this.memberList.size()) {
                MemberBlock memberBlock = (MemberBlock)this.memberList.elementAt(n2);
                n += memberBlock.getAdvertmemCount();
                ++n2;
            }
        }
        return n;
    }

    public int getDirectAdvertisingMemberCount() {
        if (this.memberList == null) {
            return 0;
        }
        int n = 0;
        Vector vector = this.memberList;
        synchronized (vector) {
            if (this.logger.requiresLogging(7)) {
                this.logger.putPacketln(this, "Total members is " + this.memberList.size());
            }
            int n2 = 0;
            while (n2 < this.memberList.size()) {
                MemberBlock memberBlock = (MemberBlock)this.memberList.elementAt(n2);
                byte by = memberBlock.getMrole();
                byte by2 = (byte)memberBlock.getHstate();
                if (by2 == 2 || by2 == 3 || by != 1) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    public synchronized int getLowestPacketAcked() throws NoSuchElementException {
        MemberBlock memberBlock = (MemberBlock)this.memberList.firstElement();
        MemberBlock memberBlock2 = null;
        TRAMSeqNumber tRAMSeqNumber = new TRAMSeqNumber(memberBlock.getLastPacketAcked());
        int n = 1;
        while (n < this.memberList.size()) {
            memberBlock = (MemberBlock)this.memberList.elementAt(n);
            if (tRAMSeqNumber.isGreaterThan(memberBlock.getLastPacketAcked())) {
                tRAMSeqNumber.setSeqNumber(memberBlock.getLastPacketAcked());
                memberBlock2 = memberBlock;
            }
            ++n;
        }
        if (memberBlock2 != null && this.logger.requiresLogging(3)) {
            this.logger.putPacketln(this, "getLowestPacketAcked:  seq num " + tRAMSeqNumber.getSeqNumber() + " " + memberBlock2.getAddress());
        }
        return tRAMSeqNumber.getSeqNumber();
    }

    public long getLastHASentTime() {
        return this.lastHaSentTime;
    }

    public void setLastHASentTime(long l) {
        this.lastHaSentTime = l;
    }

    public int getLastHaTTLSent() {
        return this.lastHaTTLSent;
    }

    public void setLastHaTTLSent(int n) {
        this.lastHaTTLSent = n;
    }

    public synchronized int getHighestSequenceAllowed() {
        if (this.getDirectMemberCount() == 0) {
            return this.tramblk.getHighestSequenceAllowed();
        }
        MemberBlock memberBlock = (MemberBlock)this.memberList.firstElement();
        MemberBlock memberBlock2 = null;
        int n = memberBlock.getHighestSequenceAllowed();
        int n2 = 1;
        while (n2 < this.memberList.size()) {
            memberBlock = (MemberBlock)this.memberList.elementAt(n2);
            if (memberBlock.getHighestSequenceAllowed() < n) {
                n = memberBlock.getHighestSequenceAllowed();
                memberBlock2 = memberBlock;
            }
            ++n2;
        }
        return n;
    }
}

