/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.TRAMLogger;

class GroupMembershipMask
implements Cloneable {
    TRAMLogger logger = null;
    private int[] memberMask;

    public GroupMembershipMask(int n) {
        this.allocateAndInitialize(n);
    }

    public GroupMembershipMask(int n, TRAMLogger tRAMLogger) {
        this.logger = tRAMLogger;
        this.allocateAndInitialize(n);
    }

    public static void main(String[] stringArray) {
        GroupMembershipMask groupMembershipMask = new GroupMembershipMask(69);
        int n = 0;
        while (n < 69) {
            System.out.println("Adding new member bit " + groupMembershipMask.assignNewMemberBit());
            ++n;
        }
        System.out.println("\n\nClearing member with id 1");
        groupMembershipMask.clearMemberBit(1);
        System.out.println("Adding new member bit " + groupMembershipMask.assignNewMemberBit());
        System.out.println("\n\nClearing member with id 32");
        groupMembershipMask.clearMemberBit(32);
        System.out.println("Adding new member bit " + groupMembershipMask.assignNewMemberBit());
        System.out.println("\n\nClearing member with id 33");
        groupMembershipMask.clearMemberBit(33);
        System.out.println("Adding new member bit " + groupMembershipMask.assignNewMemberBit());
        System.out.println("\n\nClearing member with id 64");
        groupMembershipMask.clearMemberBit(64);
        System.out.println("Adding new member bit " + groupMembershipMask.assignNewMemberBit());
        System.out.println("\n\nClearing member with id 65");
        groupMembershipMask.clearMemberBit(65);
        System.out.println("Adding new member bit " + groupMembershipMask.assignNewMemberBit());
        groupMembershipMask.clearMemberBit(5);
        GroupMembershipMask groupMembershipMask2 = null;
        try {
            groupMembershipMask2 = (GroupMembershipMask)groupMembershipMask.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("Clone NOT Supported ");
            System.exit(1);
        }
        System.out.println("Adding new member bit to Clone" + groupMembershipMask2.assignNewMemberBit());
        groupMembershipMask2.clearMemberBit(1);
        System.out.println("Adding new member bit to Orig Mask" + groupMembershipMask.assignNewMemberBit());
    }

    private void allocateAndInitialize(int n) {
        int n2 = (n + 31) / 32;
        this.memberMask = new int[n2];
        if (this.logger == null) {
            System.out.println("Member Count == " + n + " Allocated " + this.memberMask.length);
        } else if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "Member Count == " + n + " Allocated " + this.memberMask.length);
        }
        int n3 = 0;
        while (n3 < this.memberMask.length) {
            this.memberMask[n3] = 0;
            ++n3;
        }
    }

    public synchronized int assignNewMemberBit() {
        boolean bl = false;
        int n = 0;
        while (n < this.memberMask.length) {
            int n2 = 0;
            if (this.memberMask[n] != -1) {
                int n3 = 0;
                while (n3 < 32) {
                    n2 = 1 << n3;
                    if ((this.memberMask[n] & n2) == 0) {
                        int n4 = n * 32 + (n3 + 1);
                        this.memberMask[n] = this.memberMask[n] | n2;
                        if (this.logger != null) {
                            if (this.logger.requiresLogging(7)) {
                                this.logger.putPacketln(this, "Assigning MemberId " + n4 + " Index = " + n + "Mask = " + this.memberMask[n]);
                            }
                        } else {
                            System.out.println("Assigning MemberId " + n4 + " Index = " + n + "Mask = " + this.memberMask[n]);
                        }
                        return n4;
                    }
                    ++n3;
                }
            }
            ++n;
        }
        return 0;
    }

    public synchronized void clearMemberBit(int n) {
        if (n > this.memberMask.length * 32 || n < 0) {
            return;
        }
        int n2 = --n / 32;
        int n3 = 1 << n - 32 * n2;
        int n4 = n2;
        this.memberMask[n4] = this.memberMask[n4] & ~n3;
    }

    public synchronized void setMemberBit(int n) {
        if (n > this.memberMask.length * 32 || n < 0) {
            return;
        }
        int n2 = --n / 32;
        int n3 = 1 << n - 32 * n2;
        int n4 = n2;
        this.memberMask[n4] = this.memberMask[n4] | n3;
    }

    public Object clone() throws CloneNotSupportedException {
        GroupMembershipMask groupMembershipMask = null;
        groupMembershipMask = new GroupMembershipMask(this.memberMask.length * 32, this.logger);
        groupMembershipMask.copyMask(this.memberMask);
        return groupMembershipMask;
    }

    protected void copyMask(int[] nArray) {
        int n = 0;
        while (n < this.memberMask.length) {
            this.memberMask[n] = nArray[n];
            ++n;
        }
    }

    public boolean isMaskEmpty() {
        int n = 0;
        while (n < this.memberMask.length) {
            if (this.memberMask[n] != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

