/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.TRAMLoggingOptionPacket;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

final class ChangeTRAMLoggingOption {
    static final String str_SESSION_ID = "SESSION_ID";
    static final String str_SOURCE_ADDRESS = "SOURCE_ADDRESS";
    static final String str_LOG_OPTION = "LOG_OPTION";
    static final String str_MCAST_ADDRESS = "MULTICAST_ADDRESS";
    static final String str_PORT = "PORT";
    static final String str_TTL = "TTL";
    static final String str_MEMBER_ADDRESS = "MEMBER_ADDRESS";
    static final String str_LOG_OPTION_PERFMON = "LOG_PERFORMANCE_MONITOR";
    static final String str_LOG_OPTION_CONG = "LOG_CONGESTION";
    static final String str_LOG_OPTION_CNTLMESG = "LOG_CONTROL_MESSAGES";
    static final String str_LOG_OPTION_DATAMESG = "LOG_DATA_MESSAGES";
    static final String str_LOG_OPTION_SESSION = "LOG_SESSION";
    static final String str_LOG_OPTION_SECURITY = "LOG_SECURITY";
    static final String str_LOG_OPTION_DATACACHE = "LOG_DATACACHE";
    static final String str_LOG_OPTION_DIAGNOSTICS = "LOG_DIAGNOSTICS";
    static final String str_LOG_OPTION_VERBOSE = "LOG_VERBOSE";
    static final String str_LOG_OPTION_INFO = "LOG_INFO";
    static final String str_LOG_OPTION_ALL = "LOG_ALL";
    static final String str_LOG_OPTION_NONE = "LOG_NONE";
    static final String str_LOG_OPTION_ABORT_TRAM = "LOG_ABORT_TRAM";
    private int sessionId = 0;
    private InetAddress srcAddress = null;
    private InetAddress mcastAddress = null;
    private Vector memberList = new Vector();
    private int port = 0;
    private int logOption = 0;
    private MulticastSocket ms = null;
    private int ttlVal = 1;

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("\n\n Usage: requires <logOptionConfig fileName> as input\n \n See logOptionConfig.txt for config file specification \n\n");
            return;
        }
        System.out.println("Got file logOptionConfig fileName as " + stringArray[0]);
        ChangeTRAMLoggingOption changeTRAMLoggingOption = new ChangeTRAMLoggingOption();
        try {
            changeTRAMLoggingOption.loadLogOptions(stringArray[0]);
        }
        catch (IOException iOException) {
            System.out.println("File Not Found");
        }
        try {
            changeTRAMLoggingOption.send();
        }
        catch (IOException iOException) {
            System.out.println("Options packet could not be sent");
        }
    }

    public ChangeTRAMLoggingOption() {
        try {
            this.ms = new MulticastSocket();
        }
        catch (IOException iOException) {
            System.out.println("Unable to create a multicast socket for sending");
            return;
        }
    }

    public final void loadLogOptions(String string) throws IOException {
        String string2;
        Object object;
        FileInputStream fileInputStream = new FileInputStream(string);
        Properties properties = new Properties();
        boolean bl = false;
        InetAddress inetAddress = null;
        properties.load(fileInputStream);
        String string3 = null;
        string3 = properties.getProperty(str_SESSION_ID);
        if (string3 != null) {
            object = new Integer(string3);
            this.sessionId = (Integer)object;
            if (this.sessionId < 0) {
                this.sessionId = 0;
            }
        }
        if ((string3 = properties.getProperty(str_MCAST_ADDRESS)) != null) {
            object = null;
            try {
                object = InetAddress.getByName(string3);
                this.mcastAddress = object;
            }
            catch (UnknownHostException unknownHostException) {
                System.out.println("Invalid Multicast Address");
            }
        }
        if ((string3 = properties.getProperty(str_SOURCE_ADDRESS)) != null) {
            try {
                this.srcAddress = InetAddress.getByName(string3);
            }
            catch (UnknownHostException unknownHostException) {
                System.out.println("Invalid Data SourceAddress");
            }
        }
        if ((string3 = properties.getProperty(str_PORT)) != null) {
            object = new Integer(string3);
            this.port = (Integer)object;
        }
        if ((string3 = properties.getProperty(str_TTL)) != null) {
            object = new Integer(string3);
            this.ttlVal = (Integer)object;
            if (this.ttlVal > 255) {
                this.ttlVal = 255;
            }
        }
        if ((string3 = properties.getProperty(str_MEMBER_ADDRESS)) != null) {
            System.out.println(string3);
            object = new StringTokenizer(string3, "\t\n\r\f, ");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string2 = ((StringTokenizer)object).nextToken();
                try {
                    inetAddress = InetAddress.getByName(string2);
                    this.memberList.addElement(inetAddress);
                }
                catch (UnknownHostException unknownHostException) {
                    System.out.println("Invalid Data SourceAddress " + string2);
                }
            }
        }
        if ((string3 = properties.getProperty(str_LOG_OPTION)) != null) {
            System.out.println(string3);
            object = new StringTokenizer(string3, "\t\n\r\f| ");
            this.logOption = 0;
            while (((StringTokenizer)object).hasMoreTokens()) {
                string2 = ((StringTokenizer)object).nextToken();
                System.out.println(string2);
                if (str_LOG_OPTION_PERFMON.equalsIgnoreCase(string2)) {
                    this.logOption |= 0x400;
                    System.out.println("enabled Performance Monitoring");
                    continue;
                }
                if (str_LOG_OPTION_CONG.equalsIgnoreCase(string2)) {
                    this.logOption |= 0x10;
                    System.out.println("enabled Congestion");
                    continue;
                }
                if (str_LOG_OPTION_CNTLMESG.equalsIgnoreCase(string2)) {
                    this.logOption |= 0x20;
                    System.out.println("enabled Control Message");
                    continue;
                }
                if (str_LOG_OPTION_DATAMESG.equalsIgnoreCase(string2)) {
                    this.logOption |= 0x40;
                    System.out.println("enabled Data Message");
                    continue;
                }
                if (str_LOG_OPTION_SESSION.equalsIgnoreCase(string2)) {
                    this.logOption |= 0x80;
                    System.out.println("enabled Session level");
                    continue;
                }
                if (str_LOG_OPTION_SECURITY.equalsIgnoreCase(string2)) {
                    this.logOption |= 0x200;
                    System.out.println("enabled Security");
                    continue;
                }
                if (str_LOG_OPTION_DATACACHE.equalsIgnoreCase(string2)) {
                    this.logOption |= 0x100;
                    System.out.println("enabled Data Cache");
                    continue;
                }
                if (str_LOG_OPTION_DIAGNOSTICS.equalsIgnoreCase(string2)) {
                    this.logOption |= 3;
                    System.out.println("enabled DIAGNOSTICS");
                    continue;
                }
                if (str_LOG_OPTION_VERBOSE.equalsIgnoreCase(string2)) {
                    this.logOption |= 7;
                    System.out.println("enabled VERBOSE");
                    continue;
                }
                if (str_LOG_OPTION_INFO.equalsIgnoreCase(string2)) {
                    this.logOption |= 1;
                    System.out.println("enabled INFO");
                    continue;
                }
                if (str_LOG_OPTION_ALL.equalsIgnoreCase(string2)) {
                    this.logOption = 1023;
                    System.out.println("enabled ALL LEVELS");
                    continue;
                }
                if (str_LOG_OPTION_NONE.equalsIgnoreCase(string2)) {
                    this.logOption = 0;
                    System.out.println("DISABLED ALL LEVELS");
                }
                if (!str_LOG_OPTION_ABORT_TRAM.equalsIgnoreCase(string2)) continue;
                this.logOption = Integer.MIN_VALUE;
                System.out.println("Abort TRAM!");
            }
        }
    }

    public void send() throws IOException {
        InetAddress[] inetAddressArray;
        TRAMLoggingOptionPacket tRAMLoggingOptionPacket = null;
        if (this.memberList.size() == 0) {
            tRAMLoggingOptionPacket = new TRAMLoggingOptionPacket(this.mcastAddress, this.port, this.sessionId, this.srcAddress, this.logOption, null, 0);
        } else {
            inetAddressArray = new InetAddress[this.memberList.size()];
            int n = 0;
            while (n < this.memberList.size()) {
                try {
                    inetAddressArray[n] = (InetAddress)this.memberList.elementAt(n);
                    System.out.println("Including Member Address " + inetAddressArray[n]);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
            tRAMLoggingOptionPacket = new TRAMLoggingOptionPacket(this.mcastAddress, this.port, this.sessionId, this.srcAddress, this.logOption, inetAddressArray, inetAddressArray.length);
        }
        inetAddressArray = tRAMLoggingOptionPacket.createDatagramPacket();
        this.ms.send((DatagramPacket)inetAddressArray, (byte)this.ttlVal);
        System.out.println("Sent Change Logging option packet to " + this.mcastAddress + " on port " + this.port + " with a TTL of " + this.ttlVal + " with a logging option value of " + this.logOption);
    }
}

