/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

class BrickLayer
extends Frame {
    Button[] brickList;
    int xpos;
    int ypos;
    static Dimension brickSize = new Dimension(60, 20);
    boolean half = false;

    public BrickLayer(Dimension dimension, int n, String string) {
        ((Component)this).setSize(dimension);
        ((Component)this).setBackground(Color.black);
        this.setForeground(Color.white);
        this.setTitle(string);
        this.brickList = new Button[n + 1];
        this.xpos = -BrickLayer.brickSize.width;
        this.ypos = this.getSize().height - BrickLayer.brickSize.height;
        ((Component)this).setVisible(true);
        this.show();
    }

    public static void main(String[] stringArray) {
        Dimension dimension = new Dimension(600, 600);
        int n = 100;
        BrickLayer brickLayer = new BrickLayer(dimension, n, "Source");
        BrickLayer brickLayer2 = new BrickLayer(dimension, 0, "Sink");
        int n2 = 1;
        while (n2 <= n) {
            brickLayer.addBrick(n2);
            ++n2;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("/tmp/brickFile.tmp");
            FileInputStream fileInputStream = new FileInputStream("/tmp/brickFile.tmp");
            int n3 = n;
            while (n3 > 0) {
                brickLayer.getBrick(n3, fileOutputStream);
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                brickLayer2.putBrick(fileInputStream);
                --n3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        brickLayer.dispose();
        brickLayer2.dispose();
        System.exit(1);
    }

    public void addBrick(int n) {
        this.xpos += BrickLayer.brickSize.width;
        if (this.xpos >= this.getSize().width) {
            this.ypos -= BrickLayer.brickSize.height;
            if (this.half) {
                this.half = false;
                this.xpos = 0;
            } else {
                this.half = true;
                this.xpos = -(BrickLayer.brickSize.width / 2);
            }
        }
        Button button = new Button(String.valueOf(n));
        button.setLocation(this.xpos, this.ypos);
        button.setSize(brickSize);
        button.setBackground(Color.red);
        this.add(button);
        this.repaint();
        this.brickList[n] = button;
    }

    public void removeBrick(int n) {
        this.remove(this.brickList[n]);
        this.brickList[n] = null;
        this.repaint();
    }

    public void getBrick(int n, OutputStream outputStream) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(this.brickList[n]);
            objectOutputStream.flush();
            this.removeBrick(n);
            objectOutputStream = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void putBrick(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Button button = (Button)objectInputStream.readObject();
        this.add(button);
        this.repaint();
    }
}

