/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMPacket;
import com.sun.multicast.util.Util;
import java.net.DatagramPacket;
import java.net.InetAddress;

class BeaconPacket
extends TRAMPacket {
    public static final byte FLAGBIT_PRUNE = 1;
    public static final byte FLAGBIT_TXDONE = 2;
    public static final byte FLAGBIT_FILLER = 4;
    public static final byte FLAGBIT_V6ADDRESS = -128;
    private static final byte HA_INTERVAL = 0;
    private static final byte SEQ_NUM = 2;
    private static final byte FORGETBEFORESEQNUM = 6;
    private static final byte SOURCE_ADDR = 10;
    private static final byte PKT_LENGTH = 14;
    public static final int HEADERLENGTH = 14;
    private InetAddress srcAddress = null;
    private int seqNumber = 0;
    private int forgetBeforeSeqNum = 1;
    private short haInterval = 0;

    public BeaconPacket(DatagramPacket datagramPacket) {
        super(datagramPacket);
        this.seqNumber = super.readInt(2);
        this.haInterval = super.readShort(0);
        int n = super.readInt(10);
        this.srcAddress = Util.intToInetAddress(n);
    }

    public BeaconPacket(TRAMControlBlock tRAMControlBlock, int n, short s, byte by) {
        super(14 + n, tRAMControlBlock.getSessionId());
        this.setMessageType(1);
        this.setSubType(1);
        this.srcAddress = tRAMControlBlock.getLocalHost();
        super.writeInt(Util.InetAddressToInt(this.srcAddress), 10);
        this.setFlags(by);
        this.haInterval = s;
        super.writeShort(s, 0);
    }

    public DatagramPacket createDatagramPacket() {
        return super.createDatagramPacket();
    }

    public InetAddress getSrcAddress() {
        return this.srcAddress;
    }

    public void setSrcAddress(InetAddress inetAddress) {
        this.srcAddress = inetAddress;
        super.writeInt(Util.InetAddressToInt(this.srcAddress), 10);
    }

    public int getSeqNumber() {
        return this.seqNumber;
    }

    public void setSeqNumber(int n) {
        this.seqNumber = n;
        super.writeInt(this.seqNumber, 2);
    }

    public int getForgetBeforeSeqNum() {
        return this.forgetBeforeSeqNum;
    }

    public void setForgetBeforeSeqNum(int n) {
        this.forgetBeforeSeqNum = n;
        super.writeInt(this.forgetBeforeSeqNum, 6);
    }

    public short getHaInterval() {
        return this.haInterval;
    }

    public void setHaInterval(short s) {
        this.haInterval = s;
        super.writeShort(this.haInterval, 0);
    }

    public void writeBuffer(byte[] byArray, int n, int n2) {
        super.writeBuffer(byArray, n, n2 += 14);
    }

    public int getLength() {
        return super.getLength() - 14;
    }
}

