/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.tram;

import com.sun.multicast.reliable.authentication.AuthenticationModule;
import com.sun.multicast.reliable.transport.tram.BeaconPacket;
import com.sun.multicast.reliable.transport.tram.GroupMgmtThread;
import com.sun.multicast.reliable.transport.tram.TRAMControlBlock;
import com.sun.multicast.reliable.transport.tram.TRAMHeadAck;
import com.sun.multicast.reliable.transport.tram.TRAMLogger;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.security.SignatureException;

class BeaconGenThread
extends Thread {
    private TRAMControlBlock tramblk;
    private static final String name = "TRAM BeaconGenThread";
    private TRAMLogger logger;
    private GroupMgmtThread grpThread;
    private boolean done;
    private MulticastSocket ms;

    public BeaconGenThread(TRAMControlBlock tRAMControlBlock, GroupMgmtThread groupMgmtThread) {
        block3: {
            super(name);
            this.tramblk = null;
            this.logger = null;
            this.grpThread = null;
            this.done = false;
            this.ms = null;
            this.tramblk = tRAMControlBlock;
            this.grpThread = groupMgmtThread;
            this.logger = tRAMControlBlock.getLogger();
            if (tRAMControlBlock.getSimulator() == null) {
                try {
                    this.ms = tRAMControlBlock.newMulticastSocket();
                }
                catch (IOException iOException) {
                    if (!this.logger.requiresLogging(1023)) break block3;
                    this.logger.putPacketln(this, "Unable to open Multicast socket");
                }
            }
        }
        this.setDaemon(true);
        this.start();
    }

    public void run() {
        if (this.logger.requiresLogging(7)) {
            this.logger.putPacketln(this, "starting BeaconGenThread");
        }
        TRAMTransportProfile tRAMTransportProfile = this.tramblk.getTransportProfile();
        BeaconPacket beaconPacket = null;
        long l = 0L;
        int n = 0;
        if (this.tramblk.getAuthenticationModule() != null) {
            n = this.tramblk.getAuthenticationModule().getSignatureSize();
        }
        while (!this.done) {
            long l2;
            block31: {
                byte by = this.tramblk.getTRAMState();
                l2 = tRAMTransportProfile.getBeaconRate();
                beaconPacket = null;
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "In While loop: State " + by);
                }
                switch (by) {
                    case 1: {
                        l2 = 100L;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (this.logger.requiresLogging(7)) {
                            this.logger.putPacketln(this, "Generating a Beacon");
                        }
                        beaconPacket = new BeaconPacket(this.tramblk, n, this.grpThread.getHaInterval(), 0);
                        beaconPacket.setAddress(tRAMTransportProfile.getAddress());
                        beaconPacket.setPort(tRAMTransportProfile.getPort());
                        break;
                    }
                    case 3: {
                        TRAMHeadAck tRAMHeadAck = this.tramblk.getHeadAck();
                        if (tRAMHeadAck == null) break;
                        long l3 = this.tramblk.getOutputDispThread().getLastPktSentTime();
                        if (l3 < l) {
                            l3 = l;
                        }
                        if (System.currentTimeMillis() - l3 <= 3000L) break;
                        if (this.logger.requiresLogging(3)) {
                            this.logger.putPacketln(this, "Sender hasn't sent in 3 seconds,  Sending a beacon for seq " + this.tramblk.getTRAMDataCache().getHighestSequenceNumber());
                        }
                        beaconPacket = new BeaconPacket(this.tramblk, n, this.grpThread.getDataHaInterval(), 4);
                        beaconPacket.setSeqNumber(this.tramblk.getTRAMDataCache().getHighestSequenceNumber());
                        beaconPacket.setForgetBeforeSeqNum(this.tramblk.getLastKnownForgetBeforeSeqNum());
                        beaconPacket.setAddress(tRAMTransportProfile.getAddress());
                        beaconPacket.setPort(tRAMTransportProfile.getPort());
                        break;
                    }
                    case 10: {
                        beaconPacket = new BeaconPacket(this.tramblk, n, this.grpThread.getDataHaInterval(), 2);
                        beaconPacket.setSeqNumber(this.tramblk.getLastFirstTimeTxmSequenceNumber());
                        beaconPacket.setForgetBeforeSeqNum(this.tramblk.getLastKnownForgetBeforeSeqNum());
                        beaconPacket.setAddress(tRAMTransportProfile.getAddress());
                        beaconPacket.setPort(tRAMTransportProfile.getPort());
                        break;
                    }
                    default: {
                        this.done = true;
                        l2 = 0L;
                    }
                }
                if (beaconPacket != null) {
                    AuthenticationModule authenticationModule = this.tramblk.getAuthenticationModule();
                    if (authenticationModule != null) {
                        int n2 = 24;
                        byte[] byArray = beaconPacket.getBuffer();
                        try {
                            byte[] byArray2 = authenticationModule.sign(byArray, 0, n2);
                            if (this.logger.requiresLogging(519)) {
                                this.logger.putPacketln(this, "Signature Length is " + byArray2.length + "Mesg Length is " + n2 + " BufferLen is " + byArray.length);
                            }
                            beaconPacket.writeBuffer(byArray2, byArray2.length, 0);
                        }
                        catch (SignatureException signatureException) {
                            if (!this.logger.requiresLogging(519)) continue;
                            this.logger.putPacketln(this, "Could not Sign a Beacon Packet!!");
                            continue;
                        }
                    }
                    if (this.logger.requiresLogging(7)) {
                        this.logger.putPacketln(this, "Creating the datagram");
                    }
                    DatagramPacket datagramPacket = beaconPacket.createDatagramPacket();
                    try {
                        if (this.tramblk.getSimulator() != null) {
                            this.tramblk.getSimulator().simulateMulticastPacket(datagramPacket, 1, tRAMTransportProfile.getTTL());
                        } else {
                            try {
                                this.tramblk.getTRAMStats().setSendCntlMsgCounters(beaconPacket);
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                            this.ms.send(datagramPacket, tRAMTransportProfile.getTTL());
                        }
                        l = System.currentTimeMillis();
                        if (this.logger.requiresLogging(39)) {
                            this.logger.putPacketln(this, "Sending a Beacon with TTL " + tRAMTransportProfile.getTTL());
                        }
                    }
                    catch (IOException iOException) {
                        if (!this.logger.requiresLogging(39)) break block31;
                        this.logger.putPacketln(this, "unable to send Beacon packet ");
                    }
                }
            }
            if (this.done) continue;
            try {
                if (this.logger.requiresLogging(7)) {
                    this.logger.putPacketln(this, "Sleeping for " + l2 + " Millsecs");
                }
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                if (!this.logger.requiresLogging(7)) continue;
                this.logger.putPacketln(this, "BeaconGenThread -Sleep Interpt Exception");
            }
        }
        if (this.logger.requiresLogging(3)) {
            this.logger.putPacketln(this, "Stopping Beacon GenThread");
        }
        this.tramblk.setBeaconGenThread(null);
        if (this.tramblk.getSimulator() == null) {
            this.ms.close();
        }
    }

    public void terminate() {
        this.done = true;
        this.interrupt();
    }
}

