/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.lrmp;

import com.sun.multicast.reliable.RMException;
import com.sun.multicast.reliable.transport.RMPacketSocket;
import com.sun.multicast.reliable.transport.RMStatistics;
import com.sun.multicast.reliable.transport.SessionDoneException;
import com.sun.multicast.reliable.transport.TransportProfile;
import com.sun.multicast.reliable.transport.lrmp.LRMPTransportProfile;
import com.sun.multicast.util.ImpossibleException;
import com.sun.multicast.util.UnsupportedException;
import inria.net.lrmp.Lrmp;
import inria.net.lrmp.LrmpEventHandler;
import inria.net.lrmp.LrmpException;
import inria.net.lrmp.LrmpPacket;
import inria.net.lrmp.LrmpProfile;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.util.Vector;

public class LRMPPacketSocket
implements RMPacketSocket,
LrmpEventHandler {
    private LRMPTransportProfile tp;
    private Lrmp lrmp;
    private Vector inputQ = new Vector();
    private boolean first = true;
    private int port;
    private boolean eof = false;
    private InetAddress iface = null;
    private static int maxLength = 0;

    LRMPPacketSocket(LRMPTransportProfile lRMPTransportProfile) {
        this.tp = (LRMPTransportProfile)lRMPTransportProfile.clone();
        this.port = this.tp.getPort();
        LrmpProfile lrmpProfile = new LrmpProfile();
        lrmpProfile.setEventHandler(this);
        lrmpProfile.bandwidth = (int)(this.tp.getMaxDataRate() * 8L / 1000L);
        try {
            this.lrmp = new Lrmp(this.tp.getAddress().getHostAddress(), this.port, (int)this.tp.getTTL(), lrmpProfile);
            this.lrmp.startSession();
        }
        catch (LrmpException lrmpException) {
            throw new ImpossibleException(lrmpException);
        }
    }

    public InetAddress getInterface() throws SocketException {
        if (this.iface == null) {
            try {
                this.iface = new MulticastSocket().getInterface();
            }
            catch (IOException iOException) {
                throw new SocketException("unable to getInterface");
            }
        }
        return this.iface;
    }

    public TransportProfile getTransportProfile() {
        return (TransportProfile)this.tp.clone();
    }

    public RMStatistics getRMStatistics() throws UnsupportedException {
        throw new UnsupportedException();
    }

    public void setInterface(InetAddress inetAddress) throws UnsupportedException {
        throw new UnsupportedException("can't change interface on an LRMPRMPacketSocket");
    }

    public void send(DatagramPacket datagramPacket) throws IOException {
        int n = datagramPacket.getLength();
        if (this.getMaxLength() < n) {
            throw new IOException("packet too long to send via LRMP");
        }
        LrmpPacket lrmpPacket = new LrmpPacket(n);
        System.arraycopy(datagramPacket.getData(), 0, lrmpPacket.getDataBuffer(), lrmpPacket.getOffset(), n);
        lrmpPacket.setDataLength(n);
        lrmpPacket.setFirst(this.first);
        this.first = false;
        try {
            this.lrmp.send(lrmpPacket);
        }
        catch (LrmpException lrmpException) {
            throw new IOException("unable to send packet due to LrmpException");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public DatagramPacket receive() throws IOException, SessionDoneException {
        LrmpPacket lrmpPacket = null;
        if (this.eof) {
            throw new SessionDoneException();
        }
        Vector vector = this.inputQ;
        // MONITORENTER : vector
        while (lrmpPacket == null) {
            if (this.inputQ.size() > 0) {
                lrmpPacket = (LrmpPacket)this.inputQ.firstElement();
                this.inputQ.removeElementAt(0);
                continue;
            }
            try {
                this.inputQ.wait(30000L);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
        // MONITOREXIT : vector
        if (lrmpPacket.isLast()) {
            if (lrmpPacket.getDataLength() == 0) {
                throw new SessionDoneException();
            }
            this.eof = true;
        }
        byte[] byArray = new byte[lrmpPacket.getDataLength()];
        System.arraycopy(lrmpPacket.getDataBuffer(), lrmpPacket.getOffset(), byArray, 0, byArray.length);
        return new DatagramPacket(byArray, byArray.length, lrmpPacket.getAddress(), this.port);
    }

    public void abort() {
        this.lrmp.stopSession();
    }

    public void close() {
        LrmpPacket lrmpPacket = new LrmpPacket();
        lrmpPacket.setFirst(this.first);
        lrmpPacket.setLast(true);
        try {
            this.lrmp.send(lrmpPacket);
        }
        catch (LrmpException lrmpException) {
            // empty catch block
        }
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.lrmp.stopSession();
    }

    public long getMaxDataRate() {
        return this.tp.getMaxDataRate();
    }

    public void setMaxDataRate(long l) throws RMException {
        if (l == this.tp.getMaxDataRate()) {
            return;
        }
        this.tp.setMaxDataRate(l);
        LrmpProfile lrmpProfile = new LrmpProfile();
        lrmpProfile.setEventHandler(this);
        lrmpProfile.bandwidth = (int)(l * 8L / 1000L);
        try {
            this.lrmp.setProfile(lrmpProfile);
        }
        catch (LrmpException lrmpException) {
            throw new RMException("couldn't set data rate");
        }
    }

    public int getMaxLength() {
        if (maxLength == 0) {
            maxLength = new LrmpPacket().getMaxDataLength();
        }
        return maxLength;
    }

    public void processData(LrmpPacket lrmpPacket) {
        Vector vector = this.inputQ;
        synchronized (vector) {
            this.inputQ.addElement(lrmpPacket);
            this.inputQ.notify();
        }
    }

    public void processEvent(int n, Object object) {
        switch (n) {
            case 1: {
                System.out.println("reception failure!");
                break;
            }
        }
    }
}

